/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.util;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class GridTabDataBinder
implements ValueChangeListener {
    private static final CLogger logger = CLogger.getCLogger(GridTabDataBinder.class);
    private GridTab gridTab;

    public GridTabDataBinder(GridTab gridTab) {
        this.gridTab = gridTab;
    }

    @Override
    public void valueChange(ValueChangeEvent e) {
        if (this.gridTab.isProcessed()) {
            Object source = e.getSource();
            if (source instanceof WEditor) {
                WEditor editor = (WEditor)source;
                GridField gridField = editor.getGridField();
                if (gridField != null) {
                    if (!gridField.isEditable(true)) {
                        if (logger.isLoggable(Level.CONFIG)) {
                            logger.config("(" + this.gridTab.toString() + ") " + e.getPropertyName());
                        }
                        return;
                    }
                } else if (!editor.isReadWrite()) {
                    if (logger.isLoggable(Level.CONFIG)) {
                        logger.config("(" + this.gridTab.toString() + ") " + e.getPropertyName());
                    }
                    return;
                }
            } else {
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.config("(" + this.gridTab.toString() + ") " + e.getPropertyName());
                }
                return;
            }
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("(" + this.gridTab.toString() + ") " + e.getPropertyName() + "=" + e.getNewValue() + " (" + e.getOldValue() + ") " + (e.getOldValue() == null ? "" : e.getOldValue().getClass().getName()));
        }
        GridTable mTable = this.gridTab.getTableModel();
        int row = this.gridTab.getCurrentRow();
        int col = mTable.findColumn(e.getPropertyName());
        if (e.getNewValue() == null && e.getOldValue() != null && e.getOldValue().toString().length() > 0) {
            mTable.setValueAt(e.getNewValue(), row, col);
        } else {
            GridField mField;
            Object newValue = e.getNewValue();
            Integer[] newValues = null;
            if (newValue instanceof Integer[]) {
                newValues = (Integer[])newValue;
                newValue = newValues[0];
                if (newValues.length > 1) {
                    Integer[] valuesCopy = new Integer[newValues.length - 1];
                    System.arraycopy(newValues, 1, valuesCopy, 0, valuesCopy.length);
                    newValues = valuesCopy;
                } else {
                    newValues = null;
                }
            } else if (newValue instanceof Object[]) {
                logger.severe("Multiple values can only be processed for IDs (Integer)");
                throw new IllegalArgumentException("Multiple Selection values not available for this field. " + e.getPropertyName());
            }
            if (e.isInitEdit()) {
                mTable.setValueAt(newValue, row, col, false, true);
            } else {
                mTable.setValueAt(newValue, row, col);
            }
            if (e.getPropertyName().equals("S_ResourceAssignment_ID") && (mField = this.gridTab.getField(col)) != null && (mField.getCallout().length() > 0 || Core.findCallout((String)this.gridTab.getTableName(), (String)mField.getColumnName()).size() > 0)) {
                this.gridTab.processFieldChange(mField);
            }
            if (newValues != null && newValues.length > 0) {
                if (!this.gridTab.dataSave(false)) {
                    throw new AdempiereException("SaveError");
                }
                int recordId = this.gridTab.getKeyID(this.gridTab.getCurrentRow());
                Trx trx = Trx.get((String)Trx.createTrxName(), (boolean)true);
                trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_valueChange");
                trx.start();
                try {
                    try {
                        this.saveMultipleRecords(Env.getCtx(), this.gridTab.getTableName(), e.getPropertyName(), recordId, newValues, trx.getTrxName());
                        trx.commit();
                        this.gridTab.dataRefreshAll();
                    }
                    catch (Exception ex) {
                        trx.rollback();
                        logger.severe(ex.getMessage());
                        throw new AdempiereException("SaveError");
                    }
                }
                finally {
                    trx.close();
                }
            }
        }
    }

    protected void saveMultipleRecords(Properties ctx, String tableName, String columnName, int recordId, Integer[] values, String trxName) throws Exception {
        if (values == null) {
            return;
        }
        int oldRow = this.gridTab.getCurrentRow();
        GridField lineField = this.gridTab.getField("Line");
        int i = 0;
        while (i < values.length) {
            if (!this.gridTab.dataNew(false)) {
                throw new IllegalStateException("Could not create new row");
            }
            this.gridTab.setValue(columnName, (Object)values[i]);
            if (lineField != null) {
                this.gridTab.setValue(lineField, (Object)0);
            }
            if (!this.gridTab.dataSave(false)) {
                throw new IllegalStateException("Could not update row");
            }
            ++i;
        }
        this.gridTab.setCurrentRow(oldRow);
    }
}

