/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.theme;

import java.io.IOException;
import java.util.Properties;
import org.adempiere.webui.apps.AEnv;
import org.compiere.model.MClientInfo;
import org.compiere.model.MImage;
import org.compiere.model.MSysConfig;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;

public final class ThemeManager {
    public static String getLargeLogo() {
        String theme = ThemeManager.getTheme();
        String def = "/theme/" + theme + "/images/login-logo.png";
        return MSysConfig.getValue((String)"ZK_LOGO_LARGE", (String)def);
    }

    public static String getSmallLogo() {
        String theme = ThemeManager.getTheme();
        String def = "/theme/" + theme + "/images/header-logo.png";
        String url = MSysConfig.getValue((String)"ZK_LOGO_SMALL", null);
        if (url == null) {
            url = MSysConfig.getValue((String)"WEBUI_LOGOURL", (String)def);
        }
        return url;
    }

    public static String getTheme() {
        String theme = System.getProperty("ZK_THEME");
        return Util.isEmpty((String)theme) ? MSysConfig.getValue((String)"ZK_THEME", (String)"default") : theme;
    }

    public static String getStyleSheet() {
        return "/theme/" + ThemeManager.getTheme() + "/css/theme.css.dsp";
    }

    public static String getStyleSheetByBrowser() {
        return "/theme/" + ThemeManager.getTheme() + "/css/theme*.css.dsp*";
    }

    public static String getPreference() {
        return "/theme/" + ThemeManager.getTheme() + "/preference.zul";
    }

    public static String getBrowserTitle() {
        return AEnv.getDesktop().getWebApp().getAppName();
    }

    public static String getBrowserIcon() {
        String theme = ThemeManager.getTheme();
        String def = "/theme/" + theme + "/images/icon.png";
        return MSysConfig.getValue((String)"ZK_BROWSER_ICON", (String)def);
    }

    public static String getThemeResource(String name) {
        StringBuilder builder = new StringBuilder("/theme/");
        builder.append(ThemeManager.getTheme());
        builder.append("/").append(name);
        String url = builder.toString().intern();
        return url;
    }

    public static Image getClientWebLogo() throws IOException {
        MClientInfo cinfo = MClientInfo.get((Properties)Env.getCtx());
        if (cinfo.getLogoWeb_ID() > 0) {
            MImage mImage = MImage.get((Properties)Env.getCtx(), (int)cinfo.getLogoWeb_ID());
            if (mImage.getData() != null) {
                return new AImage(mImage.getName(), mImage.getData());
            }
            return null;
        }
        return null;
    }

    public static boolean isUseCSSForWindowSize() {
        return "Y".equals(Env.getContext((Properties)Env.getCtx(), (String)"#THEME_USE_CSS_FOR_WINDOW_SIZE"));
    }

    public static boolean isUseFontIconForImage() {
        return "Y".equals(Env.getContext((Properties)Env.getCtx(), (String)"#THEME_USE_FONT_ICON_FOR_IMAGE"));
    }
}

