/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.theme.ThemeManager;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.body;
import org.compiere.model.MSysConfig;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class HTMLExtension
implements IHTMLExtension {
    private String classPrefix;
    private String componentId;
    private String scriptURL;
    private String styleURL;

    public HTMLExtension(String contextPath, String classPrefix, String componentId) {
        String theme = MSysConfig.getValue((String)"HTML_REPORT_THEME", (String)"/", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (!theme.startsWith("/")) {
            theme = "/" + theme;
        }
        if (!theme.endsWith("/")) {
            theme = String.valueOf(theme) + "/";
        }
        this.classPrefix = classPrefix;
        this.componentId = componentId;
        this.scriptURL = String.valueOf(contextPath) + theme + "js/report.js";
        this.styleURL = String.valueOf(contextPath) + theme + "css/report.css";
    }

    public void extendIDColumn(int row, ConcreteElement columnElement, a href, PrintDataElement dataElement) {
        href.addAttribute("onclick", "showColumnMenu(event, '" + dataElement.getColumnName() + "', " + row + ")");
        href.addAttribute("componentId", this.componentId);
        href.addAttribute("foreignColumnName", dataElement.getForeignColumnName());
        href.addAttribute("value", dataElement.getValueAsString());
    }

    public void extendRowElement(ConcreteElement row, PrintData printData) {
        PrintDataElement pkey = printData.getPKey();
        if (pkey != null) {
            row.addAttribute("ondblclick", "parent.drillAcross('" + this.componentId + "', '" + pkey.getColumnName() + "', '" + pkey.getValueAsString() + "')");
        }
    }

    public String getClassPrefix() {
        return this.classPrefix;
    }

    public String getScriptURL() {
        return this.scriptURL;
    }

    public String getStyleURL() {
        return this.styleURL;
    }

    public void setWebAttribute(body reportBody) {
        reportBody.addAttribute("windowIco", "/webui" + ThemeManager.getThemeResource("images/mWindow.png"));
        reportBody.addAttribute("reportIco", "/webui" + ThemeManager.getThemeResource("images/mReport.png"));
        reportBody.addAttribute("reportLabel", Msg.getMsg((Language)AEnv.getLanguage(Env.getCtx()), (String)"Report").replace("&", ""));
        reportBody.addAttribute("windowLabel", Msg.getMsg((Language)AEnv.getLanguage(Env.getCtx()), (String)"Window"));
    }

    public String getFullPathStyle() {
        String theme = MSysConfig.getValue((String)"HTML_REPORT_THEME", (String)"/", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (!theme.startsWith("/")) {
            theme = "/" + theme;
        }
        if (!theme.endsWith("/")) {
            theme = String.valueOf(theme) + "/";
        }
        String resFile = String.valueOf(theme) + "css/report.css";
        URL urlFile = this.getClass().getResource(resFile);
        if (urlFile == null) {
            resFile = "/css/report.css";
            urlFile = this.getClass().getResource(resFile);
        }
        if (urlFile != null) {
            FileOutputStream cssStream = null;
            File cssFile = null;
            try {
                try {
                    int read;
                    InputStream stream = urlFile.openStream();
                    cssFile = File.createTempFile("report", ".css");
                    cssStream = new FileOutputStream(cssFile);
                    byte[] buffer = new byte[1024];
                    while ((read = stream.read(buffer)) != -1) {
                        cssStream.write(buffer, 0, read);
                    }
                }
                catch (IOException e) {
                    throw new AdempiereException((Throwable)e);
                }
            }
            finally {
                if (cssStream != null) {
                    try {
                        cssStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return cssFile.getAbsolutePath();
        }
        return null;
    }
}

