/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.idempiere.broadcast.BroadCastMsg;
import org.idempiere.broadcast.BroadcastMsgUtil;

public class KillAllSession
extends SvrProcess {
    private static final CLogger logger = CLogger.getCLogger(KillAllSession.class);
    private int scndTimeout = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null && name.equals("TimeOutInSeconds")) {
                this.scndTimeout = para[i].getParameterAsInt();
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        String sql = "SELECT servername FROM ad_session WHERE ad_session_id=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, this.getRecord_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    BroadCastMsg msg = new BroadCastMsg();
                    msg.setEventId(4);
                    msg.setIntData(this.scndTimeout);
                    msg.setTarget(rs.getString("servername"));
                    BroadcastMsgUtil.pushToQueue((BroadCastMsg)msg, (boolean)false);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "servername could not be retrieved", (Throwable)e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return "Session Time Out Initiated";
    }
}

