/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.process;

import java.io.File;
import java.io.FileInputStream;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.window.SimplePDFViewer;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MMailText;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Util;

public class InvoicePrint
extends SvrProcess {
    protected boolean p_EMailPDF = false;
    protected int p_R_MailText_ID = 0;
    protected Timestamp m_dateInvoiced_From = null;
    protected Timestamp m_dateInvoiced_To = null;
    protected int m_C_BPartner_ID = 0;
    protected int m_C_Invoice_ID = 0;
    protected String m_DocumentNo_From = null;
    protected String m_DocumentNo_To = null;
    private String p_IsPaid = null;
    private int m_C_DocType_ID = 0;
    private String p_IsPrinted = null;
    private String m_PaymentRule = null;
    private int m_C_PaymentTerm_ID = 0;
    private String m_DocStatus = null;
    protected volatile StringBuffer sql = new StringBuffer();
    protected volatile List<Object> params = new ArrayList<Object>();

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null || para[i].getParameter_To() != null) {
                if (name.equals("DateInvoiced")) {
                    this.m_dateInvoiced_From = (Timestamp)para[i].getParameter();
                    this.m_dateInvoiced_To = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("EMailPDF")) {
                    this.p_EMailPDF = "Y".equals(para[i].getParameter());
                } else if (name.equals("R_MailText_ID")) {
                    this.p_R_MailText_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.m_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Invoice_ID")) {
                    this.m_C_Invoice_ID = para[i].getParameterAsInt();
                } else if (name.equals("DocumentNo")) {
                    this.m_DocumentNo_From = (String)para[i].getParameter();
                    this.m_DocumentNo_To = (String)para[i].getParameter_To();
                } else if (name.equals("IsPaid")) {
                    this.p_IsPaid = (String)para[i].getParameter();
                } else if (name.equals("C_DocType_ID")) {
                    this.m_C_DocType_ID = para[i].getParameterAsInt();
                } else if (name.equals("IsPrinted")) {
                    this.p_IsPrinted = (String)para[i].getParameter();
                } else if (name.equals("PaymentRule")) {
                    this.m_PaymentRule = (String)para[i].getParameter();
                } else if (name.equals("C_PaymentTerm_ID")) {
                    this.m_C_PaymentTerm_ID = para[i].getParameterAsInt();
                } else if (name.equals("DocStatus")) {
                    this.m_DocStatus = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        if (this.m_DocumentNo_From != null && this.m_DocumentNo_From.length() == 0) {
            this.m_DocumentNo_From = null;
        }
        if (this.m_DocumentNo_To != null && this.m_DocumentNo_To.length() == 0) {
            this.m_DocumentNo_To = null;
        }
    }

    protected String doIt() throws Exception {
        if (this.p_EMailPDF && this.p_R_MailText_ID == 0) {
            throw new AdempiereUserError("@NotFound@: @R_MailText_ID@");
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_BPartner_ID=" + this.m_C_BPartner_ID + ", C_Invoice_ID=" + this.m_C_Invoice_ID + ", EmailPDF=" + this.p_EMailPDF + ",R_MailText_ID=" + this.p_R_MailText_ID + ", DateInvoiced=" + this.m_dateInvoiced_From + "-" + this.m_dateInvoiced_To + ", DocumentNo=" + this.m_DocumentNo_From + "-" + this.m_DocumentNo_To + ", IsPaid=" + this.p_IsPaid + ", C_DocType_ID=" + this.m_C_DocType_ID + ", IsPrinted=" + this.p_IsPrinted + ", PaymentRule=" + this.m_PaymentRule + ", C_PaymentTerm_ID=" + this.m_C_PaymentTerm_ID + ", DocStatus=" + this.m_DocStatus);
        }
        MMailText mText = null;
        if (this.p_R_MailText_ID != 0 && (mText = new MMailText(this.getCtx(), this.p_R_MailText_ID, this.get_TrxName())).get_ID() != this.p_R_MailText_ID) {
            throw new AdempiereUserError("@NotFound@: @R_MailText_ID@ - " + this.p_R_MailText_ID);
        }
        if (this.m_C_BPartner_ID == 0 && this.m_C_Invoice_ID == 0 && this.m_dateInvoiced_From == null && this.m_dateInvoiced_To == null && this.m_DocumentNo_From == null && this.m_DocumentNo_To == null && this.m_PaymentRule == null && this.m_C_PaymentTerm_ID == 0 && this.m_DocStatus == null) {
            throw new AdempiereUserError("@RestrictSelection@");
        }
        MClient client = MClient.get((Properties)this.getCtx());
        this.setSQLAndParams();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.sql.toString());
        }
        MPrintFormat format = null;
        int old_AD_PrintFormat_ID = -1;
        int old_C_Invoice_ID = -1;
        int C_BPartner_ID = 0;
        int count = 0;
        int errors = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        final ArrayList<File> pdfList = new ArrayList<File>();
        try {
            try {
                pstmt = DB.prepareStatement((String)this.sql.toString(), (String)this.get_TrxName());
                int idx = 1;
                for (Object param : this.params) {
                    if (param instanceof Integer) {
                        pstmt.setInt(idx, (Integer)param);
                    } else if (param instanceof Timestamp) {
                        pstmt.setTimestamp(idx, (Timestamp)param);
                    } else {
                        pstmt.setString(idx, param.toString());
                    }
                    ++idx;
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int C_Invoice_ID = rs.getInt(1);
                    if (C_Invoice_ID == old_C_Invoice_ID) continue;
                    old_C_Invoice_ID = C_Invoice_ID;
                    Language language = Language.getLoginLanguage();
                    String AD_Language = rs.getString(2);
                    if (AD_Language != null && "Y".equals(rs.getString(3))) {
                        language = Language.getLanguage((String)AD_Language);
                    }
                    int AD_PrintFormat_ID = rs.getInt(4);
                    int copies = rs.getInt(5);
                    if (copies == 0) {
                        copies = 1;
                    }
                    int AD_User_ID = rs.getInt(6);
                    MUser to = new MUser(this.getCtx(), AD_User_ID, this.get_TrxName());
                    String DocumentNo = rs.getString(7);
                    C_BPartner_ID = rs.getInt(8);
                    String documentDir = client.getDocumentDir();
                    if (documentDir == null || documentDir.length() == 0) {
                        documentDir = ".";
                    }
                    if (this.p_EMailPDF && (to.get_ID() == 0 || to.getEMail() == null || to.getEMail().length() == 0)) {
                        this.addLog(C_Invoice_ID, null, null, String.valueOf(DocumentNo) + " @RequestActionEMailNoTo@");
                        ++errors;
                        continue;
                    }
                    if (AD_PrintFormat_ID == 0) {
                        this.addLog(C_Invoice_ID, null, null, String.valueOf(DocumentNo) + " No Print Format");
                        ++errors;
                        continue;
                    }
                    if (AD_PrintFormat_ID != old_AD_PrintFormat_ID) {
                        format = MPrintFormat.get((Properties)this.getCtx(), (int)AD_PrintFormat_ID, (boolean)false);
                        old_AD_PrintFormat_ID = AD_PrintFormat_ID;
                    }
                    format.setLanguage(language);
                    format.setTranslationLanguage(language);
                    MQuery query = new MQuery("C_Invoice_Header_v");
                    query.addRestriction("C_Invoice_ID", "=", (Object)C_Invoice_ID);
                    PrintInfo info = new PrintInfo(DocumentNo, 318, C_Invoice_ID, C_BPartner_ID);
                    info.setCopies(copies);
                    ReportEngine re = new ReportEngine(this.getCtx(), format, query, info);
                    boolean printed = false;
                    if (this.p_EMailPDF) {
                        String subject = String.valueOf(mText.getMailHeader()) + " - " + DocumentNo;
                        EMail email = client.createEMail(to.getEMail(), subject, null);
                        if (!email.isValid()) {
                            this.addLog(C_Invoice_ID, null, null, String.valueOf(DocumentNo) + " @RequestActionEMailError@ Invalid EMail: " + to);
                            ++errors;
                            continue;
                        }
                        mText.setUser(to);
                        mText.setBPartner(C_BPartner_ID);
                        mText.setPO((PO)new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName()));
                        String message = mText.getMailText(true);
                        if (mText.isHtml()) {
                            email.setMessageHTML(subject, message);
                        } else {
                            email.setSubject(subject);
                            email.setMessageText(message);
                        }
                        File invoice = null;
                        if (!Ini.isClient()) {
                            invoice = new File(MInvoice.getPDFFileName((String)documentDir, (int)C_Invoice_ID));
                        }
                        File attachment = re.getPDF(invoice);
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine(to + " - " + attachment);
                        }
                        email.addAttachment(attachment);
                        String msg = email.send();
                        MUserMail um = new MUserMail(mText, this.getAD_User_ID(), email);
                        um.saveEx();
                        if (msg.equals("OK")) {
                            this.addLog(C_Invoice_ID, null, null, String.valueOf(DocumentNo) + " @RequestActionEMailOK@ - " + to.getEMail());
                            ++count;
                            printed = true;
                        } else {
                            this.addLog(C_Invoice_ID, null, null, String.valueOf(DocumentNo) + " @RequestActionEMailError@ " + msg + " - " + to.getEMail());
                            ++errors;
                        }
                    } else {
                        pdfList.add(re.getPDF());
                        ++count;
                        printed = true;
                    }
                    if (!printed) continue;
                    StringBuffer sb = new StringBuffer("UPDATE C_Invoice SET DatePrinted=SysDate, IsPrinted='Y' WHERE C_Invoice_ID=").append(C_Invoice_ID);
                    DB.executeUpdateEx((String)sb.toString(), (String)this.get_TrxName());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "doIt - " + this.sql, (Throwable)e);
                throw new Exception(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        AEnv.executeAsyncDesktopTask(new Runnable(){

            @Override
            public void run() {
                InvoicePrint.this.showReports(pdfList);
            }
        });
        if (this.p_EMailPDF) {
            return "@Sent@=" + count + " - @Errors@=" + errors;
        }
        return "@Printed@=" + count;
    }

    protected void setSQLAndParams() {
        this.sql.append("SELECT i.C_Invoice_ID,bp.AD_Language,c.IsMultiLingualDocument, COALESCE(bp.Invoice_PrintFormat_ID, dt.AD_PrintFormat_ID, pf.Invoice_PrintFormat_ID), dt.DocumentCopies+bp.DocumentCopies, bpc.AD_User_ID, i.DocumentNo, bp.C_BPartner_ID FROM C_Invoice i INNER JOIN C_BPartner bp ON (i.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN AD_User bpc ON (i.AD_User_ID=bpc.AD_User_ID) INNER JOIN AD_Client c ON (i.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (i.AD_Client_ID=pf.AD_Client_ID) INNER JOIN C_DocType dt ON (i.C_DocType_ID=dt.C_DocType_ID) WHERE i.AD_Client_ID=? AND i.isSOTrx='Y' AND        pf.AD_Org_ID IN (0,i.AD_Org_ID) ");
        this.params.add(Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (this.m_C_Invoice_ID != 0) {
            this.sql.append(" AND i.C_Invoice_ID=?");
            this.params.add(this.m_C_Invoice_ID);
        } else {
            if (this.m_C_BPartner_ID != 0) {
                this.sql.append(" AND i.C_BPartner_ID=?");
                this.params.add(this.m_C_BPartner_ID);
            }
            if (this.m_dateInvoiced_From != null && this.m_dateInvoiced_To != null) {
                this.sql.append(" AND TRUNC(i.DateInvoiced) BETWEEN ? AND ?");
                this.params.add(this.m_dateInvoiced_From);
                this.params.add(this.m_dateInvoiced_To);
            } else if (this.m_dateInvoiced_From != null) {
                this.sql.append(" AND TRUNC(i.DateInvoiced) >= ?");
                this.params.add(this.m_dateInvoiced_From);
            } else if (this.m_dateInvoiced_To != null) {
                this.sql.append(" AND TRUNC(i.DateInvoiced) <= ?");
                this.params.add(this.m_dateInvoiced_To);
            } else if (this.m_DocumentNo_From != null && this.m_DocumentNo_To != null) {
                this.sql.append(" AND i.DocumentNo BETWEEN ? AND ?");
                this.params.add(this.m_DocumentNo_From);
                this.params.add(this.m_DocumentNo_To);
            } else if (this.m_DocumentNo_From != null) {
                if (this.m_DocumentNo_From.indexOf(37) == -1) {
                    this.sql.append(" AND i.DocumentNo >= ?");
                } else {
                    this.sql.append(" AND i.DocumentNo LIKE ?");
                }
                this.params.add(this.m_DocumentNo_From);
            }
            if (this.p_EMailPDF) {
                this.sql.append(" AND i.DocStatus IN ('CO','CL') ");
            }
            if (this.p_IsPaid != null && this.p_IsPaid.length() == 1) {
                this.sql.append(" AND i.IsPaid=?");
                this.params.add(this.p_IsPaid);
            }
            if (this.m_C_DocType_ID != 0) {
                this.sql.append(" AND i.C_DocTypeTarget_ID=?");
                this.params.add(this.m_C_DocType_ID);
            }
            if (this.p_IsPrinted != null && this.p_IsPrinted.length() == 1) {
                this.sql.append(" AND i.IsPrinted=?");
                this.params.add(this.p_IsPrinted);
            }
            if (this.m_PaymentRule != null) {
                this.sql.append(" AND i.PaymentRule=?");
                this.params.add(this.m_PaymentRule);
            }
            if (this.m_C_PaymentTerm_ID != 0) {
                this.sql.append(" AND i.C_PaymentTerm_ID=?");
                this.params.add(this.m_C_PaymentTerm_ID);
            }
            if (this.m_DocStatus != null) {
                this.sql.append(" AND i.DocStatus=?");
                this.params.add(this.m_DocStatus);
            }
        }
        String orgWhere = MRole.getDefault((Properties)this.getCtx(), (boolean)false).getOrgWhere(false);
        if (!Util.isEmpty((String)orgWhere, (boolean)true)) {
            this.sql.append(" AND i.");
            this.sql.append(orgWhere);
        }
        this.sql.append(" ORDER BY i.C_Invoice_ID, pf.AD_Org_ID DESC");
    }

    private void showReports(List<File> pdfList) {
        if (pdfList.size() > 1) {
            try {
                File outFile = File.createTempFile("InvoicePrint", ".pdf");
                AEnv.mergePdf(pdfList, outFile);
                SimplePDFViewer win = new SimplePDFViewer(this.getName(), new FileInputStream(outFile));
                win.setAttribute("mode", "highlighted");
                SessionManager.getAppDesktop().showWindow(win, "center");
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            }
        } else if (pdfList.size() > 0) {
            try {
                SimplePDFViewer win = new SimplePDFViewer(this.getName(), new FileInputStream(pdfList.get(0)));
                win.setAttribute("mode", "highlighted");
                SessionManager.getAppDesktop().showWindow(win, "center");
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

