/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.process;

import java.util.ArrayList;
import org.adempiere.process.IPrintShippingLabel;
import org.adempiere.webui.FedexLabelWindow;
import org.adempiere.webui.LabelAppletWindow;
import org.adempiere.webui.UPSHtmlLabelWindow;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.session.SessionManager;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MShipperLabels;

public class DefaultPrintShippingLabel
implements IPrintShippingLabel {
    public String printToLabelPrinter(MAttachment attachment, MShipperLabels labelType) throws Exception {
        MAttachmentEntry[] entries = attachment.getEntries();
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        if (entries != null && entries.length > 0) {
            MAttachmentEntry[] mAttachmentEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                MAttachmentEntry entry = mAttachmentEntryArray[n2];
                if (entry.getName().startsWith("shipping_label")) {
                    list.add(entry.getData());
                }
                ++n2;
            }
            if (list.size() > 0) {
                final ArrayList<byte[]> dataList = list;
                AEnv.executeAsyncDesktopTask(new Runnable(){

                    @Override
                    public void run() {
                        LabelAppletWindow law = new LabelAppletWindow(dataList);
                        law.setAttribute("mode", "highlighted");
                        SessionManager.getAppDesktop().showWindow(law);
                    }
                });
            }
        }
        return String.valueOf(list.size()) + " labels loaded.";
    }

    public String printImageLabel(MAttachment attachment, MShipperLabels labelType, String title) throws Exception {
        MAttachmentEntry[] entries = attachment.getEntries();
        ArrayList<MAttachmentEntry> htmls = new ArrayList<MAttachmentEntry>();
        ArrayList<MAttachmentEntry> images = new ArrayList<MAttachmentEntry>();
        if (entries != null && entries.length > 0) {
            MAttachmentEntry[] mAttachmentEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                MAttachmentEntry entry = mAttachmentEntryArray[n2];
                if (entry.getName().endsWith(".html")) {
                    htmls.add(entry);
                } else if (entry.isGraphic()) {
                    images.add(entry);
                }
                ++n2;
            }
            if (htmls.size() > 0) {
                final ArrayList<MAttachmentEntry> htmlList = htmls;
                final ArrayList<MAttachmentEntry> imageList = images;
                AEnv.executeAsyncDesktopTask(new Runnable(){

                    @Override
                    public void run() {
                        UPSHtmlLabelWindow labelWindow = new UPSHtmlLabelWindow(htmlList, imageList);
                        labelWindow.setAttribute("mode", "highlighted");
                        SessionManager.getAppDesktop().showWindow(labelWindow);
                    }
                });
            } else if (images.size() > 0) {
                final ArrayList<MAttachmentEntry> imageList = images;
                AEnv.executeAsyncDesktopTask(new Runnable(){

                    @Override
                    public void run() {
                        FedexLabelWindow labelWindow = new FedexLabelWindow(imageList);
                        labelWindow.setAttribute("mode", "highlighted");
                        SessionManager.getAppDesktop().showWindow(labelWindow);
                    }
                });
            }
        }
        return String.valueOf(htmls.size()) + " labels loaded.";
    }
}

