/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.part;

import java.util.List;
import java.util.Properties;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.Menupopup;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.ToolBar;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.part.AbstractUIPart;
import org.adempiere.webui.part.ITabOnSelectHandler;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.event.SwipeEvent;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Tab;

public class WindowContainer
extends AbstractUIPart
implements EventListener<Event> {
    public static final String ON_MOBILE_SET_SELECTED_TAB = "onMobileSetSelectedTab";
    private static final String ON_AFTER_TAB_CLOSE = "onAfterTabClose";
    private static final String ON_DEFER_SET_SELECTED_TAB = "onDeferSetSelectedTab";
    public static final String ON_WINDOW_CONTAINER_SELECTION_CHANGED_EVENT = "onWindowContainerSelectionChanged";
    public static final String DEFER_SET_SELECTED_TAB = "deferSetSelectedTab";
    private static final int MAX_TITLE_LENGTH = 30;
    private Tabbox tabbox;
    private ToolBar toolbar;
    private ToolBarButton tabListBtn;

    public static WindowContainer createFrom(Tabbox tb) {
        WindowContainer wc = new WindowContainer();
        wc.tabbox = tb;
        return wc;
    }

    @Override
    protected Component doCreatePart(Component parent) {
        this.tabbox = new Tabbox();
        this.tabbox.addEventListener("onPageAttached", this);
        this.tabbox.addEventListener("onPageDetached", this);
        this.tabbox.setSupportTabDragDrop(!this.isMobile());
        this.tabbox.setActiveBySeq(true);
        this.tabbox.setCheckVisibleOnlyForNextActive(!this.isMobile());
        this.tabbox.setSclass("desktop-tabbox");
        this.tabbox.setId("desktop_tabbox");
        this.tabbox.setMaximalHeight(true);
        this.tabbox.addEventListener(ON_DEFER_SET_SELECTED_TAB, (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)((Object)event.getData());
                if (tab != null) {
                    WindowContainer.this.setSelectedTab(tab);
                }
            }
        });
        this.tabbox.addEventListener(ON_AFTER_TAB_CLOSE, evt -> {
            if (this.isMobile()) {
                this.updateMobileTabState(this.tabbox.getSelectedTab());
                this.updateTabListButton();
                this.tabbox.getTabs().invalidate();
            }
        });
        Tabpanels tabpanels = new Tabpanels();
        Tabs tabs = new Tabs();
        this.tabbox.appendChild((Component)tabs);
        this.tabbox.appendChild((Component)tabpanels);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.tabbox, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.tabbox, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabbox, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.tabbox, "1");
        if (parent != null) {
            this.tabbox.setParent(parent);
        } else {
            this.tabbox.setPage(this.page);
        }
        this.toolbar = new ToolBar();
        this.toolbar.setSclass("window-container-toolbar");
        this.tabbox.appendChild((Component)this.toolbar);
        if (this.isMobile()) {
            ToolBarButton homeButton = new ToolBarButton();
            if (ThemeManager.isUseFontIconForImage()) {
                homeButton.setIconSclass("z-icon-Home");
            } else {
                homeButton.setImage(ThemeManager.getThemeResource("images/Home16.png"));
            }
            homeButton.setSclass("window-container-toolbar-btn");
            homeButton.addEventListener("onClick", evt -> this.setSelectedTab(this.tabbox.getTabpanel(0).getLinkedTab()));
            this.toolbar.appendChild((Component)homeButton);
            this.tabListBtn = new ToolBarButton();
            if (ThemeManager.isUseFontIconForImage()) {
                this.tabListBtn.setIconSclass("z-icon-Expand");
            } else {
                this.tabListBtn.setImage(ThemeManager.getThemeResource("images/expand-header.png"));
            }
            this.tabListBtn.setSclass("window-container-toolbar-btn");
            this.tabListBtn.addEventListener("onClick", evt -> this.showTabList());
            this.tabListBtn.setVisible(false);
            this.toolbar.appendChild((Component)this.tabListBtn);
        }
        return this.tabbox;
    }

    private void showTabList() {
        org.zkoss.zul.Tabs tabs = this.tabbox.getTabs();
        List list = tabs.getChildren();
        Menupopup popup = new Menupopup();
        int i = 1;
        while (i < list.size()) {
            org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)((Object)list.get(i));
            Menuitem item = new Menuitem(tab.getLabel());
            item.setValue(Integer.toString(i));
            item.setTooltiptext(tab.getTooltiptext());
            popup.appendChild((Component)item);
            item.addEventListener("onClick", evt -> {
                Menuitem t = (Menuitem)evt.getTarget();
                String s = t.getValue();
                Integer ti = Integer.parseInt(s);
                this.setSelectedTab(this.tabbox.getTabpanel(ti).getLinkedTab());
            });
            ++i;
        }
        popup.setPage(this.tabbox.getPage());
        popup.open((Component)this.tabListBtn, "after_start");
    }

    public org.adempiere.webui.component.Tab addWindow(Component comp, String title, boolean closeable) {
        return this.addWindow(comp, title, closeable, true, null);
    }

    public org.adempiere.webui.component.Tab addWindow(Component comp, String title, boolean closeable, boolean enable) {
        return this.addWindow(comp, title, closeable, true, null);
    }

    public org.adempiere.webui.component.Tab insertBefore(org.adempiere.webui.component.Tab refTab, Component comp, String title, boolean closeable, boolean enable) {
        return this.insertBefore(refTab, comp, title, closeable, enable, null);
    }

    public org.adempiere.webui.component.Tab insertAfter(org.adempiere.webui.component.Tab refTab, Component comp, String title, boolean closeable, boolean enable) {
        return this.insertAfter(refTab, comp, title, closeable, enable, null);
    }

    public org.adempiere.webui.component.Tab addWindow(Component comp, String title, boolean closeable, Tab.DecorateInfo decorateInfo) {
        return this.addWindow(comp, title, closeable, true, decorateInfo);
    }

    public org.adempiere.webui.component.Tab addWindow(Component comp, String title, boolean closeable, boolean enable, Tab.DecorateInfo decorateInfo) {
        return this.insertBefore(null, comp, title, closeable, enable, decorateInfo);
    }

    public org.adempiere.webui.component.Tab insertBefore(org.adempiere.webui.component.Tab refTab, Component comp, String title, boolean closeable, boolean enable, Tab.DecorateInfo decorateInfo) {
        Menuitem mi;
        final Menupopup popupClose = new Menupopup();
        final org.adempiere.webui.component.Tab tab = new org.adempiere.webui.component.Tab(){
            private static final long serialVersionUID = 2387473442130217806L;

            @Override
            public void close() {
                super.close();
                popupClose.detach();
            }

            public void onPageDetached(Page page) {
                super.onPageDetached(page);
                if (WindowContainer.this.tabbox != null && WindowContainer.this.tabbox.getPage() != null) {
                    Events.postEvent((String)WindowContainer.ON_AFTER_TAB_CLOSE, (Component)WindowContainer.this.tabbox, null);
                }
            }
        };
        tab.setDecorateInfo(decorateInfo);
        if (title != null) {
            this.setTabTitle(title, tab);
        }
        tab.setClosable(closeable);
        tab.addEventListener("onSwipe", (EventListener)new EventListener<SwipeEvent>(){

            public void onEvent(SwipeEvent event) throws Exception {
                org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)event.getTarget();
                if (tab.isClosable() && ("right".equals(event.getSwipeDirection()) || "left".equals(event.getSwipeDirection()))) {
                    tab.onClose();
                }
            }
        });
        tab.addEventListener("onSelect", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Component component;
                org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)event.getTarget();
                org.zkoss.zul.Tabpanel panel = tab.getLinkedPanel();
                if (panel == null) {
                    System.console().printf("error", new Object[0]);
                }
                if ((component = panel.getFirstChild()) != null && component.getAttribute("TabOnSelectHandler") instanceof ITabOnSelectHandler) {
                    ITabOnSelectHandler handler = (ITabOnSelectHandler)component.getAttribute("TabOnSelectHandler");
                    handler.onSelect();
                }
                if (component instanceof IHelpContext) {
                    Events.sendEvent((Event)new Event(WindowContainer.ON_WINDOW_CONTAINER_SELECTION_CHANGED_EVENT, component));
                } else {
                    SessionManager.getAppDesktop().updateHelpContext("H", 0);
                }
            }
        });
        if (ClientInfo.isMobile()) {
            tab.setClientAttribute("onselectstart", "return false");
        }
        Tabpanel tabpanel = null;
        if (comp instanceof Tabpanel) {
            tabpanel = (Tabpanel)comp;
        } else {
            tabpanel = new Tabpanel();
            tabpanel.appendChild(comp);
        }
        ZKUpdateUtil.setHeight((HtmlBasedComponent)tabpanel, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)tabpanel, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)tabpanel, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)tabpanel, "1");
        tabpanel.setSclass("desktop-tabpanel");
        if (refTab == null) {
            this.tabbox.getTabs().appendChild((Component)tab);
            this.tabbox.getTabpanels().appendChild((Component)tabpanel);
        } else {
            org.zkoss.zul.Tabpanel refpanel = refTab.getLinkedPanel();
            this.tabbox.getTabs().insertBefore((Component)tab, (Component)refTab);
            this.tabbox.getTabpanels().insertBefore((Component)tabpanel, (Component)refpanel);
        }
        if (enable) {
            Boolean b = (Boolean)comp.getAttribute(DEFER_SET_SELECTED_TAB);
            if (b != null && b.booleanValue()) {
                Events.echoEvent((String)ON_DEFER_SET_SELECTED_TAB, (Component)this.tabbox, (Object)((Object)tab));
            } else {
                this.setSelectedTab(tab);
            }
        }
        if (tab.getIndex() != 0) {
            mi = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"Close"));
            popupClose.appendChild((Component)mi);
            mi.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    int currentTabIndex = tab.getIndex();
                    int tabsSizeBeforeClose = WindowContainer.this.tabbox.getTabs().getChildren().size();
                    if (tabsSizeBeforeClose == currentTabIndex + 1) {
                        --currentTabIndex;
                    }
                    if (tab.getPreviousSibling() != null) {
                        tab.onClose();
                        if (tabsSizeBeforeClose != WindowContainer.this.tabbox.getTabs().getChildren().size()) {
                            WindowContainer.this.tabbox.setSelectedIndex(currentTabIndex);
                        }
                        Events.postEvent((String)WindowContainer.ON_AFTER_TAB_CLOSE, (Component)WindowContainer.this.tabbox, null);
                    }
                }
            });
            mi = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"CloseOtherWindows"));
            popupClose.appendChild((Component)mi);
            mi.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    int focusTabIndex = 1;
                    List tabs = WindowContainer.this.tabbox.getTabs().getChildren();
                    int i = tabs.size() - 1;
                    while (i > 0) {
                        if (!((org.adempiere.webui.component.Tab)((Object)tabs.get(i))).equals((Object)tab)) {
                            ((org.adempiere.webui.component.Tab)((Object)tabs.get(i))).setSelected(false);
                            ((org.adempiere.webui.component.Tab)((Object)tabs.get(i))).onClose();
                        }
                        --i;
                    }
                    WindowContainer.this.tabbox.setSelectedIndex(focusTabIndex);
                    Events.postEvent((String)WindowContainer.ON_AFTER_TAB_CLOSE, (Component)WindowContainer.this.tabbox, null);
                }
            });
        }
        mi = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"CloseAllWindows"));
        mi.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                int focusTabIndex = 0;
                List tabs = WindowContainer.this.tabbox.getTabs().getChildren();
                int i = tabs.size() - 1;
                while (i > 0) {
                    ((org.adempiere.webui.component.Tab)((Object)tabs.get(i))).setSelected(false);
                    ((org.adempiere.webui.component.Tab)((Object)tabs.get(i))).onClose();
                    --i;
                }
                WindowContainer.this.tabbox.setSelectedIndex(focusTabIndex);
                Events.postEvent((String)WindowContainer.ON_AFTER_TAB_CLOSE, (Component)WindowContainer.this.tabbox, null);
            }
        });
        popupClose.appendChild((Component)mi);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)popupClose, "auto");
        popupClose.setPage(tab.getPage());
        tab.setContext((Popup)popupClose);
        this.updateTabListButton();
        return tab;
    }

    private void updateTabListButton() {
        if (this.isMobile() && this.tabListBtn != null) {
            int cnt = this.tabbox.getTabs().getChildren().size() - 1;
            if (cnt > 0) {
                this.tabListBtn.setLabel(Integer.toString(cnt));
                this.tabListBtn.setVisible(true);
            } else {
                this.tabListBtn.setLabel("");
                this.tabListBtn.setVisible(false);
            }
        }
    }

    public void setTabTitle(String title, int windowNo) {
        this.setTabTitle(title, this.getTab(windowNo));
    }

    private Tab getTab(int windowNo) {
        org.zkoss.zul.Tabpanels panels = this.tabbox.getTabpanels();
        List childrens = panels.getChildren();
        for (Object child : childrens) {
            Object att;
            Tabpanel panel = (Tabpanel)child;
            Component component = panel.getFirstChild();
            Object object = att = component != null ? component.getAttribute("desktop.windowno") : null;
            if (att == null || !(att instanceof Integer) || windowNo != (Integer)att) continue;
            Tab tab = panel.getLinkedTab();
            return tab;
        }
        return null;
    }

    public void setTabTitle(String title, Tab tab) {
        if (tab == null) {
            return;
        }
        if ((title = title.replaceAll("[&]", "")).length() <= 30) {
            tab.setLabel(title);
        } else {
            tab.setTooltiptext(title);
            title = String.valueOf(title.substring(0, 27)) + "...";
            tab.setLabel(title);
        }
    }

    public org.adempiere.webui.component.Tab insertAfter(org.adempiere.webui.component.Tab refTab, Component comp, String title, boolean closeable, boolean enable, Tab.DecorateInfo decorateInfo) {
        if (refTab == null) {
            return this.addWindow(comp, title, closeable, enable, decorateInfo);
        }
        return this.insertBefore((org.adempiere.webui.component.Tab)refTab.getNextSibling(), comp, title, closeable, enable, decorateInfo);
    }

    public void setSelectedTab(Tab tab) {
        if (this.isMobile()) {
            this.updateMobileTabState(tab);
        }
        this.tabbox.setSelectedTab(tab);
        if (this.isMobile()) {
            this.tabbox.getTabs().invalidate();
        }
    }

    private void updateMobileTabState(Tab tab) {
        if (this.isMobile() && this.tabListBtn != null) {
            List tabs = this.tabbox.getTabs().getChildren();
            for (Component c : tabs) {
                org.adempiere.webui.component.Tab t;
                if (!(c instanceof org.adempiere.webui.component.Tab)) continue;
                t.setVisible((t = (org.adempiere.webui.component.Tab)c) == tab);
                t.getLinkedPanel().setVisible(t == tab);
                if (!t.isVisible()) continue;
                Events.postEvent((String)ON_MOBILE_SET_SELECTED_TAB, (Component)t.getLinkedPanel(), null);
            }
        }
    }

    private boolean isMobile() {
        return ClientInfo.isMobile();
    }

    public boolean closeActiveWindow() {
        org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)this.tabbox.getSelectedTab();
        this.tabbox.getSelectedTab().onClose();
        return tab.getParent() == null;
    }

    public org.adempiere.webui.component.Tab getSelectedTab() {
        return (org.adempiere.webui.component.Tab)this.tabbox.getSelectedTab();
    }

    public void setTabTitle(int tabNo, String title, String tooltip) {
        org.zkoss.zul.Tabs tabs = this.tabbox.getTabs();
        org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)((Object)tabs.getChildren().get(tabNo));
        this.setTabTitle(title, tab);
        if (tooltip != null && tooltip.trim().length() > 0) {
            tab.setTooltiptext(tooltip);
        }
    }

    public Tabbox getComponent() {
        return this.tabbox;
    }

    public ToolBar getToobar() {
        return this.toolbar;
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget() == this.tabbox && "onPageDetached".equals(event.getName())) {
            try {
                SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", this);
            }
            catch (Exception exception) {}
        } else if (event.getTarget() == this.tabbox && "onPageAttached".equals(event.getName())) {
            try {
                SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
            }
            catch (Exception exception) {}
        } else if ("onCtrlKey".equals(event.getName())) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (keyEvent.isAltKey() && keyEvent.getKeyCode() == 34 && this.tabbox.getSelectedTab() != null && this.tabbox.getSelectedTab().getNextSibling() != null) {
                this.tabbox.setSelectedTab((Tab)this.tabbox.getSelectedTab().getNextSibling());
                keyEvent.stopPropagation();
            } else if (keyEvent.isAltKey() && keyEvent.getKeyCode() == 33 && this.tabbox.getSelectedTab() != null && this.tabbox.getSelectedTab().getPreviousSibling() != null) {
                this.tabbox.setSelectedTab((Tab)this.tabbox.getSelectedTab().getPreviousSibling());
                keyEvent.stopPropagation();
            }
        }
    }
}

