/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.panel.WRCTabPanel;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MRefList;
import org.compiere.print.MPrintFormatItem;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.Vbox;

public class WRC3SortCriteriaPanel
extends WRCTabPanel
implements EventListener<Event> {
    private static final long serialVersionUID = 6470498382547293013L;
    private Label noLabel = new Label();
    private Label yesLabel = new Label();
    private Button bAdd = new Button();
    private Button bRemove = new Button();
    private Button bUp = new Button();
    private Button bDown = new Button();
    SimpleListModel noModel = new SimpleListModel();
    SimpleListModel yesModel = new SimpleListModel();
    Listbox noList = new Listbox();
    Listbox yesList = new Listbox();
    ArrayList<MPrintFormatItem> yesItems = new ArrayList();
    ArrayList<MPrintFormatItem> noItems = new ArrayList();
    private final String asc_desc = "asc_desc";

    public void init() {
        this.noLabel.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Available"));
        this.yesLabel.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"OrderBy"));
        ZKUpdateUtil.setVflex(this.yesList, true);
        ZKUpdateUtil.setVflex(this.noList, true);
        EventListener<Event> mouseListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if ("onDoubleClick".equals(event.getName())) {
                    WRC3SortCriteriaPanel.this.migrateValueAcrossLists(event);
                }
            }
        };
        this.yesList.addDoubleClickListener(mouseListener);
        this.noList.addDoubleClickListener(mouseListener);
        EventListener<Event> actionListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                WRC3SortCriteriaPanel.this.migrateValueAcrossLists(event);
            }
        };
        this.yesList.addEventListener("onRightClick", this);
        this.yesList.setSeltype("multiple");
        this.noList.setSeltype("multiple");
        this.bAdd.setImage(ThemeManager.getThemeResource("images/Next24.png"));
        this.bAdd.addEventListener("onClick", (EventListener)actionListener);
        this.bRemove.setImage(ThemeManager.getThemeResource("images/Previous24.png"));
        this.bRemove.addEventListener("onClick", (EventListener)actionListener);
        DragListener crossListMouseListener = new DragListener();
        this.yesList.addOnDropListener(crossListMouseListener);
        this.noList.addOnDropListener(crossListMouseListener);
        this.yesList.setItemDraggable(true);
        this.noList.setItemDraggable(true);
        ListHead listHead = new ListHead();
        listHead.setParent((Component)this.yesList);
        ListHeader listHeader = new ListHeader();
        listHeader.appendChild((Component)this.yesLabel);
        listHeader.setParent((Component)listHead);
        listHead = new ListHead();
        listHead.setParent((Component)this.noList);
        listHeader = new ListHeader();
        listHeader.appendChild((Component)this.noLabel);
        listHeader.setParent((Component)listHead);
        Hlayout hlayout = new Hlayout();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)hlayout, "true");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)hlayout, "true");
        hlayout.setStyle("width:80%;height:80%;border:none;margin:none;padding:none");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.noList, "1");
        ZKUpdateUtil.setVflex(this.noList, true);
        hlayout.appendChild((Component)this.noList);
        Vbox vbox = new Vbox();
        vbox.appendChild((Component)this.bAdd);
        vbox.appendChild((Component)this.bRemove);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vbox, "50px");
        hlayout.appendChild((Component)vbox);
        ZKUpdateUtil.setVflex(this.yesList, true);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.yesList, "1");
        hlayout.appendChild((Component)this.yesList);
        EventListener<Event> actionListener2 = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                WRC3SortCriteriaPanel.this.migrateValueWithinYesList(event);
            }
        };
        this.bUp.setImage(ThemeManager.getThemeResource("images/Parent24.png"));
        this.bUp.addEventListener("onClick", (EventListener)actionListener2);
        this.bDown.setImage(ThemeManager.getThemeResource("images/Detail24.png"));
        this.bDown.addEventListener("onClick", (EventListener)actionListener2);
        vbox = new Vbox();
        vbox.appendChild((Component)this.bUp);
        vbox.appendChild((Component)this.bDown);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vbox, "46px");
        hlayout.appendChild((Component)vbox);
        this.appendChild((Component)hlayout);
    }

    public void onEvent(Event event) throws Exception {
        Menuitem menuItem;
        if (event.getTarget() == this.yesList) {
            if (this.yesList.getSelectedItems().size() > 1) {
                return;
            }
            Menupopup m_popup = new Menupopup();
            Menuitem menuItem2 = new Menuitem(this.yesItems.get(this.yesList.getSelectedIndex()).isDesc() ? String.valueOf(this.getOrderByDesc()) + " -> " + this.getOrderByAsc() : String.valueOf(this.getOrderByAsc()) + " -> " + this.getOrderByDesc());
            menuItem2.setValue("asc_desc");
            menuItem2.addEventListener("onClick", (EventListener)this);
            m_popup.appendChild((Component)menuItem2);
            m_popup.setPage(this.yesList.getPage());
            m_popup.open((Component)this.yesList);
        } else if (event.getTarget() instanceof Menuitem && !Util.isEmpty((String)(menuItem = (Menuitem)event.getTarget()).getValue()) && menuItem.getValue().equals("asc_desc")) {
            MPrintFormatItem pfi;
            pfi.setIsDesc(!(pfi = this.yesItems.get(this.yesList.getSelectedIndex())).isDesc());
            pfi.saveEx();
            this.refresh();
        }
    }

    public void setListsColumns() {
        this.yesItems = new ArrayList();
        this.noItems = new ArrayList();
        int i = 0;
        while (i < this.m_pfi.size()) {
            MPrintFormatItem item = (MPrintFormatItem)this.m_pfi.get(i);
            if (item != null) {
                if (item.isOrderBy()) {
                    this.yesItems.add(item);
                } else {
                    this.noItems.add(item);
                }
            }
            ++i;
        }
        Collections.sort(this.yesItems, new Comparator<MPrintFormatItem>(){

            @Override
            public int compare(MPrintFormatItem o1, MPrintFormatItem o2) {
                return o1.getSortNo() - o2.getSortNo();
            }
        });
    }

    @Override
    public void refresh() {
        String name;
        int ID;
        int i;
        this.setListsColumns();
        this.yesList.removeAllItems();
        this.noList.removeAllItems();
        if (this.yesItems.size() > 0 && this.yesItems != null) {
            this.yesModel.removeAllElements();
            i = 0;
            while (i < this.yesItems.size()) {
                ID = this.yesItems.get(i).get_ID();
                name = this.getName(this.yesItems.get(i));
                this.yesList.addItem(new KeyNamePair(ID, name));
                this.yesModel.addElement((Object)new ListElement(ID, name, this.yesItems.get(i).getSortNo(), true, this.yesItems.get(i).getAD_Client_ID(), this.yesItems.get(i).getAD_Org_ID()));
                ++i;
            }
        }
        if (this.noItems.size() > 0 && this.noItems != null) {
            this.noModel.removeAllElements();
            i = 0;
            while (i < this.noItems.size()) {
                ID = this.noItems.get(i).get_ID();
                name = this.noItems.get(i).getPrintName() == null ? this.noItems.get(i).getName() : this.noItems.get(i).getPrintName();
                this.noItems.get(i).setSortNo(0);
                this.noItems.get(i).setIsOrderBy(false);
                this.noList.addItem(new KeyNamePair(ID, name));
                this.noModel.add(i, (Object)new ListElement(ID, name, this.noItems.get(i).getSortNo(), false, this.noItems.get(i).getAD_Client_ID(), this.noItems.get(i).getAD_Org_ID()));
                ++i;
            }
        }
    }

    String getName(MPrintFormatItem pfi) {
        StringBuilder name = new StringBuilder(Util.isEmpty((String)pfi.getPrintName()) ? pfi.getName() : pfi.getPrintName()).append(" (").append(pfi.isDesc() ? this.getOrderByDesc() : this.getOrderByAsc()).append(")");
        return name.toString();
    }

    String getOrderByAsc() {
        return MRefList.getListName((Properties)Env.getCtx(), (int)53296, (String)"A");
    }

    String getOrderByDesc() {
        return MRefList.getListName((Properties)Env.getCtx(), (int)53296, (String)"D");
    }

    @Override
    public void updatePFI() {
    }

    void migrateValueAcrossLists(Event event) {
        Component source = event.getTarget();
        if (source instanceof ListItem) {
            source = ((ListItem)source).getListbox();
        }
        Listbox listFrom = source == this.bAdd || source == this.noList ? this.noList : this.yesList;
        Listbox listTo = source == this.bAdd || source == this.noList ? this.yesList : this.noList;
        int endIndex = this.yesList.getIndexOfItem(listTo.getSelectedItem());
        if (endIndex < 0) {
            endIndex = 0;
        }
        this.migrateLists(listFrom, listTo, endIndex);
    }

    void migrateLists(Listbox listFrom, Listbox listTo, int endIndex) {
        int index = 0;
        SimpleListModel lmFrom = listFrom == this.yesList ? this.yesModel : this.noModel;
        SimpleListModel lmTo = lmFrom == this.yesModel ? this.noModel : this.yesModel;
        Set selectedItems = listFrom.getSelectedItems();
        ArrayList<ListElement> selObjects = new ArrayList<ListElement>();
        for (Object obj : selectedItems) {
            ListItem listItem = (ListItem)((Object)obj);
            index = listFrom.getIndexOfItem(listItem);
            ListElement selObject = (ListElement)((Object)lmFrom.getElementAt(index));
            selObjects.add(selObject);
        }
        index = 0;
        boolean reOrder = false;
        Arrays.sort(selObjects.toArray());
        for (ListElement selObject : selObjects) {
            if (selObject == null) continue;
            lmFrom.removeElement((Object)selObject);
            lmTo.add(endIndex, (Object)selObject);
            index = this.m_pfi.indexOf(this.getPrintFormatItem(selObject.m_key));
            if (listFrom.equals((Object)this.noList)) {
                ((MPrintFormatItem)this.m_pfi.get(index)).setIsOrderBy(true);
                reOrder = true;
                continue;
            }
            ((MPrintFormatItem)this.m_pfi.get(index)).setIsOrderBy(false);
        }
        if (reOrder) {
            int sortNo = 10;
            ArrayList<ListElement> pp = new ArrayList<ListElement>();
            int i = 0;
            while (i < lmTo.getSize()) {
                ListElement aux = (ListElement)((Object)lmTo.getElementAt(i));
                aux.setSortNo(sortNo);
                sortNo = 10;
                pp.add(aux);
                ++i;
            }
            Collections.sort(pp, new Comparator<ListElement>(){

                @Override
                public int compare(ListElement o1, ListElement o2) {
                    return o1.getSortNo() - o2.getSortNo();
                }
            });
            for (ListElement ele : pp) {
                int auxIndex = this.m_pfi.indexOf(this.getPrintFormatItem(ele.m_key));
                ((MPrintFormatItem)this.m_pfi.get(auxIndex)).setSortNo(sortNo);
                sortNo += 10;
            }
            this.wc.setIsChanged(true);
        }
        this.refresh();
        if (listTo.getSelectedItem() != null) {
            AuFocus focus = new AuFocus((Component)listTo.getSelectedItem());
            Clients.response((AuResponse)focus);
        }
    }

    void migrateValueWithinYesList(int endIndex, List<ListElement> selObjects) {
        int iniIndex = 0;
        Arrays.sort(selObjects.toArray());
        ListElement selObject = null;
        ListElement endObject = (ListElement)((Object)this.yesModel.getElementAt(endIndex));
        for (ListElement selected : selObjects) {
            iniIndex = this.yesModel.indexOf((Object)selected);
            selObject = (ListElement)((Object)this.yesModel.getElementAt(iniIndex));
            this.yesModel.removeElement((Object)selObject);
            endIndex = this.yesModel.indexOf((Object)endObject);
            this.yesModel.add(endIndex, (Object)selObject);
        }
        int sortNo = 10;
        int auxIndex = 0;
        this.yesList.removeAllItems();
        int i = 0;
        while (i < this.yesModel.getSize()) {
            ListElement pp = (ListElement)((Object)this.yesModel.getElementAt(i));
            auxIndex = this.m_pfi.indexOf(this.getPrintFormatItem(pp.m_key));
            ((MPrintFormatItem)this.m_pfi.get(auxIndex)).setSortNo(sortNo);
            this.yesList.addItem(new KeyNamePair(pp.m_key, pp.getName()));
            sortNo += 10;
            ++i;
        }
    }

    private void migrateValueWithinYesList(Event event) {
        ListElement newObject;
        ListElement selObject;
        int index;
        int i;
        Object[] selObjects = this.yesList.getSelectedItems().toArray();
        if (selObjects == null) {
            return;
        }
        int length = selObjects.length;
        if (length == 0) {
            return;
        }
        int[] indices = this.yesList.getSelectedIndices();
        boolean change = false;
        int selectedPI = 0;
        int targetPI = 0;
        MPrintFormatItem orig = null;
        Component source = event.getTarget();
        if (source == this.bUp) {
            i = 0;
            while (i < length) {
                index = indices[i];
                if (index != 0) {
                    selObject = (ListElement)((Object)this.yesModel.getElementAt(index));
                    newObject = (ListElement)((Object)this.yesModel.getElementAt(index - 1));
                    this.yesModel.setElementAt((Object)newObject, index);
                    this.yesModel.setElementAt((Object)selObject, index - 1);
                    this.yesList.setSelectedIndex(index - 1);
                    selectedPI = this.m_pfi.indexOf(this.getPrintFormatItem(selObject.m_key));
                    targetPI = this.m_pfi.indexOf(this.getPrintFormatItem(newObject.m_key));
                    this.updateSortNo(selectedPI, targetPI);
                    this.yesItems.get(index).setSortNo(this.yesItems.get(index).getSortNo() - 10);
                    orig = this.yesItems.get(index);
                    this.yesItems.get(index - 1).setSeqNo(this.yesItems.get(index - 1).getSeqNo() + 10);
                    this.yesItems.set(index, this.yesItems.get(index - 1));
                    this.yesItems.set(index - 1, orig);
                    indices[i] = index - 1;
                    change = true;
                    ++i;
                    continue;
                }
                break;
            }
        } else if (source == this.bDown) {
            i = length - 1;
            while (i >= 0) {
                index = indices[i];
                if (index < this.yesModel.getSize() - 1) {
                    selObject = (ListElement)((Object)this.yesModel.getElementAt(index));
                    newObject = (ListElement)((Object)this.yesModel.getElementAt(index + 1));
                    this.yesModel.setElementAt((Object)newObject, index);
                    this.yesModel.setElementAt((Object)selObject, index + 1);
                    this.yesList.setSelectedIndex(index + 1);
                    selectedPI = this.m_pfi.indexOf(this.getPrintFormatItem(selObject.m_key));
                    targetPI = this.m_pfi.indexOf(this.getPrintFormatItem(newObject.m_key));
                    this.updateSortNo(selectedPI, targetPI);
                    this.yesItems.get(index).setSeqNo(this.yesItems.get(index).getSeqNo() + 10);
                    orig = (MPrintFormatItem)this.m_pfi.get(index);
                    this.yesItems.get(index + 1).setSeqNo(this.yesItems.get(index + 1).getSeqNo() - 10);
                    this.yesItems.set(index, this.yesItems.get(index + 1));
                    this.yesItems.set(index + 1, orig);
                    indices[i] = index + 1;
                    change = true;
                    --i;
                    continue;
                }
                break;
            }
        }
        if (change) {
            this.yesList.removeAllItems();
            i = 0;
            while (i < this.yesModel.getSize()) {
                ListElement pp = (ListElement)((Object)this.yesModel.getElementAt(i));
                this.yesList.addItem(new KeyNamePair(pp.m_key, pp.getName()));
                ++i;
            }
            this.yesList.setSelectedIndices(indices);
            this.wc.setIsChanged(true);
            if (this.yesList.getSelectedItem() != null) {
                AuFocus focus = new AuFocus((Component)this.yesList.getSelectedItem());
                Clients.response((AuResponse)focus);
            }
        }
    }

    private void updateSortNo(int selIndexPI, int targetIndexPI) {
        int selSortNo = ((MPrintFormatItem)this.m_pfi.get(selIndexPI)).getSortNo();
        ((MPrintFormatItem)this.m_pfi.get(selIndexPI)).setSortNo(((MPrintFormatItem)this.m_pfi.get(targetIndexPI)).getSortNo());
        ((MPrintFormatItem)this.m_pfi.get(targetIndexPI)).setSortNo(selSortNo);
    }

    private class DragListener
    implements EventListener<Event> {
        public void onEvent(Event event) throws Exception {
            if (event instanceof DropEvent) {
                int endIndex = 0;
                DropEvent me = (DropEvent)event;
                ListItem endItem = (ListItem)me.getTarget();
                ListItem startItem = (ListItem)me.getDragged();
                if (!startItem.isSelected()) {
                    startItem.setSelected(true);
                }
                if (startItem.getListbox() != endItem.getListbox()) {
                    Listbox listFrom = (Listbox)startItem.getListbox();
                    Listbox listTo = (Listbox)endItem.getListbox();
                    endIndex = WRC3SortCriteriaPanel.this.yesList.getIndexOfItem(endItem);
                    WRC3SortCriteriaPanel.this.migrateLists(listFrom, listTo, endIndex);
                } else if (startItem.getListbox() == endItem.getListbox() && startItem.getListbox() == WRC3SortCriteriaPanel.this.yesList) {
                    ArrayList<ListElement> selObjects = new ArrayList<ListElement>();
                    endIndex = WRC3SortCriteriaPanel.this.yesList.getIndexOfItem(endItem);
                    for (Object obj : WRC3SortCriteriaPanel.this.yesList.getSelectedItems()) {
                        ListItem listItem = (ListItem)((Object)obj);
                        int index = WRC3SortCriteriaPanel.this.yesList.getIndexOfItem(listItem);
                        ListElement selObject = (ListElement)((Object)WRC3SortCriteriaPanel.this.yesModel.getElementAt(index));
                        selObjects.add(selObject);
                    }
                    WRC3SortCriteriaPanel.this.migrateValueWithinYesList(endIndex, selObjects);
                }
            }
        }
    }

    public static class ListElement
    extends NamePair {
        private static final long serialVersionUID = -5645910649588308798L;
        private int m_key;
        private int m_AD_Client_ID;
        private int m_AD_Org_ID;
        private int m_sortNo;
        private boolean m_isYes;

        public ListElement(int key, String name, int sortNo, boolean isYes, int AD_Client_ID, int AD_Org_ID) {
            super(name);
            this.m_key = key;
            this.m_AD_Client_ID = AD_Client_ID;
            this.m_AD_Org_ID = AD_Org_ID;
            this.m_sortNo = sortNo;
            this.m_isYes = isYes;
        }

        public int getKey() {
            return this.m_key;
        }

        public void setSortNo(int sortNo) {
            this.m_sortNo = sortNo;
        }

        public int getSortNo() {
            return this.m_sortNo;
        }

        public void setIsYes(boolean value) {
            this.m_isYes = value;
        }

        public boolean isYes() {
            return this.m_isYes;
        }

        public int getAD_Client_ID() {
            return this.m_AD_Client_ID;
        }

        public int getAD_Org_ID() {
            return this.m_AD_Org_ID;
        }

        public String getID() {
            return this.m_key != -1 ? String.valueOf(this.m_key) : null;
        }

        public int hashCode() {
            return this.m_key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListElement) {
                ListElement li = (ListElement)((Object)obj);
                return li.getKey() == this.m_key && li.getName() != null && li.getName().equals(this.getName()) && li.getAD_Client_ID() == this.m_AD_Client_ID && li.getAD_Org_ID() == this.m_AD_Org_ID;
            }
            return false;
        }

        public String toString() {
            String s = super.toString();
            if (s == null || s.trim().length() == 0) {
                s = "<" + this.getKey() + ">";
            }
            return s;
        }
    }
}

