/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.panel.WRCTabPanel;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.print.MPrintFormatItem;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Vbox;

public class WRC2FieldOrderPanel
extends WRCTabPanel
implements EventListener<Event> {
    private static final long serialVersionUID = -7732332384947376101L;
    private Button bUp = new Button();
    private Button bDown = new Button();
    private ArrayList<MPrintFormatItem> listColumns = new ArrayList();
    SimpleListModel sortModel;
    private Listbox sortList;

    public void setListColumns() {
        this.listColumns = new ArrayList();
        for (MPrintFormatItem item : this.m_pfi) {
            if (item == null || !item.isPrinted()) continue;
            this.listColumns.add(item);
        }
    }

    public void init() {
        Hlayout hlayout = new Hlayout();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)hlayout, "true");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)hlayout, "true");
        hlayout.setStyle("width:80%;height:80%;border:none;margin:none;padding:none");
        this.sortList = new Listbox();
        this.sortModel = new SimpleListModel();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.sortList, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.sortList, "40%");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.sortList, "40");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.sortList, "true");
        this.sortList.addDoubleClickListener(this);
        this.sortList.setSeltype("multiple");
        this.sortList.addOnDropListener(this);
        this.sortList.setItemDraggable(true);
        this.sortList.setDroppable("true");
        this.sortList.setVisible(true);
        this.sortList.setMultiple(true);
        EventListener<Event> sortListMouseMotionListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event instanceof DropEvent) {
                    DropEvent me = (DropEvent)event;
                    ListItem draggedItem = (ListItem)me.getDragged();
                    ListItem targetItem = (ListItem)me.getTarget();
                    if (draggedItem.getListbox() == targetItem.getListbox() && draggedItem.getListbox() == WRC2FieldOrderPanel.this.sortList) {
                        ArrayList<ListElement> selObjects = new ArrayList<ListElement>();
                        int targetIndex = WRC2FieldOrderPanel.this.sortList.getIndexOfItem(targetItem);
                        if (!draggedItem.isSelected()) {
                            draggedItem.setSelected(true);
                        }
                        for (Object obj : WRC2FieldOrderPanel.this.sortList.getSelectedItems()) {
                            ListItem listItem = (ListItem)((Object)obj);
                            int index = WRC2FieldOrderPanel.this.sortList.getIndexOfItem(listItem);
                            ListElement selObject = (ListElement)((Object)WRC2FieldOrderPanel.this.sortModel.getElementAt(index));
                            selObjects.add(selObject);
                        }
                        WRC2FieldOrderPanel.this.migrateValueWithinYesList(targetIndex, selObjects);
                        WRC2FieldOrderPanel.this.wc.setIsChanged(true);
                        WRC2FieldOrderPanel.this.refresh();
                        if (WRC2FieldOrderPanel.this.sortList.getSelectedItem() != null) {
                            AuFocus focus = new AuFocus((Component)WRC2FieldOrderPanel.this.sortList.getSelectedItem());
                            Clients.response((AuResponse)focus);
                        }
                    }
                }
            }
        };
        this.sortList.addOnDropListener(sortListMouseMotionListener);
        ListHead listHead = new ListHead();
        listHead.setParent((Component)this.sortList);
        ListHeader header = new ListHeader();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)header, "40");
        header.setParent((Component)listHead);
        hlayout.appendChild((Component)this.sortList);
        EventListener<Event> actionListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                WRC2FieldOrderPanel.this.migrateValueWithinSortList(event);
            }
        };
        this.bUp.setImage(ThemeManager.getThemeResource("images/Parent24.png"));
        this.bUp.addEventListener("onClick", (EventListener)actionListener);
        this.bDown.setImage(ThemeManager.getThemeResource("images/Detail24.png"));
        this.bDown.addEventListener("onClick", (EventListener)actionListener);
        Vbox vbox = new Vbox();
        vbox.appendChild((Component)this.bUp);
        vbox.appendChild((Component)this.bDown);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vbox, "50px");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)vbox, "60");
        hlayout.appendChild((Component)vbox);
        this.appendChild((Component)hlayout);
    }

    void migrateValueWithinYesList(int endIndex, List<ListElement> selObjects) {
        int iniIndex = 0;
        Arrays.sort(selObjects.toArray());
        ListElement selObject = null;
        ListElement endObject = (ListElement)((Object)this.sortModel.getElementAt(endIndex));
        int targetPFISeq = 0;
        MPrintFormatItem draggedPFI = null;
        for (ListElement selected : selObjects) {
            iniIndex = this.sortModel.indexOf((Object)selected);
            selObject = (ListElement)((Object)this.sortModel.getElementAt(iniIndex));
            draggedPFI = this.listColumns.get(iniIndex);
            this.sortModel.removeElement((Object)selObject);
            this.listColumns.remove(draggedPFI);
            endIndex = this.sortModel.indexOf((Object)endObject);
            targetPFISeq = this.listColumns.get(endIndex).getSeqNo();
            this.listColumns.add(endIndex, draggedPFI);
            this.sortModel.add(endIndex, (Object)selObject);
            draggedPFI.setSeqNo(targetPFISeq - 5);
        }
    }

    public void onEvent(Event event) throws Exception {
    }

    @Override
    public void refresh() {
        this.sortList.removeAllItems();
        this.setListColumns();
        Collections.sort(this.listColumns, new Comparator<MPrintFormatItem>(){

            @Override
            public int compare(MPrintFormatItem o1, MPrintFormatItem o2) {
                return o1.getSeqNo() - o2.getSeqNo();
            }
        });
        if (this.listColumns.size() > 0 && this.listColumns != null) {
            int seq = 10;
            this.sortModel.removeAllElements();
            for (MPrintFormatItem pfi : this.listColumns) {
                pfi.setSeqNo(seq);
                ((MPrintFormatItem)this.m_pfi.get(this.m_pfi.indexOf(pfi))).setSeqNo(seq);
                String name = pfi.getPrintName() == null ? pfi.getName() : pfi.getPrintName();
                ListElement element = new ListElement(pfi.get_ID(), name, pfi.getSeqNo(), pfi.getAD_Client_ID(), pfi.getAD_Org_ID());
                this.sortModel.addElement((Object)element);
                this.sortList.addItem(new KeyNamePair(((MPrintFormatItem)this.m_pfi.get(this.m_pfi.indexOf(pfi))).get_ID(), name));
                seq += 10;
            }
        }
    }

    @Override
    public void updatePFI() {
    }

    void migrateValueWithinSortList(Event event) {
        int i;
        Object[] selObjects = this.sortList.getSelectedItems().toArray();
        if (selObjects == null) {
            return;
        }
        int length = selObjects.length;
        if (length == 0) {
            return;
        }
        int[] indices = this.sortList.getSelectedIndices();
        boolean change = false;
        MPrintFormatItem orig = null;
        Component source = event.getTarget();
        if (source == this.bUp) {
            i = 0;
            while (i < length) {
                int index = indices[i];
                if (index != 0) {
                    ListElement selObject = (ListElement)((Object)this.sortModel.getElementAt(index));
                    ListElement newObject = (ListElement)((Object)this.sortModel.getElementAt(index - 1));
                    this.sortModel.setElementAt((Object)newObject, index);
                    this.sortModel.setElementAt((Object)selObject, index - 1);
                    this.listColumns.get(index).setSeqNo(this.listColumns.get(index).getSeqNo() - 10);
                    orig = this.listColumns.get(index);
                    this.listColumns.get(index - 1).setSeqNo(this.listColumns.get(index - 1).getSeqNo() + 10);
                    this.listColumns.set(index, this.listColumns.get(index - 1));
                    this.listColumns.set(index - 1, orig);
                    indices[i] = index - 1;
                    change = true;
                    ++i;
                    continue;
                }
                break;
            }
        } else if (source == this.bDown) {
            i = length - 1;
            while (i >= 0) {
                int index = indices[i];
                if (index < this.sortModel.getSize() - 1) {
                    ListElement selObject = (ListElement)((Object)this.sortModel.getElementAt(index));
                    ListElement newObject = (ListElement)((Object)this.sortModel.getElementAt(index + 1));
                    this.sortModel.setElementAt((Object)newObject, index);
                    this.sortModel.setElementAt((Object)selObject, index + 1);
                    this.listColumns.get(index).setSeqNo(this.listColumns.get(index).getSeqNo() + 10);
                    orig = (MPrintFormatItem)this.m_pfi.get(index);
                    this.listColumns.get(index + 1).setSeqNo(this.listColumns.get(index + 1).getSeqNo() - 10);
                    this.listColumns.set(index, this.listColumns.get(index + 1));
                    this.listColumns.set(index + 1, orig);
                    indices[i] = index + 1;
                    change = true;
                    --i;
                    continue;
                }
                break;
            }
        }
        if (change) {
            this.refresh();
            this.sortList.setSelectedIndices(indices);
            this.wc.setIsChanged(true);
            if (this.sortList.getSelectedItem() != null) {
                AuFocus focus = new AuFocus((Component)this.sortList.getSelectedItem());
                Clients.response((AuResponse)focus);
            }
        }
    }

    public static class ListElement
    extends NamePair {
        private static final long serialVersionUID = -5645910649588308798L;
        private int m_key;
        private int m_AD_Client_ID;
        private int m_AD_Org_ID;
        private int m_sortNo;

        public ListElement(int key, String name, int sortNo, int AD_Client_ID, int AD_Org_ID) {
            super(name);
            this.m_key = key;
            this.m_AD_Client_ID = AD_Client_ID;
            this.m_AD_Org_ID = AD_Org_ID;
            this.m_sortNo = sortNo;
        }

        public int getKey() {
            return this.m_key;
        }

        public void setSortNo(int sortNo) {
            this.m_sortNo = sortNo;
        }

        public int getSortNo() {
            return this.m_sortNo;
        }

        public int getAD_Client_ID() {
            return this.m_AD_Client_ID;
        }

        public int getAD_Org_ID() {
            return this.m_AD_Org_ID;
        }

        public String getID() {
            return this.m_key != -1 ? String.valueOf(this.m_key) : null;
        }

        public int hashCode() {
            return this.m_key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListElement) {
                ListElement li = (ListElement)((Object)obj);
                return li.getKey() == this.m_key && li.getName() != null && li.getName().equals(this.getName()) && li.getAD_Client_ID() == this.m_AD_Client_ID && li.getAD_Org_ID() == this.m_AD_Org_ID;
            }
            return false;
        }

        public String toString() {
            String s = super.toString();
            if (s == null || s.trim().length() == 0) {
                s = "<" + this.getKey() + ">";
            }
            return s;
        }
    }
}

