/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.AdempiereWebUI;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.North;
import org.zkoss.zul.South;
import org.zkoss.zul.Vlayout;

public class WAttachment
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 4311076973993361653L;
    private static CLogger log = CLogger.getCLogger(WAttachment.class);
    private int m_WindowNo;
    private MAttachment m_attachment = null;
    private boolean m_change = false;
    private Iframe preview = new Iframe();
    private Textbox text = new Textbox();
    private Label sizeLabel = new Label();
    private Listbox cbContent = new Listbox();
    private Button bDelete = ButtonFactory.createNamedButton("Delete", false, true);
    private Button bSave = new Button();
    private Button bDeleteAll = new Button();
    private Button bLoad = new Button();
    private Button bCancel = ButtonFactory.createNamedButton("Cancel", false, true);
    private Button bOk = ButtonFactory.createNamedButton("Ok", false, true);
    private Button bRefresh = ButtonFactory.createNamedButton("Refresh", false, true);
    private Panel previewPanel = new Panel();
    private Borderlayout mainPanel = new Borderlayout();
    private Hbox toolBar = new Hbox();
    private Hlayout confirmPanel = new Hlayout();
    private int displayIndex;
    private String orientation;
    private static List<String> autoPreviewList = new ArrayList<String>();

    static {
        autoPreviewList.add("image/jpeg");
        autoPreviewList.add("image/png");
        autoPreviewList.add("image/gif");
        autoPreviewList.add("text/plain");
        autoPreviewList.add("application/pdf");
        autoPreviewList.add("text/html");
    }

    public WAttachment(int WindowNo, int AD_Attachment_ID, int AD_Table_ID, int Record_ID, String trxName) {
        this(WindowNo, AD_Attachment_ID, AD_Table_ID, Record_ID, trxName, null);
    }

    public WAttachment(int WindowNo, int AD_Attachment_ID, int AD_Table_ID, int Record_ID, String trxName, EventListener<Event> eventListener) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("ID=" + AD_Attachment_ID + ", Table=" + AD_Table_ID + ", Record=" + Record_ID);
        }
        this.m_WindowNo = WindowNo;
        this.addEventListener("onWindowClose", this);
        if (eventListener != null) {
            this.addEventListener("onWindowClose", eventListener);
        }
        try {
            this.staticInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
        this.m_attachment = AD_Attachment_ID > 0 ? new MAttachment(Env.getCtx(), AD_Attachment_ID, trxName) : new MAttachment(Env.getCtx(), AD_Table_ID, Record_ID, trxName);
        this.loadAttachments();
        try {
            this.setAttribute("mode", "highlighted");
            AEnv.showWindow(this);
            if (this.autoPreview(0, true)) {
                String script = "setTimeout(\"zk.Widget.$('" + this.preview.getUuid() + "').$n().src = zk.Widget.$('" + this.preview.getUuid() + "').$n().src\", 1000)";
                Clients.response((AuResponse)new AuScript(null, script));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void staticInit() throws Exception {
        this.setAttribute("instanceName", "attachment");
        this.setMaximizable(true);
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 700);
            ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "85%");
        } else {
            this.addCallback("afterPageAttached", (org.zkoss.zk.ui.util.Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"Attachment"));
        this.setClosable(true);
        this.setSizable(true);
        this.setBorder("normal");
        this.setSclass("popup-dialog attachment-dialog");
        this.setShadow(true);
        this.appendChild((Component)this.mainPanel);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.mainPanel, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.mainPanel, "100%");
        North northPanel = new North();
        northPanel.setStyle("padding: 4px");
        northPanel.setCollapsible(false);
        northPanel.setSplittable(false);
        this.cbContent.setMold("select");
        this.cbContent.setRows(0);
        this.cbContent.addEventListener("onSelect", this);
        this.toolBar.setAlign("center");
        this.toolBar.setPack("start");
        this.toolBar.appendChild((Component)this.bLoad);
        this.toolBar.appendChild((Component)this.bDelete);
        this.toolBar.appendChild((Component)this.bSave);
        this.toolBar.appendChild((Component)this.cbContent);
        this.toolBar.appendChild((Component)this.sizeLabel);
        this.mainPanel.appendChild((Component)northPanel);
        Vlayout div = new Vlayout();
        div.appendChild((Component)this.toolBar);
        this.text.setRows(3);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.text, "1");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.text, "100%");
        div.appendChild((Component)this.text);
        northPanel.appendChild((Component)div);
        this.bSave.setEnabled(false);
        this.bSave.setSclass("img-btn");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bSave.setIconSclass("z-icon-Export");
        } else {
            this.bSave.setImage(ThemeManager.getThemeResource("images/Export24.png"));
        }
        this.bSave.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"AttachmentSave"));
        this.bSave.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bLoad.setIconSclass("z-icon-Import");
        } else {
            this.bLoad.setImage(ThemeManager.getThemeResource("images/Import24.png"));
        }
        this.bLoad.setSclass("img-btn");
        this.bLoad.setId("bLoad");
        this.bLoad.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Load"));
        this.bLoad.setUpload("multiple=true," + AdempiereWebUI.getUploadSetting());
        this.bLoad.addEventListener("onUpload", this);
        this.bDelete.addEventListener("onClick", this);
        this.previewPanel.appendChild((Component)this.preview);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.preview, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.preview, "100%");
        Center centerPane = new Center();
        centerPane.setSclass("dialog-content");
        centerPane.setAutoscroll(true);
        this.mainPanel.appendChild((Component)centerPane);
        centerPane.appendChild((Component)this.previewPanel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.previewPanel, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.previewPanel, "1");
        South southPane = new South();
        southPane.setSclass("dialog-footer");
        this.mainPanel.appendChild((Component)southPane);
        southPane.appendChild((Component)this.confirmPanel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)southPane, "min");
        this.bCancel.addEventListener("onClick", this);
        this.bOk.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bDeleteAll.setIconSclass("z-icon-Delete");
        } else {
            this.bDeleteAll.setImage(ThemeManager.getThemeResource("images/Delete24.png"));
        }
        this.bDeleteAll.setSclass("img-btn");
        this.bDeleteAll.addEventListener("onClick", this);
        this.bDeleteAll.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"DeleteAll")));
        this.bRefresh.addEventListener("onClick", this);
        this.confirmPanel.appendChild((Component)this.bDeleteAll);
        this.confirmPanel.appendChild((Component)this.bRefresh);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.confirmPanel, "1");
        Hbox hbox = new Hbox();
        hbox.setPack("end");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)hbox, "1");
        this.confirmPanel.appendChild((Component)hbox);
        hbox.appendChild((Component)this.bOk);
        hbox.appendChild((Component)this.bCancel);
        this.text.setTooltiptext(Msg.getElement((Properties)Env.getCtx(), (String)"TextMsg"));
        if (ClientInfo.isMobile()) {
            this.orientation = ClientInfo.get().orientation;
            ClientInfo.onClientInfo((Component)this, this::onClientInfo);
        }
    }

    protected void onClientInfo() {
        String newOrienation;
        if (this.getPage() != null && !(newOrienation = ClientInfo.get().orientation).equals(this.orientation)) {
            this.orientation = newOrienation;
            ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
            ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            this.invalidate();
        }
    }

    @Override
    public void dispose() {
        this.preview = null;
        this.detach();
    }

    private void loadAttachments() {
        log.config("");
        String sText = this.m_attachment.getTextMsg();
        if (sText == null) {
            this.text.setText("");
        } else {
            this.text.setText(sText);
        }
        int size = this.m_attachment.getEntryCount();
        int i = 0;
        while (i < size) {
            this.cbContent.appendItem(this.m_attachment.getEntryName(i), this.m_attachment.getEntryName(i));
            ++i;
        }
        if (size > 0) {
            this.cbContent.setSelectedIndex(0);
        }
    }

    private boolean autoPreview(int index, boolean immediate) {
        MAttachmentEntry entry = this.m_attachment.getEntry(index);
        if (entry != null) {
            String mimeType = entry.getContentType();
            byte[] data = entry.getData();
            String unit = " KB";
            BigDecimal size = new BigDecimal(data != null ? data.length : 0);
            if ((size = size.divide(new BigDecimal("1024"))).compareTo(new BigDecimal("1024")) >= 0) {
                size = size.divide(new BigDecimal("1024"));
                unit = " MB";
            }
            size = size.setScale(2, RoundingMode.HALF_EVEN);
            this.sizeLabel.setText(String.valueOf(size.toPlainString()) + unit);
            this.bSave.setEnabled(true);
            this.bDelete.setEnabled(true);
            if (autoPreviewList.contains(mimeType)) {
                this.displayData(index, immediate);
                return true;
            }
            this.clearPreview();
            return false;
        }
        this.bSave.setEnabled(false);
        this.bDelete.setEnabled(false);
        this.sizeLabel.setText("");
        return false;
    }

    private void displayData(int index, boolean immediate) {
        this.preview.setSrc(null);
        this.displayIndex = index;
        if (immediate) {
            this.displaySelected();
        } else {
            Clients.response((AuResponse)new AuEcho((Component)this, "displaySelected", null));
        }
    }

    private void clearPreview() {
        this.preview.setSrc(null);
        this.preview.setVisible(false);
    }

    public void displaySelected() {
        MAttachmentEntry entry = this.m_attachment.getEntry(this.displayIndex);
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Index=" + this.displayIndex + " - " + entry);
        }
        if (entry != null && entry.getData() != null && autoPreviewList.contains(entry.getContentType())) {
            if (log.isLoggable(Level.CONFIG)) {
                log.config(entry.toStringX());
            }
            try {
                String contentType = entry.getContentType();
                AMedia media = new AMedia(entry.getName(), null, contentType, entry.getData());
                this.preview.setContent((Media)media);
                this.preview.setVisible(true);
                this.preview.invalidate();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "attachment", (Throwable)e);
            }
        }
    }

    private String getFileName(int index) {
        String fileName = null;
        if (index >= 0 && this.cbContent.getItemCount() > index) {
            ListItem listitem = this.cbContent.getItemAtIndex(index);
            fileName = (String)listitem.getValue();
        }
        return fileName;
    }

    public void onEvent(Event e) {
        if (e instanceof UploadEvent) {
            this.preview.setVisible(false);
            UploadEvent ue = (UploadEvent)e;
            Media[] mediaArray = ue.getMedias();
            int n = mediaArray.length;
            int n2 = 0;
            while (n2 < n) {
                Media media = mediaArray[n2];
                this.processUploadMedia(media);
                ++n2;
            }
            this.clearPreview();
            this.autoPreview(this.cbContent.getSelectedIndex(), false);
        } else if (e.getTarget() == this.bOk || "onWindowClose".equals(e.getName())) {
            if (this.m_attachment != null) {
                String oldText;
                String newText = this.text.getText();
                if (newText == null) {
                    newText = "";
                }
                if ((oldText = this.m_attachment.getTextMsg()) == null) {
                    oldText = "";
                }
                if (!this.m_change) {
                    boolean bl = this.m_change = !newText.equals(oldText);
                }
                if (newText.length() > 0 || this.m_attachment.getEntryCount() > 0) {
                    if (this.m_change) {
                        this.m_attachment.setBinaryData(new byte[0]);
                        this.m_attachment.setTextMsg(this.text.getText());
                        this.m_attachment.saveEx();
                        this.m_change = false;
                    }
                } else {
                    this.m_attachment.delete(true);
                    this.m_attachment = null;
                }
                this.dispose();
            }
        } else if (e.getTarget() == this.bCancel) {
            this.dispose();
        } else if (e.getTarget() == this.bDeleteAll) {
            this.deleteAttachment();
            this.dispose();
        } else if (e.getTarget() == this.bDelete) {
            this.deleteAttachmentEntry();
        } else if (e.getTarget() == this.cbContent) {
            this.clearPreview();
            this.autoPreview(this.cbContent.getSelectedIndex(), false);
        } else if (e.getTarget() == this.bSave) {
            this.saveAttachmentToFile();
        } else if (e.getTarget() == this.bRefresh) {
            this.displayData(this.cbContent.getSelectedIndex(), true);
        }
    }

    private void processUploadMedia(Media media) {
        if (media == null || media.getByteData().length <= 0) {
            this.preview.setVisible(true);
            this.preview.invalidate();
            return;
        }
        String fileName = media.getName();
        log.config(fileName);
        int cnt = this.m_attachment.getEntryCount();
        int i = 0;
        while (i < cnt) {
            if (this.m_attachment.getEntryName(i).equals(fileName)) {
                this.m_attachment.updateEntry(i, this.getMediaData(media));
                this.cbContent.setSelectedIndex(i);
                this.m_change = true;
                return;
            }
            ++i;
        }
        if (this.m_attachment.addEntry(fileName, this.getMediaData(media))) {
            this.cbContent.appendItem(media.getName(), media.getName());
            this.cbContent.setSelectedIndex(this.cbContent.getItemCount() - 1);
            this.m_change = true;
        }
    }

    private byte[] getMediaData(Media media) {
        byte[] bytes = null;
        try {
            if (media.inMemory()) {
                bytes = media.isBinary() ? media.getByteData() : media.getStringData().getBytes(WAttachment.getCharset(media.getContentType()));
            } else {
                InputStream is = media.getStreamData();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[1000];
                int byteread = 0;
                while ((byteread = is.read(buf)) != -1) {
                    baos.write(buf, 0, byteread);
                }
                bytes = baos.toByteArray();
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            throw new IllegalStateException(e.getLocalizedMessage());
        }
        return bytes;
    }

    private void deleteAttachment() {
        log.info("");
        FDialog.ask(this.m_WindowNo, (Component)this, "AttachmentDelete?", new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue() && WAttachment.this.m_attachment != null) {
                    WAttachment.this.m_attachment.delete(true);
                    WAttachment.this.m_attachment = null;
                }
            }
        });
    }

    private void deleteAttachmentEntry() {
        log.info("");
        final int index = this.cbContent.getSelectedIndex();
        String fileName = this.getFileName(index);
        if (fileName == null) {
            return;
        }
        FDialog.ask(this.m_WindowNo, (Component)this, "AttachmentDeleteEntry?", new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    if (WAttachment.this.m_attachment.deleteEntry(index)) {
                        WAttachment.this.cbContent.removeItemAt(index);
                        WAttachment.this.clearPreview();
                        WAttachment.this.autoPreview(WAttachment.this.cbContent.getSelectedIndex(), true);
                    }
                    WAttachment.this.m_change = true;
                }
            }
        });
    }

    private void saveAttachmentToFile() {
        int index = this.cbContent.getSelectedIndex();
        log.info("index=" + index);
        if (this.m_attachment.getEntryCount() < index) {
            return;
        }
        MAttachmentEntry entry = this.m_attachment.getEntry(index);
        if (entry != null && entry.getData() != null) {
            try {
                AMedia media = new AMedia(entry.getName(), null, entry.getContentType(), entry.getData());
                Filedownload.save((Media)media);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "attachment", (Throwable)e);
            }
        }
    }

    private static String getCharset(String contentType) {
        String cs;
        int j;
        if (contentType != null && (j = contentType.indexOf("charset=")) >= 0 && (cs = contentType.substring(j + 8).trim()).length() > 0) {
            return cs;
        }
        return "UTF-8";
    }
}

