/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.AutoComplete;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.DocumentSearch;
import org.adempiere.webui.util.TreeItemAction;
import org.adempiere.webui.util.TreeNodeAction;
import org.adempiere.webui.util.TreeUtils;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MTreeNode;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.A;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.event.TreeDataEvent;
import org.zkoss.zul.event.TreeDataListener;
import org.zkoss.zul.impl.LabelElement;
import org.zkoss.zul.impl.LabelImageElement;

public class TreeSearchPanel
extends Panel
implements EventListener<Event>,
TreeDataListener,
IdSpace {
    public static final String TREE_ROW_MOVABLE = "tree.row.movable";
    private static final long serialVersionUID = -1659100374345282774L;
    private static final String ON_COMBO_SELECT_ECHO_EVENT = "onComboSelectEcho";
    private static final String ON_POST_SELECT_TREEITEM_EVENT = "onPostSelectTreeitem";
    protected static final String ON_POST_FIRE_TREE_EVENT = "onPostFireTreeEvent";
    protected TreeMap<String, Object> treeNodeItemMap = new TreeMap();
    protected String[] treeValues;
    protected String[] treeTypes;
    protected String[] treeDescription;
    protected String[] treeImages;
    private Label lblSearch;
    protected AutoComplete cmbSearch;
    protected Tree tree;
    protected String eventToFire;
    private int m_windowno = 0;
    private int m_tabno = 0;
    private Treeitem selectedItem;
    protected Hlayout layout;
    private Hlayout moveItemBox;
    private ToolBarButton moveItemBtn;
    private static final String PREFIX_DOCUMENT_SEARCH = "/";
    private static final String onComboSelectEchoScript = "var combo=zk('@combo').$();var panel=zk('@this').$();var comboitem=zk('@item').$();var popupheight=combo.getPopupNode_().offsetHeight;var evt = new zk.Event(panel, 'onComboSelectEcho', [comboitem.uuid, popupheight], {toServer: true});zAu.send(evt);";

    public TreeSearchPanel(Tree tree) {
        this(tree, "onClick");
    }

    public TreeSearchPanel(Tree tree, String event) {
        this.tree = tree;
        this.eventToFire = event;
        this.init();
    }

    public TreeSearchPanel(Tree tree, String event, int windowno, int tabno) {
        this.tree = tree;
        this.eventToFire = event;
        this.m_windowno = windowno;
        this.m_tabno = tabno;
        this.init();
    }

    protected void init() {
        this.layout = new Hlayout();
        this.layout.setValign("middle");
        this.lblSearch = new Label();
        this.lblSearch.setValue(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"TreeSearch").replaceAll("&", "")) + ":");
        this.lblSearch.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"TreeSearchText"));
        this.cmbSearch = new AutoComplete();
        this.cmbSearch.setAutodrop(true);
        this.cmbSearch.setAutocomplete(false);
        this.cmbSearch.setId("treeSearchCombo");
        this.cmbSearch.setSclass("tree-search-combo");
        this.cmbSearch.addEventListener("onOK", this);
        this.cmbSearch.addEventListener("onSelect", (EventListener)new EventListener<SelectEvent<Comboitem, Object>>(){

            public void onEvent(SelectEvent<Comboitem, Object> event) throws Exception {
                Set set = event.getSelectedItems();
                if (set.size() > 0) {
                    Comboitem item = (Comboitem)set.iterator().next();
                    String script = TreeSearchPanel.onComboSelectEchoScript.replaceFirst("@combo", TreeSearchPanel.this.cmbSearch.getUuid()).replaceFirst("@this", TreeSearchPanel.this.getUuid()).replaceFirst("@item", item.getUuid());
                    AuScript response = new AuScript(script);
                    Clients.response((AuResponse)response);
                }
            }
        });
        this.addEventListener(ON_COMBO_SELECT_ECHO_EVENT, this);
        this.addEventListener(ON_POST_SELECT_TREEITEM_EVENT, this);
        if (AEnv.isInternetExplorer()) {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.cmbSearch, "200px");
        }
        this.layout.appendChild((Component)this.lblSearch);
        this.layout.appendChild((Component)this.cmbSearch);
        if (ClientInfo.isMobile()) {
            this.moveItemBtn = new ToolBarButton();
            this.moveItemBtn.setSclass("tree-moveitem-btn");
            this.moveItemBtn.setIconSclass("z-icon-arrows-alt");
            this.layout.appendChild((Component)this.moveItemBtn);
            this.moveItemBtn.addEventListener("onClick", evt -> this.onMoveBtnClicked());
            this.tree.addEventListener("onPostMove", evt -> this.onPostMove(evt));
        }
        this.appendChild((Component)this.layout);
        this.addEventListener(ON_POST_FIRE_TREE_EVENT, this);
        if (ClientInfo.isMobile()) {
            this.tree.addEventListener("onSelect", evt -> this.onSelect(evt));
        }
    }

    private void onSelect(Event evt) {
        if (this.moveItemBox != null) {
            Treeitem selected = this.tree.getSelectedItem();
            Treerow selectedRow = selected.getTreerow();
            Component dragged = (Component)this.moveItemBox.getAttribute("draggedComponent");
            DropEvent event = new DropEvent("onDrop", (Component)selectedRow, dragged, 0, 0, 0, 0, 0);
            this.moveItemBox.detach();
            this.moveItemBox = null;
            this.moveItemBtn.setSclass("tree-moveitem-btn");
            this.moveItemBtn.setAttribute("draggedComponent", dragged);
            Events.postEvent((Event)event);
            Events.postEvent((String)"onPostMove", (Component)this.tree, (Object)selected);
        }
    }

    private void onPostMove(Event evt) {
        Treeitem next;
        Treeitem item = (Treeitem)evt.getData();
        Treerow dragged = (Treerow)this.moveItemBtn.getAttribute("draggedComponent");
        if (dragged == null) {
            return;
        }
        Treeitem draggedItem = (Treeitem)dragged.getParent();
        if (item.getNextSibling() != null && (next = (Treeitem)item.getNextSibling()).getValue().equals(draggedItem.getValue())) {
            this.tree.setSelectedItem(next);
            next.focus();
            Events.postEvent((String)"onSelect", (Component)this.tree, (Object)next);
        }
    }

    private void onMoveBtnClicked() {
        if (this.moveItemBox != null) {
            this.moveItemBox.detach();
            this.moveItemBox = null;
            this.moveItemBtn.setSclass("tree-moveitem-btn");
            Treeitem ti = this.tree.getSelectedItem();
            if (ti != null) {
                ti.focus();
            }
            return;
        }
        this.moveItemBtn.setSclass("tree-moveitem-btn pressed");
        Treeitem ti = this.tree.getSelectedItem();
        if (ti == null) {
            return;
        }
        Treerow tr2 = ti.getTreerow();
        if (tr2 == null) {
            return;
        }
        if (tr2.getAttribute(TREE_ROW_MOVABLE) == null) {
            return;
        }
        this.moveItemBox = new Hlayout();
        Label l = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"MoveSelectedTreeItem"));
        l.setStyle("font-weight: 600");
        this.moveItemBox.appendChild((Component)l);
        this.moveItemBox.setValign("middle");
        ToolBarButton btn = new ToolBarButton();
        btn.setIconSclass("z-icon-remove");
        this.moveItemBox.appendChild((Component)btn);
        this.moveItemBox.setAttribute("draggedComponent", (Object)tr2);
        btn.addEventListener("onClick", e -> {
            this.moveItemBox.detach();
            this.moveItemBox = null;
            this.moveItemBtn.setSclass("tree-moveitem-btn");
            if (this.tree.getSelectedItem() != null) {
                this.tree.getSelectedItem().focus();
            }
        });
        this.insertBefore((Component)this.moveItemBox, (Component)this.layout);
        String script = "var w=zk.Widget.$('#" + this.moveItemBox.getUuid() + "'); ";
        script = String.valueOf(script) + "var e=jq('#" + this.layout.getUuid() + "'); ";
        script = String.valueOf(script) + "w.setWidth(e.css('width')); ";
        Clients.response((AuResponse)new AuScript(script));
        ti.focus();
    }

    protected void addTreeItem(Treeitem treeItem) {
        StringBuilder key = new StringBuilder(this.getLabel(treeItem)).append(".").append(treeItem.getAttribute("menu.type"));
        this.treeNodeItemMap.put(key.toString(), treeItem);
    }

    protected void addTreeItem(DefaultTreeNode<?> node) {
        Object data = node.getData();
        if (data instanceof MTreeNode) {
            MTreeNode mNode = (MTreeNode)data;
            this.treeNodeItemMap.put(mNode.getName(), node);
        }
    }

    public void initialise() {
        this.refreshSearchList();
        if (this.tree.getModel() != null) {
            this.tree.getModel().addTreeDataListener((TreeDataListener)this);
        }
    }

    public void refreshSearchList() {
        this.treeNodeItemMap.clear();
        if (this.tree.getModel() == null) {
            TreeUtils.traverse(this.tree, new TreeItemAction(){

                @Override
                public void run(Treeitem treeItem) {
                    if (treeItem.isVisible()) {
                        TreeSearchPanel.this.addTreeItem(treeItem);
                    }
                }
            });
        } else {
            TreeUtils.traverse((TreeModel<Object>)this.tree.getModel(), new TreeNodeAction(){

                @Override
                public void run(DefaultTreeNode<?> treeNode) {
                    TreeSearchPanel.this.addTreeItem(treeNode);
                }
            });
        }
        this.treeValues = new String[this.treeNodeItemMap.size()];
        this.treeDescription = new String[this.treeNodeItemMap.size()];
        this.treeImages = new String[this.treeNodeItemMap.size()];
        this.treeTypes = new String[this.treeNodeItemMap.size()];
        int i = -1;
        for (Object value : this.treeNodeItemMap.values()) {
            ++i;
            if (value instanceof Treeitem) {
                Treeitem treeItem = (Treeitem)value;
                this.treeValues[i] = this.getLabel(treeItem);
                this.treeTypes[i] = String.valueOf(treeItem.getAttribute("menu.type"));
                this.treeDescription[i] = treeItem.getTooltiptext();
                this.treeImages[i] = this.getImage(treeItem);
                if (this.treeImages[i] != null && this.treeImages[i].trim().length() != 0 || !this.isFolder(treeItem)) continue;
                this.treeImages[i] = ThemeManager.getThemeResource("images/Folder16.png");
                continue;
            }
            if (!(value instanceof DefaultTreeNode)) continue;
            DefaultTreeNode sNode = (DefaultTreeNode)value;
            MTreeNode mNode = (MTreeNode)sNode.getData();
            this.treeValues[i] = mNode.getName();
            this.treeDescription[i] = mNode.getDescription();
            String indicator = mNode.getImageIndiactor();
            if (Util.isEmpty((String)indicator) && !mNode.isSummary()) continue;
            String imagePath = mNode.getImagePath();
            if (imagePath != null) {
                if (imagePath.startsWith("/images")) {
                    imagePath = ThemeManager.getThemeResource(imagePath.substring(1));
                } else if (imagePath.startsWith("images")) {
                    imagePath = ThemeManager.getThemeResource(imagePath);
                }
            }
            String string = this.treeImages[i] = imagePath != null ? imagePath.intern() : null;
        }
        this.cmbSearch.setDescription(this.treeDescription);
        this.cmbSearch.setDict(this.treeValues);
        this.cmbSearch.setImages(this.treeImages);
        this.cmbSearch.setContents(this.treeTypes);
    }

    protected boolean isFolder(Treeitem treeItem) {
        List list = treeItem.getChildren();
        for (Component c : list) {
            if (!(c instanceof Treechildren) || ((Treechildren)c).getChildren().size() <= 0) continue;
            return true;
        }
        return false;
    }

    protected String getLabel(Treeitem treeItem) {
        String label = treeItem.getLabel();
        if ((label == null || label.trim().length() == 0) && treeItem.getTreerow().getFirstChild().getFirstChild() != null && treeItem.getTreerow().getFirstChild().getFirstChild() instanceof LabelElement) {
            LabelElement element = (LabelElement)treeItem.getTreerow().getFirstChild().getFirstChild();
            label = element.getLabel();
        }
        return label;
    }

    protected String getImage(Treeitem treeItem) {
        String image = treeItem.getImage();
        if ((image == null || image.trim().length() == 0) && treeItem.getTreerow().getFirstChild().getFirstChild() != null && treeItem.getTreerow().getFirstChild().getFirstChild() instanceof LabelImageElement) {
            LabelImageElement element = (LabelImageElement)treeItem.getTreerow().getFirstChild().getFirstChild();
            image = element.getImage();
        }
        return image != null ? image.intern() : null;
    }

    public void onEvent(Event event) {
        if (this.cmbSearch.equals(event.getTarget())) {
            if (!this.cmbSearch.isEnabled()) {
                return;
            }
            if (event.getName().equals("onOK")) {
                this.selectedItem = null;
                String value = this.cmbSearch.getValue();
                if (value != null && value.trim().length() > 0 && value.substring(0, 1).equals(PREFIX_DOCUMENT_SEARCH)) {
                    DocumentSearch search = new DocumentSearch();
                    if (search.openDocumentsByDocumentNo(value.substring(1))) {
                        this.cmbSearch.setText(null);
                    }
                    return;
                }
                for (Component comp : this.cmbSearch.getChildren()) {
                    Comboitem item = (Comboitem)comp;
                    if (!item.getLabel().equals(value)) continue;
                    String type = this.cmbSearch.getContent(item);
                    if (!Util.isEmpty((String)type)) {
                        this.selectTreeitem(String.valueOf(value) + "." + type);
                    } else {
                        this.selectTreeitem(value);
                    }
                    return;
                }
            }
        } else if (event.getName().equals(ON_POST_FIRE_TREE_EVENT)) {
            this.cmbSearch.setEnabled(true);
            this.cmbSearch.clearLastSel();
        } else if (event.getName().equals(ON_COMBO_SELECT_ECHO_EVENT)) {
            Object[] data = (Object[])event.getData();
            String uuid = (String)data[0];
            int height = (Integer)data[1];
            if (height == 0) {
                List childs = this.cmbSearch.getChildren();
                for (Component comp : childs) {
                    if (!comp.getUuid().equals(uuid)) continue;
                    Comboitem item = (Comboitem)comp;
                    String value = item.getLabel();
                    String type = this.cmbSearch.getContent(item);
                    if (!Util.isEmpty((String)type)) {
                        this.selectTreeitem(String.valueOf(value) + "." + type);
                        continue;
                    }
                    this.selectTreeitem(value);
                }
            } else {
                this.cmbSearch.clearLastSel();
            }
        } else if (event.getName().equals(ON_POST_SELECT_TREEITEM_EVENT)) {
            this.onPostSelectTreeitem();
        }
    }

    private void selectTreeitem(String value) {
        if (Executions.getCurrent().getAttribute(String.valueOf(this.getUuid()) + ".selectTreeitem") != null) {
            return;
        }
        Object node = this.treeNodeItemMap.get(value);
        Treeitem treeItem = null;
        if (node == null) {
            return;
        }
        if (node instanceof Treeitem) {
            treeItem = (Treeitem)node;
        } else {
            DefaultTreeNode sNode = (DefaultTreeNode)node;
            int[] path = this.tree.getModel().getPath((Object)sNode);
            treeItem = this.tree.renderItemByPath(path);
            this.tree.setSelectedItem(treeItem);
        }
        if (treeItem != null) {
            this.selectedItem = treeItem;
            Executions.getCurrent().setAttribute(String.valueOf(this.getUuid()) + ".selectTreeitem", (Object)Boolean.TRUE);
            this.cmbSearch.setEnabled(false);
            TreeSearchPanel.select(treeItem);
            Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Loading"));
            Events.echoEvent((String)ON_POST_SELECT_TREEITEM_EVENT, (Component)this, null);
        }
    }

    protected void onPostSelectTreeitem() {
        Clients.clearBusy();
        Event event = null;
        event = this.eventToFire.equals("onClick") ? (this.tree.getSelectedItem().getTreerow().getFirstChild().getFirstChild() instanceof A ? new Event("onClick", this.tree.getSelectedItem().getTreerow().getFirstChild().getFirstChild()) : new Event("onClick", (Component)this.tree.getSelectedItem().getTreerow())) : new Event(this.eventToFire, (Component)this.tree);
        Events.postEvent((Event)event);
        Events.echoEvent((String)ON_POST_FIRE_TREE_EVENT, (Component)this, null);
    }

    public static void select(Treeitem selectedItem) {
        Treeitem parent = selectedItem.getParentItem();
        while (parent != null) {
            if (!parent.isOpen()) {
                parent.setOpen(true);
            }
            parent = parent.getParentItem();
        }
        selectedItem.getTree().setSelectedItem(selectedItem);
    }

    public void onChange(TreeDataEvent event) {
        this.refreshSearchList();
    }

    public Treeitem getSelectedItem() {
        return this.selectedItem;
    }
}

