/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.Properties;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.WRecordInfo;
import org.compiere.apps.IStatusBar;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.MRole;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Vbox;

public class StatusBarPanel
extends Panel
implements EventListener<Event>,
IStatusBar {
    private static final long serialVersionUID = -3262889055635240201L;
    private static final String POPUP_INFO_BACKGROUND_STYLE = "background-color: #262626; -moz-border-radius: 3px; -webkit-border-radius: 3px; border: 1px solid #262626; border-radius: 3px; ";
    private static final String POPUP_ERROR_BACKGROUND_STYLE = "background-color: #8B0000; -moz-border-radius: 3px; -webkit-border-radius: 3px; border: 1px solid #8B0000; border-radius: 3px; ";
    private static final String POPUP_POSITION_STYLE = "position: absolute; z-index: 99; display: block; visibility: visible;";
    private static final String POPUP_TEXT_STYLE = "color: white; background-color: transparent; font-size: 14px; font-weight:bold; position: relative; -moz-box-shadow: 0px 0px 0px #000;-webkit-box-shadow: 0px 0px 0px #000;box-shadow: 0px 0px 0px #000; padding: 5px; width: 590px; min-height: 20px;";
    private static final String SHADOW_STYLE = "-moz-box-shadow: 2px 2px 2px #888; -webkit-box-shadow: 2px 2px 2px #888; box-shadow: 2px 2px 2px #888;";
    private Label statusDB;
    private Label infoLine;
    private Label statusLine;
    private Label selectedLine;
    private DataStatusEvent m_dse;
    private String m_text;
    private Div east;
    private Div west;
    private Div popup;
    private Div popupContent;
    private String popupStyle;

    public StatusBarPanel() {
        this.init();
    }

    private void init() {
        this.setWidgetAttribute("instanceName", "statusBar");
        this.statusDB = new Label("  ");
        this.statusLine = new Label();
        Hbox hbox = new Hbox();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)hbox, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)hbox, "100%");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)hbox, "1");
        Cell leftCell = new Cell();
        hbox.appendChild((Component)leftCell);
        Cell rightCell = new Cell();
        hbox.appendChild((Component)rightCell);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)leftCell, "50%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)rightCell, "50%");
        this.west = new Div();
        this.west.setStyle("text-align: left; ");
        this.selectedLine = new Label();
        this.west.appendChild((Component)this.selectedLine);
        this.selectedLine.setVisible(false);
        LayoutUtils.addSclass("status-selected", (HtmlBasedComponent)this.selectedLine);
        this.west.appendChild((Component)this.statusLine);
        Vbox vbox = new Vbox();
        vbox.setPack("center");
        LayoutUtils.addSclass("status", (HtmlBasedComponent)vbox);
        vbox.appendChild((Component)this.west);
        leftCell.appendChild((Component)vbox);
        this.east = new Div();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.east, "100%");
        this.east.setStyle("text-align: right; ");
        this.infoLine = new Label();
        this.east.appendChild((Component)this.infoLine);
        this.infoLine.setVisible(false);
        this.east.appendChild((Component)this.statusDB);
        LayoutUtils.addSclass("status-db", (HtmlBasedComponent)this.statusDB);
        LayoutUtils.addSclass("status-info", (HtmlBasedComponent)this.infoLine);
        vbox = new Vbox();
        vbox.setAlign("stretch");
        vbox.setPack("center");
        LayoutUtils.addSclass("status", (HtmlBasedComponent)vbox);
        vbox.appendChild((Component)this.east);
        rightCell.appendChild((Component)vbox);
        this.appendChild((Component)hbox);
        this.statusDB.addEventListener("onClick", this);
        this.createPopup();
    }

    public void setStatusDB(String text) {
        this.setStatusDB(text, null);
    }

    public void setStatusDB(String text, DataStatusEvent dse) {
        if (text == null || text.trim().length() == 0) {
            this.statusDB.setValue("");
            this.statusDB.setVisible(false);
        } else {
            StringBuilder sb = new StringBuilder(" ");
            sb.append(text).append(" ");
            this.statusDB.setValue(sb.toString());
            this.statusDB.setVisible(true);
        }
        this.m_text = text;
        this.m_dse = dse;
    }

    public void setStatusLine(String text) {
        this.setStatusLine(text, false);
    }

    public void setStatusLine(String text, boolean error) {
        this.setStatusLine(text, error, error);
    }

    public void setStatusLine(String text, boolean error, boolean showPopup) {
        this.statusLine.setText(text);
        if (error) {
            this.statusLine.setStyle("color: red");
        } else {
            this.statusLine.setStyle("color: black");
        }
        this.statusLine.setTooltiptext(text);
        if (showPopup && AEnv.isBrowserSupported()) {
            Text t = new Text(text);
            this.popupContent.getChildren().clear();
            this.popupContent.appendChild((Component)t);
            this.popupContent.setStyle(POPUP_TEXT_STYLE);
            this.popupStyle = error ? POPUP_ERROR_BACKGROUND_STYLE : POPUP_INFO_BACKGROUND_STYLE;
            String shadow = SHADOW_STYLE;
            this.popupStyle = String.valueOf(this.popupStyle) + shadow + POPUP_POSITION_STYLE;
            this.showPopup();
            String script = "setTimeout('zk.Widget.$(\"" + this.popup.getUuid() + "\").$n().style.display = \"none\"',";
            script = error ? String.valueOf(script) + "3500" : String.valueOf(script) + "1000";
            script = String.valueOf(script) + ")";
            AuScript aus = new AuScript((Component)this.popup, script);
            Clients.response((String)"statusPopupFade", (AuResponse)aus);
        }
    }

    public String getStatusLine() {
        return this.statusLine.getValue();
    }

    private void createPopup() {
        this.popupContent = new Div();
        this.popup = new Div();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.popup, "600px");
        this.popup.appendChild((Component)this.popupContent);
        this.popup.addEventListener("onClick", (EventListener)this);
        this.popup.setPage(SessionManager.getAppDesktop().getComponent().getPage());
        this.popup.setStyle("position: absolute; display: none");
    }

    private void showPopup() {
        this.popup.setVisible(true);
        this.popup.setStyle(this.popupStyle);
        if (this.getRoot() == null || !this.getRoot().isVisible()) {
            return;
        }
        String script = "var d = zk.Widget.$('" + this.popup.getUuid() + "').$n();";
        script = String.valueOf(script) + "d.style.display='block';d.style.visibility='hidden';";
        script = String.valueOf(script) + "var dhs = document.defaultView.getComputedStyle(d, null).getPropertyValue('height');";
        script = String.valueOf(script) + "var dh = parseInt(dhs, 10);";
        script = String.valueOf(script) + "var r = zk.Widget.$('" + this.getRoot().getUuid() + "').$n();";
        script = String.valueOf(script) + "var rhs = document.defaultView.getComputedStyle(r, null).getPropertyValue('height');";
        script = String.valueOf(script) + "var rh = parseInt(rhs, 10);";
        script = String.valueOf(script) + "var p = jq('#" + this.getRoot().getUuid() + "').zk.cmOffset();";
        script = String.valueOf(script) + "d.style.top=(rh-dh-5)+'px';";
        script = String.valueOf(script) + "d.style.left=(p[0]+1)+'px';";
        script = String.valueOf(script) + "d.style.visibility='visible';";
        AuScript aus = new AuScript((Component)this.popup, script);
        Clients.response((AuResponse)aus);
    }

    public final void addStatusComponent(Component component) {
        this.east.appendChild(component);
    }

    public void setInfo(String text) {
        this.infoLine.setValue(text != null ? text : "");
        this.infoLine.setTooltiptext(text);
        if (text == null || text.trim().length() == 0) {
            this.infoLine.setVisible(false);
        } else {
            this.infoLine.setVisible(true);
        }
    }

    public void setSelectedRowNumber(String rowNum) {
        this.selectedLine.setVisible(rowNum != null);
        if (rowNum != null) {
            this.selectedLine.setValue(rowNum);
        }
    }

    public void onEvent(Event event) throws Exception {
        if ("onClick".equals(event.getName()) && event.getTarget() == this.statusDB) {
            if (this.m_dse == null || this.m_dse.CreatedBy == null || !MRole.getDefault().isShowPreference()) {
                return;
            }
            String title = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Who")) + this.m_text;
            new WRecordInfo(title, this.m_dse);
        } else if ("onClick".equals(event.getName()) && event.getTarget() == this.popup) {
            this.popup.setVisible(false);
        }
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this.popup != null) {
            this.popup.detach();
        }
    }

    public void setEastVisibility(boolean visible) {
        this.east.setVisible(visible);
    }
}

