/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.sql.Timestamp;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import org.adempiere.util.Callback;
import org.adempiere.webui.AdempiereIdGenerator;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ComboItem;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.UserPreference;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.adempiere.webui.window.LoginWindow;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.zkoss.zhtml.Table;
import org.zkoss.zhtml.Td;
import org.zkoss.zhtml.Tr;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Deferrable;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Div;
import org.zkoss.zul.Image;

public class RolePanel
extends Window
implements EventListener<Event>,
Deferrable {
    private static final long serialVersionUID = 372661654078492488L;
    protected LoginWindow wndLogin;
    protected Login login;
    protected Combobox lstRole;
    protected Combobox lstClient;
    protected Combobox lstOrganisation;
    protected Combobox lstWarehouse;
    protected Label lblRole;
    protected Label lblClient;
    protected Label lblOrganisation;
    protected Label lblWarehouse;
    protected Label lblDate;
    protected WDateEditor lstDate;
    protected org.zkoss.zul.Button btnOk;
    protected org.zkoss.zul.Button btnCancel;
    protected Properties m_ctx;
    protected String m_userName;
    protected KeyNamePair[] m_clientKNPairs;
    protected UserPreference m_userpreference = null;
    protected boolean m_show = true;
    private RolePanel component;
    private boolean isChangeRole = false;
    private Properties ctxBeforeChangeRole = null;
    private static final String ON_DEFER_LOGOUT = "onDeferLogout";

    public boolean isChangeRole() {
        return this.isChangeRole;
    }

    public void setChangeRole(boolean isChangeRole) {
        this.isChangeRole = isChangeRole;
    }

    public RolePanel(Properties ctx, LoginWindow loginWindow, String userName, boolean show, KeyNamePair[] clientsKNPairs) {
        this.wndLogin = loginWindow;
        this.m_ctx = ctx;
        this.m_userName = userName;
        this.login = new Login(ctx);
        this.m_show = show;
        this.m_clientKNPairs = clientsKNPairs;
        if (this.m_clientKNPairs.length == 1 && !this.m_show) {
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Client_ID", (String)this.m_clientKNPairs[0].getID());
            MUser user = MUser.get((Properties)this.m_ctx, (String)this.m_userName);
            this.m_userpreference = new UserPreference();
            this.m_userpreference.loadPreference(user.get_ID());
        }
        this.initComponents();
        this.init();
        this.setId("rolePanel");
        this.setSclass("login-box");
        if (!(this.m_show || this.lstRole.getSelectedItem() != null && this.lstRole.getSelectedItem().getValue() != null && this.lstClient.getSelectedItem() != null && this.lstClient.getSelectedItem().getValue() != null && this.lstOrganisation.getSelectedItem() != null && this.lstOrganisation.getSelectedItem().getValue() != null)) {
            this.m_show = true;
        }
        if (this.m_show) {
            AuFocus auf = null;
            auf = this.lstClient.getItemCount() > 1 ? new AuFocus((Component)this.lstClient) : (MSysConfig.getBooleanValue((String)"ALogin_ShowOneRole", (boolean)true) || this.lstRole.getItemCount() > 1 ? new AuFocus((Component)this.lstRole) : new AuFocus((Component)this.lstOrganisation));
            Clients.response((AuResponse)auf);
        } else {
            this.validateRoles();
        }
    }

    private void init() {
        Clients.response((AuResponse)new AuScript("zAu.cmd0.clearBusy()"));
        this.createUI();
    }

    protected void createUI() {
        Div div = new Div();
        div.setSclass("login-box-header");
        Label label = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"SelectRole"));
        label.setSclass("login-box-header-txt");
        div.appendChild((Component)label);
        this.appendChild((Component)div);
        Table table2 = new Table();
        table2.setId("grdChooseRole");
        table2.setDynamicProperty("cellpadding", (Object)"0");
        table2.setDynamicProperty("cellspacing", (Object)"5");
        table2.setSclass("login-box-body");
        this.appendChild((Component)table2);
        Tr tr2 = new Tr();
        table2.appendChild((Component)tr2);
        Td td2 = new Td();
        td2.setSclass("login-box-header-logo");
        tr2.appendChild((Component)td2);
        td2.setDynamicProperty("colspan", (Object)"2");
        Image image = new Image();
        image.setSrc(ThemeManager.getLargeLogo());
        td2.appendChild((Component)image);
        tr2 = new Tr();
        tr2.setId("rowclient");
        table2.appendChild((Component)tr2);
        td2 = new Td();
        tr2.appendChild((Component)td2);
        td2.setSclass("login-label");
        td2.appendChild(this.lblClient.rightAlign());
        td2 = new Td();
        td2.setSclass("login-field");
        tr2.appendChild((Component)td2);
        td2.appendChild((Component)this.lstClient);
        tr2 = new Tr();
        tr2.setId("rowRole");
        table2.appendChild((Component)tr2);
        td2 = new Td();
        tr2.appendChild((Component)td2);
        td2.setSclass("login-label");
        td2.appendChild(this.lblRole.rightAlign());
        td2 = new Td();
        td2.setSclass("login-field");
        tr2.appendChild((Component)td2);
        td2.appendChild((Component)this.lstRole);
        tr2 = new Tr();
        tr2.setId("rowOrganisation");
        table2.appendChild((Component)tr2);
        td2 = new Td();
        tr2.appendChild((Component)td2);
        td2.setSclass("login-label");
        td2.appendChild(this.lblOrganisation.rightAlign());
        td2 = new Td();
        td2.setSclass("login-field");
        tr2.appendChild((Component)td2);
        td2.appendChild((Component)this.lstOrganisation);
        tr2 = new Tr();
        tr2.setId("rowWarehouse");
        table2.appendChild((Component)tr2);
        td2 = new Td();
        tr2.appendChild((Component)td2);
        td2.setSclass("login-label");
        td2.appendChild(this.lblWarehouse.rightAlign());
        td2 = new Td();
        td2.setSclass("login-field");
        tr2.appendChild((Component)td2);
        td2.appendChild((Component)this.lstWarehouse);
        tr2 = new Tr();
        tr2.setId("rowDate");
        table2.appendChild((Component)tr2);
        td2 = new Td();
        tr2.appendChild((Component)td2);
        td2.setSclass("login-label");
        td2.appendChild(this.lblDate.rightAlign());
        td2 = new Td();
        td2.setSclass("login-field");
        tr2.appendChild((Component)td2);
        td2.appendChild((Component)this.lstDate.getComponent());
        div = new Div();
        div.setSclass("login-box-footer");
        ConfirmPanel pnlButtons = new ConfirmPanel(true, false, false, false, false, false, true);
        pnlButtons.addActionListener(this);
        Button okBtn = pnlButtons.getButton("Ok");
        okBtn.setWidgetListener("onClick", "zAu.cmd0.showBusy(null)");
        LayoutUtils.addSclass("login-box-footer-pnl", (HtmlBasedComponent)pnlButtons);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)pnlButtons, null);
        pnlButtons.getButton("Ok").setSclass("login-btn");
        pnlButtons.getButton("Cancel").setSclass("login-btn");
        div.appendChild((Component)pnlButtons);
        this.appendChild((Component)div);
    }

    private void initComponents() {
        Language language = Env.getLanguage((Properties)this.m_ctx);
        this.lblClient = new Label();
        this.lblClient.setId("lblClient");
        this.lblClient.setValue(Msg.getMsg((Language)language, (String)"Client"));
        this.lblRole = new Label();
        this.lblRole.setId("lblRole");
        this.lblRole.setValue(Msg.getMsg((Language)language, (String)"Role"));
        this.lblOrganisation = new Label();
        this.lblOrganisation.setId("lblOrganisation");
        this.lblOrganisation.setValue(Msg.getMsg((Language)language, (String)"Organization"));
        this.lblWarehouse = new Label();
        this.lblWarehouse.setId("lblWarehouse");
        this.lblWarehouse.setValue(Msg.getMsg((Language)language, (String)"Warehouse"));
        this.lblDate = new Label();
        this.lblDate.setId("lblDate");
        this.lblDate.setValue(Msg.getMsg((Language)language, (String)"Date"));
        this.lstRole = new Combobox();
        this.lstRole.setAutocomplete(true);
        this.lstRole.setAutodrop(true);
        this.lstRole.setId("lstRole");
        this.lstRole.addEventListener("onSelect", this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstRole, "220px");
        this.lstClient = new Combobox();
        this.lstClient.setAutocomplete(true);
        this.lstClient.setAutodrop(true);
        this.lstClient.setId("lstClient");
        this.lstClient.addEventListener("onSelect", this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstClient, "220px");
        this.lstOrganisation = new Combobox();
        this.lstOrganisation.setAutocomplete(true);
        this.lstOrganisation.setAutodrop(true);
        this.lstOrganisation.setId("lstOrganisation");
        this.lstOrganisation.addEventListener("onSelect", this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstOrganisation, "220px");
        this.lstWarehouse = new Combobox();
        this.lstWarehouse.setAutocomplete(true);
        this.lstWarehouse.setAutodrop(true);
        this.lstWarehouse.setId("lstWarehouse");
        this.lstWarehouse.addEventListener("onSelect", this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstWarehouse, "220px");
        this.lstDate = new WDateEditor();
        this.lstDate.setValue(new Timestamp(System.currentTimeMillis()));
        this.lstDate.getComponent().setId("loginDate");
        this.btnOk = new org.zkoss.zul.Button();
        this.btnOk.setId("btnOk");
        this.btnOk.setLabel("Ok");
        this.btnOk.addEventListener("onClick", (EventListener)this);
        this.btnCancel = new org.zkoss.zul.Button();
        this.btnCancel.setId("btnCancel");
        this.btnCancel.setLabel("Cancel");
        this.btnCancel.addEventListener("onClick", (EventListener)this);
        UserPreference userPreference = SessionManager.getSessionApplication().getUserPreference();
        String initDefault = userPreference.getProperty("Client");
        if (initDefault.length() == 0 && !this.m_show && this.m_userpreference != null) {
            initDefault = this.m_userpreference.getProperty("Client");
        }
        if (this.m_clientKNPairs != null && this.m_clientKNPairs.length > 0) {
            int i = 0;
            while (i < this.m_clientKNPairs.length) {
                ComboItem ci = new ComboItem(this.m_clientKNPairs[i].getName(), this.m_clientKNPairs[i].getID());
                String id = AdempiereIdGenerator.escapeId(ci.getLabel());
                if (this.lstClient.getFellowIfAny(id) == null) {
                    ci.setId(id);
                }
                this.lstClient.appendChild((Component)ci);
                if (this.m_clientKNPairs[i].getID().equals(initDefault)) {
                    this.lstClient.setSelectedItem(ci);
                }
                ++i;
            }
            if (this.lstClient.getSelectedIndex() == -1 && this.lstClient.getItemCount() > 0) {
                this.m_show = true;
                this.lstClient.setSelectedIndex(0);
            }
        }
        if (this.m_clientKNPairs != null && this.m_clientKNPairs.length == 1) {
            this.lstClient.setSelectedIndex(0);
            this.lblClient.setVisible(false);
            this.lstClient.setVisible(false);
        } else {
            this.lblClient.setVisible(true);
            this.lstClient.setVisible(true);
        }
        this.setUserID();
        this.updateRoleList();
        this.component = this;
        this.component.addEventListener(ON_DEFER_LOGOUT, this);
    }

    private void updateRoleList() {
        this.lstRole.getItems().clear();
        this.lstRole.setText("");
        Comboitem lstItemClient = this.lstClient.getSelectedItem();
        if (lstItemClient != null) {
            KeyNamePair clientKNPair;
            KeyNamePair[] roleKNPairs;
            UserPreference userPreference = SessionManager.getSessionApplication().getUserPreference();
            String initDefault = userPreference.getProperty("Role");
            if (initDefault.length() == 0 && !this.m_show && this.m_userpreference != null) {
                initDefault = this.m_userpreference.getProperty("Role");
            }
            if ((roleKNPairs = this.login.getRoles(this.m_userName, clientKNPair = new KeyNamePair(Integer.valueOf((String)lstItemClient.getValue()).intValue(), lstItemClient.getLabel()))) != null && roleKNPairs.length > 0) {
                int i = 0;
                while (i < roleKNPairs.length) {
                    ComboItem ci = new ComboItem(roleKNPairs[i].getName(), roleKNPairs[i].getID());
                    String id = AdempiereIdGenerator.escapeId(ci.getLabel());
                    if (this.lstRole.getFellowIfAny(id) == null) {
                        ci.setId(id);
                    }
                    this.lstRole.appendChild((Component)ci);
                    if (roleKNPairs[i].getID().equals(initDefault)) {
                        this.lstRole.setSelectedItem(ci);
                    }
                    ++i;
                }
                if (this.lstRole.getSelectedIndex() == -1 && this.lstRole.getItemCount() > 0) {
                    this.m_show = true;
                    this.lstRole.setSelectedIndex(0);
                }
            }
            MRole.getDefault((Properties)this.m_ctx, (boolean)true);
            if (this.m_clientKNPairs.length == 1 && this.lstRole.getItemCount() == 1 && !MSysConfig.getBooleanValue((String)"ALogin_ShowOneRole", (boolean)true)) {
                this.lstRole.setSelectedIndex(0);
                this.lblRole.setVisible(false);
                this.lstRole.setVisible(false);
            } else {
                this.lblRole.setVisible(true);
                this.lstRole.setVisible(true);
            }
        }
        this.setUserID();
        this.updateOrganisationList();
    }

    private void updateOrganisationList() {
        this.lstOrganisation.getItems().clear();
        this.lstOrganisation.setText("");
        Comboitem lstItemRole = this.lstRole.getSelectedItem();
        if (lstItemRole != null) {
            KeyNamePair RoleKNPair;
            KeyNamePair[] orgKNPairs;
            UserPreference userPreference = SessionManager.getSessionApplication().getUserPreference();
            String initDefault = userPreference.getProperty("Organization");
            if (initDefault.length() == 0 && !this.m_show && this.m_userpreference != null) {
                initDefault = this.m_userpreference.getProperty("Organization");
            }
            if ((orgKNPairs = this.login.getOrgs(RoleKNPair = new KeyNamePair(Integer.valueOf((String)lstItemRole.getValue()).intValue(), lstItemRole.getLabel()))) != null && orgKNPairs.length > 0) {
                int i = 0;
                while (i < orgKNPairs.length) {
                    ComboItem ci = new ComboItem(orgKNPairs[i].getName(), orgKNPairs[i].getID());
                    String id = AdempiereIdGenerator.escapeId(ci.getLabel());
                    if (this.lstOrganisation.getFellowIfAny(id) == null) {
                        ci.setId(id);
                    }
                    this.lstOrganisation.appendChild((Component)ci);
                    if (orgKNPairs[i].getID().equals(initDefault)) {
                        this.lstOrganisation.setSelectedItem(ci);
                    }
                    ++i;
                }
                if (this.lstOrganisation.getSelectedIndex() == -1 && this.lstOrganisation.getItemCount() > 0) {
                    this.m_show = true;
                    this.lstOrganisation.setSelectedIndex(0);
                }
            }
        }
        this.updateWarehouseList();
    }

    private void updateWarehouseList() {
        this.lstWarehouse.getItems().clear();
        this.lstWarehouse.setText("");
        Comboitem lstItemOrganisation = this.lstOrganisation.getSelectedItem();
        if (lstItemOrganisation != null) {
            KeyNamePair organisationKNPair;
            KeyNamePair[] warehouseKNPairs;
            UserPreference userPreference = SessionManager.getSessionApplication().getUserPreference();
            String initDefault = userPreference.getProperty("Warehouse");
            if (initDefault.length() == 0 && !this.m_show && this.m_userpreference != null) {
                initDefault = this.m_userpreference.getProperty("Warehouse");
            }
            if ((warehouseKNPairs = this.login.getWarehouses(organisationKNPair = new KeyNamePair(Integer.valueOf((String)lstItemOrganisation.getValue()).intValue(), lstItemOrganisation.getLabel()))) != null && warehouseKNPairs.length > 0) {
                int i = 0;
                while (i < warehouseKNPairs.length) {
                    ComboItem ci = new ComboItem(warehouseKNPairs[i].getName(), warehouseKNPairs[i].getID());
                    ci.setLabel(ci.getLabel());
                    this.lstWarehouse.appendChild((Component)ci);
                    if (warehouseKNPairs[i].getID().equals(initDefault)) {
                        this.lstWarehouse.setSelectedItem(ci);
                    }
                    ++i;
                }
                if (this.lstWarehouse.getSelectedIndex() == -1 && this.lstWarehouse.getItemCount() > 0) {
                    this.m_show = true;
                    this.lstWarehouse.setSelectedIndex(0);
                }
            }
        }
    }

    public void onEvent(Event event) {
        String eventCompId = event.getTarget().getId();
        String eventName = event.getName();
        if (eventName.equals("onSelect")) {
            if (eventCompId.equals(this.lstClient.getId())) {
                this.updateRoleList();
            } else if (eventCompId.equals(this.lstRole.getId())) {
                this.setUserID();
                this.updateOrganisationList();
            } else if (eventCompId.equals(this.lstOrganisation.getId())) {
                this.updateWarehouseList();
            }
        }
        if (event.getTarget().getId().equals("Ok")) {
            this.validateRoles();
        } else if (event.getTarget().getId().equals("Cancel")) {
            if (this.isChangeRole()) {
                this.changeRole(this.ctxBeforeChangeRole);
                this.validateRoles();
            } else {
                this.ctxBeforeChangeRole = null;
                SessionManager.logoutSession();
            }
        } else if (ON_DEFER_LOGOUT.equals(event.getName())) {
            SessionManager.logoutSession();
        }
    }

    private void setUserID() {
        if (this.lstClient.getSelectedItem() != null) {
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Client_ID", (String)((String)this.lstClient.getSelectedItem().getValue()));
        } else {
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Client_ID", null);
        }
        MUser user = MUser.get((Properties)this.m_ctx, (String)this.m_userName);
        if (user != null) {
            Env.setContext((Properties)this.m_ctx, (String)"#AD_User_ID", (int)user.getAD_User_ID());
            Env.setContext((Properties)this.m_ctx, (String)"#AD_User_Name", (String)user.getName());
            Env.setContext((Properties)this.m_ctx, (String)"#SalesRep_ID", (int)user.getAD_User_ID());
        }
    }

    public void changeRole(Properties ctx) {
        this.ctxBeforeChangeRole = ctx;
        int AD_Client_ID = Env.getAD_Client_ID((Properties)ctx);
        this.lstClient.setValue(AD_Client_ID);
        this.updateRoleList();
        int AD_Role_ID = Env.getAD_Role_ID((Properties)ctx);
        this.lstRole.setValue(AD_Role_ID);
        this.updateOrganisationList();
        int AD_Org_ID = Env.getAD_Org_ID((Properties)ctx);
        this.lstOrganisation.setValue(AD_Org_ID);
        this.updateWarehouseList();
        int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (String)"#M_Warehouse_ID");
        this.lstWarehouse.setValue(M_Warehouse_ID);
    }

    public void validateRoles() {
        Timestamp date;
        String msg;
        Clients.clearBusy();
        Comboitem lstItemRole = this.lstRole.getSelectedItem();
        Comboitem lstItemClient = this.lstClient.getSelectedItem();
        Comboitem lstItemOrg = this.lstOrganisation.getSelectedItem();
        Comboitem lstItemWarehouse = this.lstWarehouse.getSelectedItem();
        if (lstItemRole == null || lstItemRole.getValue() == null) {
            throw new WrongValueException((Component)this.lstRole, String.valueOf(Msg.getMsg((Properties)this.m_ctx, (String)"FillMandatory")) + this.lblRole.getValue());
        }
        if (lstItemClient == null || lstItemClient.getValue() == null) {
            throw new WrongValueException((Component)this.lstClient, String.valueOf(Msg.getMsg((Properties)this.m_ctx, (String)"FillMandatory")) + this.lblClient.getValue());
        }
        if (lstItemOrg == null || lstItemOrg.getValue() == null) {
            throw new WrongValueException((Component)this.lstOrganisation, String.valueOf(Msg.getMsg((Properties)this.m_ctx, (String)"FillMandatory")) + this.lblOrganisation.getValue());
        }
        int orgId = 0;
        int warehouseId = 0;
        orgId = Integer.parseInt((String)lstItemOrg.getValue());
        KeyNamePair orgKNPair = new KeyNamePair(orgId, lstItemOrg.getLabel());
        KeyNamePair warehouseKNPair = null;
        if (lstItemWarehouse != null && lstItemWarehouse.getValue() != null) {
            warehouseId = Integer.parseInt((String)lstItemWarehouse.getValue());
            warehouseKNPair = new KeyNamePair(warehouseId, lstItemWarehouse.getLabel());
        }
        if (Util.isEmpty((String)(msg = this.login.loadPreferences(orgKNPair, warehouseKNPair, date = (Timestamp)this.lstDate.getValue(), null)))) {
            Session currSess = Executions.getCurrent().getDesktop().getSession();
            HttpSession httpSess = (HttpSession)currSess.getNativeSession();
            int timeout = MSysConfig.getIntValue((String)"ZK_SESSION_TIMEOUT_IN_SECONDS", (int)-2, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Org_ID((Properties)Env.getCtx()));
            if (timeout != -2) {
                httpSess.setMaxInactiveInterval(timeout);
            }
            msg = this.login.validateLogin(orgKNPair);
        }
        if (!Util.isEmpty((String)msg)) {
            Env.getCtx().clear();
            FDialog.error(0, (Component)this, "Error", msg, new Callback<Integer>(){

                public void onCallback(Integer result) {
                    Events.echoEvent((Event)new Event(RolePanel.ON_DEFER_LOGOUT, (Component)RolePanel.this.component));
                }
            });
            return;
        }
        if (!MUser.get((Properties)Env.getCtx()).isNoPasswordReset()) {
            int notifyDay = MSysConfig.getIntValue((String)"USER_LOCKING_PASSWORD_NOTIFY_DAY", (int)0);
            int pwdAgeDay = MSysConfig.getIntValue((String)"USER_LOCKING_MAX_PASSWORD_AGE_DAY", (int)0);
            if (notifyDay > 0 && pwdAgeDay > 0) {
                Timestamp limit = TimeUtil.addDays((Timestamp)MUser.get((Properties)Env.getCtx()).getDatePasswordChanged(), (int)pwdAgeDay);
                Timestamp notifyAfter = TimeUtil.addDays((Timestamp)limit, (int)(-notifyDay));
                Timestamp now = TimeUtil.getDay(null);
                if (now.after(notifyAfter)) {
                    FDialog.warn(0, null, "", Msg.getMsg((Properties)Env.getCtx(), (String)"YourPasswordWillExpireInDays", (Object[])new Object[]{TimeUtil.getDaysBetween((Timestamp)now, (Timestamp)limit)}));
                }
            }
        }
        this.wndLogin.loginCompleted();
        UserPreference userPreference = SessionManager.getSessionApplication().getUserPreference();
        userPreference.setProperty("Language", Env.getContext((Properties)this.m_ctx, (String)"#LanguageName"));
        userPreference.setProperty("Role", (String)lstItemRole.getValue());
        userPreference.setProperty("Client", (String)lstItemClient.getValue());
        userPreference.setProperty("Organization", (String)lstItemOrg.getValue());
        userPreference.setProperty("Warehouse", lstItemWarehouse != null ? (String)lstItemWarehouse.getValue() : "0");
        userPreference.savePreference();
    }

    public boolean isDeferrable() {
        return false;
    }
}

