/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.Properties;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.panel.AbstractMenuPanel;
import org.adempiere.webui.panel.MenuTreeFilterPanel;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.TreeUtils;
import org.compiere.model.MUser;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Panelchildren;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Toolbarbutton;

public class MenuTreePanel
extends AbstractMenuPanel {
    private static final long serialVersionUID = -911113870835089567L;
    private static final String ON_EXPAND_MENU_EVENT = "onExpandMenu";
    private ToolBarButton expandToggle;
    private MenuTreeFilterPanel filterPanel;
    private Toolbarbutton filterBtn;

    public MenuTreePanel(Component parent) {
        super(parent);
    }

    @Override
    protected void init() {
        super.init();
        if (MUser.get((Properties)this.getCtx()).isMenuAutoExpand()) {
            this.expandAll();
        }
        EventQueues.lookup((String)"MENU_TREE_FILTER_CHECKED_QUEUE", (String)"desktop", (boolean)true).subscribe((EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Checkbox chk;
                if (event.getName() == "onCheck" && (chk = (Checkbox)event.getData()) != null) {
                    if ("flatView".equals(chk.getId())) {
                        MenuTreeFilterPanel.toggleFlatView(MenuTreePanel.this.getMenuTree(), chk);
                    } else {
                        MenuTreeFilterPanel.toggle(MenuTreePanel.this.getMenuTree(), chk);
                    }
                    MenuTreePanel.this.getMenuTree().invalidate();
                }
            }
        });
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        Panelchildren pc = new Panelchildren();
        this.appendChild((Component)pc);
        pc.appendChild((Component)this.getMenuTree());
        Toolbar toolbar = new Toolbar();
        toolbar.setSclass("desktop-menu-toolbar");
        this.appendChild((Component)toolbar);
        this.expandToggle = new ToolBarButton();
        this.expandToggle.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"ExpandTree")));
        this.expandToggle.setMode("toggle");
        this.expandToggle.addEventListener("onCheck", this);
        toolbar.appendChild((Component)this.expandToggle);
        toolbar.setMold("panel");
        this.addEventListener(ON_EXPAND_MENU_EVENT, this);
        this.filterPanel = new MenuTreeFilterPanel(this.getMenuTree(), null);
        pc.appendChild((Component)this.filterPanel);
        this.filterBtn = new Toolbarbutton();
        if (ThemeManager.isUseFontIconForImage()) {
            this.filterBtn.setIconSclass("z-icon-Preference");
        } else {
            this.filterBtn.setImage(ThemeManager.getThemeResource("images/Preference16.png"));
        }
        this.filterBtn.addEventListener("onClick", (EventListener)this);
        toolbar.appendChild((Component)this.filterBtn);
    }

    @Override
    public void onEvent(Event event) {
        super.onEvent(event);
        String eventName = event.getName();
        if (eventName.equals("onCheck") && event.getTarget() == this.expandToggle) {
            Clients.showBusy(null);
            Events.echoEvent((String)ON_EXPAND_MENU_EVENT, (Component)this, null);
        } else if (eventName.equals(ON_EXPAND_MENU_EVENT)) {
            this.expandOnCheck();
            Clients.clearBusy();
        } else if (event.getName().equals("onClick") && event.getTarget() == this.filterBtn) {
            this.filterPanel.open((Component)this.filterBtn, "before_start");
        }
    }

    public void expandAll() {
        if (!this.expandToggle.isChecked()) {
            this.expandToggle.setChecked(true);
        }
        TreeUtils.expandAll(this.getMenuTree());
    }

    public void collapseAll() {
        if (this.expandToggle.isChecked()) {
            this.expandToggle.setChecked(false);
        }
        TreeUtils.collapseAll(this.getMenuTree());
    }

    private void expandOnCheck() {
        if (this.expandToggle.isChecked()) {
            this.expandAll();
        } else {
            this.collapseAll();
        }
    }
}

