/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.IInfoColumn;
import org.adempiere.model.MInfoProcess;
import org.adempiere.model.MInfoRelated;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.BusyDialog;
import org.adempiere.webui.apps.ProcessModalDialog;
import org.adempiere.webui.apps.WProcessCtl;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.ProcessInfoDialog;
import org.adempiere.webui.component.WListItemRenderer;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.factory.InfoManager;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.part.ITabOnSelectHandler;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.GridField;
import org.compiere.model.MInfoColumn;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Paging;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Sortable;

public abstract class InfoPanel
extends Window
implements EventListener<Event>,
WTableModelListener,
Sortable<Object>,
IHelpContext {
    private static final long serialVersionUID = 3761627143274259211L;
    private static final int DEFAULT_PAGE_SIZE = 100;
    private static final int DEFAULT_PAGE_PRELOAD = 4;
    protected List<Button> btProcessList = new ArrayList<Button>();
    protected Map<String, WEditor> editorMap = new HashMap<String, WEditor>();
    protected static final String PROCESS_ID_KEY = "processId";
    protected static final String ON_RUN_PROCESS = "onRunProcess";
    protected static final String ATT_INFO_PROCESS_KEY = "INFO_PROCESS";
    protected int pageSize;
    public LinkedHashMap<KeyNamePair, LinkedHashMap<String, Object>> m_values = null;
    protected MInfoRelated[] relatedInfoList;
    protected boolean isIgnoreCacheAll = true;
    protected int numPagePreLoad = MSysConfig.getIntValue((String)"ZK_INFO_NUM_PAGE_PRELOAD", (int)4);
    protected int extra_max_row = 1;
    protected MInfoColumn keyColumnOfView = null;
    protected int indexKeyOfView = -1;
    protected boolean isIDColumnKeyOfView = false;
    protected boolean hasRightQuickEntry = true;
    protected boolean isHasNextPage = false;
    protected Map<Integer, List<Object>> recordSelectedData = new HashMap<Integer, List<Object>>();
    protected boolean isRequeryByRunSuccessProcess = false;
    static final int INFO_WIDTH = 800;
    protected boolean m_lookup;
    protected int m_infoWindowID;
    protected ConfirmPanel confirmPanel;
    protected int p_WindowNo;
    protected String p_tableName;
    protected String p_keyColumn;
    protected boolean p_multipleSelection;
    protected String p_whereClause = "";
    protected StatusBarPanel statusBar = new StatusBarPanel();
    private List<Object> line;
    private boolean m_ok = false;
    private boolean m_cancel = false;
    private ArrayList<Integer> m_results = new ArrayList(3);
    private ListModelTable model;
    protected ColumnInfo[] p_layout;
    protected String m_sqlMain;
    protected String m_sqlCount;
    protected String m_sqlOrder;
    protected String m_sqlUserOrder;
    private ArrayList<ValueChangeListener> listeners = new ArrayList();
    protected boolean p_loadedOK = false;
    private int m_SO_Window_ID = -1;
    private int m_PO_Window_ID = -1;
    protected MInfoWindow infoWindow;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    protected WListbox contentPanel = new WListbox();
    protected Paging paging;
    protected int pageNo;
    protected int m_count;
    private int cacheStart;
    private int cacheEnd;
    private boolean m_useDatabasePaging = false;
    private BusyDialog progressWindow;
    private int m_lastSelectedIndex = -1;
    protected GridField m_gridfield;
    protected boolean isQueryByUser = false;
    protected String prevWhereClause = null;
    protected List<Object> prevParameterValues = null;
    protected List<String> prevQueryOperators = null;
    protected List<WEditor> prevRefParmeterEditor = null;
    private static final String[] lISTENER_EVENTS = new String[0];
    protected MInfoProcess[] infoProcessList;
    protected boolean haveProcess = false;
    protected List<MInfoProcess> infoProcessBtList;
    protected List<MInfoProcess> infoProcessDropList;
    protected List<MInfoProcess> infoProcessMenuList;
    protected Collection<KeyNamePair> m_viewIDMap = new ArrayList<KeyNamePair>();
    protected Map<Integer, Integer> columnDataIndex = new HashMap<Integer, Integer>();
    protected boolean isMustUpdateColumnIndex = true;
    protected int indexColumnCount = 0;
    protected List<Integer> lsReadedColumn = new ArrayList<Integer>();
    protected Button btCbbProcess;
    protected Combobox cbbProcess;
    protected Button btMenuProcess;
    public static final int VK_ENTER = 13;
    public static final int VK_ESCAPE = 27;

    public static InfoPanel create(int WindowNo, String tableName, String keyColumn, String value, boolean multiSelection, String whereClause) {
        return InfoManager.create(WindowNo, tableName, keyColumn, value, multiSelection, whereClause, true);
    }

    public static void showPanel(String tableName) {
        InfoPanel info = InfoManager.create(0, tableName, String.valueOf(tableName) + "_ID", "", false, "", false);
        info.setAttribute("mode", "embedded");
        AEnv.showWindow(info);
    }

    protected InfoPanel(int WindowNo, String tableName, String keyColumn, boolean multipleSelection, String whereClause) {
        this(WindowNo, tableName, keyColumn, multipleSelection, whereClause, true);
    }

    protected InfoPanel(int WindowNo, String tableName, String keyColumn, boolean multipleSelection, String whereClause, boolean lookup) {
        this(WindowNo, tableName, keyColumn, multipleSelection, whereClause, lookup, 0);
    }

    protected InfoPanel(int WindowNo, String tableName, String keyColumn, boolean multipleSelection, String whereClause, boolean lookup, int ADInfoWindowID) {
        this.p_WindowNo = WindowNo <= 0 ? SessionManager.getAppDesktop().registerWindow(this) : WindowNo;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("WinNo=" + WindowNo + " " + whereClause);
        }
        this.p_tableName = tableName;
        this.m_infoWindowID = ADInfoWindowID;
        this.p_keyColumn = keyColumn;
        this.p_multipleSelection = multipleSelection;
        this.m_lookup = lookup;
        this.loadInfoWindowData();
        if (whereClause == null || whereClause.indexOf(64) == -1) {
            this.p_whereClause = whereClause == null ? "" : whereClause;
        } else {
            this.p_whereClause = Env.parseContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)whereClause, (boolean)false, (boolean)false);
            if (this.p_whereClause.length() == 0) {
                this.log.log(Level.SEVERE, "Cannot parse context= " + whereClause);
            }
        }
        this.pageSize = MSysConfig.getIntValue((String)"ZK_PAGING_SIZE", (int)100, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        this.init();
        this.setAttribute("TabOnSelectHandler", new ITabOnSelectHandler(){

            @Override
            public void onSelect() {
                InfoPanel.this.scrollToSelectedRow();
            }
        });
        this.setWidgetAttribute("instanceName", "infopanel");
        this.addEventListener("onWindowContainerSelectionChanged", this);
        this.addEventListener(ON_RUN_PROCESS, this);
        this.addEventListener("onClose", this);
    }

    private void init() {
        if (this.isLookup()) {
            this.setAttribute("mode", "highlighted");
            this.setBorder("normal");
            this.setClosable(true);
            int height = ClientInfo.get().desktopHeight;
            int width = ClientInfo.get().desktopWidth;
            if (width <= 1000) {
                ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "100%");
                ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "100%");
            } else {
                height = height * 85 / 100;
                width = width * 80 / 100;
                ZKUpdateUtil.setWidth((HtmlBasedComponent)this, String.valueOf(width) + "px");
                ZKUpdateUtil.setHeight((HtmlBasedComponent)this, String.valueOf(height) + "px");
            }
            this.setContentStyle("overflow: auto");
        } else {
            this.setAttribute("mode", "embedded");
            this.setBorder("none");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "100%");
            ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "100%");
            this.setStyle("position: absolute");
        }
        this.confirmPanel = new ConfirmPanel(true, true, true, true, true, true);
        this.confirmPanel.addComponentsLeft(this.confirmPanel.createButton("New"));
        this.confirmPanel.addActionListener("onClick", this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.confirmPanel, "1");
        if (ClientInfo.isMobile() && (ClientInfo.maxWidth(700) || ClientInfo.maxHeight(500))) {
            this.confirmPanel.addButtonSclass("btn-small small-img-btn");
        }
        this.confirmPanel.getButton("Customize").setVisible(this.hasCustomize());
        this.confirmPanel.getButton("History").setVisible(this.hasHistory());
        this.confirmPanel.getButton("Zoom").setVisible(this.hasZoom());
        this.confirmPanel.getButton("New").setVisible(this.hasNew());
        if (!this.isLookup()) {
            this.confirmPanel.getButton("Ok").setVisible(false);
        }
        this.setSizable(true);
        this.setMaximizable(true);
        this.addEventListener("onOK", this);
        if (this.isLookup()) {
            this.addEventListener("onCancel", this);
        }
        this.contentPanel.setOddRowSclass(null);
        this.contentPanel.setWidgetAttribute("instanceName", "infoListbox");
        this.contentPanel.addEventListener("onAfterRender", this);
        this.contentPanel.setSclass("z-word-nowrap");
        this.setSclass("info-panel");
    }

    public boolean loadedOK() {
        return this.p_loadedOK;
    }

    public void setStatusLine(String text, boolean error) {
        this.statusBar.setStatusLine(text, error);
    }

    public void setStatusDB(String text) {
        this.statusBar.setStatusDB(text);
    }

    public void setStatusSelected() {
        if (!this.p_multipleSelection) {
            return;
        }
        int selectedCount = this.recordSelectedData.size();
        int rowIndex = 0;
        while (rowIndex < this.contentPanel.getModel().getRowCount()) {
            Integer keyCandidate = this.getColumnValue(rowIndex);
            List candidateRecord = (List)this.contentPanel.getModel().get(rowIndex);
            if (this.contentPanel.getModel().isSelected(candidateRecord)) {
                if (!this.recordSelectedData.containsKey(keyCandidate)) {
                    ++selectedCount;
                }
            } else if (this.recordSelectedData.containsKey(keyCandidate)) {
                --selectedCount;
            }
            ++rowIndex;
        }
        String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"IWStatusSelected", (Object[])new Object[]{String.valueOf(selectedCount)});
        this.statusBar.setSelectedRowNumber(msg);
    }

    protected void prepareTable(ColumnInfo[] layout, String from, String where, String orderBy) {
        String sql = this.contentPanel.prepareTable(layout, from, where, this.p_multipleSelection, this.getTableName(), false);
        this.p_layout = this.contentPanel.getLayout();
        this.m_sqlMain = sql;
        this.m_sqlCount = "SELECT COUNT(*) FROM " + from + " WHERE " + where;
        this.m_sqlOrder = "";
        if (orderBy != null && orderBy.trim().length() > 0) {
            this.m_sqlOrder = " ORDER BY " + orderBy;
        }
    }

    protected boolean isLoadPageNumber() {
        return this.infoWindow == null || this.infoWindow.isLoadPageNum();
    }

    protected void executeQuery() {
        this.line = new ArrayList<Object>();
        this.setCacheStart(-1);
        this.cacheEnd = -1;
        if (this.isLoadPageNumber()) {
            this.testCount();
        } else {
            this.m_count = Integer.MAX_VALUE;
        }
        if (this.m_count > 0) {
            boolean bl = this.m_useDatabasePaging = this.isIgnoreCacheAll || this.m_count > 1000;
            if (this.m_useDatabasePaging) {
                return;
            }
            this.readLine(0, -1);
        }
    }

    private void readData(ResultSet rs) throws SQLException {
        int colOffset = 1;
        ArrayList<Object> data = new ArrayList<Object>();
        int col = 0;
        while (col < this.p_layout.length) {
            Object value = null;
            Class c = this.p_layout[col].getColClass();
            int colIndex = col + colOffset;
            if (c == IDColumn.class) {
                value = new IDColumn(rs.getInt(colIndex));
            } else if (c == Boolean.class) {
                value = "Y".equals(rs.getString(colIndex));
            } else if (c == Timestamp.class) {
                value = rs.getTimestamp(colIndex);
            } else if (c == BigDecimal.class) {
                value = rs.getBigDecimal(colIndex);
            } else if (c == Double.class) {
                value = rs.getDouble(colIndex);
            } else if (c == Integer.class) {
                value = rs.getInt(colIndex);
            } else if (c == KeyNamePair.class) {
                if (this.p_layout[col].isKeyPairCol()) {
                    String display = rs.getString(colIndex);
                    int key = rs.getInt(colIndex + 1);
                    if (!rs.wasNull()) {
                        value = new KeyNamePair(key, display);
                    }
                    ++colOffset;
                } else {
                    int key = rs.getInt(colIndex);
                    if (!rs.wasNull()) {
                        WEditor editor = this.editorMap.get(this.p_layout[col].getColSQL());
                        if (editor != null) {
                            editor.setValue(key);
                            value = new KeyNamePair(key, editor.getDisplayTextForGridView(key));
                        } else {
                            value = new KeyNamePair(key, Integer.toString(key));
                        }
                    }
                }
            } else if (c == ValueNamePair.class) {
                String key = rs.getString(colIndex);
                WEditor editor = this.editorMap.get(this.p_layout[col].getColSQL());
                value = editor != null ? new ValueNamePair(key, editor.getDisplayTextForGridView(key)) : new ValueNamePair(key, key);
            } else {
                value = rs.getString(colIndex);
            }
            data.add(value);
            ++col;
        }
        this.line.add(data);
        this.appendDataForViewID(rs, data, this.lsReadedColumn);
        this.appendDataForParentLink(rs, data, this.lsReadedColumn);
        this.appendDataForKeyView(rs, data, this.lsReadedColumn);
    }

    protected void appendDataForViewID(ResultSet rs, List<Object> data, List<Integer> listReadedColumn) throws SQLException {
        this.appendInfoColumnData(rs, data, (IInfoColumn[])this.infoProcessList, listReadedColumn);
    }

    protected void appendDataForParentLink(ResultSet rs, List<Object> data, List<Integer> listReadedColumn) throws SQLException {
        this.appendInfoColumnData(rs, data, (IInfoColumn[])this.relatedInfoList, listReadedColumn);
    }

    protected void appendDataForKeyView(ResultSet rs, List<Object> data, List<Integer> listReadedColumn) throws SQLException {
        if (this.isNeedAppendKeyViewData()) {
            this.appendInfoColumnData(rs, data, new IInfoColumn[]{this.keyColumnOfView}, listReadedColumn);
        }
    }

    protected void appendInfoColumnData(ResultSet rs, List<Object> data, IInfoColumn[] listModelHasInfoColumn, List<Integer> listReadedColumn) throws SQLException {
        if (listModelHasInfoColumn == null || listModelHasInfoColumn.length == 0) {
            return;
        }
        IInfoColumn[] iInfoColumnArray = listModelHasInfoColumn;
        int n = listModelHasInfoColumn.length;
        int n2 = 0;
        while (n2 < n) {
            IInfoColumn modelHasInfoColumn = iInfoColumnArray[n2];
            if (modelHasInfoColumn.getInfoColumnID() > 0 && !listReadedColumn.contains(modelHasInfoColumn.getInfoColumnID())) {
                MInfoColumn infoColumnAppend = modelHasInfoColumn.getAD_InfoColumn();
                String appendData = null;
                try {
                    appendData = rs.getString(infoColumnAppend.getColumnName());
                }
                catch (SQLException e) {
                    appendData = null;
                }
                if (rs.wasNull()) {
                    appendData = null;
                }
                data.add(appendData);
                if (this.isMustUpdateColumnIndex && !this.columnDataIndex.containsKey(modelHasInfoColumn.getInfoColumnID())) {
                    this.columnDataIndex.put(modelHasInfoColumn.getInfoColumnID(), this.indexColumnCount);
                    ++this.indexColumnCount;
                }
                listReadedColumn.add(modelHasInfoColumn.getInfoColumnID());
            }
            ++n2;
        }
    }

    protected void renderItems() {
        if (this.m_count > 0) {
            if (this.m_count > this.pageSize) {
                if (this.paging == null) {
                    this.paging = new Paging();
                    this.paging.setPageSize(this.pageSize);
                    this.paging.setTotalSize(this.m_count);
                    this.paging.setDetailed(true);
                    this.paging.addEventListener("onPaging", (EventListener)this);
                } else {
                    this.paging.setTotalSize(this.m_count);
                    this.paging.setActivePage(0);
                }
                List<Object> subList = this.readLine(0, this.pageSize);
                this.model = new ListModelTable(subList);
                this.model.setSorter(this);
                this.model.addTableModelListener(this);
                this.model.setMultiple(this.p_multipleSelection);
                this.contentPanel.setData(this.model, null);
                this.pageNo = 0;
            } else {
                if (this.paging != null) {
                    this.paging.setTotalSize(this.m_count);
                    this.paging.setActivePage(0);
                    this.pageNo = 0;
                }
                this.model = new ListModelTable(this.readLine(0, -1));
                this.model.setSorter(this);
                this.model.addTableModelListener(this);
                this.model.setMultiple(this.p_multipleSelection);
                this.contentPanel.setData(this.model, null);
            }
        } else {
            if (this.paging != null) {
                this.paging.setTotalSize(this.m_count);
                this.paging.setActivePage(0);
                this.pageNo = 0;
            }
            this.model = new ListModelTable(new ArrayList());
            this.model.setSorter(this);
            this.model.addTableModelListener(this);
            this.model.setMultiple(this.p_multipleSelection);
            this.contentPanel.setData(this.model, null);
        }
        this.restoreSelectedInPage();
        this.updateStatusBar(this.m_count);
        this.setStatusSelected();
        this.addDoubleClickListener();
        if (this.paging != null && this.paging.getParent() == null) {
            this.insertPagingComponent();
        }
    }

    protected void updateStatusBar(int no) {
        this.setStatusLine(String.valueOf(no == Integer.MAX_VALUE ? "?" : Integer.toString(no)) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"SearchRows_EnterQuery"), false);
        this.setStatusDB(no == Integer.MAX_VALUE ? "?" : Integer.toString(no));
    }

    private List<Object> readLine(int start, int end) {
        block22: {
            if (this.getCacheStart() >= 1 && this.cacheEnd > this.getCacheStart()) {
                if (this.m_useDatabasePaging) {
                    if (start + 1 >= this.getCacheStart() && end + 1 <= this.cacheEnd) {
                        return end == -1 ? this.line : this.getSubList(start - this.getCacheStart() + 1, end - this.getCacheStart() + 1, this.line);
                    }
                } else {
                    if (end > this.cacheEnd || end <= 0) {
                        end = this.cacheEnd;
                    }
                    return this.getSubList(start, end, this.line);
                }
            }
            this.setCacheStart(this.getOverIntValue((long)start + 1L - (long)(this.pageSize * this.numPagePreLoad)));
            if (this.getCacheStart() <= 0) {
                this.setCacheStart(1);
            }
            if (end == -1) {
                this.cacheEnd = this.m_count;
            } else {
                this.cacheEnd = this.getOverIntValue(end + 1 + this.pageSize * this.numPagePreLoad);
                if (this.cacheEnd > this.m_count) {
                    this.cacheEnd = this.m_count;
                }
            }
            this.line = new ArrayList<Object>();
            CPreparedStatement m_pstmt = null;
            ResultSet m_rs = null;
            String dataSql = null;
            long startTime = System.currentTimeMillis();
            dataSql = this.buildDataSQL(start, end);
            this.isHasNextPage = false;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(dataSql);
            }
            Trx trx = null;
            try {
                try {
                    String trxName = Trx.createTrxName((String)"InfoPanelLoad:");
                    trx = Trx.get((String)trxName, (boolean)true);
                    trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_readLine");
                    m_pstmt = DB.prepareStatement((String)dataSql, (String)trxName);
                    this.setParameters((PreparedStatement)m_pstmt, false);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Start query - " + (System.currentTimeMillis() - startTime) + "ms");
                    }
                    m_pstmt.setFetchSize(100);
                    m_rs = m_pstmt.executeQuery();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("End query - " + (System.currentTimeMillis() - startTime) + "ms");
                    }
                    if (end > start && this.m_useDatabasePaging && !DB.getDatabase().isPagingSupported()) {
                        int i = 0;
                        while (i < this.getCacheStart() - 1) {
                            if (!m_rs.next()) break;
                            ++i;
                        }
                    }
                    int rowPointer = this.getCacheStart() - 1;
                    while (m_rs.next()) {
                        this.lsReadedColumn.clear();
                        this.readData(m_rs);
                        this.isMustUpdateColumnIndex = false;
                        if (!this.m_useDatabasePaging || ++rowPointer < this.cacheEnd) continue;
                        this.isHasNextPage = true;
                        break;
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, dataSql, (Throwable)e);
                    DB.close(m_rs, m_pstmt);
                    trx.close();
                    break block22;
                }
            }
            catch (Throwable throwable) {
                DB.close(m_rs, m_pstmt);
                trx.close();
                throw throwable;
            }
            DB.close((ResultSet)m_rs, (Statement)m_pstmt);
            trx.close();
        }
        if (end > this.cacheEnd || end <= 0) {
            end = this.cacheEnd;
        }
        this.validateEndPage();
        if (end == -1) {
            return this.line;
        }
        int fromIndex = start - this.getCacheStart() + 1;
        int toIndex = end - this.getCacheStart() + 1;
        return this.getSubList(fromIndex, toIndex, this.line);
    }

    protected void validateEndPage() {
        if (this.paging == null || this.isLoadPageNumber()) {
            return;
        }
        if (!this.isHasNextPage) {
            int extraPage = this.line.size() % this.pageSize > 0 ? 1 : 0;
            int pageInCache = this.line.size() / this.pageSize + extraPage;
            if (pageInCache == 0 || pageInCache <= this.numPagePreLoad) {
                this.testCount();
                extraPage = this.m_count % this.pageSize > 0 ? 1 : 0;
                pageInCache = this.m_count / this.pageSize + extraPage;
                this.paging.setTotalSize(this.m_count);
                PagingEvent pagingEvent = new PagingEvent("onPaging", (Component)this.paging, this.paging.getPageCount() - 1);
                Events.postEvent((Event)pagingEvent);
            } else if (pageInCache > this.numPagePreLoad) {
                int prePage = this.pageNo - this.numPagePreLoad;
                int readTotalRecord = (prePage > 0 ? prePage : 0) * this.pageSize + this.line.size();
                this.paging.setTotalSize(readTotalRecord);
                this.m_count = readTotalRecord;
            }
            this.updateStatusBar(this.m_count);
        }
    }

    protected List<Object> getSubList(int fromIndex, int toIndex, List<Object> line) {
        if (toIndex > line.size()) {
            toIndex = line.size();
        }
        if (fromIndex >= line.size()) {
            fromIndex = line.size();
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        return line.subList(fromIndex, toIndex);
    }

    protected int getOverIntValue(long overValue) {
        return this.getOverIntValue(overValue, 0);
    }

    protected int getOverIntValue(long overValue, int extra) {
        if (overValue >= Integer.MAX_VALUE) {
            overValue = Integer.MAX_VALUE - extra;
        }
        return (int)overValue;
    }

    protected String buildDataSQL(int start, int end) {
        String dynWhere = this.getSQLWhere();
        StringBuilder sql = new StringBuilder(this.m_sqlMain);
        if (dynWhere.length() > 0) {
            sql.append(dynWhere);
        }
        if (sql.toString().trim().endsWith("WHERE")) {
            int index = sql.lastIndexOf(" WHERE");
            sql.delete(index, sql.length());
        }
        if (this.m_sqlUserOrder != null && this.m_sqlUserOrder.trim().length() > 0) {
            sql.append(this.m_sqlUserOrder);
        } else {
            sql.append(this.m_sqlOrder);
        }
        String dataSql = Msg.parseTranslation((Properties)Env.getCtx(), (String)sql.toString());
        dataSql = MRole.getDefault().addAccessSQL(dataSql, this.getTableName(), true, false);
        if (end > start && this.m_useDatabasePaging && DB.getDatabase().isPagingSupported()) {
            dataSql = DB.getDatabase().addPagingSQL(dataSql, this.getCacheStart(), this.cacheEnd);
        }
        return dataSql;
    }

    private void addDoubleClickListener() {
        Iterator i = this.contentPanel.getEventListeners("onDoubleClick").iterator();
        while (i.hasNext()) {
            if (i.next() != this) continue;
            return;
        }
        this.contentPanel.addEventListener("onDoubleClick", this);
        this.contentPanel.addEventListener("onSelect", this);
    }

    protected void insertPagingComponent() {
        this.contentPanel.getParent().insertBefore((Component)this.paging, this.contentPanel.getNextSibling());
    }

    public Vector<String> getColumnHeader(ColumnInfo[] p_layout) {
        Vector<String> columnHeader = new Vector<String>();
        ColumnInfo[] columnInfoArray = p_layout;
        int n = p_layout.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnInfo info = columnInfoArray[n2];
            columnHeader.add(info.getColHeader());
            ++n2;
        }
        return columnHeader;
    }

    protected boolean testCount() {
        long start;
        block10: {
            String countSql;
            start = System.currentTimeMillis();
            String dynWhere = this.getSQLWhere();
            StringBuilder sql = new StringBuilder(this.m_sqlCount);
            if (dynWhere.length() > 0) {
                sql.append(dynWhere);
            }
            if ((countSql = Msg.parseTranslation((Properties)Env.getCtx(), (String)sql.toString())).trim().endsWith("WHERE")) {
                countSql = countSql.trim();
                countSql = countSql.substring(0, countSql.length() - 5);
            }
            countSql = MRole.getDefault().addAccessSQL(countSql, this.getTableName(), true, false);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(countSql);
            }
            this.m_count = -1;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)countSql, null);
                    this.setParameters((PreparedStatement)pstmt, true);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_count = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, countSql, (Throwable)e);
                    this.m_count = -2;
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_count + " - " + (System.currentTimeMillis() - start) + "ms");
        }
        return true;
    }

    protected void saveSelection() {
        if (this.contentPanel == null) {
            return;
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("OK=" + this.m_ok);
        }
        this.m_results.clear();
        if (!this.m_ok) {
            this.contentPanel = null;
            this.detach();
            return;
        }
        if (this.p_multipleSelection) {
            this.m_results.addAll(this.getSelectedRowKeys());
        } else {
            Integer data = this.getSelectedRowKey();
            if (data != null) {
                this.m_results.add(data);
            }
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(this.getSelectedSQL());
        }
        this.saveSelectionDetail();
    }

    protected Integer getSelectedRowKey() {
        Integer key = this.contentPanel.getSelectedRowKey();
        return key;
    }

    protected ArrayList<Integer> getSelectedRowKeys() {
        ArrayList<Integer> selectedDataList = new ArrayList<Integer>();
        Set<Integer> lsKeyValueOfSelectedRow = this.getSelectedRowInfo().keySet();
        if (lsKeyValueOfSelectedRow.size() == 0) {
            return selectedDataList;
        }
        if (this.p_multipleSelection) {
            for (Integer key : lsKeyValueOfSelectedRow) {
                selectedDataList.add(key);
            }
        }
        return selectedDataList;
    }

    public Collection<Integer> getSelectedKeysCollection() {
        this.m_ok = true;
        this.saveSelection();
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results;
    }

    public Collection<KeyNamePair> getSaveKeys(int infoCulumnId) {
        this.m_viewIDMap.clear();
        if (this.p_multipleSelection) {
            Map<Integer, List<Object>> selectedRow = this.getSelectedRowInfo();
            for (Map.Entry<Integer, List<Object>> selectedInfo : selectedRow.entrySet()) {
                Integer keyData = selectedInfo.getKey();
                if (infoCulumnId > 0) {
                    int dataIndex = this.columnDataIndex.get(infoCulumnId) + this.p_layout.length;
                    Object viewIDValue = selectedInfo.getValue().get(dataIndex);
                    this.m_viewIDMap.add(new KeyNamePair(keyData.intValue(), viewIDValue == null ? null : viewIDValue.toString()));
                    continue;
                }
                this.m_viewIDMap.add(new KeyNamePair(keyData.intValue(), null));
            }
            return this.m_viewIDMap;
        }
        return null;
    }

    protected boolean isNeedAppendKeyViewData() {
        return false;
    }

    protected boolean isIDColumn(Object keyData, boolean isCheckNull) {
        if (isCheckNull && keyData == null) {
            AdempiereException ex = this.getKeyNullException();
            this.log.severe(ex.getMessage());
            throw ex;
        }
        return keyData != null && keyData instanceof IDColumn;
    }

    protected boolean isIDColumn(Object keyData) {
        return this.isIDColumn(keyData, false);
    }

    protected void updateListSelected() {
        int rowIndex = 0;
        while (rowIndex < this.contentPanel.getModel().getRowCount()) {
            Integer keyCandidate = this.getColumnValue(rowIndex);
            List candidateRecord = (List)this.contentPanel.getModel().get(rowIndex);
            if (this.contentPanel.getModel().isSelected(candidateRecord)) {
                this.recordSelectedData.put(keyCandidate, candidateRecord);
            } else if (this.recordSelectedData.containsKey(keyCandidate)) {
                List<Object> recordSelected = this.recordSelectedData.get(keyCandidate);
                IDColumn idcSel = null;
                if (recordSelected.get(0) instanceof IDColumn) {
                    idcSel = (IDColumn)recordSelected.get(0);
                }
                IDColumn idcCan = null;
                if (candidateRecord.get(0) instanceof IDColumn) {
                    idcCan = (IDColumn)candidateRecord.get(0);
                }
                if (idcSel != null && idcCan != null && idcSel.getRecord_ID().equals(idcCan.getRecord_ID())) {
                    recordSelected.set(0, candidateRecord.get(0));
                }
                if (recordSelected.equals(candidateRecord)) {
                    this.recordSelectedData.remove(keyCandidate);
                }
            }
            ++rowIndex;
        }
    }

    protected int getIndexKeyColumnOfView() {
        if (this.keyColumnOfView == null) {
            return this.contentPanel.getKeyColumnIndex();
        }
        if (this.isNeedAppendKeyViewData()) {
            return this.columnDataIndex.get(this.keyColumnOfView.getInfoColumnID()) + this.p_layout.length;
        }
        return this.indexKeyOfView;
    }

    protected void restoreSelectedInPage() {
        if (!this.p_multipleSelection) {
            return;
        }
        ArrayList<Object> lsSelectionRecord = new ArrayList<Object>();
        int rowIndex = 0;
        while (rowIndex < this.contentPanel.getModel().getRowCount()) {
            Object row;
            Integer keyViewValue = this.getColumnValue(rowIndex);
            if (this.recordSelectedData.containsKey(keyViewValue) && this.onRestoreSelectedItemIndexInPage(keyViewValue, rowIndex, row = this.contentPanel.getModel().get(rowIndex))) {
                lsSelectionRecord.add(row);
            }
            ++rowIndex;
        }
        this.contentPanel.getModel().setSelection(lsSelectionRecord);
    }

    public boolean onRestoreSelectedItemIndexInPage(Integer keyViewValue, int rowIndex, Object row) {
        return true;
    }

    protected AdempiereException getKeyNullException() {
        String errorMessage = String.format("has null value at column %1$s use as key of view in info window %2$s", this.keyColumnOfView == null ? this.p_keyColumn : this.keyColumnOfView, this.infoWindow.getName());
        return new AdempiereException(errorMessage);
    }

    protected Integer getColumnValue(int rowIndex) {
        int keyIndex = this.getIndexKeyColumnOfView();
        Integer keyValue = null;
        Object keyColumValue = this.contentPanel.getModel().getDataAt(rowIndex, keyIndex);
        if (keyColumValue == null) {
            AdempiereException ex = this.getKeyNullException();
            this.log.severe(ex.getMessage());
            throw ex;
        }
        if (keyColumValue != null && keyColumValue instanceof IDColumn) {
            keyColumValue = ((IDColumn)keyColumValue).getRecord_ID();
        }
        if (!(keyColumValue instanceof Integer)) {
            String msg = "column play keyView should is integer";
            AdempiereException ex = new AdempiereException(msg);
            this.log.severe(msg);
            throw ex;
        }
        keyValue = (Integer)keyColumValue;
        return keyValue;
    }

    protected void syncSelectedAfterRequery() {
        if (this.isRequeryByRunSuccessProcess) {
            this.isRequeryByRunSuccessProcess = false;
        }
    }

    public Map<Integer, List<Object>> getSelectedRowInfo() {
        this.updateListSelected();
        return this.recordSelectedData;
    }

    public Object[] getSelectedKeys() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results.toArray(new Integer[0]);
    }

    public Object getSelectedKey() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results.get(0);
    }

    public boolean isCancelled() {
        return this.m_cancel;
    }

    public String getSelectedSQL() {
        Object[] keys = this.getSelectedKeys();
        if (keys == null || keys.length == 0) {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("No Results - OK=" + this.m_ok + ", Cancel=" + this.m_cancel);
            }
            return "";
        }
        StringBuilder sb = new StringBuilder(this.getKeyColumn());
        if (keys.length > 1) {
            sb.append(" IN (");
        } else {
            sb.append("=");
        }
        int i = 0;
        while (i < keys.length) {
            if (this.getKeyColumn().endsWith("_ID")) {
                sb.append(keys[i].toString()).append(",");
            } else {
                sb.append("'").append(keys[i].toString()).append("',");
            }
            ++i;
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        if (keys.length > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    protected void loadInfoWindowData() {
    }

    protected String getTableName() {
        return this.p_tableName;
    }

    protected String getKeyColumn() {
        return this.p_keyColumn;
    }

    public String[] getEvents() {
        return lISTENER_EVENTS;
    }

    protected void enableButtons() {
        boolean enable = this.contentPanel.getSelectedCount() > 0 || this.getSelectedRowInfo().size() > 0;
        this.enableButtons(enable);
    }

    protected void enableButtons(boolean enable) {
        this.confirmPanel.getOKButton().setEnabled(enable);
        if (this.hasHistory()) {
            this.confirmPanel.getButton("History").setEnabled(enable);
        }
        if (this.hasZoom()) {
            this.confirmPanel.getButton("Zoom").setEnabled(!enable ? enable : this.contentPanel.getSelectedCount() == 1);
        }
        if (this.hasProcess()) {
            this.confirmPanel.getButton("Process").setEnabled(enable);
        }
        for (Button btProcess : this.btProcessList) {
            btProcess.setEnabled(enable);
        }
        if (this.btCbbProcess != null) {
            this.btCbbProcess.setEnabled(enable);
        }
        if (this.btMenuProcess != null) {
            this.btMenuProcess.setEnabled(enable);
        }
        if (this.cbbProcess != null) {
            this.cbbProcess.setEnabled(enable);
        }
    }

    protected abstract String getSQLWhere();

    protected abstract void setParameters(PreparedStatement var1, boolean var2) throws SQLException;

    protected void showHistory() {
    }

    protected boolean hasHistory() {
        return false;
    }

    protected boolean hasProcess() {
        return false;
    }

    protected void customize() {
    }

    protected boolean hasCustomize() {
        return false;
    }

    protected boolean hasZoom() {
        return false;
    }

    protected boolean hasNew() {
        return false;
    }

    protected void saveSelectionDetail() {
    }

    protected int getAD_Window_ID(String tableName, boolean isSOTrx) {
        block9: {
            if (!isSOTrx && this.m_PO_Window_ID > 0) {
                return this.m_PO_Window_ID;
            }
            if (this.m_SO_Window_ID > 0) {
                return this.m_SO_Window_ID;
            }
            String sql = "SELECT AD_Window_ID, PO_Window_ID FROM AD_Table WHERE TableName=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setString(1, tableName);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_SO_Window_ID = rs.getInt(1);
                        this.m_PO_Window_ID = rs.getInt(2);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (!isSOTrx && this.m_PO_Window_ID > 0) {
            return this.m_PO_Window_ID;
        }
        return this.m_SO_Window_ID;
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        if (event.getTarget().equals((Object)this.confirmPanel.getButton("Ok"))) {
            this.onOk();
        } else if (event.getTarget() == this.contentPanel && event.getName().equals("onSelect")) {
            this.setStatusSelected();
            SelectEvent selectEvent = (SelectEvent)event;
            if (selectEvent.getReference() != null && selectEvent.getReference() instanceof Listitem) {
                Listitem m_lastOnSelectItem = (Listitem)selectEvent.getReference();
                this.m_lastSelectedIndex = m_lastOnSelectItem.getIndex();
            }
        } else if (event.getTarget() == this.contentPanel && event.getName().equals("onAfterRender")) {
            this.enableButtons();
        } else if (event.getTarget() == this.contentPanel && event.getName().equals("onDoubleClick")) {
            if (event.getClass().equals(MouseEvent.class)) {
                return;
            }
            if (this.contentPanel.isMultiple() && this.m_lastSelectedIndex >= 0) {
                this.contentPanel.setSelectedIndex(this.m_lastSelectedIndex);
                this.model.clearSelection();
                ArrayList<Object> lsSelectedItem = new ArrayList<Object>();
                lsSelectedItem.add(this.model.getElementAt(this.m_lastSelectedIndex));
                this.model.setSelection(lsSelectedItem);
                int m_keyColumnIndex = this.contentPanel.getKeyColumnIndex();
                int i = 0;
                while (i < this.contentPanel.getRowCount()) {
                    Object data = this.contentPanel.getModel().getValueAt(i, m_keyColumnIndex);
                    if (data instanceof IDColumn) {
                        IDColumn dataColumn = (IDColumn)data;
                        if (i == this.m_lastSelectedIndex) {
                            dataColumn.setSelected(true);
                        } else {
                            dataColumn.setSelected(false);
                        }
                    }
                    ++i;
                }
            }
            this.onDoubleClick();
            this.contentPanel.repaint();
            this.m_lastSelectedIndex = -1;
        } else if (event.getTarget().equals((Object)this.confirmPanel.getButton("Refresh"))) {
            this.onUserQuery();
        } else if (event.getTarget().equals((Object)this.confirmPanel.getButton("Cancel"))) {
            this.m_cancel = true;
            this.dispose(false);
        } else if (event.getTarget().equals((Object)this.confirmPanel.getButton("Reset"))) {
            this.resetParameters();
        } else if (event.getTarget().equals((Object)this.confirmPanel.getButton("History"))) {
            if (!this.contentPanel.getChildren().isEmpty() && this.contentPanel.getSelectedRowKey() != null) {
                this.showHistory();
            }
        } else if (event.getTarget().equals((Object)this.confirmPanel.getButton("Customize"))) {
            if (!this.contentPanel.getChildren().isEmpty() && this.contentPanel.getSelectedRowKey() != null) {
                this.customize();
            }
        } else if (event.getTarget().equals((Object)this.confirmPanel.getButton("Zoom"))) {
            if (!this.contentPanel.getChildren().isEmpty() && this.contentPanel.getSelectedRowKey() != null) {
                this.zoom();
                if (this.isLookup()) {
                    this.detach();
                }
            }
        } else if (event.getTarget().equals((Object)this.confirmPanel.getButton("New"))) {
            this.newRecordAction();
        } else if (ON_RUN_PROCESS.equals(event.getName())) {
            this.runProcess((Integer)event.getData());
        } else if ("onClick".equals(event.getName()) && event.getTarget() != null && event.getTarget() instanceof Menuitem && event.getTarget().getAttribute(PROCESS_ID_KEY) != null) {
            this.preRunProcess((Integer)event.getTarget().getAttribute(PROCESS_ID_KEY));
        } else if (event.getTarget().equals((Object)this.btCbbProcess)) {
            Comboitem cbbSelectedItem = this.cbbProcess.getSelectedItem();
            if (cbbSelectedItem == null || cbbSelectedItem.getValue() == null) {
                return;
            }
            MProcess selectedProcess = (MProcess)cbbSelectedItem.getValue();
            this.preRunProcess(selectedProcess.getAD_Process_ID());
        } else if (this.btProcessList.contains(event.getTarget())) {
            Button btProcess = (Button)event.getTarget();
            Integer processId = (Integer)btProcess.getAttribute(PROCESS_ID_KEY);
            this.preRunProcess(processId);
        } else if (event.getTarget() == this.paging) {
            this.updateListSelected();
            int pgNo = this.paging.getActivePage();
            if (pgNo == this.paging.getPageCount() - 1 && !this.isLoadPageNumber()) {
                this.testCount();
                this.paging.setTotalSize(this.m_count);
                pgNo = this.paging.getActivePage();
            }
            if (this.pageNo != pgNo) {
                this.contentPanel.clearSelection();
                this.pageNo = pgNo;
                int start = this.pageNo * this.pageSize;
                int end = this.getOverIntValue((long)start + (long)this.pageSize, this.extra_max_row);
                if (end >= this.m_count) {
                    end = this.m_count;
                }
                List<Object> subList = this.readLine(start, end);
                this.model = new ListModelTable(subList);
                this.model.setSorter(this);
                this.model.addTableModelListener(this);
                this.model.setMultiple(this.p_multipleSelection);
                this.contentPanel.setData(this.model, null);
                this.restoreSelectedInPage();
            }
        } else if (!event.getName().equals("onChange")) {
            if (event.getName().equals("onWindowContainerSelectionChanged")) {
                if (this.infoWindow != null) {
                    SessionManager.getAppDesktop().updateHelpContext("I", this.infoWindow.getAD_InfoWindow_ID());
                } else {
                    SessionManager.getAppDesktop().updateHelpContext("H", 0);
                }
            } else if (event.getName().equals("onCtrlKey")) {
                KeyEvent keyEvent = (KeyEvent)event;
                if (LayoutUtils.isReallyVisible((Component)this)) {
                    this.onCtrlKeyEvent(keyEvent);
                }
            } else if (event.getName().equals("onOK")) {
                if (this.m_lookup && this.contentPanel.getSelectedIndex() >= 0) {
                    this.onOk();
                }
            } else if (event.getName().equals("onCancel") || event.getTarget().equals(this) && event.getName().equals("onClose")) {
                this.m_cancel = true;
                this.dispose(false);
            }
        }
    }

    private void onCtrlKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isAltKey() && !keyEvent.isCtrlKey() && keyEvent.isShiftKey()) {
            if (keyEvent.getKeyCode() == 40 && this.contentPanel.getRowCount() > 0) {
                this.contentPanel.setFocus(true);
                this.contentPanel.setSelectedIndex(0);
            }
        } else {
            keyEvent.getKeyCode();
        }
    }

    public void onUserQuery() {
        if (this.validateParameters()) {
            this.showBusyDialog();
            this.isQueryByUser = true;
            Clients.response((AuResponse)new AuEcho((Component)this, "onQueryCallback", null));
        }
    }

    public boolean validateParameters() {
        return true;
    }

    protected void initParameters() {
    }

    protected void updateSubcontent() {
        this.updateSubcontent(-1);
    }

    protected void updateSubcontent(int targetRow) {
    }

    protected void resetParameters() {
    }

    void preRunProcess(Integer processId) {
        this.enableButtons(false);
        Events.echoEvent((String)ON_RUN_PROCESS, (Component)this, (Object)processId);
    }

    protected void runProcess(Object processIdObj) {
        Integer processId = (Integer)processIdObj;
        MProcess m_process = MProcess.get((Properties)Env.getCtx(), (int)processId);
        final ProcessInfo m_pi = new ProcessInfo(m_process.getName(), processId.intValue());
        m_pi.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
        m_pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)Env.getCtx()));
        MPInstance instance = new MPInstance(Env.getCtx(), processId.intValue(), 0);
        instance.saveEx();
        final int pInstanceID = instance.getAD_PInstance_ID();
        m_pi.setAD_PInstance_ID(pInstanceID);
        m_pi.setAD_InfoWindow_ID(this.infoWindow.getAD_InfoWindow_ID());
        WProcessCtl.process(this.p_WindowNo, m_pi, null, new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                ProcessModalDialog processModalDialog = (ProcessModalDialog)event.getTarget();
                if ("onBeforeRunProcess".equals(event.getName())) {
                    InfoPanel.this.updateListSelected();
                    DB.createT_SelectionNew((int)pInstanceID, InfoPanel.this.getSaveKeys(InfoPanel.this.getInfoColumnIDFromProcess(processModalDialog.getAD_Process_ID())), null);
                    InfoPanel.this.saveResultSelection(InfoPanel.this.getInfoColumnIDFromProcess(processModalDialog.getAD_Process_ID()));
                    InfoPanel.this.createT_Selection_InfoWindow(pInstanceID);
                } else if ("onWindowClose".equals(event.getName())) {
                    if (processModalDialog.isCancel()) {
                        InfoPanel.this.m_results.clear();
                        InfoPanel.this.enableButtons();
                    } else if (m_pi.isError()) {
                        ProcessInfoDialog.showProcessInfo(m_pi, InfoPanel.this.p_WindowNo, (Component)InfoPanel.this, true);
                        InfoPanel.this.enableButtons();
                    } else if (!m_pi.isError()) {
                        ProcessInfoDialog.showProcessInfo(m_pi, InfoPanel.this.p_WindowNo, (Component)InfoPanel.this, true);
                        InfoPanel.this.isRequeryByRunSuccessProcess = true;
                        Clients.response((AuResponse)new AuEcho((Component)InfoPanel.this, "onQueryCallback", null));
                    }
                }
            }
        });
    }

    protected void saveResultSelection(int infoColumnId) {
        int m_keyColumnIndex = this.contentPanel.getKeyColumnIndex();
        if (m_keyColumnIndex == -1) {
            return;
        }
        this.m_values = new LinkedHashMap();
        if (this.p_multipleSelection) {
            Map<Integer, List<Object>> selectedRow = this.getSelectedRowInfo();
            for (Map.Entry<Integer, List<Object>> selectedInfo : selectedRow.entrySet()) {
                Integer keyData = selectedInfo.getKey();
                KeyNamePair kp = null;
                if (infoColumnId > 0) {
                    int dataIndex = this.columnDataIndex.get(infoColumnId) + this.p_layout.length;
                    Object viewIDValue = selectedInfo.getValue().get(dataIndex);
                    kp = new KeyNamePair(keyData.intValue(), viewIDValue == null ? null : viewIDValue.toString());
                } else {
                    kp = new KeyNamePair(keyData.intValue(), null);
                }
                LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
                int col = 0;
                while (col < this.p_layout.length) {
                    if (!this.p_layout[col].isReadOnly()) {
                        values.put(this.p_layout[col].getColumnName(), selectedInfo.getValue().get(col));
                    }
                    ++col;
                }
                if (values.size() <= 0) continue;
                this.m_values.put(kp, values);
            }
        }
    }

    public void createT_Selection_InfoWindow(int AD_PInstance_ID) {
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO T_Selection_InfoWindow (AD_PINSTANCE_ID, T_SELECTION_ID, COLUMNNAME , VALUE_STRING, VALUE_NUMBER , VALUE_DATE ) VALUES(?,?,?,?,?,?) ");
        for (Map.Entry<KeyNamePair, LinkedHashMap<String, Object>> records : this.m_values.entrySet()) {
            LinkedHashMap<String, Object> fields = records.getValue();
            for (Map.Entry<String, Object> field : fields.entrySet()) {
                Comparable<BigDecimal> value;
                ArrayList<Object> parameters = new ArrayList<Object>();
                parameters.add(AD_PInstance_ID);
                KeyNamePair key = records.getKey();
                if (key instanceof KeyNamePair) {
                    KeyNamePair knp = key;
                    parameters.add(knp.getKey());
                } else {
                    parameters.add(key);
                }
                parameters.add(field.getKey());
                Object data = field.getValue();
                if (data instanceof IDColumn) {
                    IDColumn id = (IDColumn)data;
                    parameters.add(null);
                    parameters.add(id.getRecord_ID());
                    parameters.add(null);
                } else if (data instanceof String) {
                    parameters.add(data);
                    parameters.add(null);
                    parameters.add(null);
                } else if (data instanceof BigDecimal || data instanceof Integer || data instanceof Double) {
                    parameters.add(null);
                    if (data instanceof Double) {
                        value = BigDecimal.valueOf((Double)data);
                        parameters.add(value);
                    } else {
                        parameters.add(data);
                    }
                    parameters.add(null);
                } else if (data instanceof Integer) {
                    parameters.add(null);
                    parameters.add((Integer)data);
                    parameters.add(null);
                } else if (data instanceof Timestamp || data instanceof Date) {
                    parameters.add(null);
                    parameters.add(null);
                    if (data instanceof Date) {
                        value = new Timestamp(((Date)data).getTime());
                        parameters.add(value);
                    } else {
                        parameters.add(data);
                    }
                } else if (data instanceof KeyNamePair) {
                    KeyNamePair knpData = (KeyNamePair)data;
                    parameters.add(null);
                    parameters.add(knpData.getKey());
                    parameters.add(null);
                } else {
                    parameters.add(data);
                    parameters.add(null);
                    parameters.add(null);
                }
                DB.executeUpdateEx((String)insert.toString(), (Object[])parameters.toArray(), null);
            }
        }
    }

    protected int getInfoColumnIDFromProcess(int processId) {
        int i = 0;
        while (i < this.infoProcessList.length) {
            if (this.infoProcessList[i].getAD_Process_ID() == processId) {
                return this.infoProcessList[i].getAD_InfoColumn_ID();
            }
            ++i;
        }
        return -1;
    }

    private void showBusyDialog() {
        this.progressWindow = new BusyDialog();
        this.progressWindow.setPage(this.getPage());
        this.progressWindow.doHighlighted();
    }

    private void hideBusyDialog() {
        if (this.progressWindow != null) {
            this.progressWindow.dispose();
            this.progressWindow = null;
        }
    }

    public void onQueryCallback(Event event) {
        try {
            ListHead listHead = this.contentPanel.getListHead();
            if (listHead != null) {
                List headers = listHead.getChildren();
                for (Object obj : headers) {
                    Listheader header = (Listheader)obj;
                    header.setSortDirection("natural");
                }
            }
            this.m_sqlUserOrder = "";
            if (event == null) {
                this.m_count = 0;
            } else {
                this.executeQuery();
            }
            this.renderItems();
            if (this.isQueryByUser) {
                this.bindInfoProcess();
                this.recordSelectedData.clear();
                this.isRequeryByRunSuccessProcess = false;
            }
            if (this.isRequeryByRunSuccessProcess) {
                this.syncSelectedAfterRequery();
                this.restoreSelectedInPage();
            }
            this.updateSubcontent();
        }
        finally {
            this.isQueryByUser = false;
            this.hideBusyDialog();
        }
    }

    protected void bindInfoProcess() {
    }

    protected void onOk() {
        if (!this.contentPanel.getChildren().isEmpty() && this.getSelectedRowInfo().size() > 0) {
            this.dispose(true);
        }
    }

    private void onDoubleClick() {
        if (this.isLookup()) {
            this.dispose(true);
        } else {
            this.zoom();
        }
    }

    @Override
    public void tableChanged(WTableModelEvent event) {
        this.enableButtons();
    }

    public void zoom() {
        Integer recordId = this.contentPanel.getSelectedRowKey();
        if (recordId == null) {
            return;
        }
        if (this.listeners != null && this.listeners.size() > 0) {
            ValueChangeEvent event = new ValueChangeEvent(this, "zoom", this.contentPanel.getSelectedRowKey(), this.contentPanel.getSelectedRowKey());
            this.fireValueChange(event);
        } else {
            int AD_Table_ID = MTable.getTable_ID((String)this.p_tableName);
            if (AD_Table_ID <= 0 && this.p_keyColumn.endsWith("_ID")) {
                AD_Table_ID = MTable.getTable_ID((String)this.p_keyColumn.substring(0, this.p_keyColumn.length() - 3));
            }
            if (AD_Table_ID > 0) {
                AEnv.zoom(AD_Table_ID, recordId);
            }
        }
    }

    protected void newRecordAction() {
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void fireValueChange(ValueChangeEvent event) {
        for (ValueChangeListener listener : this.listeners) {
            listener.valueChange(event);
        }
    }

    public void dispose(boolean ok) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("OK=" + ok);
        }
        this.m_ok = ok;
        if (this.isLookup()) {
            this.saveSelection();
        }
        if ("embedded".equals(this.getAttribute("mode"))) {
            SessionManager.getAppDesktop().closeActiveWindow();
        } else {
            this.detach();
        }
    }

    public void sort(Comparator<Object> cmpr, boolean ascending) {
        this.updateListSelected();
        WListItemRenderer.ColumnComparator lsc = (WListItemRenderer.ColumnComparator)cmpr;
        if (this.m_useDatabasePaging) {
            int col = lsc.getColumnIndex();
            String colsql = this.p_layout[col].getColSQL().trim();
            int lastSpaceIdx = colsql.lastIndexOf(" ");
            if (lastSpaceIdx > 0) {
                String tmp = colsql.substring(0, lastSpaceIdx).trim();
                char last = tmp.charAt(tmp.length() - 1);
                String alias = colsql.substring(lastSpaceIdx).trim();
                boolean hasAlias = alias.matches("^[a-zA-Z_][a-zA-Z0-9_]*$");
                if (tmp.toLowerCase().endsWith("as") && hasAlias) {
                    colsql = alias;
                } else if (last != '*' && last != '-' && last != '+' && last != '/' && last != '>' && last != '<' && last != '=') {
                    if (alias.startsWith("\"") && alias.endsWith("\"")) {
                        colsql = alias;
                    } else if (hasAlias) {
                        colsql = alias;
                    }
                }
            }
            this.m_sqlUserOrder = " ORDER BY " + colsql;
            if (!ascending) {
                this.m_sqlUserOrder = String.valueOf(this.m_sqlUserOrder) + " DESC ";
            }
            this.executeQuery();
            this.renderItems();
        } else {
            Collections.sort(this.line, lsc);
            this.renderItems();
        }
    }

    public boolean isLookup() {
        return this.m_lookup;
    }

    public void scrollToSelectedRow() {
        ListItem selected;
        if (this.contentPanel != null && this.contentPanel.getSelectedIndex() >= 0 && (selected = this.contentPanel.getItemAtIndex(this.contentPanel.getSelectedIndex())) != null) {
            selected.focus();
        }
    }

    public String getSortDirection(Comparator<Object> cmpr) {
        return "natural";
    }

    public int getWindowNo() {
        return this.p_WindowNo;
    }

    public int getRowCount() {
        return this.contentPanel.getRowCount();
    }

    public Integer getFirstRowKey() {
        return this.contentPanel.getFirstRowKey();
    }

    protected int getCacheStart() {
        return this.cacheStart;
    }

    private void setCacheStart(int cacheStart) {
        this.cacheStart = cacheStart;
    }

    protected int getCacheEnd() {
        return this.cacheEnd;
    }

    protected boolean isUseDatabasePaging() {
        return this.m_useDatabasePaging;
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null) {
            if (this.infoWindow != null) {
                SessionManager.getAppDesktop().updateHelpContext("I", this.infoWindow.getAD_InfoWindow_ID());
            } else {
                SessionManager.getAppDesktop().updateHelpContext("H", 0);
            }
        }
        SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        try {
            SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public GridField getGridfield() {
        return this.m_gridfield;
    }

    public void setGridfield(GridField m_gridfield) {
        this.m_gridfield = m_gridfield;
    }

    public int getPageSize() {
        return this.pageSize;
    }
}

