/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.Properties;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Menupopup;
import org.adempiere.webui.desktop.IDesktop;
import org.adempiere.webui.event.ZoomEvent;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.WCtxHelpSuggestion;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MCtxHelpMsg;
import org.compiere.model.MForm;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MTab;
import org.compiere.model.MTask;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWorkflow;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Anchorchildren;
import org.zkoss.zul.Anchorlayout;
import org.zkoss.zul.Html;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Panelchildren;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Style;
import org.zkoss.zul.Vlayout;

public class HelpController {
    private Anchorlayout dashboardLayout = new Anchorlayout();
    private Panel pnlToolTip;
    private Panel pnlContextHelp;
    private Panel pnlQuickInfo;
    private Html htmlToolTip;
    private Html htmlContextHelp;
    private Html htmlQuickInfo;

    public HelpController() {
        this.dashboardLayout.setSclass("dashboard-layout");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.dashboardLayout, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.dashboardLayout, "1");
    }

    public void render(Component parent, IDesktop desktopImpl) {
        Style style = new Style();
        style.setContent(".z-anchorlayout { overflow:auto } .z-anchorchildren { overflow:visible } ");
        style.setPage(parent.getPage());
        parent.appendChild((Component)this.dashboardLayout);
        Vlayout dashboardColumnLayout = new Vlayout();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)dashboardColumnLayout, "1");
        Anchorchildren dashboardColumn = new Anchorchildren();
        dashboardColumn.setAnchor("95% 100%");
        dashboardColumn.appendChild((Component)dashboardColumnLayout);
        this.dashboardLayout.appendChild((Component)dashboardColumn);
        Panelchildren content = new Panelchildren();
        this.pnlQuickInfo = new Panel();
        this.pnlQuickInfo.setSclass("dashboard-widget");
        this.pnlQuickInfo.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"QuickInfo"));
        this.pnlQuickInfo.setMaximizable(false);
        this.pnlQuickInfo.setCollapsible(true);
        this.pnlQuickInfo.setOpen(true);
        this.pnlQuickInfo.setBorder("normal");
        dashboardColumnLayout.appendChild((Component)this.pnlQuickInfo);
        content = new Panelchildren();
        this.pnlQuickInfo.appendChild((Component)content);
        this.htmlQuickInfo = new Html();
        content.appendChild((Component)this.htmlQuickInfo);
        Env.setContext((Properties)Env.getCtx(), (String)"#clientInfo_QuickInfoComponentId", (String)this.htmlQuickInfo.getUuid());
        this.htmlQuickInfo.addEventListener("onZoom", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event instanceof ZoomEvent) {
                    Clients.clearBusy();
                    ZoomEvent ze = (ZoomEvent)event;
                    if (ze.getData() != null && ze.getData() instanceof MQuery) {
                        AEnv.zoom((MQuery)ze.getData());
                    }
                }
            }
        });
        this.pnlToolTip = new Panel();
        this.pnlToolTip.setSclass("dashboard-widget");
        this.pnlToolTip.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"ToolTip"));
        this.pnlToolTip.setMaximizable(false);
        this.pnlToolTip.setCollapsible(true);
        this.pnlToolTip.setOpen(true);
        this.pnlToolTip.setBorder("normal");
        dashboardColumnLayout.appendChild((Component)this.pnlToolTip);
        content = new Panelchildren();
        this.pnlToolTip.appendChild((Component)content);
        this.htmlToolTip = new Html();
        content.appendChild((Component)this.htmlToolTip);
        this.htmlToolTip.setWidgetOverride("defaultMessage", "'" + Msg.getMsg((Properties)Env.getCtx(), (String)"PlaceCursorIntoField") + "'");
        this.htmlToolTip.setWidgetOverride("onFieldTooltip", "function(origin,opts,header,description,help){var s='<html><body><div class=\"help-content\">';if (typeof header == 'undefined') {s=s+'<i>'+this.defaultMessage+'</i>';} else {s=s+'<b>'+header+'</b>';if (typeof description=='string' && description.length > 0) {s=s+'<br><br><i>'+description+'</i>';}if (typeof help=='string' && help.length > 0) {s=s+'<br><br>'+help;}}s=s+'</div></body></html>';this.setContent(s);}");
        this.setupFieldTooltip();
        this.pnlContextHelp = new Panel();
        this.pnlContextHelp.setSclass("dashboard-widget");
        this.pnlContextHelp.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"HowTo"));
        this.pnlContextHelp.setMaximizable(false);
        this.pnlContextHelp.setCollapsible(true);
        this.pnlContextHelp.setOpen(true);
        this.pnlContextHelp.setBorder("normal");
        dashboardColumnLayout.appendChild((Component)this.pnlContextHelp);
        content = new Panelchildren();
        this.pnlContextHelp.appendChild((Component)content);
        this.htmlContextHelp = new Html();
        content.appendChild((Component)this.htmlContextHelp);
        this.renderToolTip(null);
        this.renderCtxHelp("H", 0);
        this.renderQuickInfo(null);
    }

    public void setupFieldTooltip() {
        Clients.response((String)"helpControllerFieldTooltip", (AuResponse)new AuScript((Component)this.htmlToolTip, "var w=zk.Widget.$('#" + this.htmlToolTip.getUuid() + "');zWatch.listen({onFieldTooltip: w});"));
    }

    public void renderToolTip(GridField field) {
        String hdr = null;
        String desc = null;
        String help = null;
        String otherContent = null;
        if (field != null) {
            hdr = field.getHeader();
            if (hdr != null && hdr.length() > 0) {
                if (field.getDescription().length() != 0) {
                    desc = field.getDescription();
                }
                if (field.getHelp().length() != 0) {
                    help = field.getHelp();
                }
            }
        } else {
            otherContent = Msg.getMsg((Properties)Env.getCtx(), (String)"PlaceCursorIntoField");
        }
        this.renderToolTip(hdr, desc, help, otherContent);
    }

    public void renderToolTip(String hdr, String desc, String help, String otherContent) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n<body>\n<div class=\"help-content\">\n");
        if (hdr == null || hdr.trim().length() == 0) {
            if (otherContent == null) {
                otherContent = Msg.getMsg((Properties)Env.getCtx(), (String)"PlaceCursorIntoField");
            }
            sb.append("<i>(");
            sb.append(otherContent);
            sb.append(")</i>");
        } else {
            sb.append("<b>");
            sb.append(hdr);
            sb.append("</b>");
            if (desc != null && desc.trim().length() > 0) {
                sb.append("<br><br>\n<i>");
                sb.append(desc);
                sb.append("</i>");
            }
            if (help != null && help.trim().length() > 0) {
                sb.append("<br><br>\n");
                sb.append(help);
            }
        }
        sb.append("</div>\n</body>\n</html>");
        this.htmlToolTip.setContent(sb.toString());
    }

    public void renderCtxHelp(String ctxType, int recordId) {
        if (ctxType != "H" && ctxType != "T" && ctxType != "P" && ctxType != "F" && ctxType != "I" && ctxType != "W" && ctxType != "K" && ctxType != "N") {
            ctxType = "H";
        }
        if (recordId == 0) {
            ctxType = "H";
        }
        this.pnlToolTip.setVisible(ctxType.equals("T") || ctxType.equals("P") || ctxType.equals("I"));
        this.pnlContextHelp.setTitle(ctxType.equals("H") ? Msg.getMsg((Properties)Env.getCtx(), (String)"GettingStarted") : Msg.getMsg((Properties)Env.getCtx(), (String)"HowTo"));
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"help-content\">\n");
        MCtxHelpMsg ctxHelpMsg = this.getCtxHelpMsg(ctxType, recordId);
        Component previousPopup = (Component)this.pnlContextHelp.removeAttribute("contextMenu");
        if (previousPopup != null) {
            previousPopup.detach();
        }
        this.pnlContextHelp.setContext(null);
        if (ctxHelpMsg != null) {
            sb.append(String.valueOf(this.stripHtml(ctxHelpMsg.get_Translation("MsgText"), false)) + "<br>\n");
            ContextHelpMenupopup popup = new ContextHelpMenupopup(ctxHelpMsg);
            this.pnlContextHelp.setAttribute("contextMenu", (Object)popup);
            this.pnlContextHelp.setContext((Popup)popup);
            popup.setPage(this.pnlContextHelp.getPage());
        } else {
            StringBuilder baseContent = new StringBuilder();
            StringBuilder translatedContent = new StringBuilder();
            ContextHelpMenupopup popup = null;
            if (ctxType.equals("T")) {
                MTab tab = new MTab(Env.getCtx(), recordId, null);
                if (!Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Tab")) {
                    String helpMsg;
                    String descMsg;
                    String nameMsg = tab.get_Translation("Name", false);
                    if (tab != null && nameMsg != null && nameMsg.length() != 0) {
                        translatedContent.append("<p><strong>" + nameMsg + "</strong></p>\n");
                    }
                    if ((descMsg = tab.get_Translation("Description", false)) != null && descMsg.length() != 0) {
                        translatedContent.append("<p><em>" + descMsg + "</em></p>\n");
                    }
                    if ((helpMsg = tab.get_Translation("Help", false)) != null && helpMsg.length() != 0) {
                        translatedContent.append("<p>" + helpMsg + "</p>\n");
                    }
                    if (translatedContent.length() > 0) {
                        translatedContent.insert(0, "<p>\n");
                        translatedContent.append("</p>");
                    }
                }
                if (tab != null && tab.getName() != null && tab.getName().length() != 0) {
                    baseContent.append("<p><strong>" + tab.getName() + "</strong></p>\n");
                }
                if (tab.getDescription() != null && tab.getDescription().length() != 0) {
                    baseContent.append("<p><em>" + tab.getDescription() + "</em></p>\n");
                }
                if (tab.getHelp() != null && tab.getHelp().length() != 0) {
                    baseContent.append("<p>" + tab.getHelp() + "</p>\n");
                }
                if (baseContent.length() > 0) {
                    baseContent.insert(0, "<p>\n");
                    baseContent.append("</p>");
                }
                sb.append(Util.isEmpty((String)translatedContent.toString()) ? baseContent.toString() : translatedContent.toString());
                popup = new ContextHelpMenupopup((PO)tab, baseContent.toString(), translatedContent.toString());
                this.pnlContextHelp.setAttribute("contextMenu", (Object)popup);
                this.pnlContextHelp.setContext((Popup)popup);
                popup.setPage(this.pnlContextHelp.getPage());
            } else if (ctxType.equals("P")) {
                MProcess process = MProcess.get((Properties)Env.getCtx(), (int)recordId);
                if (!Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Process")) {
                    String helpMsg;
                    String descMsg;
                    String nameMsg = process.get_Translation("Name", false);
                    if (process != null && nameMsg != null && nameMsg.length() != 0) {
                        translatedContent.append("<p><strong>" + nameMsg + "</strong></p>\n");
                    }
                    if ((descMsg = process.get_Translation("Description", false)) != null && descMsg.length() != 0) {
                        translatedContent.append("<p><em>" + descMsg + "</em></p>\n");
                    }
                    if ((helpMsg = process.get_Translation("Help", false)) != null && helpMsg.length() != 0) {
                        translatedContent.append("<p>" + helpMsg + "</p>\n");
                    }
                    if (translatedContent.length() > 0) {
                        translatedContent.insert(0, "<p>\n");
                        translatedContent.append("</p>");
                    }
                }
                if (process != null && process.getName() != null && process.getName().length() != 0) {
                    baseContent.append("<p><strong>" + process.getName() + "</strong></p>\n");
                }
                if (process.getDescription() != null && process.getDescription().length() != 0) {
                    baseContent.append("<p><em>" + process.getDescription() + "</em></p>\n");
                }
                if (process.getHelp() != null && process.getHelp().length() != 0) {
                    baseContent.append("<p>" + process.getHelp() + "</p>\n");
                }
                if (baseContent.length() > 0) {
                    baseContent.insert(0, "<p>\n");
                    baseContent.append("</p>");
                }
                sb.append(Util.isEmpty((String)translatedContent.toString()) ? baseContent.toString() : translatedContent.toString());
                popup = new ContextHelpMenupopup((PO)process, baseContent.toString(), translatedContent.toString());
                this.pnlContextHelp.setAttribute("contextMenu", (Object)popup);
                this.pnlContextHelp.setContext((Popup)popup);
                popup.setPage(this.pnlContextHelp.getPage());
            } else if (ctxType.equals("F")) {
                MForm form = new MForm(Env.getCtx(), recordId, null);
                if (!Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Form")) {
                    String helpMsg;
                    String descMsg;
                    String nameMsg = form.get_Translation("Name", false);
                    if (form != null && nameMsg != null && nameMsg.length() != 0) {
                        translatedContent.append("<p><strong>" + nameMsg + "</strong></p>\n");
                    }
                    if ((descMsg = form.get_Translation("Description", false)) != null && descMsg.length() != 0) {
                        translatedContent.append("<p><em>" + descMsg + "</em></p>\n");
                    }
                    if ((helpMsg = form.get_Translation("Help", false)) != null && helpMsg.length() != 0) {
                        translatedContent.append("<p>" + helpMsg + "</p>\n");
                    }
                    if (translatedContent.length() > 0) {
                        translatedContent.insert(0, "<p>\n");
                        translatedContent.append("</p>");
                    }
                }
                if (form != null && form.getName() != null && form.getName().length() != 0) {
                    baseContent.append("<p><strong>" + form.getName() + "</strong></p>\n");
                }
                if (form.getDescription() != null && form.getDescription().length() != 0) {
                    baseContent.append("<p><em>" + form.getDescription() + "</em></p>\n");
                }
                if (form.getHelp() != null && form.getHelp().length() != 0) {
                    baseContent.append("<p>" + form.getHelp() + "</p>\n");
                }
                if (baseContent.length() > 0) {
                    baseContent.insert(0, "<p>\n");
                    baseContent.append("</p>");
                }
                sb.append(Util.isEmpty((String)translatedContent.toString()) ? baseContent.toString() : translatedContent.toString());
                popup = new ContextHelpMenupopup((PO)form, baseContent.toString(), translatedContent.toString());
                this.pnlContextHelp.setAttribute("contextMenu", (Object)popup);
                this.pnlContextHelp.setContext((Popup)popup);
                popup.setPage(this.pnlContextHelp.getPage());
            } else if (ctxType.equals("I")) {
                MInfoWindow info = new MInfoWindow(Env.getCtx(), recordId, null);
                if (!Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_InfoWindow")) {
                    String helpMsg;
                    String descMsg;
                    String nameMsg = info.get_Translation("Name", false);
                    if (info != null && nameMsg != null && nameMsg.length() != 0) {
                        translatedContent.append("<p><strong>" + nameMsg + "</strong></p>\n");
                    }
                    if ((descMsg = info.get_Translation("Description", false)) != null && descMsg.length() != 0) {
                        translatedContent.append("<p><em>" + descMsg + "</em></p>\n");
                    }
                    if ((helpMsg = info.get_Translation("Help", false)) != null && helpMsg.length() != 0) {
                        translatedContent.append("<p>" + helpMsg + "</p>\n");
                    }
                    if (translatedContent.length() > 0) {
                        translatedContent.insert(0, "<p>\n");
                        translatedContent.append("</p>");
                    }
                }
                if (info != null && info.getName() != null && info.getName().length() != 0) {
                    baseContent.append("<p><strong>" + info.getName() + "</strong></p>\n");
                }
                if (info.getDescription() != null && info.getDescription().length() != 0) {
                    baseContent.append("<p><em>" + info.getDescription() + "</em></p>\n");
                }
                if (info.getHelp() != null && info.getHelp().length() != 0) {
                    baseContent.append("<p>" + info.getHelp() + "</p>\n");
                }
                if (baseContent.length() > 0) {
                    baseContent.insert(0, "<p>\n");
                    baseContent.append("</p>");
                }
                sb.append(Util.isEmpty((String)translatedContent.toString()) ? baseContent.toString() : translatedContent.toString());
                popup = new ContextHelpMenupopup((PO)info, baseContent.toString(), translatedContent.toString());
                this.pnlContextHelp.setAttribute("contextMenu", (Object)popup);
                this.pnlContextHelp.setContext((Popup)popup);
                popup.setPage(this.pnlContextHelp.getPage());
            } else if (ctxType.equals("W")) {
                MWorkflow workflow = MWorkflow.get((Properties)Env.getCtx(), (int)recordId);
                if (!Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Workflow")) {
                    String helpMsg;
                    String descMsg;
                    String nameMsg = workflow.get_Translation("Name", false);
                    if (workflow != null && nameMsg != null && nameMsg.length() != 0) {
                        translatedContent.append("<p><strong>" + nameMsg + "</strong></p>\n");
                    }
                    if ((descMsg = workflow.get_Translation("Description", false)) != null && descMsg.length() != 0) {
                        translatedContent.append("<p><em>" + descMsg + "</em></p>\n");
                    }
                    if ((helpMsg = workflow.get_Translation("Help", false)) != null && helpMsg.length() != 0) {
                        translatedContent.append("<p>" + helpMsg + "</p>\n");
                    }
                    if (translatedContent.length() > 0) {
                        translatedContent.insert(0, "<p>\n");
                        translatedContent.append("</p>");
                    }
                }
                if (workflow != null && workflow.getName() != null && workflow.getName().length() != 0) {
                    baseContent.append("<p><strong>" + workflow.getName() + "</strong></p>\n");
                }
                if (workflow.getDescription() != null && workflow.getDescription().length() != 0) {
                    baseContent.append("<p><em>" + workflow.getDescription() + "</em></p>\n");
                }
                if (workflow.getHelp() != null && workflow.getHelp().length() != 0) {
                    baseContent.append("<p>" + workflow.getHelp() + "</p>\n");
                }
                if (baseContent.length() > 0) {
                    baseContent.insert(0, "<p>\n");
                    baseContent.append("</p>");
                }
                sb.append(Util.isEmpty((String)translatedContent.toString()) ? baseContent.toString() : translatedContent.toString());
                popup = new ContextHelpMenupopup((PO)workflow, baseContent.toString(), translatedContent.toString());
                this.pnlContextHelp.setAttribute("contextMenu", (Object)popup);
                this.pnlContextHelp.setContext((Popup)popup);
                popup.setPage(this.pnlContextHelp.getPage());
            } else if (ctxType.equals("K")) {
                MTask task = new MTask(Env.getCtx(), recordId, null);
                if (!Env.getLoginLanguage((Properties)Env.getCtx()).isBaseLanguage()) {
                    String helpMsg;
                    String descMsg;
                    String nameMsg = task.get_Translation("Name", false);
                    if (task != null && nameMsg != null && nameMsg.length() != 0) {
                        translatedContent.append("<p><strong>" + nameMsg + "</strong></p>\n");
                    }
                    if ((descMsg = task.get_Translation("Description", false)) != null && descMsg.length() != 0) {
                        translatedContent.append("<p><em>" + descMsg + "</em></p>\n");
                    }
                    if ((helpMsg = task.get_Translation("Help", false)) != null && helpMsg.length() != 0) {
                        translatedContent.append("<p>" + helpMsg + "</p>\n");
                    }
                    if (translatedContent.length() > 0) {
                        translatedContent.insert(0, "<p>\n");
                        translatedContent.append("</p>");
                    }
                }
                if (task != null && task.getName() != null && task.getName().length() != 0) {
                    baseContent.append("<p><strong>" + task.getName() + "</strong></p>\n");
                }
                if (task.getDescription() != null && task.getDescription().length() != 0) {
                    baseContent.append("<p><em>" + task.getDescription() + "</em></p>\n");
                }
                if (task.getHelp() != null && task.getHelp().length() != 0) {
                    baseContent.append("<p>" + task.getHelp() + "</p>\n");
                }
                if (baseContent.length() > 0) {
                    baseContent.insert(0, "<p>\n");
                    baseContent.append("</p>");
                }
                sb.append(Util.isEmpty((String)translatedContent.toString()) ? baseContent.toString() : translatedContent.toString());
                popup = new ContextHelpMenupopup((PO)task, baseContent.toString(), translatedContent.toString());
                this.pnlContextHelp.setAttribute("contextMenu", (Object)popup);
                this.pnlContextHelp.setContext((Popup)popup);
                popup.setPage(this.pnlContextHelp.getPage());
            } else if (ctxType.equals("N")) {
                MWFNode node = MWFNode.get((Properties)Env.getCtx(), (int)recordId);
                if (!Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_WF_Node")) {
                    String helpMsg;
                    String descMsg;
                    String nameMsg = node.get_Translation("Name", false);
                    if (node != null && nameMsg != null && nameMsg.length() != 0) {
                        translatedContent.append("<p><strong>" + nameMsg + "</strong></p>\n");
                    }
                    if ((descMsg = node.get_Translation("Description", false)) != null && descMsg.length() != 0) {
                        translatedContent.append("<p><em>" + descMsg + "</em></p>\n");
                    }
                    if ((helpMsg = node.get_Translation("Help", false)) != null && helpMsg.length() != 0) {
                        translatedContent.append("<p>" + helpMsg + "</p>\n");
                    }
                    if (translatedContent.length() > 0) {
                        translatedContent.insert(0, "<p>\n");
                        translatedContent.append("</p>");
                    }
                }
                if (node != null && node.getName() != null && node.getName().length() != 0) {
                    baseContent.append("<p><strong>" + node.getName() + "</strong></p>\n");
                }
                if (node.getDescription() != null && node.getDescription().length() != 0) {
                    baseContent.append("<p><em>" + node.getDescription() + "</em></p>\n");
                }
                if (node.getHelp() != null && node.getHelp().length() != 0) {
                    baseContent.append("<p>" + node.getHelp() + "</p>\n");
                }
                if (baseContent.length() > 0) {
                    baseContent.insert(0, "<p>\n");
                    baseContent.append("</p>");
                }
                sb.append(Util.isEmpty((String)translatedContent.toString()) ? baseContent.toString() : translatedContent.toString());
                popup = new ContextHelpMenupopup((PO)node, baseContent.toString(), translatedContent.toString());
                this.pnlContextHelp.setAttribute("contextMenu", (Object)popup);
                this.pnlContextHelp.setContext((Popup)popup);
                popup.setPage(this.pnlContextHelp.getPage());
            } else {
                translatedContent.append("<p><em>(" + Msg.getMsg((Properties)Env.getCtx(), (String)"NotAvailable") + ")</em></p>");
                baseContent.append("<p><em>(" + Msg.getMsg((String)Language.getBaseAD_Language(), (String)"NotAvailable") + ")</em></p>");
                sb.append(translatedContent.toString());
                popup = new ContextHelpMenupopup(null, baseContent.toString(), translatedContent.toString());
                this.pnlContextHelp.setAttribute("contextMenu", (Object)popup);
                this.pnlContextHelp.setContext((Popup)popup);
                popup.setPage(this.pnlContextHelp.getPage());
            }
        }
        sb.append("</div>");
        this.htmlContextHelp.setContent(sb.toString());
    }

    public void renderQuickInfo(GridTab gridTab) {
        if (gridTab == null) {
            this.pnlQuickInfo.setVisible(false);
        } else {
            String widget = gridTab.getStatusLinesWidget();
            if (widget == null) {
                this.pnlQuickInfo.setVisible(false);
            } else {
                this.pnlQuickInfo.setVisible(true);
                StringBuilder sb = new StringBuilder();
                sb.append("<html>\n<body>\n<div class=\"help-content\">\n");
                sb.append(widget);
                sb.append("</div>\n</body>\n</html>");
                this.htmlQuickInfo.setContent(sb.toString());
            }
        }
    }

    private String stripHtml(String htmlString, boolean all) {
        htmlString = htmlString.replace("<html>", "").replace("</html>", "").replace("<body>", "").replace("</body>", "").replace("<head>", "").replace("</head>", "");
        if (all) {
            htmlString = htmlString.replace(">", "&gt;").replace("<", "&lt;");
        }
        return htmlString;
    }

    private MCtxHelpMsg getCtxHelpMsg(String ctxType, int recordId) {
        Properties ctx = Env.getCtx();
        MCtxHelpMsg retValue = MCtxHelpMsg.get((Properties)ctx, (String)ctxType, (int)recordId);
        return retValue;
    }

    public static String escapeJavascriptContent(String content) {
        if (content == null) {
            return "function(){return '';}";
        }
        StringBuilder out = new StringBuilder("function(){return '");
        char[] chars = content.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            switch (c) {
                case '\r': {
                    out.append("");
                    break;
                }
                case '\'': {
                    out.append("\\'");
                    break;
                }
                case '\n': {
                    out.append("<br>");
                    break;
                }
                default: {
                    out.append(c);
                }
            }
            ++i;
        }
        out.append("';}");
        return out.toString();
    }

    private class ContextHelpMenupopup
    extends Menupopup
    implements EventListener<Event> {
        private static final long serialVersionUID = 5430991475805225567L;
        private MCtxHelpMsg ctxHelpMsg;
        private PO po;
        private String baseContent;
        private String translatedContent;

        private ContextHelpMenupopup(MCtxHelpMsg ctxHelpMsg) {
            this.ctxHelpMsg = ctxHelpMsg;
            this.init();
        }

        private ContextHelpMenupopup(PO po, String baseContent, String translatedContent) {
            this.po = po;
            this.baseContent = baseContent;
            this.translatedContent = translatedContent;
            this.init();
        }

        private void init() {
            Menuitem item = new Menuitem();
            if (this.ctxHelpMsg != null && this.ctxHelpMsg.getAD_Client_ID() == Env.getAD_Client_ID((Properties)Env.getCtx())) {
                item.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"edit"));
            } else {
                item.setLabel(Msg.getElement((Properties)Env.getCtx(), (String)"AD_CtxHelpSuggestion_ID"));
            }
            this.appendChild((Component)item);
            item.addEventListener("onClick", (EventListener)this);
        }

        public void onEvent(Event event) throws Exception {
            WCtxHelpSuggestion suggestion = null;
            suggestion = this.ctxHelpMsg != null ? new WCtxHelpSuggestion(this.ctxHelpMsg) : new WCtxHelpSuggestion(this.po, this.baseContent, this.translatedContent);
            suggestion.setPage(this.getPage());
            suggestion.doHighlighted();
        }
    }
}

