/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.adempiere.model.MBroadcastMessage;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.panel.HeaderPanel;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MNote;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.broadcast.IBroadcastMsgPopup;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Html;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;

public class BroadcastMessageWindow
extends Window
implements IBroadcastMsgPopup,
EventListener<Event> {
    private static final long serialVersionUID = 1849434312706721390L;
    private static CLogger log = CLogger.getCLogger(BroadcastMessageWindow.class);
    public static final int PRESSED_PREV = 1;
    public static final int PRESSED_NEXT = 2;
    public static final int UPDATE_CurrMsg = 0;
    private int currMsg = 0;
    private Label textMsgNo = null;
    private Html textMsgContent = null;
    private North north = null;
    private Div swDiv = null;
    private Div sDiv = null;
    private Button btnPrev = null;
    private Button btnNext = null;
    private Checkbox acknowledged = null;
    private ArrayList<MBroadcastMessage> mbMessages = null;
    private Hashtable<Integer, Boolean> hashMessages = new Hashtable();
    private HeaderPanel pnlHead = null;
    private boolean isTest = false;
    private boolean initialised = false;

    public BroadcastMessageWindow(HeaderPanel pnlHead) {
        this.pnlHead = pnlHead;
        this.textMsgNo = new Label();
        this.textMsgContent = new Html();
        this.textMsgContent.setStyle("color:black;");
        this.btnPrev = new Button("<");
        this.btnNext = new Button(">");
    }

    private void init() {
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"Message"));
        Borderlayout layout = new Borderlayout();
        this.appendChild((Component)layout);
        this.addEventListener("onFocus", this);
        this.initialised = true;
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "30%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "30%");
        this.setPosition("right,bottom");
        this.setBorder(true);
        this.setShadow(false);
        this.doOverlapped();
        this.setClosable(true);
        this.north = new North();
        layout.appendChild((Component)this.north);
        Center center = new Center();
        layout.appendChild((Component)center);
        Div htmlDiv = new Div();
        htmlDiv.appendChild((Component)this.textMsgContent);
        this.textMsgContent.setContent(this.mbMessages.get(0).get_Translation("BroadcastMessage"));
        htmlDiv.setFocus(true);
        htmlDiv.setStyle("display: table-cell; vertical-align: middle; text-align: center;");
        Div divAlign = new Div();
        divAlign.setStyle("color:white; position: absolute; width: 370px; height: 120px; display: table;");
        htmlDiv.setParent((Component)divAlign);
        center.appendChild((Component)divAlign);
        center.setBorder("rounded");
        center.setStyle("-moz-border-radius: 3px; -webkit-border-radius: 3px; border: 1px solid #BBBBBB; border-radius: 3px; margin-bottom:10px;");
        South south = new South();
        layout.appendChild((Component)south);
        Hbox southHLayout = new Hbox();
        south.appendChild((Component)southHLayout);
        southHLayout.setSpacing("30");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)southHLayout, "350px");
        Cell leftCell = new Cell();
        southHLayout.appendChild((Component)leftCell);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)leftCell, "1");
        leftCell.setAlign("left");
        this.swDiv = new Div();
        this.swDiv.setParent((Component)leftCell);
        this.acknowledged = new Checkbox();
        Cell rightCell = new Cell();
        southHLayout.appendChild((Component)rightCell);
        rightCell.setAlign("right");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)rightCell, "true");
        this.sDiv = new Div();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.sDiv, "70px");
        rightCell.appendChild((Component)this.sDiv);
        this.currMsg = 0;
        this.btnPrev.addEventListener("onClick", this);
        this.btnNext = new Button(">");
        this.btnNext.addEventListener("onClick", this);
        this.swDiv.appendChild((Component)this.btnPrev);
        this.swDiv.appendChild((Component)new Separator("vertical"));
        this.swDiv.appendChild((Component)this.textMsgNo);
        this.swDiv.appendChild((Component)new Separator("vertical"));
        this.swDiv.appendChild((Component)this.btnNext);
        this.textMsgNo.setStyle("font-weight:bold;");
        this.renderMsg(0);
        if (this.mbMessages.size() <= 0) {
            this.swDiv.setVisible(false);
        }
        ZKUpdateUtil.setHeight((HtmlBasedComponent)south, "22%");
        this.acknowledged.setParent((Component)rightCell);
        this.acknowledged.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Acknowledge"));
        this.acknowledged.addEventListener("onClick", this);
    }

    private void createHashTable() {
        this.hashMessages.clear();
        int i = 0;
        while (i < this.mbMessages.size()) {
            if (!this.mbMessages.get(i).getBroadcastType().equals("I")) {
                MNote note = this.getMNote(this.mbMessages.get(i));
                if (note != null) {
                    this.hashMessages.put(this.mbMessages.get(i).get_ID(), note.isProcessed());
                }
            } else {
                this.hashMessages.put(this.mbMessages.get(i).get_ID(), false);
            }
            ++i;
        }
    }

    public void prepareMessage(ArrayList<MBroadcastMessage> arrMessages) {
        this.mbMessages = arrMessages;
        this.createHashTable();
        if (!this.initialised) {
            this.init();
        }
        this.pnlHead.appendChild((Component)this);
    }

    public void appendMessage(MBroadcastMessage mbMessage, boolean isTest) {
        this.isTest = isTest;
        this.currMsg = 0;
        if (this.mbMessages != null && isTest) {
            this.mbMessages.clear();
        } else if (this.mbMessages == null) {
            this.mbMessages = new ArrayList();
        }
        this.mbMessages.add(0, mbMessage);
        if (!isTest) {
            this.createHashTable();
        }
        if (!this.initialised) {
            this.init();
        } else if (!isTest) {
            this.currMsg = 0;
            this.renderMsg(0);
        }
        this.pnlHead.appendChild((Component)this);
    }

    public void onEvent(Event event) throws Exception {
        Component comp = event.getTarget();
        int noOfMsgs = this.mbMessages.size();
        if (event.getName().equals("onClick")) {
            if (comp == this.btnPrev) {
                if (this.currMsg > 0) {
                    --this.currMsg;
                    this.renderMsg(1);
                }
            } else if (comp == this.btnNext) {
                if (this.currMsg < noOfMsgs - 1) {
                    ++this.currMsg;
                    this.renderMsg(2);
                }
            } else if (comp == this.acknowledged) {
                this.hashMessages.put(this.mbMessages.get(this.currMsg).get_ID(), this.acknowledged.isChecked());
            }
        }
    }

    public void renderMsg(int status) {
        int msgToUpdate = this.currMsg - 1;
        if (status == 2) {
            msgToUpdate = this.currMsg - 1;
        } else if (status == 1) {
            msgToUpdate = this.currMsg + 1;
        } else if (status == 0) {
            msgToUpdate = this.currMsg;
        }
        int noOfMsgs = this.mbMessages.size();
        MBroadcastMessage mbMessage = this.mbMessages.get(this.currMsg);
        String broadcastFrequency = mbMessage.getBroadcastFrequency();
        if (this.mbMessages.size() > 1) {
            this.swDiv.setVisible(true);
        } else {
            this.swDiv.setVisible(false);
        }
        if (noOfMsgs > 1) {
            this.btnNext.setEnabled(true);
            this.btnPrev.setEnabled(true);
            MBroadcastMessage prevMsg = this.mbMessages.get(msgToUpdate);
            if (prevMsg.getBroadcastFrequency().equals("J") || prevMsg.getBroadcastType().equals("I")) {
                this.hashMessages.put(prevMsg.get_ID(), true);
            }
            if (this.currMsg == 0) {
                this.btnPrev.setEnabled(false);
            } else if (this.currMsg == noOfMsgs - 1) {
                if (broadcastFrequency.equals("J") || mbMessage.getBroadcastType().equals("I")) {
                    this.hashMessages.put(mbMessage.get_ID(), true);
                }
                this.btnNext.setEnabled(false);
            }
        }
        this.textMsgNo.setValue(String.valueOf(this.currMsg + 1) + "/" + noOfMsgs);
        this.textMsgContent.setContent(mbMessage.get_Translation("BroadcastMessage"));
        if (!this.isTest && mbMessage.isLogAcknowledge()) {
            boolean ack = this.hashMessages.get(mbMessage.get_ID());
            this.acknowledged.setChecked(ack);
            this.acknowledged.setVisible(true);
        } else if (mbMessage.isLogAcknowledge()) {
            this.acknowledged.setVisible(true);
        } else if (broadcastFrequency.equals("J") || mbMessage.getBroadcastType().equals("I")) {
            this.acknowledged.setVisible(false);
            this.hashMessages.put(this.mbMessages.get(this.currMsg).get_ID(), true);
        } else {
            this.acknowledged.setVisible(false);
        }
    }

    public MNote getMNote(MBroadcastMessage mbMessage) {
        MNote note = null;
        if (!mbMessage.getBroadcastType().equals("I")) {
            String sql = "SELECT * FROM AD_Note WHERE AD_BroadcastMessage_ID = ? AND AD_User_ID = ? AND AD_Client_ID in (?, 0)";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, mbMessage.get_ID());
                    pstmt.setInt(2, Env.getAD_User_ID((Properties)Env.getCtx()));
                    pstmt.setInt(3, Env.getAD_Client_ID((Properties)Env.getCtx()));
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        note = new MNote(Env.getCtx(), rs, null);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Note for the Message Could not be retrieved ", (Throwable)e);
                    throw new DBException(e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        return note;
    }

    public void onClose() {
        super.onClose();
        if (!this.isTest) {
            if (this.mbMessages.size() == 1 && (this.mbMessages.get(0).getBroadcastFrequency().equals("J") || this.mbMessages.get(0).getBroadcastFrequency().equals("E") || this.mbMessages.get(0).getBroadcastType().equals("I"))) {
                this.hashMessages.put(this.mbMessages.get(0).get_ID(), true);
            }
            ArrayList<MBroadcastMessage> acknowedgedMsgs = new ArrayList<MBroadcastMessage>();
            for (MBroadcastMessage mbMessage : this.mbMessages) {
                if (!mbMessage.getBroadcastType().equals("I")) {
                    MNote note = this.getMNote(mbMessage);
                    if (mbMessage.getBroadcastFrequency().equals("E")) {
                        note.setProcessed(true);
                    } else {
                        note.setProcessed(this.hashMessages.get(mbMessage.get_ID()).booleanValue());
                    }
                    if (this.hashMessages.get(mbMessage.get_ID()).booleanValue()) {
                        acknowedgedMsgs.add(mbMessage);
                    }
                    note.saveEx();
                    continue;
                }
                acknowedgedMsgs.add(mbMessage);
            }
            for (MBroadcastMessage mBroadcastMessage : acknowedgedMsgs) {
                this.mbMessages.remove(mBroadcastMessage);
            }
        }
    }
}

