/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.adempiere.util.Callback;
import org.adempiere.webui.adwindow.ADTabpanel;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.exception.ApplicationException;
import org.adempiere.webui.panel.TreeSearchPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MMenu;
import org.compiere.model.MQuery;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zul.A;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treecol;
import org.zkoss.zul.Treecols;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;

public abstract class AbstractMenuPanel
extends Panel
implements EventListener<Event> {
    private static final long serialVersionUID = -6160708371157917922L;
    public static final String MENU_ITEM_SELECTED_QUEUE = "MENU_ITEM_SELECTED_QUEUE";
    private Properties ctx;
    private Tree menuTree;
    private EventListener<Event> listener;

    public AbstractMenuPanel(Component parent) {
        if (parent != null) {
            this.setParent(parent);
        }
        this.init();
    }

    protected void init() {
        this.ctx = Env.getCtx();
        int adRoleId = Env.getAD_Role_ID((Properties)this.ctx);
        int adTreeId = this.getTreeId(this.ctx, adRoleId);
        MTree mTree = new MTree(this.ctx, adTreeId, false, true, null);
        MTreeNode rootNode = mTree.getRoot();
        this.initComponents();
        this.initMenu(rootNode);
    }

    protected void initComponents() {
        this.setSclass("menu-panel");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this, "1");
        this.menuTree = new Tree();
        this.menuTree.setMultiple(false);
        this.menuTree.setId("mnuMain");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.menuTree, "1");
        this.menuTree.setSizedByContent(false);
        this.menuTree.setPageSize(-1);
    }

    private void initMenu(MTreeNode rootNode) {
        Treecols treeCols = new Treecols();
        Treecol treeCol = new Treecol();
        Treechildren rootTreeChildren = new Treechildren();
        treeCols.appendChild((Component)treeCol);
        this.menuTree.appendChild((Component)treeCols);
        this.menuTree.appendChild((Component)rootTreeChildren);
        this.generateMenu(rootTreeChildren, rootNode);
    }

    private int getTreeId(Properties ctx, int adRoleId) {
        int AD_Tree_ID = DB.getSQLValue(null, (String)"SELECT COALESCE(r.AD_Tree_Menu_ID, ci.AD_Tree_Menu_ID)FROM AD_ClientInfo ci INNER JOIN AD_Role r ON (ci.AD_Client_ID=r.AD_Client_ID) WHERE AD_Role_ID=?", (int)adRoleId);
        if (AD_Tree_ID <= 0) {
            AD_Tree_ID = 10;
        }
        return AD_Tree_ID;
    }

    private void generateMenu(Treechildren treeChildren, MTreeNode mNode) {
        Enumeration nodeEnum = mNode.children();
        while (nodeEnum.hasMoreElements()) {
            MTreeNode mChildNode = (MTreeNode)nodeEnum.nextElement();
            Treeitem treeitem = new Treeitem();
            treeChildren.appendChild((Component)treeitem);
            treeitem.setTooltiptext(mChildNode.getDescription());
            if (mChildNode.getChildCount() != 0) {
                treeitem.setOpen(false);
                treeitem.setLabel(mChildNode.getName());
                Treecell cell = (Treecell)treeitem.getTreerow().getFirstChild();
                cell.setSclass("menu-treecell-cnt");
                Treechildren treeItemChildren = new Treechildren();
                treeitem.appendChild((Component)treeItemChildren);
                this.generateMenu(treeItemChildren, mChildNode);
                if (treeItemChildren.getChildren().size() == 0) {
                    treeItemChildren.detach();
                }
                treeitem.getTreerow().addEventListener("onClick", (EventListener)this);
                continue;
            }
            treeitem.setValue((Object)String.valueOf(mChildNode.getNode_ID()));
            Treerow treeRow = new Treerow();
            treeitem.appendChild((Component)treeRow);
            Treecell treeCell = new Treecell();
            treeCell.setSclass("menu-treecell-cnt");
            treeRow.appendChild((Component)treeCell);
            A link = new A();
            treeCell.appendChild((Component)link);
            if (mChildNode.isReport()) {
                if (ThemeManager.isUseFontIconForImage()) {
                    link.setIconSclass("z-icon-Report");
                } else {
                    link.setImage(ThemeManager.getThemeResource("images/mReport.png"));
                }
                treeitem.setAttribute("menu.type", (Object)"report");
            } else if (mChildNode.isProcess() || mChildNode.isTask()) {
                if (ThemeManager.isUseFontIconForImage()) {
                    link.setIconSclass("z-icon-Process");
                } else {
                    link.setImage(ThemeManager.getThemeResource("images/mProcess.png"));
                }
                treeitem.setAttribute("menu.type", (Object)"process");
            } else if (mChildNode.isWorkFlow()) {
                if (ThemeManager.isUseFontIconForImage()) {
                    link.setIconSclass("z-icon-Workflow");
                } else {
                    link.setImage(ThemeManager.getThemeResource("images/mWorkFlow.png"));
                }
                treeitem.setAttribute("menu.type", (Object)"workflow");
            } else if (mChildNode.isForm()) {
                if (ThemeManager.isUseFontIconForImage()) {
                    link.setIconSclass("z-icon-Form");
                } else {
                    link.setImage(ThemeManager.getThemeResource("images/mForm.png"));
                }
                treeitem.setAttribute("menu.type", (Object)"form");
            } else if (mChildNode.isInfo()) {
                if (ThemeManager.isUseFontIconForImage()) {
                    link.setIconSclass("z-icon-Info");
                } else {
                    link.setImage(ThemeManager.getThemeResource("images/mInfo.png"));
                }
                treeitem.setAttribute("menu.type", (Object)"info");
            } else {
                if (ThemeManager.isUseFontIconForImage()) {
                    link.setIconSclass("z-icon-Window");
                } else {
                    link.setImage(ThemeManager.getThemeResource("images/mWindow.png"));
                }
                treeitem.setAttribute("menu.type", (Object)"window");
                Toolbarbutton newBtn = this.createNewButton();
                treeCell.appendChild((Component)newBtn);
                newBtn.addEventListener("onClick", (EventListener)this);
            }
            link.setLabel(mChildNode.getName());
            link.addEventListener("onClick", (EventListener)this);
            link.setSclass("menu-href");
            treeitem.getTreerow().setDraggable("favourite");
            treeitem.setAttribute("MTreeNode", (Object)mChildNode);
        }
    }

    public Toolbarbutton createNewButton() {
        Toolbarbutton newBtn = new Toolbarbutton(null, ThemeManager.getThemeResource("images/New10.png"));
        if (ThemeManager.isUseFontIconForImage()) {
            newBtn.setImage(null);
            newBtn.setIconSclass("z-icon-New");
        }
        newBtn.setSclass("menu-href-newbtn");
        return newBtn;
    }

    public void onEvent(Event event) {
        Component comp = event.getTarget();
        String eventName = event.getName();
        if (eventName.equals("onClick")) {
            this.doOnClick(comp, event.getData());
        }
    }

    private void doOnClick(Component comp, Object eventData) {
        boolean newRecord = false;
        if (comp instanceof A) {
            comp = comp.getParent().getParent();
        }
        if (comp instanceof Toolbarbutton) {
            comp = comp.getParent().getParent();
            newRecord = true;
        } else if (eventData != null && eventData instanceof Boolean) {
            newRecord = (Boolean)eventData;
        }
        if (comp instanceof Treerow) {
            Treeitem selectedItem = (Treeitem)comp.getParent();
            if (selectedItem.getValue() != null) {
                if (newRecord) {
                    this.onNewRecord(selectedItem);
                } else {
                    this.fireMenuSelectedEvent(selectedItem);
                }
            } else {
                selectedItem.setOpen(!selectedItem.isOpen());
            }
            selectedItem.setSelected(true);
            EventQueues.lookup((String)MENU_ITEM_SELECTED_QUEUE, (String)"desktop", (boolean)true).publish(new Event("onSelect", null, (Object)selectedItem));
        }
    }

    private void onNewRecord(Treeitem selectedItem) {
        try {
            int menuId = Integer.parseInt((String)selectedItem.getValue());
            MMenu menu = new MMenu(Env.getCtx(), menuId, null);
            MQuery query = new MQuery("");
            query.addRestriction("1=2");
            query.setRecordCount(0);
            if (this.getParent() instanceof Popup) {
                ((Popup)this.getParent()).close();
            }
            SessionManager.getAppDesktop().openWindow(menu.getAD_Window_ID(), query, new Callback<ADWindow>(){

                public void onCallback(ADWindow result) {
                    if (result == null) {
                        return;
                    }
                    result.getADWindowContent().onNew();
                    ADTabpanel adtabpanel = (ADTabpanel)result.getADWindowContent().getADTab().getSelectedTabpanel();
                    adtabpanel.focusToFirstEditor(false);
                }
            });
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    protected void fireMenuSelectedEvent(Treeitem selectedItem) {
        int nodeId = Integer.parseInt((String)selectedItem.getValue());
        try {
            if (this.getParent() instanceof Popup) {
                ((Popup)this.getParent()).close();
            }
            SessionManager.getAppDesktop().onMenuSelected(nodeId);
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    public Tree getMenuTree() {
        return this.menuTree;
    }

    public Properties getCtx() {
        return this.ctx;
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this.listener != null) {
            try {
                EventQueue queue = EventQueues.lookup((String)MENU_ITEM_SELECTED_QUEUE, (String)"desktop", (boolean)true);
                if (queue != null) {
                    queue.unsubscribe(this.listener);
                }
            }
            finally {
                this.listener = null;
            }
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (this.listener == null) {
            this.listener = new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    block6: {
                        Treeitem selectedItem;
                        if (event.getName() != "onSelect" || (selectedItem = (Treeitem)event.getData()) == null) break block6;
                        Object value = selectedItem.getValue();
                        if (value != null) {
                            if (AbstractMenuPanel.this.menuTree.getSelectedItem() != null && AbstractMenuPanel.this.menuTree.getSelectedItem().getValue() != null && AbstractMenuPanel.this.menuTree.getSelectedItem().getValue().equals(value)) {
                                return;
                            }
                            Collection items = AbstractMenuPanel.this.menuTree.getItems();
                            for (Treeitem item : items) {
                                if (item == null || item.getValue() == null || !item.getValue().equals(value)) continue;
                                TreeSearchPanel.select(item);
                                return;
                            }
                        } else {
                            String label = selectedItem.getLabel();
                            if (AbstractMenuPanel.this.menuTree.getSelectedItem() != null && AbstractMenuPanel.this.menuTree.getSelectedItem().getLabel() != null && AbstractMenuPanel.this.menuTree.getSelectedItem().getLabel().equals(label)) {
                                return;
                            }
                            Collection items = AbstractMenuPanel.this.menuTree.getItems();
                            for (Treeitem item : items) {
                                if (item == null || item.getLabel() == null || !item.getLabel().equals(label)) continue;
                                TreeSearchPanel.select(item);
                                return;
                            }
                        }
                    }
                }
            };
        }
        EventQueues.lookup((String)MENU_ITEM_SELECTED_QUEUE, (String)"desktop", (boolean)true).subscribe(this.listener);
    }
}

