/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.logging.Level;
import org.adempiere.webui.Extensions;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.exception.ApplicationException;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.GridTab;
import org.compiere.model.MForm;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Window;

public abstract class ADForm
extends Window
implements EventListener<Event>,
IHelpContext {
    private static final long serialVersionUID = -5183711788893823434L;
    protected static final CLogger logger = CLogger.getCLogger(ADForm.class);
    private int m_adFormId;
    protected int m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
    private String m_name;
    private ProcessInfo m_pi;
    private IFormController m_customForm;
    private GridTab gridTab;

    protected ADForm() {
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "99%");
        this.setStyle("position:relative");
        this.setContentSclass("adform-content");
    }

    public int getWindowNo() {
        return this.m_WindowNo;
    }

    protected int getAdFormId() {
        return this.m_adFormId;
    }

    protected void init(int adFormId, String name) {
        if (adFormId <= 0) {
            throw new IllegalArgumentException("Form Id is invalid");
        }
        this.m_adFormId = adFormId;
        this.setTitle(name);
        this.m_name = name;
        this.initForm();
        this.addEventListener("onWindowContainerSelectionChanged", this);
    }

    protected abstract void initForm();

    public String getFormName() {
        return this.m_name;
    }

    public static ADForm openForm(int adFormID) {
        return ADForm.openForm(adFormID, null);
    }

    public static ADForm openForm(int adFormID, GridTab gridTab) {
        ADForm form;
        MForm mform = new MForm(Env.getCtx(), adFormID, null);
        String formName = mform.getClassname();
        String name = mform.get_Translation("Name");
        if (mform.get_ID() == 0 || formName == null) {
            throw new ApplicationException("There is no form associated with the specified selection");
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("AD_Form_ID=" + adFormID + " - Class=" + formName);
        }
        if ((form = Extensions.getForm(formName)) != null) {
            form.gridTab = gridTab;
            form.init(adFormID, name);
            return form;
        }
        throw new ApplicationException("Failed to open " + formName);
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equals("onWindowContainerSelectionChanged")) {
            SessionManager.getAppDesktop().updateHelpContext("F", this.getAdFormId());
        }
    }

    public void setProcessInfo(ProcessInfo pi) {
        this.m_pi = pi;
    }

    public ProcessInfo getProcessInfo() {
        return this.m_pi;
    }

    public void setICustomForm(IFormController customForm) {
        this.m_customForm = customForm;
    }

    public IFormController getICustomForm() {
        return this.m_customForm;
    }

    public Window.Mode getWindowMode() {
        return Window.Mode.EMBEDDED;
    }

    public GridTab getGridTab() {
        return this.gridTab;
    }
}

