/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.install;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.AdempiereWebUI;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.FolderBrowser;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ReaderInputStream;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.adempiere.webui.window.MultiFileDownloadDialog;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Zip;
import org.compiere.install.Translation;
import org.compiere.install.TranslationController;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.South;

public class WTranslationDialog
extends TranslationController
implements IFormController,
EventListener<Event> {
    private CustomForm form = new CustomForm();
    private Panel centerPanel = new Panel();
    private Grid centerLayout = GridFactory.newGridLayout();
    private Button bExport = new Button();
    private Button bImport = new Button();
    private Button bExportZIP = new Button();
    private Button bImportZIP = new Button();
    private Label lClient = new Label();
    private Listbox cbClient = ListboxFactory.newDropdownListbox();
    private Label lLanguage = new Label();
    private Listbox cbLanguage = ListboxFactory.newDropdownListbox();
    private Label lTable = new Label();
    private Listbox cbTable = ListboxFactory.newDropdownListbox();
    private StatusBarPanel statusBar = new StatusBarPanel();
    private ValueNamePair m_AD_Table;
    private int m_AD_Client_ID;
    private boolean m_imp;
    private ValueNamePair m_AD_Language;
    private Checkbox isOnlyCentralized = new Checkbox();

    public WTranslationDialog() {
        this.m_WindowNo = this.form.getWindowNo();
        Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"IsSOTrx", (String)"Y");
        try {
            this.zkInit();
            this.dynInit();
            Borderlayout contentLayout = new Borderlayout();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)contentLayout, "100%");
            ZKUpdateUtil.setHeight((HtmlBasedComponent)contentLayout, "100%");
            this.form.appendChild((Component)contentLayout);
            Center center = new Center();
            contentLayout.appendChild((Component)center);
            center.appendChild((Component)this.centerPanel);
            South south = new South();
            south.setStyle("border: none");
            contentLayout.appendChild((Component)south);
            south.appendChild((Component)this.statusBar);
            LayoutUtils.addSclass("status-border", (HtmlBasedComponent)this.statusBar);
            ZKUpdateUtil.setHeight((HtmlBasedComponent)south, "22px");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void zkInit() throws Exception {
        this.centerPanel.appendChild((Component)this.centerLayout);
        this.lClient.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Client_ID"));
        this.lLanguage.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Language"));
        this.lLanguage.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"IsSystemLanguage"));
        this.lTable.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Table_ID"));
        this.bExport.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Export"));
        this.bExport.addActionListener(this);
        this.bExport.setStyle("text-align: right;");
        this.bImport.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Import"));
        this.bImport.addActionListener(this);
        this.bExportZIP.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"ExportZIP"));
        this.bExportZIP.addActionListener(this);
        this.bImportZIP.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"ImportZIP"));
        this.bImportZIP.setUpload(AdempiereWebUI.getUploadSetting());
        this.bImportZIP.addEventListener("onUpload", this);
        this.isOnlyCentralized.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"OnlyCentralizedData"));
        this.isOnlyCentralized.setChecked(true);
        Rows rows = this.centerLayout.newRows();
        Row row = rows.newRow();
        row.appendChild(this.lClient.rightAlign());
        row.appendChild((Component)this.cbClient);
        row = rows.newRow();
        row.appendChild(this.lLanguage.rightAlign());
        row.appendChild((Component)this.cbLanguage);
        row = rows.newRow();
        row.appendChild(this.lTable.rightAlign());
        row.appendChild((Component)this.cbTable);
        row = rows.newRow();
        row.appendChild((Component)new Label(""));
        row.appendChild((Component)this.isOnlyCentralized);
        row = rows.newRow();
        Div div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.bExport);
        row.appendChild((Component)div);
        div = new Div();
        div.setStyle("text-align: left;");
        div.appendChild((Component)this.bImport);
        row.appendChild((Component)div);
        row = rows.newRow();
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.bExportZIP);
        row.appendChild((Component)div);
        div = new Div();
        div.setStyle("text-align: left;");
        div.appendChild((Component)this.bImportZIP);
        row.appendChild((Component)div);
    }

    private void dynInit() {
        ArrayList clients = this.getClientList();
        for (KeyNamePair client : clients) {
            this.cbClient.addItem(client);
        }
        ArrayList languages = this.getLanguageList();
        for (ValueNamePair language : languages) {
            this.cbLanguage.addItem(language);
        }
        ArrayList tables = this.getTableList();
        for (ValueNamePair table2 : tables) {
            this.cbTable.addItem(table2);
        }
        this.setStatusBar(this.statusBar);
    }

    public void dispose() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }

    public void onEvent(Event e) {
        if (this.cbLanguage.getSelectedIndex() == -1) {
            this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"LanguageSetupError"), true);
            return;
        }
        this.m_AD_Language = this.cbLanguage.getSelectedItem().toValueNamePair();
        if (this.m_AD_Language == null) {
            this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"LanguageSetupError"), true);
            return;
        }
        if (this.cbTable.getSelectedIndex() == -1) {
            return;
        }
        this.m_AD_Table = this.cbTable.getSelectedItem().toValueNamePair();
        if (this.m_AD_Table == null) {
            return;
        }
        this.m_imp = e.getTarget() == this.bImport || e.getTarget() == this.bImportZIP;
        this.m_AD_Client_ID = -1;
        KeyNamePair AD_Client = null;
        if (this.cbTable.getSelectedIndex() != -1) {
            AD_Client = this.cbClient.getSelectedItem().toKeyNamePair();
        }
        if (AD_Client != null) {
            this.m_AD_Client_ID = AD_Client.getKey();
        }
        if (e instanceof UploadEvent) {
            UploadEvent ue = (UploadEvent)e;
            try {
                this.processUploadMedia(ue.getMedia());
            }
            catch (AdempiereException e1) {
                throw new RuntimeException(e1);
            }
            return;
        }
        if (e.getTarget() == this.bImport || e.getTarget() == this.bExport) {
            final FolderBrowser directoryDialog = new FolderBrowser(true);
            directoryDialog.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    WTranslationDialog.this.callImportProcess(directoryDialog.getPath());
                }
            });
        } else if (e.getTarget() == this.bExportZIP) {
            this.processExportZIP();
        }
    }

    private void callImportProcess(String directory) {
        if (directory == null) {
            return;
        }
        this.statusBar.setStatusLine(directory);
        Translation t = new Translation(Env.getCtx());
        StringBuilder msg = new StringBuilder(t.validateLanguage(this.m_AD_Language.getValue()));
        if (msg.length() > 0) {
            FDialog.error(this.m_WindowNo, (Component)this.form, "LanguageSetupError", msg.toString());
            return;
        }
        if (this.m_AD_Table.getValue().equals("")) {
            msg = new StringBuilder();
            int i = 1;
            while (i < this.cbTable.getItemCount()) {
                this.m_AD_Table = this.cbTable.getItemAtIndex(i).toValueNamePair();
                msg.append(this.m_AD_Table.getValue()).append(" ").append(this.m_imp ? t.importTrl(directory, this.m_AD_Client_ID, this.m_AD_Language.getValue(), this.m_AD_Table.getValue()) : t.exportTrl(directory, this.m_AD_Client_ID, this.m_AD_Language.getValue(), this.m_AD_Table.getValue(), this.isOnlyCentralized.isChecked())).append(" ");
                ++i;
            }
            if (msg == null || msg.length() == 0) {
                msg = new StringBuilder(this.m_imp ? "Import" : "Export").append(" Successful. [").append(directory).append("]");
            }
            this.statusBar.setStatusLine(msg.toString());
        } else {
            msg = null;
            msg = new StringBuilder(this.m_imp ? t.importTrl(directory, this.m_AD_Client_ID, this.m_AD_Language.getValue(), this.m_AD_Table.getValue()) : t.exportTrl(directory, this.m_AD_Client_ID, this.m_AD_Language.getValue(), this.m_AD_Table.getValue(), this.isOnlyCentralized.isChecked()));
            if (msg == null || msg.length() == 0) {
                msg = new StringBuilder(this.m_imp ? "Import" : "Export").append(" Successful. [").append(directory).append("]");
            }
            this.statusBar.setStatusLine(msg.toString());
        }
    }

    private void processUploadMedia(Media media) throws AdempiereException {
        if (media == null) {
            return;
        }
        InputStream istream = media.isBinary() ? media.getStreamData() : new ReaderInputStream(media.getReaderData());
        if (log.isLoggable(Level.CONFIG)) {
            log.config(media.getName());
        }
        this.unZipAndProcess(istream);
    }

    private void unZipAndProcess(InputStream istream) throws AdempiereException {
        File tempfolder;
        FileOutputStream ostream = null;
        File file = null;
        try {
            try {
                int read;
                file = File.createTempFile("trlImport", ".zip");
                ostream = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                while ((read = istream.read(buffer)) != -1) {
                    ostream.write(buffer, 0, read);
                }
            }
            catch (Throwable e) {
                throw new AdempiereException("Copy zip failed", e);
            }
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            tempfolder = File.createTempFile(this.m_AD_Language.getValue(), ".trl");
            tempfolder.delete();
            tempfolder.mkdir();
        }
        catch (IOException e1) {
            throw new AdempiereException("Problem creating temp folder", (Throwable)e1);
        }
        String suffix = "_" + this.m_AD_Language.getValue() + ".xml";
        ZipFile zipFile = null;
        boolean validfile = false;
        try {
            try {
                zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) {
                        log.warning("Imported zip must not contain folders, ignored folder" + entry.getName());
                        continue;
                    }
                    if (!entry.getName().endsWith(suffix)) {
                        log.warning("Ignored file " + entry.getName());
                        continue;
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Extracting file: " + entry.getName());
                    }
                    WTranslationDialog.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(String.valueOf(tempfolder.getPath()) + File.separator + entry.getName())));
                    validfile = true;
                }
            }
            catch (Throwable e) {
                throw new AdempiereException("Uncompress zip failed", e);
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!validfile) {
            throw new AdempiereException("ZIP file invalid, doesn't contain *" + suffix + " files");
        }
        this.callImportProcess(tempfolder.getPath());
        file.delete();
        try {
            FileUtils.deleteDirectory((File)tempfolder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    private void processExportZIP() {
        File tempfolder;
        try {
            tempfolder = File.createTempFile(this.m_AD_Language.getValue(), ".trl");
            tempfolder.delete();
            tempfolder.mkdir();
        }
        catch (IOException e1) {
            throw new AdempiereException("Problem creating temp folder", (Throwable)e1);
        }
        this.callImportProcess(tempfolder.getPath());
        File destZipFile = null;
        try {
            destZipFile = File.createTempFile(String.valueOf(this.m_AD_Language.getValue()) + "_trlExport_", ".zip");
        }
        catch (Throwable e) {
            throw new AdempiereException("Unable to create temp file", e);
        }
        destZipFile.delete();
        Zip zipper = new Zip();
        zipper.setDestFile(destZipFile);
        zipper.setBasedir(tempfolder);
        zipper.setUpdate(false);
        zipper.setCompress(true);
        zipper.setCaseSensitive(false);
        zipper.setFilesonly(true);
        zipper.setTaskName("zip");
        zipper.setTaskType("zip");
        zipper.setProject(new Project());
        zipper.setOwningTarget(new Target());
        zipper.execute();
        try {
            FileUtils.deleteDirectory((File)tempfolder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MultiFileDownloadDialog downloadDialog = new MultiFileDownloadDialog(new File[]{destZipFile});
        downloadDialog.setPage(this.getForm().getPage());
        downloadDialog.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"ExportZIP"));
        Events.postEvent((Component)downloadDialog, (Event)new Event("onShow"));
    }
}

