/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.info;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.WListItemRenderer;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.info.InfoWindow;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.EmbedWinInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Paging;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Sortable;

public class RelatedInfoWindow
implements EventListener<Event>,
Sortable<Object> {
    private static final int DEFAULT_PAGE_PRELOAD = 4;
    private EmbedWinInfo info;
    private int m_count;
    private int pageNo;
    private List<Object> cache;
    private int cacheStart;
    private int cacheEnd;
    private Object parentId;
    protected Paging paging;
    protected Map<String, WEditor> editorMap = new HashMap<String, WEditor>();
    private InfoWindow parentInfoWindow;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private ListModelTable model;
    private String m_sqlUserOrder;
    private boolean m_useDatabasePaging = false;
    private String m_infoSqlCount;
    protected int numPagePreLoad = MSysConfig.getIntValue((String)"ZK_INFO_NUM_PAGE_PRELOAD", (int)4);
    protected boolean isHasNextPage = false;
    private ColumnInfo[] columnsLayout;

    public RelatedInfoWindow(EmbedWinInfo info, InfoWindow infoWindow, Paging embeddedPaging, String infoSqlCount, ColumnInfo[] layoutEmbedded) {
        this.info = info;
        this.parentInfoWindow = infoWindow;
        this.paging = embeddedPaging;
        this.m_infoSqlCount = infoSqlCount;
        this.columnsLayout = layoutEmbedded;
    }

    public void refresh(Object id) {
        this.parentId = id;
        this.cache = null;
        this.cacheEnd = 0;
        this.cacheStart = 0;
        if (this.info.getInfowin().isLoadPageNum()) {
            this.testCount();
        } else {
            this.m_count = Integer.MAX_VALUE;
        }
        this.m_useDatabasePaging = this.m_count > 1000 || this.m_count > this.parentInfoWindow.getPageSize() * 4;
        this.renderItems();
    }

    private void testCount() {
        this.m_count = 0;
        Object linkPara = null;
        if (this.parentId != null && this.parentId instanceof IDColumn) {
            IDColumn ID = (IDColumn)this.parentId;
            linkPara = ID.getRecord_ID();
        } else if (this.parentId != null) {
            linkPara = this.parentId.toString();
        }
        if (linkPara != null) {
            this.m_count = this.info.getTypeDataOfLink().equals(String.class) ? DB.getSQLValue(null, (String)this.m_infoSqlCount, (String)((String)linkPara)) : (this.info.getTypeDataOfLink().equals(Integer.TYPE) ? DB.getSQLValue(null, (String)this.m_infoSqlCount, (int)Integer.parseInt(linkPara.toString())) : DB.getSQLValue(null, (String)this.m_infoSqlCount, (Object[])new Object[]{linkPara}));
        }
    }

    private void renderItems() {
        int pageSize = this.parentInfoWindow.getPageSize();
        WListbox contentPanel = (WListbox)this.info.getInfoTbl();
        if (this.m_count > 0) {
            if (this.m_count > pageSize && this.paging != null) {
                this.paging.setVisible(true);
                this.paging.setPageSize(pageSize);
                this.paging.setTotalSize(this.m_count);
                this.paging.setDetailed(false);
                this.paging.addEventListener("onPaging", (EventListener)this);
                List<Object> subList = this.readLine(0, pageSize);
                this.model = new ListModelTable(subList);
                this.model.setSorter(this);
                this.model.setMultiple(false);
                contentPanel.setData(this.model, null);
                this.pageNo = 0;
            } else {
                if (this.paging != null) {
                    this.paging.setTotalSize(this.m_count);
                    this.paging.setActivePage(0);
                    this.paging.setVisible(false);
                    this.pageNo = 0;
                }
                this.model = new ListModelTable(this.readLine(0, -1));
                this.model.setSorter(this);
                this.model.setMultiple(false);
                contentPanel.setData(this.model, null);
            }
        } else {
            if (this.paging != null) {
                this.paging.setTotalSize(this.m_count);
                this.paging.setActivePage(0);
                this.paging.setVisible(false);
                this.pageNo = 0;
            }
            this.model = new ListModelTable(new ArrayList());
            this.model.setMultiple(false);
            contentPanel.setData(this.model, null);
        }
        contentPanel.getParent().invalidate();
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget() == this.paging) {
            WListbox contentPanel = (WListbox)this.info.getInfoTbl();
            int pageSize = this.parentInfoWindow.getPageSize();
            int pgNo = this.paging.getActivePage();
            if (pgNo == this.paging.getPageCount() - 1 && !this.info.getInfowin().isLoadPageNum()) {
                this.testCount();
                this.paging.setTotalSize(this.m_count);
                pgNo = this.paging.getActivePage();
            }
            if (this.pageNo != pgNo) {
                contentPanel.clearSelection();
                this.pageNo = pgNo;
                int start = this.pageNo * pageSize;
                int end = this.getOverIntValue((long)start + (long)pageSize, 1);
                if (end >= this.m_count) {
                    end = this.m_count;
                }
                List<Object> subList = this.readLine(start, end);
                this.model = new ListModelTable(subList);
                this.model.setSorter(this);
                this.model.setMultiple(false);
                contentPanel.setData(this.model, null);
                contentPanel.setSelectedIndex(0);
            }
        }
    }

    protected int getCacheStart() {
        return this.cacheStart;
    }

    private void setCacheStart(int cacheStart) {
        this.cacheStart = cacheStart;
    }

    protected int getCacheEnd() {
        return this.cacheEnd;
    }

    private List<Object> getSubList(int fromIndex, int toIndex, List<Object> line) {
        if (toIndex > line.size()) {
            toIndex = line.size();
        }
        if (fromIndex >= line.size()) {
            fromIndex = line.size();
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        return line.subList(fromIndex, toIndex);
    }

    private int getOverIntValue(long overValue) {
        return this.getOverIntValue(overValue, 0);
    }

    private int getOverIntValue(long overValue, int extra) {
        if (overValue >= Integer.MAX_VALUE) {
            overValue = Integer.MAX_VALUE - extra;
        }
        return (int)overValue;
    }

    private List<Object> readLine(int start, int end) {
        block33: {
            int pageSize = this.parentInfoWindow.getPageSize();
            if (this.getCacheStart() >= 1 && this.cacheEnd > this.getCacheStart()) {
                if (this.m_useDatabasePaging) {
                    if (start + 1 >= this.getCacheStart() && end + 1 <= this.cacheEnd) {
                        return end == -1 ? this.cache : this.getSubList(start - this.getCacheStart() + 1, end - this.getCacheStart() + 1, this.cache);
                    }
                } else {
                    if (end >= this.cacheEnd || end <= 0) {
                        end = this.cacheEnd;
                    }
                    return this.getSubList(start, end, this.cache);
                }
            }
            this.setCacheStart(this.getOverIntValue((long)start + 1L - (long)(pageSize * this.numPagePreLoad)));
            if (this.getCacheStart() <= 0) {
                this.setCacheStart(1);
            }
            if (end == -1) {
                this.cacheEnd = this.m_count;
            } else {
                this.cacheEnd = this.getOverIntValue(end + 1 + pageSize * this.numPagePreLoad);
                if (this.cacheEnd > this.m_count) {
                    this.cacheEnd = this.m_count;
                }
            }
            this.cache = new ArrayList<Object>();
            CPreparedStatement m_pstmt = null;
            ResultSet m_rs = null;
            String dataSql = null;
            long startTime = System.currentTimeMillis();
            dataSql = this.info.getInfoSql();
            if (!Util.isEmpty((String)this.m_sqlUserOrder)) {
                dataSql = String.valueOf(dataSql) + this.m_sqlUserOrder;
            }
            this.isHasNextPage = false;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(dataSql);
            }
            Trx trx = null;
            try {
                try {
                    String trxName = Trx.createTrxName((String)"RelatedInfoLoad:");
                    trx = Trx.get((String)trxName, (boolean)true);
                    trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_readLine");
                    m_pstmt = DB.prepareStatement((String)dataSql, (String)trxName);
                    Object linkPara = null;
                    if (this.parentId != null && this.parentId instanceof IDColumn) {
                        IDColumn ID = (IDColumn)this.parentId;
                        linkPara = ID.getRecord_ID();
                    } else if (this.parentId != null) {
                        linkPara = this.parentId.toString();
                    }
                    if (this.info.getTypeDataOfLink().equals(String.class)) {
                        m_pstmt.setString(1, (String)linkPara);
                    } else if (this.info.getTypeDataOfLink().equals(Integer.TYPE)) {
                        m_pstmt.setInt(1, Integer.parseInt(linkPara.toString()));
                    } else {
                        m_pstmt.setObject(1, linkPara);
                    }
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Start query - " + (System.currentTimeMillis() - startTime) + "ms");
                    }
                    m_pstmt.setFetchSize(100);
                    m_rs = m_pstmt.executeQuery();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("End query - " + (System.currentTimeMillis() - startTime) + "ms");
                    }
                    if (end > start && this.m_useDatabasePaging && !DB.getDatabase().isPagingSupported()) {
                        int i = 0;
                        while (i < this.getCacheStart() - 1) {
                            if (!m_rs.next()) break;
                            ++i;
                        }
                    }
                    int rowPointer = this.getCacheStart() - 1;
                    while (m_rs.next()) {
                        this.cache.add(this.readData(m_rs));
                        if (!this.m_useDatabasePaging || ++rowPointer < this.cacheEnd) continue;
                        this.isHasNextPage = true;
                        break;
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, dataSql, (Throwable)e);
                    DB.close(m_rs, m_pstmt);
                    if (trx != null) {
                        trx.close();
                    }
                    break block33;
                }
            }
            catch (Throwable throwable) {
                DB.close(m_rs, m_pstmt);
                if (trx != null) {
                    trx.close();
                }
                throw throwable;
            }
            DB.close((ResultSet)m_rs, (Statement)m_pstmt);
            if (trx != null) {
                trx.close();
            }
        }
        if (end > this.cacheEnd || end <= 0) {
            end = this.cacheEnd;
        }
        this.validateEndPage();
        if (end == -1) {
            return this.cache;
        }
        int fromIndex = start - this.getCacheStart() + 1;
        int toIndex = end - this.getCacheStart() + 1;
        return this.getSubList(fromIndex, toIndex, this.cache);
    }

    private ArrayList<Object> readData(ResultSet rs) throws SQLException {
        int colOffset = 1;
        ArrayList<Object> data = new ArrayList<Object>();
        int col = 0;
        while (col < this.columnsLayout.length) {
            Object value = null;
            Class c = this.columnsLayout[col].getColClass();
            int colIndex = col + colOffset;
            if (c == IDColumn.class) {
                value = new IDColumn(rs.getInt(colIndex));
            } else if (c == Boolean.class) {
                value = "Y".equals(rs.getString(colIndex));
            } else if (c == Timestamp.class) {
                value = rs.getTimestamp(colIndex);
            } else if (c == BigDecimal.class) {
                value = rs.getBigDecimal(colIndex);
            } else if (c == Double.class) {
                value = rs.getDouble(colIndex);
            } else if (c == Integer.class) {
                value = rs.getInt(colIndex);
            } else if (c == KeyNamePair.class) {
                if (this.columnsLayout[col].isKeyPairCol()) {
                    String display = rs.getString(colIndex);
                    int key = rs.getInt(colIndex + 1);
                    if (!rs.wasNull()) {
                        value = new KeyNamePair(key, display);
                    }
                    ++colOffset;
                } else {
                    int key = rs.getInt(colIndex);
                    if (!rs.wasNull()) {
                        WEditor editor = this.editorMap.get(this.columnsLayout[col].getColSQL());
                        if (editor != null) {
                            editor.setValue(key);
                            value = new KeyNamePair(key, editor.getDisplayTextForGridView(key));
                        } else {
                            value = new KeyNamePair(key, Integer.toString(key));
                        }
                    }
                }
            } else if (c == ValueNamePair.class) {
                String key = rs.getString(colIndex);
                WEditor editor = this.editorMap.get(this.columnsLayout[col].getColSQL());
                value = editor != null ? new ValueNamePair(key, editor.getDisplayTextForGridView(key)) : new ValueNamePair(key, key);
            } else {
                value = rs.getString(colIndex);
            }
            data.add(value);
            ++col;
        }
        return data;
    }

    public void sort(Comparator<Object> cmpr, boolean ascending) {
        WListItemRenderer.ColumnComparator lsc = (WListItemRenderer.ColumnComparator)cmpr;
        if (this.m_useDatabasePaging) {
            int col = lsc.getColumnIndex();
            String colsql = this.columnsLayout[col].getColSQL().trim();
            int lastSpaceIdx = colsql.lastIndexOf(" ");
            if (lastSpaceIdx > 0) {
                String tmp = colsql.substring(0, lastSpaceIdx).trim();
                char last = tmp.charAt(tmp.length() - 1);
                if (tmp.toLowerCase().endsWith("as")) {
                    colsql = colsql.substring(lastSpaceIdx).trim();
                } else if (last != '*' && last != '-' && last != '+' && last != '/' && last != '>' && last != '<' && last != '=') {
                    tmp = colsql.substring(lastSpaceIdx).trim();
                    if (tmp.startsWith("\"") && tmp.endsWith("\"")) {
                        colsql = colsql.substring(lastSpaceIdx).trim();
                    } else {
                        boolean hasAlias = true;
                        int i = 0;
                        while (i < tmp.length()) {
                            char c = tmp.charAt(i);
                            if (!Character.isLetterOrDigit(c)) {
                                hasAlias = false;
                                break;
                            }
                            ++i;
                        }
                        if (hasAlias) {
                            colsql = colsql.substring(lastSpaceIdx).trim();
                        }
                    }
                }
            }
            this.m_sqlUserOrder = " ORDER BY " + colsql;
            if (!ascending) {
                this.m_sqlUserOrder = String.valueOf(this.m_sqlUserOrder) + " DESC ";
            }
            this.refresh(this.parentId);
        } else {
            Collections.sort(this.cache, lsc);
            this.renderItems();
        }
    }

    public String getSortDirection(Comparator<Object> cmpr) {
        return "natural";
    }

    protected void validateEndPage() {
        if (this.paging == null || this.info.getInfowin().isLoadPageNum()) {
            return;
        }
        if (!this.isHasNextPage) {
            int pageSize = this.parentInfoWindow.getPageSize();
            int extraPage = this.cache.size() % pageSize > 0 ? 1 : 0;
            int pageInCache = this.cache.size() / pageSize + extraPage;
            if (pageInCache == 0 || pageInCache <= this.numPagePreLoad) {
                this.testCount();
                extraPage = this.m_count % pageSize > 0 ? 1 : 0;
                pageInCache = this.m_count / pageSize + extraPage;
                this.paging.setTotalSize(this.m_count);
                if (this.m_count <= pageSize) {
                    this.paging.setVisible(false);
                }
                PagingEvent pagingEvent = new PagingEvent("onPaging", (Component)this.paging, this.paging.getPageCount() - 1);
                Events.postEvent((Event)pagingEvent);
            } else if (pageInCache > this.numPagePreLoad) {
                int prePage = this.pageNo - this.numPagePreLoad;
                int readTotalRecord = (prePage > 0 ? prePage : 0) * pageSize + this.cache.size();
                this.paging.setTotalSize(readTotalRecord);
                this.m_count = readTotalRecord;
            }
        }
    }
}

