/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.info;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.impexp.AbstractExcelExporter;
import org.adempiere.model.IInfoColumn;
import org.adempiere.model.MInfoProcess;
import org.adempiere.model.MInfoRelated;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.ISupportMask;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.EditorBox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Menupopup;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.WInfoWindowListItemRenderer;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.grid.WQuickEntry;
import org.adempiere.webui.info.IWhereClauseEditor;
import org.adempiere.webui.info.RelatedInfoWindow;
import org.adempiere.webui.info.WInfoPAttributeEditor;
import org.adempiere.webui.panel.InfoPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.EmbedWinInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.AccessSqlParser;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridWindow;
import org.compiere.model.Lookup;
import org.compiere.model.MInfoColumn;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.event.SwipeEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Center;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.ComboitemRenderer;
import org.zkoss.zul.Div;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.LayoutRegion;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.North;
import org.zkoss.zul.Paging;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Vlayout;
import org.zkoss.zul.Window;

public class InfoWindow
extends InfoPanel
implements ValueChangeListener,
EventListener<Event> {
    private static final long serialVersionUID = 5041961608373943362L;
    protected Grid parameterGrid;
    private Borderlayout layout;
    private Vbox southBody;
    protected List<WEditor> editors;
    protected List<WEditor> identifiers;
    protected Properties infoContext;
    Tabbox embeddedPane = new Tabbox();
    ArrayList<EmbedWinInfo> embeddedWinList = new ArrayList();
    Map<Integer, RelatedInfoWindow> relatedMap = new HashMap<Integer, RelatedInfoWindow>();
    public static final int FIELDLENGTH = 20;
    protected ColumnInfo[] columnInfos;
    protected AccessSqlParser.TableInfo[] tableInfos;
    protected MInfoColumn[] infoColumns;
    protected String queryValue;
    protected WQuickEntry vqe;
    private List<GridField> gridFields;
    private Checkbox checkAND;
    private boolean hasEditable = false;
    private Map<Integer, List<Object>> cacheOriginalValues = new HashMap<Integer, List<Object>>();
    private Map<Integer, List<Object>> temporarySelectedData = new HashMap<Integer, List<Object>>();
    private WInfoWindowListItemRenderer infoWindowListItemRenderer = null;
    private Button exportButton = null;
    protected Menupopup ipMenu;
    private int noOfParameterColumn;

    public InfoWindow(int WindowNo, String tableName, String keyColumn, String queryValue, boolean multipleSelection, String whereClause, int AD_InfoWindow_ID) {
        this(WindowNo, tableName, keyColumn, queryValue, multipleSelection, whereClause, AD_InfoWindow_ID, true);
    }

    public InfoWindow(int WindowNo, String tableName, String keyColumn, String queryValue, boolean multipleSelection, String whereClause, int AD_InfoWindow_ID, boolean lookup) {
        this(WindowNo, tableName, keyColumn, queryValue, multipleSelection, whereClause, AD_InfoWindow_ID, lookup, null);
    }

    public InfoWindow(int WindowNo, String tableName, String keyColumn, String queryValue, boolean multipleSelection, String whereClause, int AD_InfoWindow_ID, boolean lookup, GridField field) {
        super(WindowNo, tableName, keyColumn, multipleSelection, whereClause, lookup, AD_InfoWindow_ID);
        this.m_gridfield = field;
        this.queryValue = queryValue;
        this.contentPanel.addActionListener(new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                SelectEvent selEvent;
                int row = -1;
                if (event instanceof SelectEvent && (selEvent = (SelectEvent)event).getReference() != null) {
                    row = ((Listitem)selEvent.getReference()).getIndex();
                }
                InfoWindow.this.updateSubcontent(row);
            }
        });
        this.infoContext = new Properties(Env.getCtx());
        this.p_loadedOK = this.loadInfoDefinition();
        if (!this.m_lookup) {
            this.initInfoProcess();
            if (this.haveProcess) {
                this.p_multipleSelection = true;
            }
        }
        this.loadInfoRelatedTabs();
        if (this.loadedOK()) {
            if (this.isLookup()) {
                Env.clearTabContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113);
            }
            this.renderWindow();
            if (queryValue != null && queryValue.trim().length() > 0) {
                this.prepareTable();
                this.processQueryValue();
            }
        }
        if (ClientInfo.isMobile()) {
            ClientInfo.onClientInfo((Component)this, this::onClientInfo);
        }
        this.initExport();
    }

    @Override
    protected void updateSubcontent(int row) {
        if (row < 0) {
            row = this.contentPanel.getSelectedRow();
        }
        if (row >= 0) {
            for (EmbedWinInfo embed : this.embeddedWinList) {
                int indexData = 0;
                if (this.columnDataIndex.containsKey(embed.getParentLinkColumnID())) {
                    indexData = this.p_layout.length + (Integer)this.columnDataIndex.get(embed.getParentLinkColumnID());
                }
                RelatedInfoWindow relatedInfoWindow = this.relatedMap.get(embed.getInfowin().getAD_InfoWindow_ID());
                relatedInfoWindow.refresh(this.contentPanel.getValueAt(row, indexData));
            }
        } else {
            for (EmbedWinInfo embed : this.embeddedWinList) {
                this.reset(embed);
            }
        }
    }

    protected void initInfoProcess() {
        MInfoProcess infoProcess;
        if (this.infoWindow == null) {
            return;
        }
        this.infoProcessList = this.infoWindow.getInfoProcess(false);
        if (this.infoProcessList.length == 0) {
            return;
        }
        this.haveProcess = true;
        MInfoProcess[] mInfoProcessArray = this.infoProcessList;
        int n = this.infoProcessList.length;
        int n2 = 0;
        while (n2 < n) {
            infoProcess = mInfoProcessArray[n2];
            if ("B".equals(infoProcess.getLayoutType())) {
                if (this.infoProcessBtList == null) {
                    this.infoProcessBtList = new ArrayList();
                }
                this.infoProcessBtList.add(infoProcess);
                MProcess process = MProcess.get((Properties)Env.getCtx(), (int)infoProcess.getAD_Process_ID());
                Button btProcess = this.confirmPanel.addProcessButton(process.get_Translation("Name"), infoProcess.getImageURL());
                if (Util.isEmpty((String)infoProcess.getImageURL(), (boolean)true)) {
                    btProcess.setImage(null);
                    btProcess.setLabel(process.get_Translation("Name"));
                }
                btProcess.setAttribute("processId", infoProcess.getAD_Process_ID());
                btProcess.addEventListener("onClick", this);
                btProcess.setAttribute("INFO_PROCESS", process);
                btProcess.addEventListener("onFocus", this);
                this.btProcessList.add(btProcess);
            }
            ++n2;
        }
        mInfoProcessArray = this.infoProcessList;
        n = this.infoProcessList.length;
        n2 = 0;
        while (n2 < n) {
            infoProcess = mInfoProcessArray[n2];
            if ("L".equals(infoProcess.getLayoutType())) {
                if (this.infoProcessDropList == null) {
                    this.infoProcessDropList = new ArrayList();
                }
                this.infoProcessDropList.add(infoProcess);
            }
            ++n2;
        }
        if (this.infoProcessDropList != null && this.infoProcessDropList.size() > 0) {
            this.cbbProcess = new Combobox();
            this.cbbProcess.setItemRenderer((ComboitemRenderer)new ComboitemRenderer<MInfoProcess>(){

                public void render(Comboitem item, MInfoProcess data, int index) {
                    MProcess process = MProcess.get((Properties)Env.getCtx(), (int)data.getAD_Process_ID());
                    item.setValue((Object)process);
                    item.setLabel(process.get_Translation("Name"));
                    if (!Util.isEmpty((String)data.getImageURL(), (boolean)true)) {
                        item.setImage(ThemeManager.getThemeResource("images/" + data.getImageURL()));
                    }
                }
            });
            this.cbbProcess.addEventListener("onSelect", this);
            this.confirmPanel.addComponentsCenter(this.cbbProcess);
            this.btCbbProcess = this.confirmPanel.addProcessButton(Msg.getMsg((Properties)Env.getCtx(), (String)"Process"), null);
            this.btCbbProcess.addEventListener("onClick", this);
        }
        mInfoProcessArray = this.infoProcessList;
        n = this.infoProcessList.length;
        n2 = 0;
        while (n2 < n) {
            infoProcess = mInfoProcessArray[n2];
            if ("M".equals(infoProcess.getLayoutType())) {
                if (this.infoProcessMenuList == null) {
                    this.infoProcessMenuList = new ArrayList();
                }
                this.infoProcessMenuList.add(infoProcess);
                if (this.ipMenu == null) {
                    this.ipMenu = new Menupopup();
                    this.ipMenu.setId("ipMenu");
                    this.confirmPanel.appendChild((Component)this.ipMenu);
                    this.btMenuProcess = this.confirmPanel.addProcessButton("ProcessMenu", null);
                    this.btMenuProcess.setPopup("ipMenu, before_start");
                }
            }
            ++n2;
        }
    }

    @Override
    protected void bindInfoProcess() {
        this.bindInfoProcessBt();
        this.bindInfoProcessDropDown();
        this.bindInfoProcessMenu();
    }

    protected void bindInfoProcessBt() {
        if (this.infoProcessBtList == null) {
            return;
        }
        block0: for (MInfoProcess infoProcessBt : this.infoProcessBtList) {
            for (Button evlBt : this.btProcessList) {
                Integer processId = (Integer)evlBt.getAttribute("processId");
                if (processId.intValue() != infoProcessBt.getAD_Process_ID()) continue;
                evlBt.setVisible(infoProcessBt.isDisplayed(this.infoContext, this.p_WindowNo));
                continue block0;
            }
        }
    }

    protected void bindInfoProcessDropDown() {
        if (this.infoProcessDropList == null || this.infoProcessDropList.size() == 0) {
            return;
        }
        ArrayList<MInfoProcess> infoProcessDropListTmp = new ArrayList<MInfoProcess>();
        for (MInfoProcess infoProcessDropDown : this.infoProcessDropList) {
            if (!infoProcessDropDown.isDisplayed(this.infoContext, this.p_WindowNo)) continue;
            infoProcessDropListTmp.add(infoProcessDropDown);
        }
        this.cbbProcess.setVisible(infoProcessDropListTmp.size() > 0);
        this.btCbbProcess.setVisible(infoProcessDropListTmp.size() > 0);
        if (infoProcessDropListTmp.size() > 0) {
            ListModelList infoProccessModel = new ListModelList(infoProcessDropListTmp);
            this.cbbProcess.setModel((ListModel)infoProccessModel);
        }
    }

    protected void bindInfoProcessMenu() {
        if (this.infoProcessMenuList == null || this.infoProcessMenuList == null) {
            return;
        }
        this.ipMenu.getChildren().clear();
        for (MInfoProcess infoProcess : this.infoProcessMenuList) {
            if (!infoProcess.isDisplayed(this.infoContext, this.p_WindowNo)) continue;
            MProcess process = MProcess.get((Properties)Env.getCtx(), (int)infoProcess.getAD_Process_ID());
            Menuitem ipMenuItem = new Menuitem();
            ipMenuItem.setLabel(process.get_Translation("Name"));
            if (!Util.isEmpty((String)infoProcess.getImageURL(), (boolean)true)) {
                ipMenuItem.setImage(ThemeManager.getThemeResource("images/" + infoProcess.getImageURL()));
            }
            ipMenuItem.setAttribute("processId", (Object)infoProcess.getAD_Process_ID());
            ipMenuItem.addEventListener("onClick", (EventListener)this);
            this.ipMenu.appendChild((Component)ipMenuItem);
        }
        this.btMenuProcess.setVisible(this.ipMenu.getChildren().size() > 0);
    }

    protected void processQueryValue() {
        String separator;
        String[] values;
        this.isQueryByUser = true;
        int i = 0;
        while (i < this.identifiers.size()) {
            WEditor editor = this.identifiers.get(i);
            try {
                editor.setValue(this.queryValue);
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "error", ex.getCause());
            }
            this.testCount(false);
            if (this.m_count > 0) break;
            editor.setValue(null);
            ++i;
        }
        boolean splitValue = false;
        if (this.m_count <= 0 && (values = this.queryValue.split("[" + (separator = MSysConfig.getValue((String)"IDENTIFIER_SEPARATOR", (String)"_", (int)Env.getAD_Client_ID((Properties)Env.getCtx()))).trim() + "]")).length == 2) {
            splitValue = true;
            int i2 = 0;
            while (i2 < values.length && i2 < this.identifiers.size()) {
                WEditor editor = this.identifiers.get(i2);
                editor.setValue(values[i2].trim());
                ++i2;
            }
            this.testCount(false);
        }
        if (this.m_count > 0) {
            this.executeQuery();
            this.renderItems();
        } else if (!splitValue) {
            this.editors.get(0).setValue(this.queryValue);
        }
        this.isQueryByUser = false;
    }

    @Override
    protected void loadInfoWindowData() {
        this.infoWindow = this.m_infoWindowID > 0 ? new MInfoWindow(Env.getCtx(), this.m_infoWindowID, null) : MInfoWindow.get((String)this.p_tableName, null);
        if (this.infoWindow == null) {
            return;
        }
        if (!this.infoWindow.isValid()) {
            this.infoWindow = null;
        } else {
            String tableName = MTable.getTableName((Properties)Env.getCtx(), (int)this.infoWindow.getAD_Table_ID());
            if (!tableName.equalsIgnoreCase(this.p_tableName)) {
                throw new IllegalArgumentException("AD_InfoWindow.TableName <> TableName argument. (" + tableName + " <> " + this.p_tableName + ")");
            }
        }
    }

    protected boolean loadInfoDefinition() {
        if (this.infoWindow != null) {
            String tableName = null;
            tableName = MTable.getTableName((Properties)Env.getCtx(), (int)this.infoWindow.getAD_Table_ID());
            AccessSqlParser sqlParser = new AccessSqlParser("SELECT * FROM " + this.infoWindow.getFromClause());
            this.tableInfos = sqlParser.getTableInfo(0);
            if (this.tableInfos[0].getSynonym() != null && this.tableInfos[0].getSynonym().trim().length() > 0) {
                this.p_tableName = this.tableInfos[0].getSynonym().trim();
                if (this.p_whereClause != null && this.p_whereClause.trim().length() > 0) {
                    this.p_whereClause = this.p_whereClause.replace(String.valueOf(tableName) + ".", String.valueOf(this.p_tableName) + ".");
                }
            }
            this.infoColumns = this.infoWindow.getInfoColumns(this.tableInfos);
            this.gridFields = new ArrayList<GridField>();
            MInfoColumn[] mInfoColumnArray = this.infoColumns;
            int n = this.infoColumns.length;
            int n2 = 0;
            while (n2 < n) {
                String desc;
                MInfoColumn infoColumn = mInfoColumnArray[n2];
                if (infoColumn.isKey()) {
                    this.keyColumnOfView = infoColumn;
                }
                String columnName = infoColumn.getColumnName();
                boolean isMandatory = !this.m_lookup && infoColumn.isMandatory() && infoColumn.isQueryCriteria();
                GridFieldVO vo = GridFieldVO.createParameter((Properties)this.infoContext, (int)this.p_WindowNo, (int)AEnv.getADWindowID(this.p_WindowNo), (int)this.infoWindow.getAD_InfoWindow_ID(), (int)0, (String)columnName, (String)infoColumn.get_Translation("Name"), (int)infoColumn.getAD_Reference_ID(), (int)infoColumn.getAD_Reference_Value_ID(), (boolean)isMandatory, (boolean)false, (String)infoColumn.get_Translation("Placeholder"));
                if (infoColumn.getAD_Val_Rule_ID() > 0) {
                    vo.ValidationCode = infoColumn.getAD_Val_Rule().getCode();
                    if (vo.lookupInfo != null) {
                        vo.lookupInfo.ValidationCode = vo.ValidationCode;
                        vo.lookupInfo.IsValidated = false;
                    }
                }
                if (infoColumn.getDisplayLogic() != null) {
                    vo.DisplayLogic = infoColumn.getDisplayLogic();
                }
                if (infoColumn.isQueryCriteria() && infoColumn.getDefaultValue() != null) {
                    vo.DefaultValue = infoColumn.getDefaultValue();
                }
                vo.Description = (desc = infoColumn.get_Translation("Description")) != null ? desc : "";
                String help = infoColumn.get_Translation("Help");
                vo.Help = help != null ? help : "";
                GridField gridField = new GridField(vo);
                this.gridFields.add(gridField);
                ++n2;
            }
            int processCount = 0;
            if (this.infoWindow != null) {
                MInfoProcess[] processes = this.infoWindow.getInfoProcess(false);
                processCount = processes.length;
            }
            if (processCount > 0) {
                MInfoColumn[] mInfoColumnArray2 = this.infoColumns;
                int n3 = this.infoColumns.length;
                n = 0;
                while (n < n3) {
                    MInfoColumn infoColumn = mInfoColumnArray2[n];
                    if (!infoColumn.isReadOnly()) {
                        this.hasEditable = true;
                        break;
                    }
                    ++n;
                }
                if (this.hasEditable) {
                    this.infoWindowListItemRenderer = new WInfoWindowListItemRenderer(this);
                    this.contentPanel.setItemRenderer(this.infoWindowListItemRenderer);
                    this.contentPanel.setAllowIDColumnForReadWrite(true);
                    this.infoWindowListItemRenderer.addTableValueChangeListener(this.contentPanel);
                }
            }
            StringBuilder builder = new StringBuilder(this.p_whereClause != null ? this.p_whereClause.trim() : "");
            String infoWhereClause = this.infoWindow.getWhereClause();
            if (infoWhereClause != null && infoWhereClause.indexOf("@") >= 0 && (infoWhereClause = Env.parseContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)infoWhereClause, (boolean)true, (boolean)false)).length() == 0) {
                this.log.log(Level.SEVERE, "Cannot parse context= " + this.infoWindow.getWhereClause());
            }
            if (infoWhereClause != null && infoWhereClause.trim().length() > 0) {
                if (builder.length() > 0) {
                    builder.append(" AND ");
                }
                builder.append(infoWhereClause);
                this.p_whereClause = builder.toString();
            }
            return true;
        }
        return false;
    }

    protected boolean loadInfoRelatedTabs() {
        if (this.infoWindow == null) {
            return false;
        }
        this.relatedInfoList = this.infoWindow.getInfoRelated(true);
        Tabpanels tabPanels = new Tabpanels();
        Tabs tabs = new Tabs();
        if (this.relatedInfoList.length > 0) {
            ZKUpdateUtil.setHeight((HtmlBasedComponent)this.embeddedPane, "100%");
            this.embeddedPane.appendChild((Component)tabPanels);
            this.embeddedPane.appendChild((Component)tabs);
        }
        MInfoRelated[] mInfoRelatedArray = this.relatedInfoList;
        int n = this.relatedInfoList.length;
        int n2 = 0;
        while (n2 < n) {
            MInfoRelated relatedInfo = mInfoRelatedArray[n2];
            String tableName = null;
            int infoRelatedID = relatedInfo.getRelatedInfo_ID();
            MInfoWindow embedInfo = new MInfoWindow(Env.getCtx(), infoRelatedID, null);
            AccessSqlParser sqlParser = new AccessSqlParser("SELECT * FROM " + embedInfo.getFromClause());
            AccessSqlParser.TableInfo[] tableInfos = sqlParser.getTableInfo(0);
            if (tableInfos[0].getSynonym() != null && tableInfos[0].getSynonym().trim().length() > 0) {
                tableName = tableInfos[0].getSynonym().trim();
            }
            WListbox embeddedTbl = new WListbox();
            if (embedInfo != null) {
                ArrayList<Object> list = new ArrayList();
                list = this.getInfoColumnslayout(embedInfo);
                ColumnInfo[] s_layoutEmbedded = new ColumnInfo[list.size()];
                list.toArray(s_layoutEmbedded);
                String s_sqlFrom = embedInfo.getFromClause();
                String s_sqlWhere = String.valueOf(relatedInfo.getLinkColumnName()) + "=?";
                String s_sqlCount = "SELECT COUNT(*) FROM " + s_sqlFrom + " WHERE " + s_sqlWhere;
                String m_sqlEmbedded = embeddedTbl.prepareTable(s_layoutEmbedded, s_sqlFrom, s_sqlWhere, false, tableName);
                embeddedTbl.setMultiSelection(false);
                embeddedTbl.autoSize();
                embeddedTbl.getModel().addTableModelListener(this);
                ZKUpdateUtil.setVflex((HtmlBasedComponent)embeddedTbl, "1");
                Paging embeddedPaging = new Paging();
                embeddedPaging.setPageSize(this.pageSize);
                embeddedPaging.setTotalSize(0);
                ZKUpdateUtil.setHflex((HtmlBasedComponent)embeddedPaging, "1");
                embeddedPaging.setMold("os");
                embeddedPaging.setVisible(false);
                embeddedPaging.setSclass("infowindow-related-paging");
                EmbedWinInfo ewinInfo = new EmbedWinInfo(embedInfo, (IMiniTable)embeddedTbl, m_sqlEmbedded, relatedInfo.getLinkColumnName(), relatedInfo.getLinkInfoColumn(), relatedInfo.getParentRelatedColumn_ID());
                this.embeddedWinList.add(ewinInfo);
                RelatedInfoWindow relatedInfoWindow = new RelatedInfoWindow(ewinInfo, this, embeddedPaging, s_sqlCount, s_layoutEmbedded);
                this.relatedMap.put(embedInfo.getAD_InfoWindow_ID(), relatedInfoWindow);
                MInfoWindow riw = (MInfoWindow)relatedInfo.getRelatedInfo();
                String tabTitle = riw != null ? Util.cleanAmp((String)riw.get_Translation("Name")) : relatedInfo.getName();
                Tab tab = new Tab(tabTitle);
                tabs.appendChild((Component)tab);
                Tabpanel desktopTabPanel = new Tabpanel();
                ZKUpdateUtil.setHeight((HtmlBasedComponent)desktopTabPanel, "100%");
                Vlayout vlayout = new Vlayout();
                ZKUpdateUtil.setVflex((HtmlBasedComponent)vlayout, "1");
                desktopTabPanel.appendChild((Component)vlayout);
                vlayout.appendChild((Component)embeddedPaging);
                vlayout.appendChild((Component)embeddedTbl);
                tabPanels.appendChild((Component)desktopTabPanel);
            }
            ++n2;
        }
        return true;
    }

    protected void prepareTable() {
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        String keyTableAlias = this.tableInfos[0].getSynonym() != null && this.tableInfos[0].getSynonym().trim().length() > 0 ? this.tableInfos[0].getSynonym() : this.tableInfos[0].getTableName();
        String keySelectClause = String.valueOf(keyTableAlias) + "." + this.p_keyColumn;
        list.add(new ColumnInfo(" ", keySelectClause, IDColumn.class, true, false, null, this.p_keyColumn));
        ArrayList<MInfoColumn> gridDisplayedIC = new ArrayList<MInfoColumn>();
        gridDisplayedIC.add(null);
        boolean haveNotProcess = !this.haveProcess;
        int i = 0;
        MInfoColumn[] mInfoColumnArray = this.infoColumns;
        int n = this.infoColumns.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                block10: {
                    ColumnInfo columnInfo;
                    MInfoColumn infoColumn;
                    block13: {
                        String colSQL;
                        block11: {
                            infoColumn = mInfoColumnArray[n2];
                            if (!infoColumn.isDisplayed(this.infoContext, this.p_WindowNo)) break block10;
                            columnInfo = null;
                            colSQL = infoColumn.getSelectClause();
                            if (!colSQL.toUpperCase().contains(" AS ")) {
                                colSQL = String.valueOf(colSQL) + " AS " + infoColumn.getColumnName();
                            }
                            if (infoColumn.getAD_Reference_ID() != 13) break block11;
                            if (infoColumn.getSelectClause().equalsIgnoreCase(keySelectClause)) break block12;
                            columnInfo = new ColumnInfo(infoColumn.get_Translation("Name"), colSQL, DisplayType.getClass((int)infoColumn.getAD_Reference_ID(), (boolean)true), infoColumn.isReadOnly() || haveNotProcess);
                            break block13;
                        }
                        if (DisplayType.isLookup((int)infoColumn.getAD_Reference_ID())) {
                            if (infoColumn.getAD_Reference_ID() == 17) {
                                WEditor editor = null;
                                editor = WebEditorFactory.getEditor(this.gridFields.get(i), true);
                                editor.setMandatory(false);
                                editor.setReadWrite(false);
                                this.editorMap.put(colSQL, editor);
                                columnInfo = new ColumnInfo(infoColumn.get_Translation("Name"), colSQL, ValueNamePair.class, null, infoColumn.isReadOnly() || haveNotProcess);
                            } else {
                                columnInfo = this.createLookupColumnInfo(this.tableInfos, this.gridFields.get(i), infoColumn);
                            }
                        } else {
                            columnInfo = new ColumnInfo(infoColumn.get_Translation("Name"), colSQL, DisplayType.getClass((int)infoColumn.getAD_Reference_ID(), (boolean)true), infoColumn.isReadOnly() || haveNotProcess);
                        }
                    }
                    columnInfo.setColDescription(infoColumn.get_Translation("Description"));
                    columnInfo.setAD_Reference_ID(infoColumn.getAD_Reference_ID());
                    columnInfo.setGridField(this.gridFields.get(i));
                    columnInfo.setColumnName(infoColumn.getColumnName());
                    list.add(columnInfo);
                    gridDisplayedIC.add(infoColumn);
                    if (this.keyColumnOfView == infoColumn) {
                        if (columnInfo.getColClass().equals(IDColumn.class)) {
                            this.isIDColumnKeyOfView = true;
                        }
                        this.indexKeyOfView = list.size() - 1;
                    }
                }
                ++i;
            }
            ++n2;
        }
        if (this.keyColumnOfView == null) {
            this.isIDColumnKeyOfView = true;
        }
        this.columnInfos = list.toArray(new ColumnInfo[0]);
        MInfoColumn[] gridDisplayedInfoColumns = gridDisplayedIC.toArray(new MInfoColumn[gridDisplayedIC.size()]);
        if (this.infoWindowListItemRenderer != null) {
            this.infoWindowListItemRenderer.setGridDisplaydInfoColumns(gridDisplayedInfoColumns, this.columnInfos);
        }
        this.prepareTable(this.columnInfos, this.infoWindow.getFromClause(), this.p_whereClause, this.infoWindow.getOrderByClause());
    }

    protected ColumnInfo createLookupColumnInfo(AccessSqlParser.TableInfo[] tableInfos, GridField gridField, MInfoColumn infoColumn) {
        String columnName = gridField.getColumnName();
        String validationCode = "";
        MLookupInfo lookupInfo = MLookupFactory.getLookupInfo((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)infoColumn.getAD_Reference_ID(), (Language)Env.getLanguage((Properties)Env.getCtx()), (String)columnName, (int)infoColumn.getAD_Reference_Value_ID(), (boolean)false, (String)validationCode);
        String displayColumn = lookupInfo.DisplayColumn;
        boolean haveNotProcess = !this.haveProcess;
        int index = infoColumn.getSelectClause().indexOf(".");
        if (index == infoColumn.getSelectClause().lastIndexOf(".")) {
            String synonym = infoColumn.getSelectClause().substring(0, index);
            AccessSqlParser.TableInfo[] tableInfoArray = tableInfos;
            int n = tableInfos.length;
            int n2 = 0;
            while (n2 < n) {
                AccessSqlParser.TableInfo tableInfo = tableInfoArray[n2];
                if (tableInfo.getSynonym() != null && tableInfo.getSynonym().equals(synonym)) {
                    if (!tableInfo.getTableName().equalsIgnoreCase(lookupInfo.TableName)) break;
                    displayColumn = displayColumn.replace(String.valueOf(lookupInfo.TableName) + ".", String.valueOf(tableInfo.getSynonym()) + ".");
                    ColumnInfo columnInfo = new ColumnInfo(infoColumn.get_Translation("Name"), displayColumn, KeyNamePair.class, infoColumn.getSelectClause(), infoColumn.isReadOnly() || haveNotProcess);
                    return columnInfo;
                }
                ++n2;
            }
        }
        WEditor editor = null;
        editor = WebEditorFactory.getEditor(gridField, true);
        editor.setMandatory(false);
        editor.setReadWrite(false);
        String colSQL = infoColumn.getSelectClause();
        if (!colSQL.toUpperCase().contains(" AS ")) {
            colSQL = String.valueOf(colSQL) + " AS " + infoColumn.getColumnName();
        }
        this.editorMap.put(colSQL, editor);
        ColumnInfo columnInfo = new ColumnInfo(infoColumn.get_Translation("Name"), colSQL, KeyNamePair.class, null, infoColumn.isReadOnly() || haveNotProcess);
        return columnInfo;
    }

    @Override
    protected String getSQLWhere() {
        String sql;
        if (!this.isQueryByUser && this.prevWhereClause != null) {
            return this.prevWhereClause;
        }
        StringBuilder builder = new StringBuilder();
        MTable table2 = MTable.get((Properties)Env.getCtx(), (int)this.infoWindow.getAD_Table_ID());
        if (!this.hasIsActiveEditor() && table2.get_ColumnIndex("IsActive") >= 0) {
            if (this.p_whereClause != null && this.p_whereClause.trim().length() > 0) {
                builder.append(" AND ");
            }
            builder.append(this.tableInfos[0].getSynonym()).append(".IsActive='Y'");
        }
        int count = 0;
        for (WEditor editor : this.editors) {
            MInfoColumn mInfoColumn;
            if (!editor.isVisible()) continue;
            if (editor instanceof IWhereClauseEditor) {
                String whereClause = ((IWhereClauseEditor)((Object)editor)).getWhereClause();
                if (whereClause == null || whereClause.trim().length() <= 0) continue;
                if (++count == 1) {
                    if (builder.length() > 0) {
                        builder.append(" AND ");
                        if (!this.checkAND.isChecked()) {
                            builder.append(" ( ");
                        }
                    } else if (this.p_whereClause != null && this.p_whereClause.trim().length() > 0) {
                        builder.append(" AND ");
                        if (!this.checkAND.isChecked()) {
                            builder.append(" ( ");
                        }
                    }
                } else {
                    builder.append(this.checkAND.isChecked() ? " AND " : " OR ");
                }
                builder.append(whereClause);
                continue;
            }
            if (editor.getGridField() == null || editor.getValue() == null || editor.getValue().toString().trim().length() <= 0 || (mInfoColumn = this.findInfoColumn(editor.getGridField())) == null || mInfoColumn.getSelectClause().equals("0")) continue;
            String columnName = mInfoColumn.getSelectClause();
            int asIndex = columnName.toUpperCase().lastIndexOf(" AS ");
            if (asIndex > 0) {
                columnName = columnName.substring(0, asIndex);
            }
            if (++count == 1) {
                if (builder.length() > 0) {
                    builder.append(" AND ");
                    if (!this.checkAND.isChecked()) {
                        builder.append(" ( ");
                    }
                } else if (this.p_whereClause != null && this.p_whereClause.trim().length() > 0) {
                    builder.append(" AND ");
                    if (!this.checkAND.isChecked()) {
                        builder.append(" ( ");
                    }
                } else if (this.hasIsActiveEditor() && !this.checkAND.isChecked()) {
                    builder.append(" ( ");
                }
            } else {
                builder.append(this.checkAND.isChecked() ? " AND " : " OR ");
            }
            String columnClause = null;
            if (mInfoColumn.getQueryFunction() != null && mInfoColumn.getQueryFunction().trim().length() > 0) {
                String function = mInfoColumn.getQueryFunction();
                if (function.indexOf("@") >= 0) {
                    String s = Env.parseContext((Properties)this.infoContext, (int)this.p_WindowNo, (String)function, (boolean)true, (boolean)false);
                    if (s.length() == 0) {
                        this.log.log(Level.SEVERE, "Failed to parse query function. " + function);
                    } else {
                        function = s;
                    }
                }
                columnClause = function.indexOf("?") >= 0 ? function.replaceFirst("[?]", columnName) : String.valueOf(function) + "(" + columnName + ")";
            } else {
                columnClause = columnName;
            }
            builder.append(columnClause).append(" ").append(mInfoColumn.getQueryOperator());
            if (columnClause.toUpperCase().startsWith("UPPER(")) {
                builder.append(" UPPER(?)");
                continue;
            }
            builder.append(" ?");
        }
        if (count > 0 && !this.checkAND.isChecked()) {
            builder.append(" ) ");
        }
        if ((sql = builder.toString()).indexOf("@") >= 0) {
            sql = Env.parseContext((Properties)this.infoContext, (int)this.p_WindowNo, (String)sql, (boolean)true, (boolean)true);
        }
        this.prevWhereClause = sql;
        return sql;
    }

    protected MInfoColumn findInfoColumn(GridField gridField) {
        int i = 0;
        while (i < this.gridFields.size()) {
            if (this.gridFields.get(i) == gridField) {
                return this.infoColumns[i];
            }
            ++i;
        }
        return null;
    }

    protected boolean isParameteChangeValue() {
        if (this.prevParameterValues == null) {
            return true;
        }
        int parameterIndex = 0;
        while (parameterIndex < this.prevParameterValues.size()) {
            Object newValue = ((WEditor)this.prevRefParmeterEditor.get(parameterIndex)).getValue();
            if (!this.prevParameterValues.get(parameterIndex).equals(newValue)) {
                return true;
            }
            ++parameterIndex;
        }
        for (WEditor editor : this.editors) {
            MInfoColumn mInfoColumn;
            if (!editor.isVisible() || this.prevRefParmeterEditor.contains(editor) || editor.getGridField() == null || editor.getValue() == null || editor.getValue().toString().trim().length() <= 0 || (mInfoColumn = this.findInfoColumn(editor.getGridField())) == null || mInfoColumn.getSelectClause().equals("0")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        if (!this.isQueryByUser && this.prevParameterValues != null) {
            int parameterIndex = 0;
            while (parameterIndex < this.prevParameterValues.size()) {
                this.setParameter(pstmt, parameterIndex + 1, this.prevParameterValues.get(parameterIndex), (String)this.prevQueryOperators.get(parameterIndex));
                ++parameterIndex;
            }
            return;
        }
        if (this.prevParameterValues == null) {
            this.prevParameterValues = new ArrayList();
            this.prevQueryOperators = new ArrayList();
            this.prevRefParmeterEditor = new ArrayList();
        } else {
            this.prevParameterValues.clear();
            this.prevQueryOperators.clear();
            this.prevRefParmeterEditor.clear();
        }
        int parameterIndex = 0;
        for (WEditor editor : this.editors) {
            MInfoColumn mInfoColumn;
            if (!editor.isVisible() || editor.getGridField() == null || editor.getValue() == null || editor.getValue().toString().trim().length() <= 0 || (mInfoColumn = this.findInfoColumn(editor.getGridField())) == null || mInfoColumn.getSelectClause().equals("0")) continue;
            Object value = editor.getValue();
            ++parameterIndex;
            this.prevParameterValues.add(value);
            this.prevQueryOperators.add(mInfoColumn.getQueryOperator());
            this.prevRefParmeterEditor.add(editor);
            this.setParameter(pstmt, parameterIndex, value, mInfoColumn.getQueryOperator());
        }
    }

    protected void setParameter(PreparedStatement pstmt, int parameterIndex, Object value, String queryOperator) throws SQLException {
        if (value instanceof Boolean) {
            pstmt.setString(parameterIndex, (Boolean)value != false ? "Y" : "N");
        } else if (value instanceof String) {
            StringBuilder valueStr = new StringBuilder(value.toString());
            if (queryOperator.equals("Like")) {
                if (!valueStr.toString().endsWith("%")) {
                    valueStr.append("%");
                }
            } else if (queryOperator.equals("LIKE")) {
                if (!valueStr.toString().startsWith("%")) {
                    valueStr.insert(0, "%");
                }
                if (!valueStr.toString().endsWith("%")) {
                    valueStr.append("%");
                }
            }
            pstmt.setString(parameterIndex, valueStr.toString());
        } else {
            pstmt.setObject(parameterIndex, value);
        }
    }

    @Override
    protected void prepareTable(ColumnInfo[] layout, String from, String where, String orderBy) {
        String sql;
        super.prepareTable(layout, from, where, orderBy);
        if (this.m_sqlMain.indexOf("@") >= 0) {
            sql = Env.parseContext((Properties)this.infoContext, (int)this.p_WindowNo, (String)this.m_sqlMain, (boolean)true);
            if (sql == null || sql.length() == 0) {
                this.log.severe("Failed to parsed sql. sql=" + this.m_sqlMain);
            } else {
                this.m_sqlMain = sql;
            }
        }
        this.addViewIDToQuery();
        this.addKeyViewToQuery();
        if (this.m_sqlMain.length() > 0 && this.infoWindow.isDistinct()) {
            this.m_sqlMain = this.m_sqlMain.substring("SELECT ".length());
            this.m_sqlMain = "SELECT DISTINCT " + this.m_sqlMain;
        }
        if (this.m_sqlOrder != null && this.m_sqlOrder.indexOf("@") >= 0) {
            sql = Env.parseContext((Properties)this.infoContext, (int)this.p_WindowNo, (String)this.m_sqlOrder, (boolean)true, (boolean)false);
            if (sql == null || sql.length() == 0) {
                this.log.severe("Failed to parsed sql. sql=" + this.m_sqlOrder);
            } else {
                this.m_sqlOrder = sql;
            }
        }
    }

    protected void addViewIDToQuery() {
        this.m_sqlMain = this.addMoreColumnToQuery(this.m_sqlMain, (IInfoColumn[])this.infoProcessList);
    }

    protected void addKeyViewToQuery() {
        if (this.isNeedAppendKeyViewData()) {
            this.m_sqlMain = this.addMoreColumnToQuery(this.m_sqlMain, new IInfoColumn[]{this.keyColumnOfView});
        }
    }

    @Override
    public boolean isNeedAppendKeyViewData() {
        return this.keyColumnOfView != null && !this.keyColumnOfView.isDisplayed(this.infoContext, this.p_WindowNo);
    }

    protected String addMoreColumnToQuery(String sqlMain, IInfoColumn[] listInfoColumn) {
        if (sqlMain == null || sqlMain.length() == 0 || listInfoColumn == null || listInfoColumn.length == 0) {
            return sqlMain;
        }
        int fromIndex = sqlMain.indexOf("FROM");
        String selectClause = sqlMain.substring(0, fromIndex);
        String fromClause = sqlMain.substring(fromIndex);
        StringBuilder sqlBuilder = new StringBuilder(selectClause);
        StringBuilder sqlColumn = new StringBuilder();
        IInfoColumn[] iInfoColumnArray = listInfoColumn;
        int n = listInfoColumn.length;
        int n2 = 0;
        while (n2 < n) {
            MInfoColumn infocol;
            IInfoColumn infoProcess = iInfoColumnArray[n2];
            if (infoProcess.getInfoColumnID() > 0 && !(infocol = infoProcess.getAD_InfoColumn()).isDisplayed()) {
                sqlColumn.append(", ").append(infocol.getSelectClause()).append(" AS ").append(infocol.getColumnName()).append(" ");
                if (!sqlBuilder.toString().contains(sqlColumn)) {
                    sqlBuilder.append((CharSequence)sqlColumn);
                }
                sqlColumn.delete(0, sqlColumn.length());
            }
            ++n2;
        }
        sqlBuilder.append(fromClause);
        return sqlBuilder.toString();
    }

    protected void renderWindow() {
        this.setTitle(this.infoWindow.get_Translation("Name"));
        this.layout = new Borderlayout();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.layout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.layout, "100%");
        if (!this.isLookup()) {
            this.layout.setStyle("position: relative");
        }
        this.appendChild((Component)this.layout);
        if (this.isLookup()) {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.contentPanel, "99%");
        } else {
            this.contentPanel.setStyle("width: 99%; margin: 0px auto;");
        }
        ZKUpdateUtil.setVflex(this.contentPanel, true);
        this.contentPanel.setSizedByContent(true);
        this.contentPanel.setSpan(true);
        North north = new North();
        north.setCollapsible(true);
        north.setSplittable(true);
        north.setAutoscroll(true);
        LayoutUtils.addSlideSclass((LayoutRegion)north);
        this.layout.appendChild((Component)north);
        this.renderParameterPane(north);
        Center center = new Center();
        this.layout.appendChild((Component)center);
        this.renderContentPane(center);
        South south = new South();
        this.layout.appendChild((Component)south);
        this.renderFooter(south);
        this.confirmPanel.getButton("Zoom").setVisible(this.hasZoom());
        this.confirmPanel.getButton("Zoom").setDisabled(true);
        for (Button btProcess : this.btProcessList) {
            btProcess.setDisabled(true);
        }
        if (this.btCbbProcess != null) {
            this.btCbbProcess.setDisabled(true);
        }
        if (this.btMenuProcess != null) {
            this.btMenuProcess.setDisabled(true);
        }
        if (this.cbbProcess != null) {
            this.cbbProcess.setDisabled(true);
        }
    }

    protected void renderFooter(South south) {
        this.southBody = new Vbox();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.southBody, "1");
        south.appendChild((Component)this.southBody);
        this.southBody.appendChild((Component)new Separator());
        this.southBody.appendChild((Component)this.confirmPanel);
        this.southBody.appendChild((Component)this.statusBar);
    }

    @Override
    protected void insertPagingComponent() {
        this.southBody.insertBefore((Component)this.paging, this.southBody.getFirstChild());
        this.layout.invalidate();
    }

    protected void renderContentPane(Center center) {
        Div div = new Div();
        div.setStyle("width :100%; height: 100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)div, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)div, "1");
        div.appendChild((Component)this.contentPanel);
        Borderlayout inner = new Borderlayout();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)inner, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)inner, "100%");
        int height = SessionManager.getAppDesktop().getClientInfo().desktopHeight * 90 / 100;
        inner.setStyle("border: none; position: relative; ");
        inner.appendCenter((Component)div);
        inner.getCenter().setAutoscroll(false);
        if (this.embeddedWinList.size() > 0) {
            South south = new South();
            int detailHeight = height * 25 / 100;
            ZKUpdateUtil.setHeight((HtmlBasedComponent)south, String.valueOf(detailHeight) + "px");
            south.setAutoscroll(true);
            south.setCollapsible(true);
            south.setSplittable(true);
            south.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"Related Information"));
            south.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"Related Information"));
            south.addEventListener("onSwipe", (EventListener)new EventListener<SwipeEvent>(){

                public void onEvent(SwipeEvent event) throws Exception {
                    South south = (South)event.getTarget();
                    if ("down".equals(event.getSwipeDirection())) {
                        south.setOpen(false);
                    }
                }
            });
            south.setSclass("south-collapsible-with-title");
            south.setAutoscroll(true);
            inner.appendChild((Component)south);
            this.embeddedPane.setSclass("info-product-tabbedpane");
            ZKUpdateUtil.setVflex((HtmlBasedComponent)this.embeddedPane, "1");
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.embeddedPane, "1");
            south.appendChild((Component)this.embeddedPane);
        }
        center.appendChild((Component)inner);
    }

    protected void renderParameterPane(North north) {
        this.createParameterPanel();
        north.appendChild((Component)this.parameterGrid);
    }

    protected void createParameterPanel() {
        this.layoutParameterGrid(false);
    }

    protected void layoutParameterGrid(boolean update) {
        if (!update) {
            this.parameterGrid = GridFactory.newGridLayout();
            this.parameterGrid.setWidgetAttribute("instanceName", "infoParameterPanel");
            this.parameterGrid.setStyle("width: 95%; margin: auto !important;");
        }
        if (this.parameterGrid.getColumns() != null) {
            this.parameterGrid.getColumns().detach();
        }
        Columns columns = new Columns();
        this.parameterGrid.appendChild((Component)columns);
        this.noOfParameterColumn = this.getNoOfParameterColumns();
        int i = 0;
        while (i < this.noOfParameterColumn) {
            columns.appendChild((Component)new Column());
            ++i;
        }
        Column column = new Column();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "100px");
        column.setAlign("right");
        columns.appendChild((Component)column);
        if (this.parameterGrid.getRows() != null) {
            this.parameterGrid.getRows().detach();
        }
        Rows rows = new Rows();
        this.parameterGrid.appendChild((Component)rows);
        if (!update) {
            this.editors = new ArrayList<WEditor>();
            this.identifiers = new ArrayList<WEditor>();
        }
        TreeMap<Integer, ArrayList<Object[]>> tree = new TreeMap<Integer, ArrayList<Object[]>>();
        int i2 = 0;
        while (i2 < this.infoColumns.length) {
            if (this.infoColumns[i2].isQueryCriteria()) {
                List<Object> list = (List)tree.get(this.infoColumns[i2].getSeqNoSelection());
                if (list == null) {
                    list = new ArrayList<Object[]>();
                    tree.put(this.infoColumns[i2].getSeqNoSelection(), (ArrayList<Object[]>)list);
                }
                list.add(new Object[]{this.infoColumns[i2], this.gridFields.get(i2)});
            }
            ++i2;
        }
        for (Integer i3 : tree.keySet()) {
            List list = (List)tree.get(i3);
            block3: for (Object[] value : list) {
                if (update) {
                    for (WEditor editor : this.editors) {
                        if (editor.getGridField() != value[1]) continue;
                        this.addSearchParameter(editor.getLabel(), editor.getComponent());
                        continue block3;
                    }
                    continue;
                }
                this.addSelectionColumn((MInfoColumn)value[0], (GridField)value[1]);
            }
        }
        if (this.checkAND == null && this.parameterGrid.getRows() != null && this.parameterGrid.getRows().getFirstChild() != null) {
            Row row = (Row)this.parameterGrid.getRows().getFirstChild();
            int col = row.getChildren().size();
            while (col < 6) {
                row.appendChild((Component)new Space());
                ++col;
            }
            this.createAndCheckbox();
            row.appendChild((Component)this.checkAND);
        }
        this.evalDisplayLogic();
        if (!update) {
            this.initParameters();
        }
        this.dynamicDisplay(null);
    }

    protected void evalDisplayLogic() {
        for (WEditor editor : this.editors) {
            if (editor.getGridField() != null && !editor.getGridField().isDisplayed(true)) {
                editor.getComponent().setVisible(false);
                if (editor.getLabel() == null) continue;
                editor.getLabel().setVisible(false);
                continue;
            }
            if (editor.getComponent().isVisible()) continue;
            editor.getComponent().setVisible(true);
            if (editor.getLabel() == null) continue;
            editor.getLabel().setVisible(true);
        }
    }

    protected void addSelectionColumn(MInfoColumn infoColumn, GridField mField) {
        int displayLength = mField.getDisplayLength();
        if (displayLength <= 0 || displayLength > 20) {
            mField.setDisplayLength(20);
        } else {
            displayLength = 0;
        }
        WEditor editor = null;
        if (mField.getDisplayType() == 35) {
            editor = new WInfoPAttributeEditor(this.infoContext, this.p_WindowNo, mField);
            editor.setReadWrite(true);
        } else {
            editor = WebEditorFactory.getEditor(mField, false);
            editor.setReadWrite(true);
            editor.dynamicDisplay();
            editor.addValueChangeListener(this);
            editor.fillHorizontal();
        }
        Label label = editor.getLabel();
        Component fieldEditor = editor.getComponent();
        if (displayLength > 0) {
            mField.setDisplayLength(displayLength);
        }
        if (label != null && (infoColumn.getQueryOperator().equals(">") || infoColumn.getQueryOperator().equals(">=") || infoColumn.getQueryOperator().equals("<") || infoColumn.getQueryOperator().equals("<=") || infoColumn.getQueryOperator().equals("!="))) {
            label.setValue(String.valueOf(label.getValue()) + " " + infoColumn.getQueryOperator());
        }
        this.addSearchParameter(label, fieldEditor);
        this.editors.add(editor);
        editor.showMenu();
        if (infoColumn.isIdentifier()) {
            this.identifiers.add(editor);
        }
        fieldEditor.addEventListener("onOK", (EventListener)this);
        mField.addPropertyChangeListener((PropertyChangeListener)editor);
        mField.setValue(mField.getDefaultForPanel(), true);
    }

    protected void addSearchParameter(Label label, Component fieldEditor) {
        Row panel = null;
        if (this.parameterGrid.getRows().getChildren().isEmpty()) {
            panel = new Row();
            this.parameterGrid.getRows().appendChild((Component)panel);
        } else {
            panel = (Row)this.parameterGrid.getRows().getLastChild();
            if (panel.getChildren().size() == this.getNoOfParameterColumns()) {
                if (this.parameterGrid.getRows().getChildren().size() == 1) {
                    this.createAndCheckbox();
                    panel.appendChild((Component)this.checkAND);
                } else {
                    panel.appendChild((Component)new Space());
                }
                panel = new Row();
                this.parameterGrid.getRows().appendChild((Component)panel);
            }
        }
        if (!(fieldEditor instanceof Checkbox)) {
            Div div = new Div();
            div.setStyle("text-align: right;");
            div.appendChild((Component)label);
            if (label.getDecorator() != null) {
                div.appendChild(label.getDecorator());
            }
            panel.appendChild((Component)div);
        } else {
            panel.appendChild((Component)new Space());
        }
        Div outerParent = new Div();
        outerParent.appendChild(fieldEditor);
        panel.appendChild((Component)outerParent);
    }

    protected int getNoOfParameterColumns() {
        if (ClientInfo.maxWidth(699)) {
            return 2;
        }
        if (ClientInfo.maxWidth(999)) {
            return 4;
        }
        return 6;
    }

    protected void createAndCheckbox() {
        this.checkAND = new Checkbox();
        this.checkAND.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"SearchAND", (boolean)true));
        String tips = Msg.getMsg((Properties)Env.getCtx(), (String)"SearchAND", (boolean)false);
        if (!Util.isEmpty((String)tips)) {
            this.checkAND.setTooltiptext(tips);
        }
        this.checkAND.setChecked(true);
        this.checkAND.addEventListener("onCheck", (EventListener)this);
    }

    protected int findColumnIndex(String columnName) {
        int i = 0;
        while (i < this.columnInfos.length) {
            GridField field = this.columnInfos[i].getGridField();
            if (field != null && field.getColumnName().equalsIgnoreCase(columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected void saveSelectionDetail() {
        int row = this.contentPanel.getSelectedRow();
        if (row == -1) {
            return;
        }
        int column = -1;
        ColumnInfo[] columnInfoArray = this.columnInfos;
        int n = this.columnInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnInfo columnInfo = columnInfoArray[n2];
            ++column;
            GridField field = columnInfo.getGridField();
            if (field != null) {
                String columnName = field.getColumnName();
                if (columnInfo.getColClass().equals(KeyNamePair.class)) {
                    KeyNamePair knp = (KeyNamePair)this.contentPanel.getValueAt(row, column);
                    Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)columnName, (String)(knp == null ? "0" : knp.getID()));
                } else if (columnName.endsWith("_ID")) {
                    Object id = this.contentPanel.getValueAt(row, column);
                    Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)columnName, (String)(id == null ? "0" : id.toString()));
                } else {
                    Object value = this.contentPanel.getValueAt(row, column);
                    Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)field.getColumnName(), (String)(value == null ? "" : value.toString()));
                }
            }
            ++n2;
        }
    }

    @Override
    protected String buildDataSQL(int start, int end) {
        String dynWhere = this.getSQLWhere();
        StringBuilder sql = new StringBuilder(this.m_sqlMain);
        if (dynWhere.length() > 0) {
            sql.append(dynWhere);
        }
        if (sql.toString().trim().endsWith("WHERE")) {
            int index = sql.lastIndexOf(" WHERE");
            sql.delete(index, sql.length());
        }
        String dataSql = Msg.parseTranslation((Properties)Env.getCtx(), (String)sql.toString());
        dataSql = MRole.getDefault().addAccessSQL(dataSql, this.getTableName(), true, false);
        String otherClause = this.getOtherClauseParsed();
        if (otherClause.length() > 0) {
            dataSql = String.valueOf(dataSql) + " " + otherClause;
        }
        dataSql = this.m_sqlUserOrder != null && this.m_sqlUserOrder.trim().length() > 0 ? String.valueOf(dataSql) + this.m_sqlUserOrder : String.valueOf(dataSql) + this.m_sqlOrder;
        if (end > start && this.isUseDatabasePaging() && DB.getDatabase().isPagingSupported()) {
            dataSql = DB.getDatabase().addPagingSQL(dataSql, this.getCacheStart(), this.getCacheEnd());
        }
        return dataSql;
    }

    private String getOtherClauseParsed() {
        String otherClause = "";
        if (this.infoWindow != null && this.infoWindow.getOtherClause() != null && this.infoWindow.getOtherClause().trim().length() > 0 && (otherClause = this.infoWindow.getOtherClause()).indexOf("@") >= 0) {
            String s = Env.parseContext((Properties)this.infoContext, (int)this.p_WindowNo, (String)otherClause, (boolean)true, (boolean)false);
            if (s.length() == 0) {
                this.log.severe("Failed to parse other clause. " + otherClause);
            } else {
                otherClause = s;
            }
        }
        return otherClause;
    }

    @Override
    protected void executeQuery() {
        if (!this.isRequeryByRunSuccessProcess) {
            this.prepareTable();
        }
        super.executeQuery();
        this.cacheOriginalValues.clear();
        if (ClientInfo.maxHeight(499) || ClientInfo.maxWidth(699)) {
            this.layout.getNorth().setOpen(false);
            LayoutUtils.addSclass("slide", (HtmlBasedComponent)this.layout.getNorth());
        }
    }

    @Override
    protected boolean hasZoom() {
        return !this.isLookup() && this.infoWindow != null && !MTable.get((Properties)Env.getCtx(), (int)this.infoWindow.getAD_Table_ID()).isView();
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        if (evt != null && evt.getSource() instanceof WEditor) {
            WEditor editor = (WEditor)evt.getSource();
            if (evt.getNewValue() == null) {
                Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (String)editor.getColumnName(), (String)"");
                Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (int)1113, (String)editor.getColumnName(), (String)"");
            } else if (evt.getNewValue() instanceof Boolean) {
                Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (String)editor.getColumnName(), (boolean)((Boolean)evt.getNewValue()));
                Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (int)1113, (String)editor.getColumnName(), (boolean)((Boolean)evt.getNewValue()));
            } else if (evt.getNewValue() instanceof Timestamp) {
                Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (String)editor.getColumnName(), (Timestamp)((Timestamp)evt.getNewValue()));
                Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (String)("1113|" + editor.getColumnName()), (Timestamp)((Timestamp)evt.getNewValue()));
            } else {
                Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (String)editor.getColumnName(), (String)evt.getNewValue().toString());
                Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (int)1113, (String)editor.getColumnName(), (String)evt.getNewValue().toString());
            }
            this.dynamicDisplay(editor);
        }
    }

    protected void dynamicDisplay(WEditor editor) {
        this.validateField(editor);
        boolean asiChanged = false;
        if (editor != null && editor instanceof WTableDirEditor && editor.getColumnName().equals("M_AttributeSet_ID")) {
            asiChanged = true;
        }
        for (WEditor otherEditor : this.editors) {
            if (otherEditor == editor) continue;
            if (asiChanged && otherEditor instanceof WInfoPAttributeEditor) {
                ((WInfoPAttributeEditor)otherEditor).clearWhereClause();
            }
            otherEditor.dynamicDisplay();
        }
        this.evalDisplayLogic();
    }

    @Override
    public void onEvent(Event event) {
        if (event.getName().equals("onFocus") && event.getTarget() != null && event.getTarget().getAttribute("INFO_PROCESS") != null) {
            MProcess process = (MProcess)event.getTarget().getAttribute("INFO_PROCESS");
            SessionManager.getAppDesktop().updateHelpTooltip(process.get_Translation("Name"), process.get_Translation("Description"), process.get_Translation("Help"), null);
        } else if (event.getName().equals("onFocus")) {
            for (WEditor editor : this.editors) {
                if (!editor.isComponentOfEditor(event.getTarget())) continue;
                SessionManager.getAppDesktop().updateHelpTooltip(editor.getGridField());
                return;
            }
        } else if (event.getName().equals("onSelect") && event.getTarget().equals((Object)this.cbbProcess)) {
            Comboitem selectedItem = this.cbbProcess.getSelectedItem();
            if (selectedItem != null && selectedItem.getValue() != null) {
                MProcess selectedValue = (MProcess)selectedItem.getValue();
                SessionManager.getAppDesktop().updateHelpTooltip(selectedValue.get_Translation("Name"), selectedValue.get_Translation("Description"), selectedValue.get_Translation("Help"), null);
            }
        } else if (event.getName().equals("onOK") && event.getTarget() != null) {
            Component tagetComponent = event.getTarget();
            boolean isCacheEvent = false;
            for (WEditor editor : this.editors) {
                Object editorComponent = editor.getComponent();
                if (editorComponent instanceof EditorBox) {
                    editorComponent = ((EditorBox)((Object)editorComponent)).getTextbox();
                }
                if (!editorComponent.equals(tagetComponent)) continue;
                if (editor instanceof WSearchEditor && ((WSearchEditor)editor).isShowingDialog()) {
                    return;
                }
                isCacheEvent = true;
                break;
            }
            if (isCacheEvent) {
                boolean isParameterChange = this.isParameteChangeValue();
                if (isParameterChange) {
                    if (!this.isQueryByUser) {
                        this.onUserQuery();
                    }
                } else if (this.m_lookup && this.contentPanel.getSelectedIndex() >= 0) {
                    this.onOk();
                }
            } else {
                super.onEvent(event);
            }
        } else {
            super.onEvent(event);
        }
    }

    @Override
    protected void resetParameters() {
        for (WEditor editor : this.editors) {
            GridField gField = editor.getGridField();
            if (gField == null || !gField.isDisplayed()) continue;
            Object resetValue = null;
            if (!Util.isEmpty((String)gField.getVO().DefaultValue, (boolean)true)) {
                resetValue = gField.getDefaultForPanel();
            }
            Object oldValue = gField.getValue();
            gField.setValue(resetValue, true);
            ValueChangeEvent changeEvent = new ValueChangeEvent(editor, "", oldValue, resetValue);
            this.valueChange(changeEvent);
        }
        this.initParameters();
        this.dynamicDisplay(null);
        this.onQueryCallback(null);
        if (this.paging != null) {
            this.paging.setParent(null);
        }
        this.layout.invalidate();
        this.contentPanel.getListHead().detach();
    }

    @Override
    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null) {
            for (WEditor editor : this.editors) {
                editor.getComponent().addEventListener("onFocus", (EventListener)this);
            }
        }
    }

    protected void onClientInfo() {
        int t = this.getNoOfParameterColumns();
        if (t > 0 && this.noOfParameterColumn > 0 && t != this.noOfParameterColumn) {
            this.layoutParameterGrid(true);
            this.invalidate();
        }
    }

    @Override
    protected boolean testCount() {
        return this.testCount(true);
    }

    protected boolean testCount(boolean promptError) {
        long start;
        block13: {
            String countSql;
            start = System.currentTimeMillis();
            String dynWhere = this.getSQLWhere();
            StringBuilder sql = new StringBuilder(this.m_sqlMain);
            if (dynWhere.length() > 0) {
                sql.append(dynWhere);
            }
            if ((countSql = Msg.parseTranslation((Properties)Env.getCtx(), (String)sql.toString())).trim().endsWith("WHERE")) {
                countSql = countSql.trim();
                countSql = countSql.substring(0, countSql.length() - 5);
            }
            countSql = MRole.getDefault().addAccessSQL(countSql, this.getTableName(), true, false);
            String otherClause = this.getOtherClauseParsed();
            if (otherClause.length() > 0) {
                countSql = String.valueOf(countSql) + " " + otherClause;
            }
            countSql = "SELECT COUNT(*) FROM ( " + countSql + " ) a";
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(countSql);
            }
            this.m_count = -1;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)countSql, null);
                    this.setParameters((PreparedStatement)pstmt, true);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_count = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, countSql, (Throwable)e);
                    this.m_count = -2;
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_count + " - " + (System.currentTimeMillis() - start) + "ms");
        }
        if (this.infoWindow.getMaxQueryRecords() > 0 && this.m_count > this.infoWindow.getMaxQueryRecords()) {
            if (promptError) {
                FDialog.error(this.getWindowNo(), (Component)this, "InfoFindOverMax", String.valueOf(this.m_count) + " > " + this.infoWindow.getMaxQueryRecords());
            }
            this.m_count = 0;
        }
        return true;
    }

    boolean hasIsActiveEditor() {
        for (WEditor editor : this.editors) {
            if (editor.getGridField() == null || !"IsActive".equals(editor.getGridField().getColumnName())) continue;
            return true;
        }
        return false;
    }

    public ArrayList<ColumnInfo> getInfoColumnslayout(MInfoWindow info) {
        AccessSqlParser sqlParser = new AccessSqlParser("SELECT * FROM " + info.getFromClause());
        AccessSqlParser.TableInfo[] tableInfos = sqlParser.getTableInfo(0);
        MInfoColumn[] infoColumns = info.getInfoColumns(tableInfos);
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        String keyTableAlias = tableInfos[0].getSynonym() != null && tableInfos[0].getSynonym().trim().length() > 0 ? tableInfos[0].getSynonym() : tableInfos[0].getTableName();
        String keySelectClause = String.valueOf(keyTableAlias) + "." + this.p_keyColumn;
        MInfoColumn[] mInfoColumnArray = infoColumns;
        int n = infoColumns.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                ColumnInfo columnInfo;
                MInfoColumn infoColumn;
                block8: {
                    String colSQL;
                    block7: {
                        infoColumn = mInfoColumnArray[n2];
                        if (!infoColumn.isDisplayed(this.infoContext, this.p_WindowNo)) break block6;
                        columnInfo = null;
                        colSQL = infoColumn.getSelectClause();
                        if (!colSQL.toUpperCase().contains(" AS ")) {
                            colSQL = String.valueOf(colSQL) + " AS " + infoColumn.getColumnName();
                        }
                        if (infoColumn.getAD_Reference_ID() != 13) break block7;
                        if (infoColumn.getSelectClause().equalsIgnoreCase(keySelectClause)) break block6;
                        columnInfo = new ColumnInfo(infoColumn.get_Translation("Name"), colSQL, DisplayType.getClass((int)infoColumn.getAD_Reference_ID(), (boolean)true));
                        break block8;
                    }
                    if (DisplayType.isLookup((int)infoColumn.getAD_Reference_ID())) {
                        if (infoColumn.getAD_Reference_ID() == 17) {
                            WEditor editor = null;
                            editor = WebEditorFactory.getEditor(this.getGridField(infoColumn), true);
                            editor.setMandatory(false);
                            editor.setReadWrite(false);
                            this.editorMap.put(colSQL, editor);
                            columnInfo = new ColumnInfo(infoColumn.get_Translation("Name"), colSQL, ValueNamePair.class, null);
                        } else {
                            GridField field = this.getGridField(infoColumn);
                            columnInfo = this.createLookupColumnInfo(tableInfos, field, infoColumn);
                        }
                    } else {
                        columnInfo = new ColumnInfo(infoColumn.get_Translation("Name"), colSQL, DisplayType.getClass((int)infoColumn.getAD_Reference_ID(), (boolean)true));
                    }
                }
                columnInfo.setColDescription(infoColumn.get_Translation("Description"));
                columnInfo.setGridField(this.getGridField(infoColumn));
                list.add(columnInfo);
            }
            ++n2;
        }
        return list;
    }

    protected void reset(EmbedWinInfo relatedInfo) {
        if (relatedInfo.getInfoTbl() != null) {
            if (((WListbox)relatedInfo.getInfoTbl()).getModel() != null) {
                ((WListbox)relatedInfo.getInfoTbl()).getModel().clear();
            } else {
                ((WListbox)relatedInfo.getInfoTbl()).clear();
            }
        }
    }

    protected GridField getGridField(MInfoColumn infoColumn) {
        String columnName = infoColumn.getColumnName();
        GridFieldVO vo = GridFieldVO.createParameter((Properties)this.infoContext, (int)this.p_WindowNo, (int)AEnv.getADWindowID(this.p_WindowNo), (int)this.m_infoWindowID, (int)0, (String)columnName, (String)infoColumn.get_Translation("Name"), (int)infoColumn.getAD_Reference_ID(), (int)infoColumn.getAD_Reference_Value_ID(), (boolean)false, (boolean)false, (String)infoColumn.get_Translation("Placeholder"));
        if (infoColumn.getAD_Val_Rule_ID() > 0) {
            vo.ValidationCode = infoColumn.getAD_Val_Rule().getCode();
            if (vo.lookupInfo != null) {
                vo.lookupInfo.ValidationCode = vo.ValidationCode;
                vo.lookupInfo.IsValidated = false;
            }
        }
        vo.DisplayLogic = infoColumn.getDisplayLogic() != null ? infoColumn.getDisplayLogic() : "";
        String desc = infoColumn.get_Translation("Description");
        vo.Description = desc != null ? desc : "";
        String help = infoColumn.get_Translation("Help");
        vo.Help = help != null ? help : "";
        GridField gridField = new GridField(vo);
        return gridField;
    }

    @Override
    public boolean validateParameters() {
        boolean isValid = true;
        int i = 0;
        while (i < this.editors.size()) {
            WEditor wEditor = this.editors.get(i);
            if (wEditor != null && wEditor.isVisible() && wEditor.getGridField() != null) {
                isValid &= this.validateField(wEditor);
            }
            ++i;
        }
        return isValid;
    }

    protected boolean validateField(WEditor wEditor) {
        if (wEditor == null || !wEditor.isVisible() || wEditor.getGridField() == null) {
            return true;
        }
        GridField validateGrid = wEditor.getGridField();
        if (validateGrid.isMandatory(true)) {
            wEditor.updateStyle();
            Object data = wEditor.getValue();
            if (data == null || data.toString().length() == 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean hasNew() {
        boolean hasNew;
        boolean bl = hasNew = this.getADWindowID() > 0;
        if (hasNew && this.vqe == null && this.hasRightQuickEntry) {
            GridWindow gridwindow = GridWindow.get((Properties)Env.getCtx(), (int)0, (int)this.getADWindowID());
            boolean bl2 = this.hasRightQuickEntry = gridwindow != null;
            if (this.hasRightQuickEntry) {
                this.vqe = new WQuickEntry(0, this.getADWindowID());
            }
        }
        return hasNew && this.vqe != null && this.vqe.isAvailableQuickEdit();
    }

    protected int getADWindowID() {
        if (this.infoWindow == null) {
            return 0;
        }
        String isSOTrx = Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"IsSOTrx");
        if (!this.isLookup() && Util.isEmpty((String)isSOTrx)) {
            isSOTrx = "Y";
        }
        return super.getAD_Window_ID(MTable.getTableName((Properties)Env.getCtx(), (int)this.infoWindow.getAD_Table_ID()), isSOTrx.equalsIgnoreCase("Y"));
    }

    @Override
    protected void newRecordAction() {
        WQuickEntry vqe = new WQuickEntry(0, this.getADWindowID());
        vqe.loadRecord(0);
        final ISupportMask parent = LayoutUtils.showWindowWithMask((Window)vqe, (Component)this, 4);
        vqe.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Clients.response((AuResponse)new AuEcho((Component)InfoWindow.this, "onQueryCallback", null));
                if (parent != null) {
                    parent.hideMask();
                }
            }
        });
        vqe.setVisible(true);
    }

    protected void setSouthVisible(boolean visible) {
        Center comp = this.layout.getCenter();
        block0: for (Component c : comp.getChildren()) {
            if (!(c instanceof Borderlayout)) continue;
            for (Component c1 : c.getChildren()) {
                if (!(c1 instanceof South)) continue;
                c1.setVisible(visible);
                continue block0;
            }
        }
    }

    public Properties getRowaAsCtx(int row, int editingColumn, Object editingValue) {
        Object val;
        ListModelTable model = this.contentPanel.getModel();
        Properties ctx = new Properties(Env.getCtx());
        for (WEditor e : this.editors) {
            val = e.getValue();
            String column = e.getColumnName();
            if (val == null) continue;
            if (val instanceof Integer) {
                Env.setContext((Properties)ctx, (int)0, (String)column, (int)((Integer)val));
                continue;
            }
            if (val instanceof Timestamp) {
                Env.setContext((Properties)ctx, (int)0, (String)column, (Timestamp)((Timestamp)val));
                continue;
            }
            if (val instanceof Boolean) {
                Env.setContext((Properties)ctx, (int)0, (String)column, (boolean)((Boolean)val));
                continue;
            }
            Env.setContext((Properties)ctx, (int)0, (String)column, (String)val.toString());
        }
        int i = 0;
        while (i < this.p_layout.length) {
            String column = this.p_layout[i].getColumnName();
            val = null;
            val = i != editingColumn ? model.getValueAt(row, i) : editingValue;
            if (val != null) {
                if (val instanceof IDColumn) {
                    IDColumn idc = (IDColumn)val;
                    val = idc.getRecord_ID();
                } else if (val instanceof KeyNamePair) {
                    KeyNamePair knp = (KeyNamePair)val;
                    val = knp.getKey();
                }
                if (val instanceof Integer) {
                    Env.setContext((Properties)ctx, (int)0, (String)column, (int)((Integer)val));
                } else if (val instanceof Timestamp) {
                    Env.setContext((Properties)ctx, (int)0, (String)column, (Timestamp)((Timestamp)val));
                } else if (val instanceof Boolean) {
                    Env.setContext((Properties)ctx, (int)0, (String)column, (boolean)((Boolean)val));
                } else {
                    Env.setContext((Properties)ctx, (int)0, (String)column, (String)val.toString());
                }
            }
            ++i;
        }
        return ctx;
    }

    public void onCellEditCallback(ValueChangeEvent event, int rowIndex, int colIndex, WEditor editor, GridField field) {
        Object val = event.getNewValue();
        if (val != null && this.columnInfos[colIndex].getColClass().equals(KeyNamePair.class)) {
            Integer iVal = (Integer)val;
            String display = editor.getDisplay();
            KeyNamePair kdc = new KeyNamePair(iVal.intValue(), display);
            val = kdc;
        }
        MInfoColumn infoColumn = this.infoColumns[colIndex - 1];
        boolean changeIsValid = true;
        String validationSQL = null;
        if (!Util.isEmpty((String)infoColumn.getInputFieldValidation(), (boolean)true)) {
            changeIsValid = false;
            Properties ctx = this.getRowaAsCtx(rowIndex, colIndex, val);
            String rawSQL = infoColumn.getInputFieldValidation();
            validationSQL = Env.parseContext((Properties)ctx, (int)0, (String)rawSQL, (boolean)false);
            try {
                List errors = DB.getSQLArrayObjectsEx(null, (String)validationSQL, (Object[])new Object[0]);
                if (errors != null && errors.size() > 0) {
                    StringBuilder sbError = new StringBuilder();
                    for (List line : errors) {
                        if (line.size() <= 0) continue;
                        if (sbError.length() > 0) {
                            sbError.append('\n');
                        }
                        sbError.append(line.get(0));
                    }
                    String msg = Msg.translate((Properties)ctx, (String)sbError.toString());
                    FDialog.error(0, (Component)this, "ValidationError", msg);
                } else {
                    changeIsValid = true;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Error executing validation SQL: " + validationSQL, (Throwable)e);
                FDialog.error(0, (Component)this, "Error", validationSQL);
                changeIsValid = false;
            }
        }
        if (changeIsValid) {
            ListModelTable model = this.contentPanel.getModel();
            Object row = model.get(rowIndex);
            model.removeFromSelection(row);
            this.contentPanel.setValueAt(val, rowIndex, colIndex);
            model.addToSelection(row);
            Clients.resize((Component)this.contentPanel);
        } else {
            editor.setValue(event.getOldValue());
        }
    }

    protected void restoreOriginalValues(int rowIndex) {
        Integer viewIdKey = this.getColumnValue(rowIndex);
        if (this.cacheOriginalValues.containsKey(viewIdKey)) {
            int colCount = this.contentPanel.getColumnCount();
            List<Object> row = this.cacheOriginalValues.get(viewIdKey);
            int i = 1;
            while (i < colCount) {
                Object val = row.get(i - 1);
                this.contentPanel.setValueAt(val, rowIndex, i);
                ++i;
            }
        }
    }

    protected void cacheOriginalValues(int rowIndex) {
        Integer viewIdKey = this.getColumnValue(rowIndex);
        if (!this.cacheOriginalValues.containsKey(viewIdKey)) {
            int colCount = this.contentPanel.getColumnCount();
            ArrayList<Object> row = new ArrayList<Object>();
            int i = 1;
            while (i < colCount) {
                Object val = this.contentPanel.getValueAt(rowIndex, i);
                row.add(val);
                ++i;
            }
            this.cacheOriginalValues.put(viewIdKey, row);
        }
    }

    @Override
    public void tableChanged(WTableModelEvent event) {
        if (this.hasEditable && event.getColumn() == 0) {
            int row = event.getFirstRow();
            while (row <= event.getLastRow()) {
                Object col0 = this.contentPanel.getValueAt(row, 0);
                if (col0 instanceof IDColumn) {
                    IDColumn idc = (IDColumn)col0;
                    if (idc.isSelected()) {
                        this.cacheOriginalValues(row);
                    } else {
                        this.restoreOriginalValues(row);
                    }
                }
                ++row;
            }
            Clients.resize((Component)this.contentPanel);
        }
        super.tableChanged(event);
    }

    @Override
    public void onQueryCallback(Event event) {
        super.onQueryCallback(event);
        this.enableExportButton();
    }

    @Override
    protected void updateListSelected() {
        if (this.hasEditable) {
            this.temporarySelectedData = new HashMap<Integer, List<Object>>();
            ListModelTable model = this.contentPanel.getModel();
            int[] nArray = this.contentPanel.getSelectedIndices();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int rowIndex = nArray[n2];
                Integer keyViewValue = this.getColumnValue(rowIndex);
                List row = (List)model.get(rowIndex);
                ArrayList clonedRow = new ArrayList(row);
                this.temporarySelectedData.put(keyViewValue, clonedRow);
                ++n2;
            }
            for (Map.Entry entry : this.recordSelectedData.entrySet()) {
                ArrayList clonedRow = new ArrayList((Collection)entry.getValue());
                this.temporarySelectedData.put((Integer)entry.getKey(), clonedRow);
            }
        }
        super.updateListSelected();
    }

    @Override
    protected void restoreSelectedInPage() {
        super.restoreSelectedInPage();
        if (this.temporarySelectedData != null) {
            this.temporarySelectedData.clear();
            this.temporarySelectedData = null;
        }
    }

    @Override
    public boolean onRestoreSelectedItemIndexInPage(Integer keyViewValue, int rowIndex, Object oRow) {
        if (this.hasEditable && this.temporarySelectedData != null) {
            this.cacheOriginalValues(rowIndex);
            int gridFieldsOffset = 1;
            List row = (List)oRow;
            List<Object> originalSelectedRow = this.temporarySelectedData.get(keyViewValue);
            ListModelTable model = this.contentPanel.getModel();
            model.removeTableModelListener(this);
            int i = 0;
            while (i < this.infoColumns.length) {
                if (!this.infoColumns[i].isReadOnly()) {
                    int colIndex = i + gridFieldsOffset;
                    Object obj = originalSelectedRow.get(colIndex);
                    model.setValueAt(obj, rowIndex, colIndex);
                }
                ++i;
            }
            IDColumn id = (IDColumn)row.get(0);
            if (id instanceof IDColumn) {
                IDColumn idc = id;
                idc.setSelected(true);
            }
            model.addTableModelListener(this);
        }
        return super.onRestoreSelectedItemIndexInPage(keyViewValue, rowIndex, oRow);
    }

    protected void initExport() {
        this.exportButton = ButtonFactory.createNamedButton("Export", false, true);
        this.exportButton.setId("Export");
        this.exportButton.setEnabled(false);
        this.exportButton.addEventListener("onClick", new XlsExportAction());
        this.confirmPanel.addComponentsLeft(this.exportButton);
    }

    protected void enableExportButton() {
        if (this.exportButton == null) {
            return;
        }
        this.exportButton.setEnabled(this.contentPanel.getRowCount() > 0);
    }

    private class XlsExportAction
    implements EventListener<Event> {
        private XlsExportAction() {
        }

        public void onEvent(Event evt) throws Exception {
            if (evt.getTarget() == InfoWindow.this.exportButton) {
                XlsExporter exporter = new XlsExporter();
                exporter.doExport();
            }
        }
    }

    private class XlsExporter
    extends AbstractExcelExporter {
        private ResultSet m_rs = null;
        private int rowCount = -1;
        private int currentRow = -1;

        private XlsExporter() {
        }

        public void doExport() throws Exception {
            int originalCount = InfoWindow.this.m_count;
            String dataSql = InfoWindow.this.buildDataSQL(0, 0);
            File file = File.createTempFile("Export", ".xls");
            InfoWindow.this.testCount();
            this.rowCount = InfoWindow.this.m_count;
            InfoWindow.this.m_count = originalCount;
            if (this.rowCount > 0) {
                block6: {
                    CPreparedStatement pstmt = null;
                    Trx trx = null;
                    try {
                        try {
                            String trxName = Trx.createTrxName((String)"InfoPanelLoad:");
                            trx = Trx.get((String)trxName, (boolean)true);
                            trx.setDisplayName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_exportXls");
                            pstmt = DB.prepareStatement((String)dataSql, (String)trxName);
                            InfoWindow.this.setParameters((PreparedStatement)pstmt, false);
                            pstmt.setFetchSize(100);
                            this.m_rs = pstmt.executeQuery();
                            this.export(file, null);
                        }
                        catch (SQLException e) {
                            this.log.log(Level.SEVERE, dataSql, (Throwable)e);
                            DB.close((ResultSet)this.m_rs, pstmt);
                            trx.close();
                            this.m_rs = null;
                            this.currentRow = -1;
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close((ResultSet)this.m_rs, pstmt);
                        trx.close();
                        this.m_rs = null;
                        this.currentRow = -1;
                        throw throwable;
                    }
                    DB.close((ResultSet)this.m_rs, (Statement)pstmt);
                    trx.close();
                    this.m_rs = null;
                    this.currentRow = -1;
                }
                AMedia media = null;
                media = new AMedia(file.getName(), null, "application/vnd.ms-excel", file, true);
                Filedownload.save((Media)media);
            }
        }

        public boolean isFunctionRow() {
            return false;
        }

        public int getColumnCount() {
            return InfoWindow.this.columnInfos.length;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        protected void setCurrentRow(int row) {
            if (row > this.currentRow) {
                try {
                    this.m_rs.next();
                    this.currentRow = row;
                }
                catch (SQLException e) {
                    throw new AdempiereException((Throwable)e);
                }
            }
        }

        protected int getCurrentRow() {
            return this.currentRow;
        }

        public boolean isColumnPrinted(int col) {
            return InfoWindow.this.columnInfos[col].getGridField() != null;
        }

        public String getHeaderName(int col) {
            return InfoWindow.this.columnInfos[col].getColHeader();
        }

        public int getDisplayType(int row, int col) {
            int displayType = -1;
            GridField gridField = InfoWindow.this.columnInfos[col].getGridField();
            displayType = gridField.getDisplayType();
            return displayType;
        }

        public Object getValueAt(int row, int col) {
            Object val = null;
            try {
                val = this.m_rs.getObject(col + 1);
            }
            catch (SQLException e) {
                throw new AdempiereException((Throwable)e);
            }
            GridField gridField = InfoWindow.this.columnInfos[col].getGridField();
            Lookup lookup = gridField.getLookup();
            if (lookup != null) {
                val = lookup.getDisplay(val);
            }
            return val;
        }

        public boolean isPageBreak(int row, int col) {
            return false;
        }
    }
}

