/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.grid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WLocationEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.GridWindow;
import org.compiere.model.MField;
import org.compiere.model.MLookup;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Span;
import org.zkoss.zul.Vlayout;

public class WQuickEntry
extends Window
implements EventListener<Event>,
ValueChangeListener {
    private static final long serialVersionUID = -1397302187339942732L;
    public static final String QUICK_ENTRY_MODE = "_QUICK_ENTRY_MODE_";
    public static final String QUICK_ENTRY_CALLER_WINDOW = "_QUICK_ENTRY_CALLER_WINDOW_";
    private static CLogger log = CLogger.getCLogger(WQuickEntry.class);
    protected int m_WindowNo;
    private int parent_WindowNo;
    List<GridField> quickFields = new ArrayList<GridField>();
    protected List<WEditor> quickEditors = new ArrayList<WEditor>();
    List<Object> initialValues = new ArrayList<Object>();
    List<GridTab> quickTabs = new ArrayList<GridTab>();
    List<PO> quickPOs = new ArrayList<PO>();
    private boolean m_readOnly = false;
    protected Vlayout centerPanel = new Vlayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, false, false, false, false, false);
    protected int m_AD_Window_ID;
    private boolean isHasField = false;
    private String orientation;

    public WQuickEntry(int WindowNo, int AD_Window_ID) {
        this.m_AD_Window_ID = AD_Window_ID;
        this.parent_WindowNo = WindowNo;
        this.m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
        log.info("R/O=" + this.m_readOnly);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)QUICK_ENTRY_MODE, (String)"Y");
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)QUICK_ENTRY_CALLER_WINDOW, (int)this.parent_WindowNo);
        this.initPOs();
    }

    public WQuickEntry(int AD_Window_ID) {
        this.m_AD_Window_ID = AD_Window_ID;
        this.parent_WindowNo = 0;
        this.m_WindowNo = 0;
        log.info("R/O=" + this.m_readOnly);
    }

    private void jbInit() throws Exception {
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 350);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
            });
        }
        this.setSclass("quick-entry-dialog");
        this.setBorder("normal");
        this.setClosable(true);
        this.setSizable(true);
        this.appendChild((Component)this.centerPanel);
        this.appendChild((Component)this.confirmPanel);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.centerPanel, "100%");
        this.confirmPanel.addActionListener("onClick", this);
        if (ClientInfo.isMobile()) {
            if (ClientInfo.maxWidth(500) || ClientInfo.maxHeight(500)) {
                this.confirmPanel.addButtonSclass("btn-small small-image-btn");
            }
            this.orientation = ClientInfo.get().orientation;
            ClientInfo.onClientInfo((Component)this, this::onClientInfo);
        }
    }

    protected void onClientInfo() {
        String newOrientation;
        if (this.getPage() != null && !(newOrientation = ClientInfo.get().orientation).equals(this.orientation)) {
            this.orientation = newOrientation;
            ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
            this.invalidate();
        }
    }

    protected void initPOs() {
        GridWindow gridwindow = GridWindow.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)this.m_AD_Window_ID);
        this.setTitle(gridwindow.getName());
        boolean newTab = false;
        int i = 0;
        while (i < gridwindow.getTabCount()) {
            GridTab gridtab = gridwindow.getTab(i);
            if (i == 0) {
                boolean bl = this.m_readOnly = !MRole.getDefault().canUpdate(Env.getAD_Client_ID((Properties)Env.getCtx()), Env.getAD_Org_ID((Properties)Env.getCtx()), gridtab.getAD_Table_ID(), 0, false);
            }
            if (!gridtab.isLoadComplete()) {
                gridwindow.initTab(i);
            }
            GridField[] gridFieldArray = gridtab.getFields();
            int n = gridFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                GridField gridfield = gridFieldArray[n2];
                MField field = new MField(Env.getCtx(), gridfield.getAD_Field_ID(), null);
                if (field.isQuickEntry() && this.isValidQuickEntryType(field.getAD_Reference_ID())) {
                    WEditor editor = WebEditorFactory.getEditor(gridfield, false);
                    if (this.m_readOnly) {
                        editor.setReadWrite(false);
                    }
                    if (gridfield.isMandatory(false)) {
                        editor.setMandatory(true);
                    }
                    this.createLine(editor, newTab, gridtab);
                    this.quickFields.add(gridfield);
                    this.quickEditors.add(editor);
                    editor.addValueChangeListener(this);
                    if (!this.quickTabs.contains(gridtab)) {
                        this.quickTabs.add(gridtab);
                    }
                    this.isHasField = true;
                    newTab = false;
                }
                ++n2;
            }
            newTab = true;
            ++i;
        }
    }

    private boolean isValidQuickEntryType(int refID) {
        boolean valid = refID != 28 && refID != 23 && refID != 13;
        return valid;
    }

    private void createLine(WEditor editor, boolean newTab, GridTab gt) {
        if (newTab) {
            Separator sep = new Separator();
            this.centerPanel.appendChild((Component)sep);
            Label tabLabel = new Label(gt.getName());
            this.centerPanel.appendChild((Component)tabLabel);
            Separator sepl = new Separator();
            sepl.setBar(true);
            this.centerPanel.appendChild((Component)sepl);
        }
        Component field = editor.getComponent();
        Hlayout layout = new Hlayout();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)layout, "10");
        Span span = new Span();
        if (this.parent_WindowNo != 0) {
            ZKUpdateUtil.setHflex((HtmlBasedComponent)span, "3");
        }
        layout.appendChild((Component)span);
        Label label = editor.getLabel();
        span.appendChild((Component)label);
        label.setSclass("field-label");
        layout.appendChild(field);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)field, "7");
        this.centerPanel.appendChild((Component)layout);
    }

    public boolean isAvailableQuickEdit() {
        return this.isHasField && !this.m_readOnly;
    }

    public boolean loadRecord(int Record_ID) {
        GridField field;
        int idxf;
        String parentColumn = null;
        int idxt = 0;
        while (idxt < this.quickTabs.size()) {
            int parentid;
            GridTab gridtab = this.quickTabs.get(idxt);
            int id = 0;
            if (idxt == 0) {
                id = Record_ID;
                parentColumn = String.valueOf(gridtab.getTableName()) + "_ID";
            } else if (Record_ID > 0) {
                String columnname = String.valueOf(gridtab.getTableName()) + "_ID";
                id = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.parent_WindowNo, (String)columnname, (boolean)true);
            }
            MQuery query = new MQuery(gridtab.getAD_Table_ID());
            if (id == 0) {
                query.addRestriction("1=2");
                gridtab.setQuery(query);
                gridtab.query(false);
                if (gridtab.isInsertRecord()) {
                    gridtab.dataNew(false);
                }
            } else {
                if (gridtab.getTabNo() == 0) {
                    query.addRestriction(gridtab.getKeyColumnName(), "=", id);
                }
                gridtab.setQuery(query);
                gridtab.query(false);
            }
            this.quickTabs.set(idxt, gridtab);
            MTable table2 = MTable.get((Properties)Env.getCtx(), (String)gridtab.getTableName());
            PO po = table2.getPO(id, null);
            if (idxt > 0 && (parentid = po.get_ValueAsInt(parentColumn)) != Record_ID) {
                po = table2.getPO(0, null);
            }
            this.quickPOs.add(po);
            ++idxt;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Record_ID=" + Record_ID);
        }
        if (Record_ID == 0) {
            idxf = 0;
            while (idxf < this.quickFields.size()) {
                field = this.quickFields.get(idxf);
                WEditor editor = this.quickEditors.get(idxf);
                Object value = field.getDefault();
                if (value != null) {
                    editor.setValue(value);
                    field.setValue(value, true);
                    field.getGridTab().processCallout(field);
                }
                this.initialValues.add(editor.getValue());
                ++idxf;
            }
            this.dynamicDisplay();
            return true;
        }
        if (this.quickPOs.get(0).get_ID() == 0) {
            FDialog.error(this.m_WindowNo, (Component)this, "RecordNotFound");
            return false;
        }
        idxf = 0;
        while (idxf < this.quickFields.size()) {
            field = this.quickFields.get(idxf);
            WEditor editor = this.quickEditors.get(idxf);
            int idxt2 = this.quickTabs.indexOf(field.getGridTab());
            PO po = this.quickPOs.get(idxt2);
            Object value = po.get_Value(field.getColumnName());
            if (value != null) {
                editor.setValue(value);
                field.setValue(value, false);
            } else {
                editor.dynamicDisplay();
            }
            this.initialValues.add(editor.getValue());
            ++idxf;
        }
        this.dynamicDisplay();
        return true;
    }

    protected boolean actionSave() {
        log.config("");
        boolean anyChange = false;
        int idxf = 0;
        while (idxf < this.quickEditors.size()) {
            boolean changed;
            WEditor editor = this.quickEditors.get(idxf);
            Object value = editor.getValue();
            Object initialValue = this.initialValues.get(idxf);
            boolean bl = changed = value != null && initialValue == null || value == null && initialValue != null || value != null && initialValue != null && !value.equals(initialValue);
            if (changed) {
                anyChange = true;
            }
            ++idxf;
        }
        if (anyChange) {
            for (GridField field : this.quickFields) {
                String msg = field.getGridTab().processCallout(field);
                if (Util.isEmpty((String)msg)) continue;
                FDialog.error(this.m_WindowNo, (Component)this, "", msg);
                return false;
            }
        }
        int parentID = 0;
        String parentColumn = null;
        String tabZeroName = null;
        boolean isParentSave = this.getRecord_ID() > 0;
        int idxt = 0;
        while (idxt < this.quickTabs.size()) {
            GridField field;
            GridTab gridtab = this.quickTabs.get(idxt);
            PO po = this.quickPOs.get(idxt);
            if (idxt == 0) {
                parentColumn = String.valueOf(gridtab.getTableName()) + "_ID";
                tabZeroName = gridtab.getName();
            }
            boolean savePO = false;
            boolean fillMandatoryError = false;
            StringBuilder mandatoryFields = new StringBuilder();
            int idxf2 = 0;
            while (idxf2 < this.quickFields.size()) {
                field = this.quickFields.get(idxf2);
                if (field.getGridTab() == gridtab) {
                    WEditor editor = this.quickEditors.get(idxf2);
                    Object value = editor.getValue();
                    Object initialValue = this.initialValues.get(idxf2);
                    boolean changed = value != null && initialValue == null || value == null && initialValue != null || value != null && initialValue != null && !value.equals(initialValue);
                    boolean thisMandatoryError = false;
                    if (field.isMandatory(true) && (value == null || value.toString().length() == 0)) {
                        fillMandatoryError = true;
                        thisMandatoryError = true;
                        if (mandatoryFields.length() > 0) {
                            mandatoryFields.append(", ");
                        }
                        mandatoryFields.append(Msg.getElement((Properties)Env.getCtx(), (String)field.getColumnName()));
                    }
                    po.set_ValueOfColumn(field.getColumnName(), value);
                    if (changed && !thisMandatoryError) {
                        savePO = true;
                    }
                }
                ++idxf2;
            }
            if (savePO && fillMandatoryError) {
                FDialog.error(this.m_WindowNo, (Component)this, "FillMandatory", mandatoryFields.toString());
                return false;
            }
            if (savePO) {
                int actualID;
                if (idxt > 0 && (actualID = po.get_ValueAsInt(parentColumn)) != parentID) {
                    po.set_ValueOfColumn(parentColumn, (Object)parentID);
                }
                if (gridtab.getTabLevel() > 0 && !isParentSave) {
                    FDialog.error(this.m_WindowNo, (Component)this, "FillMinimumInfo", tabZeroName);
                    return false;
                }
                po.saveEx();
                if (gridtab.getTabLevel() == 0) {
                    isParentSave = true;
                }
                idxf2 = 0;
                while (idxf2 < this.quickFields.size()) {
                    WEditor we;
                    field = this.quickFields.get(idxf2);
                    if (field.getGridTab() == gridtab && po.get_Value((we = this.quickEditors.get(idxf2)).getColumnName()) != null) {
                        we.setValue(po.get_Value(we.getColumnName()));
                    }
                    ++idxf2;
                }
            }
            if (idxt == 0) {
                parentID = po.get_ID();
            }
            ++idxt;
        }
        return true;
    }

    public int getRecord_ID() {
        if (this.quickPOs.isEmpty() || this.quickPOs.get(0) == null) {
            return 0;
        }
        return this.quickPOs.get(0).get_ID();
    }

    public void onEvent(Event e) throws Exception {
        if (this.m_readOnly) {
            this.detach();
        } else if (e.getTarget() == this.confirmPanel.getButton("Ok") && this.actionSave()) {
            this.detach();
        } else if (e.getTarget() == this.confirmPanel.getButton("Cancel")) {
            this.detach();
        }
    }

    public void detach() {
        super.detach();
        if (this.m_WindowNo != 0) {
            SessionManager.getAppDesktop().unregisterWindow(this.m_WindowNo);
        }
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        int idx;
        if (evt.getSource() instanceof WEditor && (idx = this.quickEditors.indexOf(evt.getSource())) >= 0) {
            GridField field = this.quickFields.get(idx);
            WEditor editor = this.quickEditors.get(idx);
            GridTab gridTab = field.getGridTab();
            String columnName = field.getColumnName();
            GridTable mTable = gridTab.getTableModel();
            int row = gridTab.getCurrentRow();
            int col = mTable.findColumn(columnName);
            if (!(evt.getSource() instanceof WLocationEditor) || evt.getNewValue() != null || editor.getValue() == null) {
                mTable.setValueAt(evt.getNewValue(), row, col);
                field.setValue(evt.getNewValue(), field.getGridTab().getTableModel().isInserting());
                gridTab.processFieldChange(field);
            }
            ArrayList dependants = gridTab.getDependantFields(columnName);
            for (GridField dependentField : dependants) {
                MLookup mLookup;
                if (dependentField == null || !(dependentField.getLookup() instanceof MLookup) || (mLookup = (MLookup)dependentField.getLookup()).getValidation().indexOf("@" + columnName + "@") == -1) continue;
                mLookup.refresh();
            }
            this.dynamicDisplay();
        }
    }

    public void dynamicDisplay() {
        int idxf = 0;
        while (idxf < this.quickFields.size()) {
            GridField field = this.quickFields.get(idxf);
            GridTab gridTab = field.getGridTab();
            String columnName = field.getColumnName();
            GridTable mTable = gridTab.getTableModel();
            int row = gridTab.getCurrentRow();
            int col = mTable.findColumn(columnName);
            WEditor editor = this.quickEditors.get(idxf);
            editor.setValue(mTable.getValueAt(row, col));
            editor.setReadWrite(field.isEditable(true));
            editor.setVisible(field.isDisplayed(true));
            ++idxf;
        }
    }

    public int getQuickFields() {
        return this.quickFields.size();
    }
}

