/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.factory;

import java.util.Properties;
import javax.activation.DataSource;
import javax.xml.bind.DatatypeConverter;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.FeedbackRequestWindow;
import org.adempiere.webui.factory.IFeedbackService;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.FeedbackManager;
import org.adempiere.webui.window.WEMailDialog;
import org.compiere.model.MSystem;
import org.compiere.model.MUser;
import org.compiere.util.ByteArrayDataSource;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Window;

public class DefaultFeedbackService
implements IFeedbackService {
    @Override
    public void emailSupport(boolean errorOnly) {
        new EmailSupportAction(errorOnly);
    }

    @Override
    public void createNewRequest() {
        new CreateNewRequestAction();
    }

    protected static class CreateNewRequestAction
    implements EventListener<Event> {
        protected CreateNewRequestAction() {
            SessionManager.getAppDesktop().getComponent().addEventListener("onCreateFeedbackRequest", (EventListener)this);
            String script = "html2canvas(document.body, { onrendered: function(canvas) { var dataUrl = canvas.toDataURL();  var widget = zk.Widget.$('#" + SessionManager.getAppDesktop().getComponent().getUuid() + "');" + "  var event = new zk.Event(widget, 'onCreateFeedbackRequest', dataUrl, {toServer: true});" + "  zAu.send(event); } " + "});";
            Clients.response((AuResponse)new AuScript(script));
        }

        public void onEvent(Event event) throws Exception {
            SessionManager.getAppDesktop().getComponent().removeEventListener("onCreateFeedbackRequest", (EventListener)this);
            String dataUrl = (String)event.getData();
            byte[] imageBytes = null;
            if (dataUrl != null && dataUrl.startsWith("data:image/png;base64,")) {
                try {
                    String img64 = dataUrl.substring("data:image/png;base64,".length()).trim();
                    imageBytes = DatatypeConverter.parseBase64Binary((String)img64);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.showRequestDialog(imageBytes);
        }

        protected void showRequestDialog(byte[] imageBytes) {
            FeedbackRequestWindow window = new FeedbackRequestWindow();
            AEnv.showWindow(window);
            if (imageBytes != null && imageBytes.length > 0) {
                ByteArrayDataSource screenShot = new ByteArrayDataSource(imageBytes, "image/png");
                screenShot.setName("screenshot.png");
                window.addAttachment((DataSource)screenShot, true);
            }
            window.focus();
        }
    }

    protected static class EmailSupportAction
    implements EventListener<Event> {
        private boolean errorOnly;

        protected EmailSupportAction(boolean errorOnly) {
            this.errorOnly = errorOnly;
            SessionManager.getAppDesktop().getComponent().addEventListener("onEmailSupport", (EventListener)this);
            String script = "html2canvas(document.body, { onrendered: function(canvas) { var dataUrl = canvas.toDataURL();  var widget = zk.Widget.$('#" + SessionManager.getAppDesktop().getComponent().getUuid() + "');" + "  var event = new zk.Event(widget, 'onEmailSupport', dataUrl, {toServer: true});" + "  zAu.send(event); } " + "});";
            Clients.response((AuResponse)new AuScript(script));
        }

        public void onEvent(Event event) throws Exception {
            SessionManager.getAppDesktop().getComponent().removeEventListener("onEmailSupport", (EventListener)this);
            String dataUrl = (String)event.getData();
            byte[] imageBytes = null;
            if (dataUrl != null && dataUrl.startsWith("data:image/png;base64,")) {
                try {
                    String img64 = dataUrl.substring("data:image/png;base64,".length()).trim();
                    imageBytes = DatatypeConverter.parseBase64Binary((String)img64);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.showEmailDialog(imageBytes);
        }

        protected String getFeedbackSubject() {
            String feedBackHeader = Msg.getMsg((Properties)Env.getCtx(), (String)"FeedBackHeader");
            return Env.parseContext((Properties)Env.getCtx(), (int)0, (String)feedBackHeader, (boolean)false, (boolean)false);
        }

        protected void showEmailDialog(byte[] imageBytes) {
            DataSource ds = FeedbackManager.getLogAttachment(this.errorOnly);
            WEMailDialog dialog = new WEMailDialog(Msg.getMsg((Properties)Env.getCtx(), (String)"EMailSupport"), MUser.get((Properties)Env.getCtx()), "", this.getFeedbackSubject(), "", ds);
            dialog.setAttribute("mode", Window.Mode.OVERLAPPED);
            MSystem system = MSystem.get((Properties)Env.getCtx());
            if (!Util.isEmpty((String)system.getSupportEMail())) {
                dialog.addTo(system.getSupportEMail(), true);
            }
            AEnv.showWindow(dialog);
            if (imageBytes != null && imageBytes.length > 0) {
                ByteArrayDataSource screenShot = new ByteArrayDataSource(imageBytes, "image/png");
                screenShot.setName("screenshot.png");
                dialog.addAttachment((DataSource)screenShot, true);
            }
            dialog.focus();
        }
    }
}

