/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.factory;

import java.util.Properties;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.model.MSysConfig;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.HtmlBasedComponent;

public class ButtonFactory {
    public static final boolean isWithText() {
        String type = MSysConfig.getValue((String)"ZK_BUTTON_STYLE", (String)"I");
        return type.indexOf("T") >= 0;
    }

    public static final boolean isWithImage() {
        String type = MSysConfig.getValue((String)"ZK_BUTTON_STYLE", (String)"I");
        return type.indexOf("I") >= 0;
    }

    public static Button createNamedButton(String name) {
        return ButtonFactory.createNamedButton(name, ButtonFactory.isWithText(), ButtonFactory.isWithImage());
    }

    public static Button createNamedButton(String name, boolean withText, boolean withImage) {
        Button button = new Button();
        button.setName("btn" + name);
        String text = Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)name));
        if (withText && text != null) {
            button.setLabel(text);
            if (withImage) {
                if (ThemeManager.isUseFontIconForImage()) {
                    button.setIconSclass("z-icon-" + name);
                } else {
                    button.setImage(ThemeManager.getThemeResource("images/" + name + "16.png"));
                }
            }
            LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)button);
        } else {
            if (ThemeManager.isUseFontIconForImage()) {
                button.setIconSclass("z-icon-" + name);
            } else {
                button.setImage(ThemeManager.getThemeResource("images/" + name + "24.png"));
            }
            if (text != null) {
                button.setTooltiptext(text);
            }
            LayoutUtils.addSclass("img-btn", (HtmlBasedComponent)button);
        }
        String className = "btn-" + name.toLowerCase();
        LayoutUtils.addSclass(className, (HtmlBasedComponent)button);
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("font-icon-button", (HtmlBasedComponent)button);
        }
        return button;
    }

    public static Button createButton(String label, String image, String tooltiptext) {
        Button button = new Button();
        if (!Util.isEmpty((String)label)) {
            button.setLabel(label);
            if (!Util.isEmpty((String)image)) {
                button.setImage(image);
                LayoutUtils.addSclass("img-txt-btn", (HtmlBasedComponent)button);
            } else {
                LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)button);
            }
        } else if (!Util.isEmpty((String)image)) {
            button.setImage(image);
            LayoutUtils.addSclass("img-btn", (HtmlBasedComponent)button);
        }
        if (!Util.isEmpty((String)tooltiptext)) {
            button.setTooltiptext(tooltiptext);
        }
        return button;
    }
}

