/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor.grid.selection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;
import org.adempiere.model.MTabCustomization;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.editor.grid.selection.GridTabSelectionListViewRenderer;
import org.adempiere.webui.editor.grid.selection.SimpleGridTableListModel;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.MSysConfig;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.South;
import org.zkoss.zul.ext.Selectable;

public class GridTabSelectionListView
extends Borderlayout {
    private static final long serialVersionUID = 4145737989132101461L;
    private static final int MIN_COLUMN_WIDTH = 100;
    private static final int MAX_COLUMN_WIDTH = 300;
    private Listbox listbox = null;
    private int pageSize = 100;
    private GridField[] gridField;
    private AbstractTableModel tableModel;
    private int numColumns = 5;
    private int windowNo;
    private GridTab gridTab;
    private boolean init;
    private SimpleGridTableListModel listModel;
    private GridTabSelectionListViewRenderer renderer;
    private South south;
    private Map<Integer, String> columnWidthMap;
    private Label selectedLabel;

    public GridTabSelectionListView(boolean multiple) {
        this(multiple, 0);
    }

    public GridTabSelectionListView(boolean multiple, int windowNo) {
        this.windowNo = windowNo;
        this.listbox = new Listbox();
        this.listbox.setCheckmark(true);
        this.listbox.setMultiple(multiple);
        this.south = new South();
        this.appendChild((Component)this.south);
        this.pageSize = MSysConfig.getIntValue((String)"ZK_PAGING_SIZE", (int)100);
        this.listbox.setMold("paging");
        this.listbox.setPageSize(this.pageSize);
        this.setStyle("min-height: 200px;");
    }

    public void init(GridTab gridTab) {
        if (this.init) {
            return;
        }
        this.setupFields(gridTab);
        this.setupColumns();
        this.render();
        this.init = true;
    }

    private void setupFields(GridTab gridTab) {
        this.gridTab = gridTab;
        this.tableModel = gridTab.getTableModel();
        GridField[] tmpFields = ((GridTable)this.tableModel).getFields();
        MTabCustomization tabCustomization = MTabCustomization.get((Properties)Env.getCtx(), (int)Env.getAD_User_ID((Properties)Env.getCtx()), (int)gridTab.getAD_Tab_ID(), null);
        if (tabCustomization != null && tabCustomization.getAD_Tab_Customization_ID() > 0 && tabCustomization.getCustom() != null && tabCustomization.getCustom().trim().length() > 0) {
            String custom = tabCustomization.getCustom().trim();
            String[] customComponent = custom.split(";");
            String[] fieldIds = customComponent[0].split("[,]");
            ArrayList<GridField> fieldList = new ArrayList<GridField>();
            String[] stringArray = fieldIds;
            int n = fieldIds.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldIdStr = stringArray[n2];
                if ((fieldIdStr = fieldIdStr.trim()).length() != 0) {
                    int AD_Field_ID = Integer.parseInt(fieldIdStr);
                    GridField[] gridFieldArray = tmpFields;
                    int n3 = tmpFields.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        GridField gridField = gridFieldArray[n4];
                        if (gridField.getAD_Field_ID() == AD_Field_ID) {
                            fieldList.add(gridField);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            this.gridField = fieldList.toArray(new GridField[0]);
            if (customComponent.length == 2) {
                String[] widths = customComponent[1].split("[,]");
                int i = 0;
                while (i < this.gridField.length) {
                    this.columnWidthMap.put(this.gridField[i].getAD_Field_ID(), widths[i]);
                    ++i;
                }
            }
        } else {
            this.gridField = tmpFields;
        }
        this.numColumns = this.gridField.length;
    }

    public boolean isInit() {
        return this.init;
    }

    public void activate(GridTab gridTab) {
        if (this.isInit()) {
            if (this.gridTab != gridTab) {
                this.init = false;
                this.init(gridTab);
            }
        } else {
            this.init(gridTab);
        }
    }

    public void refresh(GridTab gridTab) {
        gridTab.query(false, 0, 0);
        gridTab.getTableModel().fireTableDataChanged();
        if (this.gridTab != gridTab) {
            this.init = false;
            this.init(gridTab);
        }
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void clear() {
        this.getChildren().clear();
    }

    private void setupColumns() {
        if (this.init) {
            return;
        }
        ListHead header = new ListHead();
        header.setSizable(true);
        ListHeader selectionHeader = new ListHeader();
        selectionHeader.setWidth("40px");
        selectionHeader.setAlign("center");
        header.appendChild((Component)selectionHeader);
        HashMap<Integer, String> colnames = new HashMap<Integer, String>();
        int index = 0;
        int i = 0;
        while (i < this.numColumns) {
            if (this.gridField[i].isDisplayed() && this.gridField[i].isDisplayedGrid()) {
                colnames.put(index, this.gridField[i].getHeader());
                ++index;
                ListHeader colHeader = new ListHeader();
                colHeader.setSort("auto");
                colHeader.setLabel(this.gridField[i].getHeader());
                colHeader.setAttribute("ColumnIndex", this.getColumnIndex(this.gridField[i].getColumnName()));
                if (this.columnWidthMap != null && this.columnWidthMap.get(this.gridField[i].getAD_Field_ID()) != null) {
                    colHeader.setWidth(this.columnWidthMap.get(this.gridField[i].getAD_Field_ID()));
                } else {
                    int l;
                    int n = l = DisplayType.isNumeric((int)this.gridField[i].getDisplayType()) ? 100 : this.gridField[i].getDisplayLength() * 9;
                    if (this.gridField[i].getHeader().length() * 9 > l) {
                        l = this.gridField[i].getHeader().length() * 9;
                    }
                    if (l > 300) {
                        l = 300;
                    } else if (l < 100) {
                        l = 100;
                    }
                    colHeader.setWidth(String.valueOf(Integer.toString(l)) + "px");
                }
                header.appendChild((Component)colHeader);
            }
            ++i;
        }
        this.listbox.appendChild((Component)header);
    }

    private int getColumnIndex(String columnName) {
        int i = 0;
        while (i < this.gridTab.getTableModel().getColumnCount()) {
            if (this.gridTab.getTableModel().getColumnName(i).equals(columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void render() {
        this.listbox.setStyle("min-height: 200px");
        this.listbox.setVflex(true);
        this.listbox.setHflex("1");
        this.listbox.setSizedByContent(true);
        this.updateModel();
        Center center = new Center();
        center.appendChild((Component)this.listbox);
        this.appendChild((Component)center);
        this.selectedLabel = new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected")) + " : 0");
        this.south.appendChild((Component)this.selectedLabel);
    }

    private void updateModel() {
        this.listModel = new SimpleGridTableListModel((GridTable)this.tableModel, this.windowNo);
        this.listModel.setMultiple(this.listbox.isMultiple());
        this.renderer = new GridTabSelectionListViewRenderer(this.gridTab, this.windowNo);
        this.renderer.setListView(this);
        this.listbox.setItemRenderer(this.renderer);
        this.listbox.setModel((ListModel)this.listModel);
    }

    public void deactivate() {
    }

    public Listbox getListbox() {
        return this.listbox;
    }

    public void setWindowNo(int windowNo) {
        this.windowNo = windowNo;
    }

    public GridField[] getFields() {
        return this.gridField;
    }

    public boolean addEventListener(int priority, String evtnm, EventListener<? extends Event> listener) {
        if ("onSelect".equals(evtnm)) {
            return this.listbox.addEventListener(priority, evtnm, listener);
        }
        return super.addEventListener(priority, evtnm, listener);
    }

    public void setSelectedIndices(int[] selectedIndices) {
        ListModel model = this.listbox.getModel();
        if (model != null && model instanceof Selectable) {
            HashSet<Object> selection = new HashSet<Object>();
            Selectable selectable = (Selectable)model;
            int[] nArray = selectedIndices;
            int n = selectedIndices.length;
            int n2 = 0;
            while (n2 < n) {
                int selected = nArray[n2];
                selection.add(model.getElementAt(selected));
                ++n2;
            }
            selectable.setSelection(selection);
        } else {
            this.listbox.setSelectedIndices(selectedIndices);
        }
        this.selectedLabel.setValue(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected")) + " : " + selectedIndices.length);
    }

    public void clearSelection() {
        ListModel model = this.listbox.getModel();
        if (model != null && model instanceof Selectable) {
            Selectable selectable = (Selectable)model;
            selectable.clearSelection();
        } else {
            this.listbox.clearSelection();
        }
        this.selectedLabel.setValue(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected")) + " : 0");
    }

    public void setSelectedIndex(int selected) {
        ListModel model = this.listbox.getModel();
        if (model != null && model instanceof Selectable) {
            Selectable selectable = (Selectable)model;
            HashSet<Object> selection = new HashSet<Object>();
            selection.add(model.getElementAt(selected));
            selectable.setSelection(selection);
            this.selectedLabel.setValue(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected")) + " : " + selection.size());
        } else {
            this.listbox.setSelectedIndex(selected);
            this.selectedLabel.setValue(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected")) + " : " + this.listbox.getSelectedCount());
        }
    }
}

