/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.beans.PropertyChangeEvent;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public class WYesNoEditor
extends WEditor
implements ContextMenuListener {
    public static final String[] LISTENER_EVENTS = new String[]{"onCheck"};
    private static final CLogger logger = CLogger.getCLogger(WYesNoEditor.class);
    private boolean oldValue = false;

    public WYesNoEditor(GridField gridField) {
        super((Component)new Checkbox(), gridField);
        this.init();
    }

    public WYesNoEditor(String columnName, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super((Component)new Checkbox(), columnName, label, description, mandatory, readonly, updateable);
        this.init();
    }

    private void init() {
        if (this.gridField != null) {
            this.getComponent().setLabel(this.gridField.getHeader());
        } else {
            this.getComponent().setLabel(this.label.getValue());
        }
        this.label.setValue("");
        this.label.setTooltiptext("");
        this.popupMenu = new WEditorPopupMenu(false, false, this.isShowPreference());
        this.popupMenu.addMenuListener(this);
        this.addChangeLogMenu(this.popupMenu);
    }

    public void onEvent(Event event) {
        if ("onCheck".equalsIgnoreCase(event.getName())) {
            Boolean newValue = (Boolean)this.getValue();
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
            super.fireValueChange(changeEvent);
            this.oldValue = newValue;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public String getDisplay() {
        String display = this.getComponent().isChecked() ? "Y" : "N";
        return Msg.translate((Properties)Env.getCtx(), (String)display);
    }

    @Override
    public Object getValue() {
        return this.getComponent().isChecked();
    }

    @Override
    public void setValue(Object value) {
        if (value == null || value instanceof Boolean) {
            Boolean val = value == null ? false : (Boolean)value;
            this.getComponent().setChecked(val);
            this.oldValue = val;
        } else if (value instanceof String) {
            Boolean val = value.equals("Y");
            this.getComponent().setChecked(val);
            this.oldValue = val;
        } else {
            logger.log(Level.SEVERE, "New field value of unknown type, Type: " + value.getClass() + ", Value: " + value);
            this.getComponent().setChecked(false);
        }
    }

    public Checkbox getComponent() {
        return (Checkbox)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        } else if ("VALUE_PREFERENCE".equals(evt.getContextEvent()) && this.isShowPreference()) {
            ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
        }
    }
}

