/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.util.CLogger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Timebox;

public class WTimeEditor
extends WEditor
implements ContextMenuListener {
    private static final String[] LISTENER_EVENTS = new String[]{"onChange", "onOK"};
    private static final CLogger logger = CLogger.getCLogger(WDateEditor.class);
    private Timestamp oldValue = new Timestamp(0L);

    public WTimeEditor(GridField gridField) {
        super((Component)new Timebox(), gridField);
        this.init();
    }

    public WTimeEditor(String columnName, boolean mandatory, boolean readonly, boolean updateable, String title) {
        super((Component)new Timebox(), columnName, title, null, mandatory, readonly, updateable);
        this.init();
    }

    public WTimeEditor(String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super((Component)new Timebox(), label, description, mandatory, readonly, updateable);
        this.setColumnName("Time");
        this.init();
    }

    public WTimeEditor() {
        this("Time", "Time", false, false, true);
        this.init();
    }

    private void init() {
        this.getComponent().setCols(10);
        this.popupMenu = new WEditorPopupMenu(false, false, this.isShowPreference());
        this.popupMenu.addMenuListener(this);
        this.addChangeLogMenu(this.popupMenu);
        if (this.gridField != null) {
            this.getComponent().setPlaceholder(this.gridField.getPlaceholder());
        }
    }

    public void onEvent(Event event) {
        if ("onChange".equalsIgnoreCase(event.getName()) || "onOK".equalsIgnoreCase(event.getName())) {
            Date date = this.getComponent().getValue();
            Timestamp newValue = null;
            if (date != null) {
                newValue = new Timestamp(date.getTime());
            }
            if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
                return;
            }
            if (this.oldValue == null && newValue == null) {
                return;
            }
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
            super.fireValueChange(changeEvent);
            this.oldValue = newValue;
        }
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    @Override
    public Object getValue() {
        if (this.getComponent().getValue() == null) {
            return null;
        }
        return new Timestamp(this.getComponent().getValue().getTime());
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.oldValue = null;
            this.getComponent().setValue(null);
        } else if (value instanceof Timestamp) {
            this.getComponent().setValue((Date)((Timestamp)value));
            this.oldValue = (Timestamp)value;
        } else {
            logger.log(Level.SEVERE, "New field value is not of type timestamp");
        }
    }

    public Timebox getComponent() {
        return (Timebox)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return !this.getComponent().isReadonly();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setReadonly(!readWrite);
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void fillHorizontal() {
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        } else if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
            if (this.isShowPreference()) {
                ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
            }
            return;
        }
    }
}

