/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.beans.PropertyChangeEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.AutoComplete;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.editor.IZoomableEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.grid.WQuickEntry;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.adempiere.webui.window.WLocationDialog;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MLookup;
import org.compiere.model.MTable;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CacheInterface;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Menuitem;

public class WTableDirEditor
extends WEditor
implements ListDataListener,
ContextMenuListener,
IZoomableEditor {
    public static final String[] LISTENER_EVENTS = new String[]{"onSelect"};
    private static final CLogger logger = CLogger.getCLogger(WTableDirEditor.class);
    private Lookup lookup;
    private Object oldValue;
    public static final String SHORT_LIST_EVENT = "SHORT_LIST";
    protected boolean onlyShortListItems;
    private CCacheListener tableCacheListener;
    private boolean onselecting = false;

    public WTableDirEditor(GridField gridField) {
        this((Component)(gridField.isAutocomplete() ? new EditorAutoComplete() : new EditorCombobox()), gridField);
    }

    private WTableDirEditor(Component comp, GridField gridField) {
        super(comp, gridField);
        ((ITableDirEditor)((Object)this.getComponent())).setEditor(this);
        this.lookup = gridField.getLookup();
        this.init();
    }

    public WTableDirEditor(Lookup lookup, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        this(lookup, label, description, mandatory, readonly, updateable, false);
    }

    public WTableDirEditor(Lookup lookup, String label, String description, boolean mandatory, boolean readonly, boolean updateable, boolean autocomplete) {
        this((Component)(autocomplete ? new EditorAutoComplete() : new EditorCombobox()), lookup, label, description, mandatory, readonly, updateable);
    }

    private WTableDirEditor(Component comp, Lookup lookup, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super(comp, label, description, mandatory, readonly, updateable);
        ((ITableDirEditor)((Object)this.getComponent())).setEditor(this);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        super.setColumnName(lookup.getColumnName());
        this.init();
    }

    public WTableDirEditor(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, Lookup lookup) {
        this(columnName, mandatory, isReadOnly, isUpdateable, lookup, false);
    }

    public WTableDirEditor(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, Lookup lookup, boolean autocomplete) {
        this((Component)(autocomplete ? new EditorAutoComplete() : new EditorCombobox()), columnName, mandatory, isReadOnly, isUpdateable, lookup);
    }

    private WTableDirEditor(Component comp, String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, Lookup lookup) {
        super(comp, columnName, null, null, mandatory, isReadOnly, isUpdateable);
        ((ITableDirEditor)((Object)this.getComponent())).setEditor(this);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        this.init();
    }

    private void init() {
        int posPoint;
        String tableName_temp;
        String tableName;
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.getComponent(), "200px");
        this.getComponent().setAutocomplete(true);
        this.getComponent().setAutodrop(true);
        this.getComponent().addEventListener("onBlur", this);
        if (!(this.getComponent() instanceof EditorAutoComplete)) {
            this.getComponent().addEventListener("onChanging", this);
        }
        boolean zoom = false;
        if (this.lookup != null) {
            this.lookup.addListDataListener((ListDataListener)this);
            this.lookup.setMandatory(this.isMandatory());
            if (this.lookup.getDisplayType() == 17 && Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Role_ID") == 0 || this.lookup.getDisplayType() != 17) {
                zoom = true;
            }
            if (this.isReadWrite()) {
                this.lookup.refresh();
            } else {
                this.refreshList();
            }
        }
        this.popupMenu = (tableName = (tableName_temp = this.lookup.getColumnName()).substring(0, posPoint = tableName_temp.indexOf("."))).toUpperCase().equals("C_BPARTNER_LOCATION") ? new WEditorPopupMenu(true, true, this.isShowPreference(), false, false, true, this.lookup) : new WEditorPopupMenu(zoom, true, this.isShowPreference(), false, false, false, this.lookup);
        this.addChangeLogMenu(this.popupMenu);
        if (this.gridField != null) {
            boolean isShortListAvailable = false;
            if (this.lookup != null && (this.lookup.getDisplayType() == 19 || this.lookup.getDisplayType() == 18)) {
                MTable table2 = MTable.get((Properties)Env.getCtx(), (String)tableName);
                boolean bl = isShortListAvailable = table2.getColumnIndex("IsShortList") >= 0;
                if (isShortListAvailable) {
                    this.onlyShortListItems = true;
                    this.lookup.setShortList(true);
                    this.getLabel().setText(">" + this.getGridField().getHeader() + "<");
                    this.actionRefresh();
                    Menuitem searchMode = new Menuitem();
                    searchMode.setAttribute("EVENT", (Object)SHORT_LIST_EVENT);
                    searchMode.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"ShortListSwitchSearchMode"));
                    searchMode.setImage(ThemeManager.getThemeResource("images/Lock16.png"));
                    searchMode.addEventListener("onClick", (EventListener)this.popupMenu);
                    this.popupMenu.appendChild((Component)searchMode);
                }
            }
        }
        if (this.gridField != null) {
            this.getComponent().setPlaceholder(this.gridField.getPlaceholder());
        }
    }

    private void createCacheListener() {
        String columnName;
        int dotIndex;
        if (this.lookup != null && (dotIndex = (columnName = this.lookup.getColumnName()).indexOf(".")) > 0) {
            String tableName = columnName.substring(0, dotIndex);
            this.tableCacheListener = new CCacheListener(tableName, this);
        }
    }

    @Override
    public String getDisplay() {
        String display = null;
        Comboitem selItem = this.getComponent().getSelectedItem();
        if (selItem != null) {
            display = selItem.getLabel();
        }
        return display;
    }

    @Override
    public Object getValue() {
        Object retVal = null;
        Comboitem selItem = this.getComponent().getSelectedItem();
        if (selItem != null) {
            retVal = selItem.getValue();
            if (retVal instanceof Integer && (Integer)retVal == -1) {
                retVal = null;
            } else if (retVal instanceof String && "".equals(retVal)) {
                retVal = null;
            }
        }
        return retVal;
    }

    @Override
    public void setValue(Object value) {
        if (this.onselecting) {
            return;
        }
        if (value != null && (value instanceof Integer || value instanceof String || value instanceof Timestamp || value instanceof BigDecimal)) {
            this.getComponent().setValue(value);
            if (!this.getComponent().isSelected(value)) {
                Object curValue = this.oldValue;
                this.oldValue = value;
                if (this.isReadWrite() && this.lookup != null) {
                    this.lookup.refresh();
                } else {
                    this.refreshList();
                }
                if (!(this.getComponent().isSelected(value) || !(value instanceof Integer) || this.gridField == null || this.gridField.getDisplayType() == 13 || this.gridTab != null && this.gridTab.getTableModel().isImporting())) {
                    this.getComponent().setValue(null);
                    if (curValue == null) {
                        curValue = value;
                    }
                    ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), curValue, null);
                    super.fireValueChange(changeEvent);
                    this.oldValue = null;
                }
            } else {
                this.oldValue = value;
            }
        } else {
            this.getComponent().setValue(null);
            this.getComponent().setSelectedItem(null);
            this.oldValue = value;
            if (this.getComponent() instanceof EditorAutoComplete) {
                this.updateStyle();
            }
        }
    }

    public Combobox getComponent() {
        return (Combobox)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
        this.getComponent().setButtonVisible(readWrite);
    }

    private void refreshList() {
        NamePair pair;
        if (this.getComponent().getItemCount() > 0) {
            this.getComponent().removeAllItems();
        }
        if (this.isReadWrite()) {
            if (this.lookup != null) {
                NamePair pair2;
                int size = this.lookup.getSize();
                boolean found = false;
                int i = 0;
                while (i < size) {
                    KeyNamePair lookupKNPair;
                    Object obj = this.lookup.getElementAt(i);
                    if (obj instanceof KeyNamePair) {
                        lookupKNPair = (KeyNamePair)obj;
                        this.getComponent().appendItem(lookupKNPair.getName(), lookupKNPair.getKey());
                        if (!found && this.oldValue != null && this.oldValue instanceof Integer && lookupKNPair.getKey() == ((Integer)this.oldValue).intValue()) {
                            found = true;
                        }
                    } else if (obj instanceof ValueNamePair) {
                        lookupKNPair = (ValueNamePair)obj;
                        this.getComponent().appendItem(lookupKNPair.getName(), lookupKNPair.getValue());
                        if (!found && this.oldValue != null && lookupKNPair.getValue().equals(this.oldValue.toString())) {
                            found = true;
                        }
                    }
                    ++i;
                }
                if (!found && this.oldValue != null && (pair2 = this.lookup.getDirect(this.oldValue, false, true)) != null) {
                    if (pair2 instanceof KeyNamePair) {
                        int key = ((KeyNamePair)pair2).getKey();
                        this.getComponent().appendItem(pair2.getName(), key);
                    } else if (pair2 instanceof ValueNamePair) {
                        ValueNamePair valueNamePair = (ValueNamePair)pair2;
                        this.getComponent().appendItem(valueNamePair.getName(), valueNamePair.getValue());
                    }
                }
            }
        } else if (this.lookup != null && (pair = this.lookup.getDirect(this.oldValue, false, false)) != null) {
            if (pair instanceof KeyNamePair) {
                int key = ((KeyNamePair)pair).getKey();
                this.getComponent().appendItem(pair.getName(), key);
            } else if (pair instanceof ValueNamePair) {
                ValueNamePair valueNamePair = (ValueNamePair)pair;
                this.getComponent().appendItem(valueNamePair.getName(), valueNamePair.getValue());
            }
        }
        if (this.getComponent() instanceof EditorAutoComplete) {
            EditorAutoComplete editor = (EditorAutoComplete)this.getComponent();
            editor.setDict(null);
            editor.setValues(null);
            editor.setDescription(null);
            String[] dict = new String[this.getComponent().getItemCount()];
            Object[] values = new Object[this.getComponent().getItemCount()];
            String[] description = new String[this.getComponent().getItemCount()];
            int i = 0;
            while (i < dict.length) {
                Comboitem item = this.getComponent().getItemAtIndex(i);
                dict[i] = item.getLabel();
                values[i] = item.getValue();
                ++i;
            }
            editor.setDict(dict, false);
            editor.setDescription(description);
            editor.setValues(values);
        }
        this.getComponent().setValue(this.oldValue);
    }

    public void onEvent(Event event) {
        if ("onSelect".equalsIgnoreCase(event.getName())) {
            block23: {
                try {
                    this.onselecting = true;
                    Object newValue = this.getValue();
                    if (!this.isValueChange(newValue)) break block23;
                    try {
                        if (this.gridField != null) {
                            this.gridField.setLookupEditorSettingValue(true);
                        }
                        ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
                        super.fireValueChange(changeEvent);
                        this.oldValue = newValue;
                        this.getComponent().setValue(newValue);
                    }
                    finally {
                        if (this.gridField != null) {
                            this.gridField.setLookupEditorSettingValue(false);
                        }
                    }
                }
                finally {
                    this.onselecting = false;
                }
            }
            Events.echoEvent((String)"onPostSelect", (Component)this.getComponent(), null);
        } else if ("onBlur".equalsIgnoreCase(event.getName())) {
            Object newValue;
            Comboitem item = this.getComponent().getSelectedItem();
            if (item == null) {
                this.setValue(this.oldValue);
            } else if (item.getLabel().equals("") && this.isValueChange(newValue = this.getValue())) {
                try {
                    if (this.gridField != null) {
                        this.gridField.setLookupEditorSettingValue(true);
                    }
                    ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
                    super.fireValueChange(changeEvent);
                    this.oldValue = newValue;
                }
                finally {
                    if (this.gridField != null) {
                        this.gridField.setLookupEditorSettingValue(false);
                    }
                }
            }
        } else if (event.getName().equals("onChanging")) {
            this.onChanging((InputEvent)event);
        } else if (event.getName().equals("onPostSelect") && this.getComponent().isOpen()) {
            this.getComponent().select();
            this.getComponent().setOpen(false);
            this.getComponent().setOpen(true);
        }
    }

    private void onChanging(InputEvent event) {
        String v = event.getValue();
        if (!Util.isEmpty((String)v)) {
            v = v.toLowerCase();
            int count = this.getComponent().getItemCount();
            int i = 0;
            while (i < count) {
                Comboitem item = this.getComponent().getItemAtIndex(i);
                if (item.getLabel() != null && item.getLabel().toLowerCase().startsWith(v)) {
                    Clients.scrollIntoView((Component)item);
                    break;
                }
                ++i;
            }
        } else if (this.getComponent().getItemCount() > 0) {
            Comboitem item = this.getComponent().getItemAtIndex(0);
            Clients.scrollIntoView((Component)item);
        }
    }

    private boolean isValueChange(Object newValue) {
        return this.oldValue == null && newValue != null || this.oldValue != null && newValue == null || this.oldValue != null && newValue != null && !this.oldValue.equals(newValue);
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.refreshList();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    public void actionRefresh() {
        if (this.lookup != null) {
            Object curValue = this.getValue();
            if (this.isReadWrite()) {
                this.lookup.refresh();
            } else {
                this.refreshList();
            }
            if (curValue != null) {
                this.setValue(curValue);
            }
        }
    }

    @Override
    public void actionZoom() {
        AEnv.actionZoom(this.lookup, this.getValue());
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private void actionQuickEntry(boolean newRecord) {
        if (!this.getComponent().isEnabled()) {
            return;
        }
        final WQuickEntry vqe = new WQuickEntry(this.lookup.getWindowNo(), this.lookup.getZoom());
        int Record_ID = 0;
        Object value = this.getValue();
        if (!newRecord) {
            if (value instanceof Integer) {
                Record_ID = (Integer)value;
            } else if (value != null && "".compareTo(value.toString()) != 0) {
                Record_ID = Integer.parseInt(value.toString());
            }
        }
        vqe.loadRecord(Record_ID);
        final int finalRecord_ID = Record_ID;
        vqe.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                int result = vqe.getRecord_ID();
                if (result == 0 && result == finalRecord_ID) {
                    return;
                }
                Integer newValue = result;
                WTableDirEditor.this.lookup.getDirect((Object)newValue, false, true);
                WTableDirEditor.this.setValue(result);
                ValueChangeEvent changeEvent = new ValueChangeEvent(this, WTableDirEditor.this.getColumnName(), WTableDirEditor.this.oldValue, newValue);
                WTableDirEditor.this.fireValueChange(changeEvent);
                WTableDirEditor.this.oldValue = newValue;
            }
        });
        vqe.setVisible(true);
        AEnv.showWindow(vqe);
    }

    private void actionLocation() {
        int BPLocation_ID = 0;
        Object value = this.getValue();
        if (value instanceof Integer) {
            BPLocation_ID = (Integer)value;
        } else if (value != null) {
            BPLocation_ID = Integer.parseInt(value.toString());
        }
        if (BPLocation_ID > 0) {
            MBPartnerLocation bpl = new MBPartnerLocation(Env.getCtx(), BPLocation_ID, null);
            MLocation location = new MLocation(Env.getCtx(), bpl.getC_Location_ID(), null);
            WLocationDialog vbp = new WLocationDialog(Msg.getMsg((Properties)Env.getCtx(), (String)"Location"), location);
            vbp.setVisible(true);
            AEnv.showWindow(vbp);
        }
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("REQUERY".equals(evt.getContextEvent())) {
            this.actionRefresh();
        } else if ("ZOOM".equals(evt.getContextEvent())) {
            this.actionZoom();
        } else {
            if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
                if (this.isShowPreference()) {
                    ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
                }
                return;
            }
            if ("NEW_RECORD".equals(evt.getContextEvent())) {
                this.actionQuickEntry(true);
            } else if ("UPDATE_RECORD".equals(evt.getContextEvent())) {
                this.actionQuickEntry(false);
            } else if ("CHANGE_LOG".equals(evt.getContextEvent())) {
                WFieldRecordInfo.start(this.gridField);
            } else if ("SHOW_LOCATION".equals(evt.getContextEvent())) {
                this.actionLocation();
            } else if (SHORT_LIST_EVENT.equals(evt.getContextEvent())) {
                String champ = this.getGridField().getHeader();
                if (this.onlyShortListItems) {
                    this.onlyShortListItems = false;
                    this.lookup.setShortList(false);
                    this.actionRefresh();
                    this.getLabel().setText(champ);
                } else {
                    this.onlyShortListItems = true;
                    this.lookup.setShortList(true);
                    this.actionRefresh();
                    this.getLabel().setText(">" + champ + "<");
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("FieldValue".equals(evt.getPropertyName())) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public void dynamicDisplay(Properties ctx) {
        if (this.lookup instanceof MLookup) {
            ((MLookup)this.lookup).getLookupInfo().ctx = ctx;
        }
        if (this.lookup != null && (!this.lookup.isValidated() || !this.lookup.isLoaded() || this.isReadWrite() && this.lookup.getSize() != this.getComponent().getItemCount())) {
            this.actionRefresh();
        }
        super.dynamicDisplay(ctx);
    }

    private static class CCacheListener
    extends CCache<String, Object> {
        private static final long serialVersionUID = 3543247404379028327L;
        private WTableDirEditor editor;

        protected CCacheListener(String tableName, WTableDirEditor editor) {
            super(tableName, tableName, 0, true);
            this.editor = editor;
        }

        public int reset() {
            if (this.editor.getComponent().getDesktop() != null && this.editor.isReadWrite()) {
                this.refreshLookupList();
            }
            return 0;
        }

        private void refreshLookupList() {
            Executions.schedule((Desktop)this.editor.getComponent().getDesktop(), (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) {
                    try {
                        if (editor.isReadWrite()) {
                            editor.actionRefresh();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, (Event)new Event("onResetLookupList"));
        }

        public void newRecord(int record_ID) {
            if (this.editor.getComponent().getDesktop() != null && this.editor.isReadWrite()) {
                this.refreshLookupList();
            }
        }
    }

    private static class EditorAutoComplete
    extends AutoComplete
    implements ITableDirEditor {
        private static final long serialVersionUID = 8435677226644775152L;
        protected WTableDirEditor editor;
        private DesktopCleanup listener = null;

        protected EditorAutoComplete() {
        }

        public void setPage(Page page) {
            super.setPage(page);
        }

        public void onPageAttached(Page newpage, Page oldpage) {
            super.onPageAttached(newpage, oldpage);
            if (this.editor.tableCacheListener == null) {
                this.editor.createCacheListener();
                if (this.listener == null) {
                    this.listener = new DesktopCleanup(){

                        public void cleanup(Desktop desktop) throws Exception {
                            this.cleanup();
                        }
                    };
                    newpage.getDesktop().addListener((Object)this.listener);
                }
            }
        }

        public void onPageDetached(Page page) {
            super.onPageDetached(page);
            if (this.listener != null && page.getDesktop() != null) {
                page.getDesktop().removeListener((Object)this.listener);
            }
            this.cleanup();
        }

        protected void cleanup() {
            if (this.editor.tableCacheListener != null) {
                CacheMgt.get().unregister((CacheInterface)this.editor.tableCacheListener);
                this.editor.tableCacheListener = null;
            }
        }

        @Override
        public void setEditor(WTableDirEditor editor) {
            this.editor = editor;
        }

        @Override
        public void setValue(String value) {
            this.setText(value);
            if (Util.isEmpty((String)value)) {
                this.refresh("");
            }
        }
    }

    private static class EditorCombobox
    extends Combobox
    implements ITableDirEditor {
        private static final long serialVersionUID = 9087317631313577239L;
        private WTableDirEditor editor;
        private DesktopCleanup listener = null;

        protected EditorCombobox() {
        }

        public void setPage(Page page) {
            super.setPage(page);
        }

        public void onPageAttached(Page newpage, Page oldpage) {
            super.onPageAttached(newpage, oldpage);
            if (this.editor.tableCacheListener == null) {
                this.editor.createCacheListener();
                if (this.listener == null) {
                    this.listener = new DesktopCleanup(){

                        public void cleanup(Desktop desktop) throws Exception {
                            this.cleanup();
                        }
                    };
                    newpage.getDesktop().addListener((Object)this.listener);
                }
            }
        }

        public void onPageDetached(Page page) {
            super.onPageDetached(page);
            if (this.listener != null && page.getDesktop() != null) {
                page.getDesktop().removeListener((Object)this.listener);
            }
            this.cleanup();
        }

        protected void cleanup() {
            if (this.editor.tableCacheListener != null) {
                CacheMgt.get().unregister((CacheInterface)this.editor.tableCacheListener);
                this.editor.tableCacheListener = null;
            }
        }

        @Override
        public void setEditor(WTableDirEditor editor) {
            this.editor = editor;
        }
    }

    private static interface ITableDirEditor {
        public void setEditor(WTableDirEditor var1);
    }
}

