/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.List;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.editor.WPasswordEditor;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.adempiere.webui.window.WTextEditorDialog;
import org.compiere.model.GridField;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Textbox;

public class WStringEditor
extends WEditor
implements ContextMenuListener {
    private static final String[] LISTENER_EVENTS = new String[]{"onChange", "onOK"};
    private String oldValue;
    private boolean tableEditor = false;
    private AbstractADWindowContent adwindowContent;

    public WStringEditor() {
        this("String", false, false, true, 30, 30, "", null);
    }

    public WStringEditor(GridField gridField) {
        this(gridField, false);
    }

    public WStringEditor(GridField gridField, boolean tableEditor) {
        super((Component)(gridField.isAutocomplete() ? new Combobox() : new org.adempiere.webui.component.Textbox()), gridField);
        this.tableEditor = tableEditor;
        if (gridField.getVFormat() != null && !gridField.getVFormat().isEmpty()) {
            this.getComponent().setWidgetListener("onBind", "jq(this).mask('" + gridField.getVFormat() + "');");
        }
        this.init(gridField.getObscureType());
    }

    public WStringEditor(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int displayLength, int fieldLength, String wVFormat, String obscureType) {
        super((Component)new org.adempiere.webui.component.Textbox(), columnName, null, null, mandatory, isReadOnly, isUpdateable);
        if (wVFormat != null && !wVFormat.isEmpty()) {
            this.getComponent().setWidgetListener("onBind", "jq(this).mask('" + wVFormat + "');");
        }
        this.init(obscureType);
    }

    public Textbox getComponent() {
        return (Textbox)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return !this.getComponent().isReadonly();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setReadonly(!readWrite);
    }

    private void init(String obscureType) {
        this.setChangeEventWhenEditing(true);
        if (this.gridField != null) {
            this.getComponent().setMaxlength(this.gridField.getFieldLength());
            int displayLength = this.gridField.getDisplayLength();
            if (displayLength <= 0 || displayLength > 35) {
                displayLength = 35;
            }
            if (!this.tableEditor) {
                this.getComponent().setCols(displayLength);
            }
            if (this.tableEditor) {
                this.getComponent().setMultiline(false);
            } else if (this.gridField.getDisplayType() == 14) {
                this.getComponent().setMultiline(true);
            } else if (this.gridField.getDisplayType() == 36) {
                this.getComponent().setMultiline(true);
            } else if (this.gridField.getDisplayType() == 34) {
                this.getComponent().setMultiline(true);
            } else {
                this.getComponent().setMultiline(false);
            }
            if (!this.gridField.isAutocomplete()) {
                this.getComponent().setRows(this.gridField.getNumLines() <= 0 || this.tableEditor ? 1 : this.gridField.getNumLines());
            }
            if (this.getComponent().getRows() > 1) {
                ZKUpdateUtil.setHeight((HtmlBasedComponent)this.getComponent(), "100%");
            }
            if (this.getComponent() instanceof org.adempiere.webui.component.Textbox) {
                ((org.adempiere.webui.component.Textbox)this.getComponent()).setObscureType(obscureType);
            }
            if (!(this instanceof WPasswordEditor)) {
                this.popupMenu = new WEditorPopupMenu(false, this.gridField.isAutocomplete(), this.isShowPreference());
                this.addTextEditorMenu(this.popupMenu);
                this.addChangeLogMenu(this.popupMenu);
            }
            if (this.gridField.isAutocomplete()) {
                Combobox combo = (Combobox)this.getComponent();
                combo.setAutodrop(true);
                combo.setAutocomplete(true);
                combo.setButtonVisible(false);
                List items = this.gridField.getEntries();
                for (String s : items) {
                    combo.appendItem(s);
                }
            }
            if ("email".equalsIgnoreCase(this.gridField.getColumnName())) {
                this.getComponent().setClientAttribute("type", "email");
            }
            if (this.gridField != null) {
                this.getComponent().setPlaceholder(this.gridField.getPlaceholder());
            }
        }
    }

    public void onEvent(Event event) {
        boolean isStartEdit = "onInitEdit".equalsIgnoreCase(event.getName());
        if ("onChange".equals(event.getName()) || "onOK".equals(event.getName()) || isStartEdit) {
            String newValue = this.getComponent().getValue();
            if (!isStartEdit && this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
                return;
            }
            if (!isStartEdit && this.oldValue == null && newValue == null) {
                return;
            }
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
            changeEvent.setIsInitEdit(isStartEdit);
            super.fireValueChange(changeEvent);
            this.oldValue = this.getComponent().getValue();
        }
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getValue();
    }

    @Override
    public Object getValue() {
        return this.getComponent().getValue();
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            this.getComponent().setValue(value.toString());
        } else {
            this.getComponent().setValue("");
        }
        this.oldValue = this.getComponent().getValue();
    }

    protected void setTypePassword(boolean password) {
        if (password) {
            this.getComponent().setType("password");
        } else {
            this.getComponent().setType("text");
        }
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
            if (this.isShowPreference()) {
                ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
            }
            return;
        }
        if ("EDITOR".equals(evt.getContextEvent())) {
            this.adwindowContent = this.findADWindowContent();
            boolean isHtml = false;
            if ((this.gridField.getDisplayType() == 14 || this.gridField.getDisplayType() == 36 || this.gridField.getDisplayType() == 34) && this.adwindowContent != null && this.adwindowContent.getActiveGridTab() != null && this.adwindowContent.getActiveGridTab().getAD_Table_ID() == 416) {
                isHtml = this.adwindowContent.getActiveGridTab().getValueAsBoolean("IsHtml");
            }
            final WTextEditorDialog dialog = new WTextEditorDialog(this.gridField.getVO().Header, this.getDisplay(), this.isReadWrite(), this.gridField.getFieldLength(), isHtml);
            dialog.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    if (WStringEditor.this.adwindowContent != null) {
                        WStringEditor.this.adwindowContent.hideBusyMask();
                    }
                    if (!dialog.isCancelled()) {
                        WStringEditor.this.getComponent().setText(dialog.getText());
                        String newText = WStringEditor.this.getComponent().getValue();
                        ValueChangeEvent changeEvent = new ValueChangeEvent(WStringEditor.this, WStringEditor.this.getColumnName(), WStringEditor.this.oldValue, newText);
                        WStringEditor.super.fireValueChange(changeEvent);
                        WStringEditor.this.oldValue = newText;
                    }
                }
            });
            if (this.adwindowContent != null) {
                this.adwindowContent.getComponent().getParent().appendChild((Component)dialog);
                this.adwindowContent.showBusyMask(dialog);
                LayoutUtils.openOverlappedWindow(this.adwindowContent.getComponent().getParent(), dialog, "middle_center");
            } else {
                SessionManager.getAppDesktop().showWindow(dialog);
            }
            dialog.focus();
        } else if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        } else if ("REQUERY".equals(evt.getContextEvent())) {
            this.actionRefresh();
        }
    }

    @Override
    public void dynamicDisplay() {
        super.dynamicDisplay();
        this.actionRefresh();
    }

    public void actionRefresh() {
        if (this.gridField.isAutocomplete()) {
            Combobox combo = (Combobox)this.getComponent();
            List items = this.gridField.getEntries();
            combo.removeAllItems();
            for (String s : items) {
                combo.appendItem(s);
            }
        }
    }

    private AbstractADWindowContent findADWindowContent() {
        Component parent = this.getComponent().getParent();
        while (parent != null) {
            if (parent.getAttribute("org.adempiere.webui.adwindow") != null) {
                ADWindow adwindow = (ADWindow)parent.getAttribute("org.adempiere.webui.adwindow");
                return adwindow.getADWindowContent();
            }
            parent = parent.getParent();
        }
        return null;
    }
}

