/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.beans.PropertyChangeEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.ADWindowContent;
import org.adempiere.webui.adwindow.IFieldEditorContainer;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Searchbox;
import org.adempiere.webui.editor.IZoomableEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.factory.InfoManager;
import org.adempiere.webui.grid.WQuickEntry;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.panel.InfoPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;

public class WSearchEditor
extends WEditor
implements ContextMenuListener,
ValueChangeListener,
IZoomableEditor {
    private static final String[] LISTENER_EVENTS = new String[]{"onClick", "onChange", "onOK"};
    private Lookup lookup;
    private String m_tableName = null;
    private String m_keyColumnName = null;
    private String columnName;
    private Object value;
    private InfoPanel infoPanel = null;
    private String imageUrl;
    private static CLogger log = CLogger.getCLogger(WSearchEditor.class);
    private static final String IN_PROGRESS_IMAGE = "~./zk/img/progress3.gif";
    private ADWindow adwindow;

    public WSearchEditor(GridField gridField) {
        super((Component)new CustomSearchBox(), gridField);
        this.lookup = gridField.getLookup();
        if (this.lookup != null) {
            this.columnName = this.lookup.getColumnName();
        }
        this.init();
    }

    public Searchbox getComponent() {
        return (Searchbox)super.getComponent();
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    public WSearchEditor(Lookup lookup, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super((Component)new Searchbox(), label, description, mandatory, readonly, updateable);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        this.columnName = lookup.getColumnName();
        super.setColumnName(this.columnName);
        this.init();
    }

    public WSearchEditor(String columnName, boolean mandatory, boolean readonly, boolean updateable, Lookup lookup) {
        super((Component)new Searchbox(), null, null, mandatory, readonly, updateable);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        this.columnName = columnName;
        super.setColumnName(columnName);
        this.init();
    }

    private void init() {
        this.columnName = this.getColumnName();
        if (this.columnName.equals("C_BPartner_ID")) {
            this.popupMenu = new WEditorPopupMenu(true, true, this.isShowPreference(), true, true, false, this.lookup);
            this.imageUrl = ThemeManager.isUseFontIconForImage() ? "z-icon-BPartner" : ThemeManager.getThemeResource("images/BPartner16.png");
        } else if (this.columnName.equals("M_Product_ID")) {
            this.popupMenu = new WEditorPopupMenu(true, true, this.isShowPreference(), false, false, false, this.lookup);
            this.imageUrl = ThemeManager.isUseFontIconForImage() ? "z-icon-Product" : ThemeManager.getThemeResource("images/Product16.png");
        } else {
            this.popupMenu = new WEditorPopupMenu(true, true, this.isShowPreference(), false, false, false, this.lookup);
            this.imageUrl = ThemeManager.isUseFontIconForImage() ? "z-icon-More" : ThemeManager.getThemeResource("images/PickOpen16.png");
        }
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass(this.imageUrl);
        } else {
            this.getComponent().getButton().setImage(this.imageUrl);
        }
        this.addChangeLogMenu(this.popupMenu);
        if (this.gridField != null) {
            this.getComponent().getTextbox().setPlaceholder(this.gridField.getPlaceholder());
        }
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
        if (value != null && !"".equals(String.valueOf(value))) {
            String text = this.lookup.getDisplay(value);
            if (text.startsWith("_")) {
                text = text.substring(1);
            }
            this.getComponent().setText(text);
        } else {
            this.getComponent().setText("");
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    public void onEvent(Event e) {
        if ("onChange".equals(e.getName())) {
            if (this.infoPanel != null) {
                this.infoPanel.detach();
                this.infoPanel = null;
            }
            if ("".equals(this.getComponent().getText().trim())) {
                this.actionCombo(null);
                this.resetButtonState();
                return;
            }
            this.actionText(this.getComponent().getText());
        } else if ("onOK".equals(e.getName())) {
            if (this.getComponent().getText() == null || this.getComponent().getText().length() == 0) {
                if (this.infoPanel != null) {
                    this.infoPanel.detach();
                    this.infoPanel = null;
                }
                this.actionText(this.getComponent().getText());
            } else {
                this.actionRefresh(this.getValue());
            }
        } else if ("onClick".equals(e.getName())) {
            if (this.infoPanel != null) {
                this.infoPanel.detach();
                this.infoPanel = null;
            }
            this.actionButton("");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("FieldValue".equals(evt.getPropertyName())) {
            this.actionRefresh(evt.getNewValue());
        }
    }

    private void actionRefresh(Object value) {
        this.setValue(value);
    }

    @Override
    public void actionZoom() {
        AEnv.actionZoom(this.lookup, this.getValue());
    }

    private void actionZoom(Object value) {
        AEnv.actionZoom(this.lookup, value);
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("REQUERY".equals(evt.getContextEvent())) {
            this.actionRefresh(this.getValue());
        } else if ("ZOOM".equals(evt.getContextEvent())) {
            this.actionZoom();
        } else {
            if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
                if (this.isShowPreference()) {
                    ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
                }
                return;
            }
            if ("NEW_RECORD".equals(evt.getContextEvent())) {
                if (this.infoPanel != null) {
                    this.infoPanel.detach();
                    this.infoPanel = null;
                }
                this.actionQuickEntry(true);
            } else if ("UPDATE_RECORD".equals(evt.getContextEvent())) {
                if (this.infoPanel != null) {
                    this.infoPanel.detach();
                    this.infoPanel = null;
                }
                this.actionQuickEntry(false);
            } else if ("CHANGE_LOG".equals(evt.getContextEvent())) {
                WFieldRecordInfo.start(this.gridField);
            }
        }
    }

    private void actionText(String text) {
        Integer key;
        InfoPanel ip;
        if (text == null || text.length() == 0 || text.equals("%")) {
            this.actionButton(text);
            this.resetButtonState();
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(this.getColumnName()) + " - " + text);
        }
        int id = -1;
        if (this.m_tableName == null) {
            this.getDirectAccessSQL("*");
        }
        if ((ip = InfoManager.create(this.lookup, this.gridField, this.m_tableName, this.m_keyColumnName, this.getComponent().getText(), false, this.getWhereClause())) != null && ip.loadedOK() && ip.getRowCount() == 1 && (key = ip.getFirstRowKey()) != null && key > 0) {
            id = key;
        }
        if (id <= 0) {
            if (ip != null && ip.loadedOK()) {
                this.showInfoPanel(ip);
            } else {
                this.actionButton(this.getComponent().getText());
            }
            this.resetButtonState();
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(this.getColumnName()) + " - Unique ID=" + id);
        }
        this.actionCombo(id);
        Searchbox comp = this.getComponent();
        Component parent = comp.getParent();
        while (parent != null) {
            if (parent instanceof IFieldEditorContainer) {
                ((IFieldEditorContainer)parent).focusToNextEditor(this);
                break;
            }
            parent = parent.getParent();
        }
        String uid = this.getComponent().getTextbox().getUuid();
        String script = "setTimeout(function(){try{var e = zk.Widget.$('#" + uid + "').$n(); if (jq(':focus').size() == 0) e.focus();} catch(error){}}, 100);";
        Clients.response((AuResponse)new AuScript(script));
        this.resetButtonState();
    }

    private void resetButtonState() {
        this.getComponent().getButton().setEnabled(true);
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass(this.imageUrl);
        } else {
            this.getComponent().getButton().setImage(this.imageUrl);
        }
        this.getComponent().invalidate();
    }

    private void actionCombo(Object value) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Value=" + value);
        }
        try {
            if (this.gridField != null) {
                this.gridField.setLookupEditorSettingValue(true);
            }
            ValueChangeEvent evt = new ValueChangeEvent(this, this.getColumnName(), this.getValue(), value);
            this.fireValueChange(evt);
            boolean updated = false;
            if (value instanceof Object[] && ((Object[])value).length > 0) {
                value = ((Object[])value)[0];
            }
            if (value == null && this.getValue() == null) {
                updated = true;
            } else if (value != null && value.equals(this.getValue())) {
                updated = true;
                this.getComponent().setText(this.lookup.getDisplay(value));
            }
            if (!updated) {
                this.setValue(value);
            }
        }
        finally {
            if (this.gridField != null) {
                this.gridField.setLookupEditorSettingValue(false);
            }
        }
    }

    private void actionQuickEntry(boolean newRecord) {
        if (!this.getComponent().isEnabled()) {
            return;
        }
        int zoomWindowId = this.gridField != null ? this.lookup.getZoom(Env.isSOTrx((Properties)Env.getCtx(), (int)this.gridField.getWindowNo())) : this.lookup.getZoom(Env.isSOTrx((Properties)Env.getCtx()));
        final WQuickEntry vqe = new WQuickEntry(this.lookup.getWindowNo(), zoomWindowId);
        if (vqe.getQuickFields() <= 0) {
            return;
        }
        int Record_ID = 0;
        if (!newRecord) {
            if (this.value instanceof Integer) {
                Record_ID = (Integer)this.value;
            } else if (this.value != null && "".compareTo(this.value.toString()) != 0) {
                Record_ID = Integer.parseInt(this.value.toString());
            }
        }
        vqe.loadRecord(Record_ID);
        final int finalRecord_ID = Record_ID;
        vqe.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                int result;
                if (WSearchEditor.this.adwindow != null) {
                    WSearchEditor.this.adwindow.getADWindowContent().hideBusyMask();
                    WSearchEditor.this.adwindow = null;
                }
                if ((result = vqe.getRecord_ID()) == 0 && result == finalRecord_ID) {
                    return;
                }
                WSearchEditor.this.lookup.getDirect((Object)result, false, true);
                WSearchEditor.this.setValue(result);
                WSearchEditor.this.actionCombo(result);
                WSearchEditor.this.lookup.refresh();
            }
        });
        vqe.setSizable(true);
        this.adwindow = ADWindow.findADWindow((Component)this.getComponent());
        if (this.adwindow != null && !ClientInfo.isMobile()) {
            ADWindowContent content = this.adwindow.getADWindowContent();
            content.getComponent().getParent().appendChild((Component)vqe);
            content.showBusyMask(vqe);
            LayoutUtils.openOverlappedWindow(content.getComponent().getParent(), vqe, "middle_center");
        } else {
            AEnv.showWindow(vqe);
        }
    }

    private void actionButton(String queryValue) {
        InfoPanel ip;
        if (this.lookup == null) {
            return;
        }
        String whereClause = this.getWhereClause();
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(this.lookup.getColumnName()) + ", Zoom=" + this.lookup.getZoom() + " (" + whereClause + ")");
        }
        if (queryValue.length() == 0 && this.getComponent().getText().length() > 0) {
            queryValue = this.getComponent().getText();
        }
        if (this.m_tableName == null) {
            this.getDirectAccessSQL("*");
        }
        if ((ip = InfoManager.create(this.lookup, this.gridField, this.m_tableName, this.m_keyColumnName, queryValue, false, whereClause)) != null) {
            this.showInfoPanel(ip);
        }
    }

    public void showInfoPanel(final InfoPanel ip) {
        ip.setVisible(true);
        ip.setStyle("border: 2px");
        ip.setClosable(true);
        ip.addValueChangeListener(this);
        this.infoPanel = ip;
        ip.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Component component = SessionManager.getAppDesktop().getActiveWindow();
                if (component instanceof IHelpContext) {
                    Events.sendEvent((Event)new Event("onWindowContainerSelectionChanged", component));
                } else {
                    SessionManager.getAppDesktop().updateHelpContext("H", 0);
                }
                boolean cancelled = ip.isCancelled();
                Object[] result = ip.getSelectedKeys();
                WSearchEditor.this.infoPanel = null;
                if (result != null && result.length > 0) {
                    if (result.length > 1) {
                        WSearchEditor.this.actionCombo(result);
                    } else {
                        WSearchEditor.this.actionCombo(result[0]);
                    }
                } else if (cancelled) {
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config(String.valueOf(WSearchEditor.this.getColumnName()) + " - Result = null (cancelled)");
                    }
                    if (WSearchEditor.this.value != null) {
                        if (!WSearchEditor.this.lookup.getDisplay(WSearchEditor.this.value).equals(WSearchEditor.this.getComponent().getText())) {
                            WSearchEditor.this.getComponent().setText(WSearchEditor.this.lookup.getDisplay(WSearchEditor.this.value));
                        }
                    } else {
                        WSearchEditor.this.getComponent().setText("");
                        WSearchEditor.this.actionCombo(null);
                    }
                } else if (log.isLoggable(Level.CONFIG)) {
                    log.config(String.valueOf(WSearchEditor.this.getColumnName()) + " - Result = null (not cancelled)");
                }
                WSearchEditor.this.getComponent().getTextbox().focus();
            }
        });
        ip.setId(String.valueOf(ip.getTitle()) + "_" + ip.getWindowNo());
        AEnv.showWindow(ip);
    }

    private String getDirectAccessSQL(String text) {
        StringBuffer sql;
        String m_columnName;
        block40: {
            int AD_Reference_ID;
            m_columnName = this.getColumnName();
            sql = new StringBuffer();
            this.m_tableName = m_columnName.substring(0, m_columnName.length() - 3);
            this.m_keyColumnName = m_columnName;
            if (m_columnName.equals("M_Product_ID")) {
                Env.setContext((Properties)Env.getCtx(), (int)this.lookup.getWindowNo(), (int)1113, (String)"M_Product_ID", (String)"0");
                Env.setContext((Properties)Env.getCtx(), (int)this.lookup.getWindowNo(), (int)1113, (String)"M_AttributeSetInstance_ID", (String)"0");
                Env.setContext((Properties)Env.getCtx(), (int)this.lookup.getWindowNo(), (int)1113, (String)"M_Locator_ID", (String)"0");
                sql.append("SELECT M_Product_ID FROM M_Product WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING((String)text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING((String)text)).append(" OR UPC LIKE ").append(DB.TO_STRING((String)text)).append(")");
            } else if (m_columnName.equals("C_BPartner_ID")) {
                sql.append("SELECT C_BPartner_ID FROM C_BPartner WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING((String)text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING((String)text)).append(")");
            } else if (m_columnName.equals("C_Order_ID")) {
                sql.append("SELECT C_Order_ID FROM C_Order WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (m_columnName.equals("C_Invoice_ID")) {
                sql.append("SELECT C_Invoice_ID FROM C_Invoice WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (m_columnName.equals("M_InOut_ID")) {
                sql.append("SELECT M_InOut_ID FROM M_InOut WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (m_columnName.equals("C_Payment_ID")) {
                sql.append("SELECT C_Payment_ID FROM C_Payment WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (m_columnName.equals("GL_JournalBatch_ID")) {
                sql.append("SELECT GL_JournalBatch_ID FROM GL_JournalBatch WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (m_columnName.equals("SalesRep_ID")) {
                sql.append("SELECT AD_User_ID FROM AD_User WHERE UPPER(Name) LIKE ").append(DB.TO_STRING((String)text));
                this.m_tableName = "AD_User";
                this.m_keyColumnName = "AD_User_ID";
            }
            if (sql.length() > 0) {
                String wc = this.getWhereClause();
                if (wc != null && wc.length() > 0) {
                    sql.append(" AND ").append(wc);
                }
                sql.append(" AND IsActive='Y'");
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(String.valueOf(m_columnName) + " (predefined) " + sql.toString());
                }
                return MRole.getDefault().addAccessSQL(sql.toString(), this.m_tableName, false, false);
            }
            if (this.lookup != null && this.lookup instanceof MLookup && (AD_Reference_ID = ((MLookup)this.lookup).getAD_Reference_Value_ID()) != 0) {
                String displayColumnName;
                boolean isValueDisplayed;
                block38: {
                    isValueDisplayed = false;
                    String query = "SELECT kc.ColumnName, dc.ColumnName, t.TableName, rt.IsValueDisplayed FROM AD_Ref_Table rt INNER JOIN AD_Column kc ON (rt.AD_Key=kc.AD_Column_ID) INNER JOIN AD_Column dc ON (rt.AD_Display=dc.AD_Column_ID) INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) WHERE rt.AD_Reference_ID=?";
                    displayColumnName = null;
                    CPreparedStatement pstmt2 = null;
                    ResultSet rs = null;
                    try {
                        try {
                            pstmt2 = DB.prepareStatement((String)query, null);
                            pstmt2.setInt(1, AD_Reference_ID);
                            rs = pstmt2.executeQuery();
                            if (rs.next()) {
                                this.m_keyColumnName = rs.getString(1);
                                displayColumnName = rs.getString(2);
                                this.m_tableName = rs.getString(3);
                                String t = rs.getString(4);
                                isValueDisplayed = "Y".equalsIgnoreCase(t);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, query, (Throwable)e);
                            DB.close(rs, (Statement)pstmt2);
                            break block38;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)pstmt2);
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt2);
                }
                if (displayColumnName != null) {
                    sql = new StringBuffer();
                    sql.append("SELECT ").append(this.m_keyColumnName).append(" FROM ").append(this.m_tableName).append(" WHERE (UPPER(").append(displayColumnName).append(") LIKE ").append(DB.TO_STRING((String)text));
                    if (isValueDisplayed) {
                        sql.append(" OR UPPER(").append("Value").append(") LIKE ").append(DB.TO_STRING((String)text));
                    }
                    sql.append(")");
                    sql.append(" AND IsActive='Y'");
                    String wc = this.getWhereClause();
                    if (wc != null && wc.length() > 0) {
                        sql.append(" AND ").append(wc);
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest(String.valueOf(m_columnName) + " (Table) " + sql.toString());
                    }
                    return MRole.getDefault().addAccessSQL(sql.toString(), this.m_tableName, false, false);
                }
            }
            String query = "SELECT t.TableName, c.ColumnName FROM AD_Column c  INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID AND t.IsView='N') WHERE (c.ColumnName IN ('DocumentNo', 'Value', 'Name') OR c.IsIdentifier='Y') AND c.AD_Reference_ID IN (10,14) AND EXISTS (SELECT * FROM AD_Column cc WHERE cc.AD_Table_ID=t.AD_Table_ID AND cc.IsKey='Y' AND cc.ColumnName=?)";
            this.m_keyColumnName = m_columnName;
            sql = new StringBuffer();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)query, null);
                    pstmt.setString(1, this.m_keyColumnName);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (sql.length() != 0) {
                            sql.append(" OR ");
                        }
                        this.m_tableName = rs.getString(1);
                        sql.append("UPPER(").append(rs.getString(2)).append(") LIKE ").append(DB.TO_STRING((String)text));
                    }
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, query, (Throwable)ex);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block40;
                }
            }
            catch (Throwable pstmt2) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw pstmt2;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (sql.length() == 0) {
            log.log(Level.SEVERE, String.valueOf(m_columnName) + " (TableDir) - no standard/identifier columns");
            return "";
        }
        StringBuffer retValue = new StringBuffer("SELECT ").append(m_columnName).append(" FROM ").append(this.m_tableName).append(" WHERE ").append(sql).append(" AND IsActive='Y'");
        String wc = this.getWhereClause();
        if (wc != null && wc.length() > 0) {
            retValue.append(" AND ").append(wc);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.valueOf(m_columnName) + " (TableDir) " + sql.toString());
        }
        return MRole.getDefault().addAccessSQL(retValue.toString(), this.m_tableName, false, false);
    }

    private String getWhereClause() {
        String validation;
        String whereClause = "";
        if (this.lookup == null) {
            return "";
        }
        if (this.lookup.getZoomQuery() != null) {
            whereClause = this.lookup.getZoomQuery().getWhereClause();
        }
        if ((validation = this.lookup.getValidation()) == null) {
            validation = "";
        }
        if (whereClause.length() == 0) {
            whereClause = validation;
        } else if (validation.length() > 0) {
            whereClause = String.valueOf(whereClause) + " AND " + validation;
        }
        if (whereClause.indexOf(64) != -1) {
            String validated = Env.parseContext((Properties)Env.getCtx(), (int)this.lookup.getWindowNo(), (String)whereClause, (boolean)false);
            if (validated.length() == 0) {
                log.severe(String.valueOf(this.getColumnName()) + " - Cannot Parse=" + whereClause);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(String.valueOf(this.getColumnName()) + " - Parsed: " + validated);
                }
                return validated;
            }
        }
        return whereClause;
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        if ("zoom".equals(evt.getPropertyName())) {
            this.actionZoom(evt.getNewValue());
        } else if (evt.getNewValue() != null) {
            this.actionCombo(evt.getNewValue());
        }
    }

    @Override
    public void setTableEditor(boolean b) {
        super.setTableEditor(b);
        this.getComponent().setTableEditorMode(b);
    }

    public boolean isShowingDialog() {
        return this.infoPanel != null;
    }

    public static WSearchEditor createBPartner(int windowNo) {
        int AD_Column_ID = 3499;
        try {
            MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)windowNo, (int)0, (int)AD_Column_ID, (int)30);
            return new WSearchEditor("C_BPartner_ID", false, false, true, (Lookup)lookup);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
            return null;
        }
    }

    public static WSearchEditor createProduct(int windowNo) {
        int AD_Column_ID = 3840;
        try {
            MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)windowNo, (int)0, (int)AD_Column_ID, (int)30);
            return new WSearchEditor("M_Product_ID", false, false, true, (Lookup)lookup);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
            return null;
        }
    }

    @Override
    public void dynamicDisplay(Properties ctx) {
        if (this.lookup instanceof MLookup) {
            ((MLookup)this.lookup).getLookupInfo().ctx = ctx;
        }
        super.dynamicDisplay(ctx);
    }

    static class CustomSearchBox
    extends Searchbox {
        private static final long serialVersionUID = 7490301044763375829L;

        CustomSearchBox() {
        }

        public void onPageAttached(Page newpage, Page oldpage) {
            super.onPageAttached(newpage, oldpage);
            if (newpage != null) {
                String w = "try{var btn=jq('#'+this.parent.uuid+' @button').zk.$();}catch(err){}";
                if (ThemeManager.isUseFontIconForImage()) {
                    String sclass = "z-icon-spinner z-icon-spin";
                    this.getTextbox().setWidgetListener("onChange", "try{" + w + "btn.setIconSclass('" + sclass + "');" + "btn.setDisabled(true, {adbs: false, skip: false});}catch(err){}");
                } else {
                    this.getTextbox().setWidgetListener("onChange", "try{" + w + "btn.setImage(\"" + Executions.getCurrent().encodeURL(WSearchEditor.IN_PROGRESS_IMAGE) + "\");" + "btn.setDisabled(true, {adbs: false, skip: false});}catch(err){}");
                }
            }
        }
    }
}

