/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.window.WImageDialog;
import org.compiere.model.GridField;
import org.compiere.model.MImage;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;

public class WImageEditor
extends WEditor {
    private static final String[] LISTENER_EVENTS = new String[]{"onClick"};
    private MImage m_mImage = null;
    private boolean m_mandatory;
    private boolean readwrite;
    private static CLogger log = CLogger.getCLogger(WImageEditor.class);

    public WImageEditor(GridField gridField) {
        super((Component)new org.zkoss.zul.Image(), gridField);
        this.init();
    }

    public org.zkoss.zul.Image getComponent() {
        return (org.zkoss.zul.Image)this.component;
    }

    private void init() {
        Image img = null;
        this.getComponent().setContent(img);
        this.getComponent().setSclass("image-field");
    }

    @Override
    public String getDisplay() {
        return this.m_mImage.getName();
    }

    @Override
    public Object getValue() {
        if (this.m_mImage == null || this.m_mImage.get_ID() == 0) {
            return null;
        }
        return this.m_mImage.get_ID();
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    @Override
    public boolean isReadWrite() {
        return this.readwrite;
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.readwrite = readWrite;
        if (this.readwrite) {
            LayoutUtils.removeSclass("image-field-readonly", (HtmlBasedComponent)this.getComponent());
        } else {
            LayoutUtils.addSclass("image-field-readonly", (HtmlBasedComponent)this.getComponent());
        }
    }

    @Override
    public void setValue(Object value) {
        int newValue = 0;
        if (value instanceof Integer) {
            newValue = (Integer)value;
        }
        if (newValue == 0) {
            this.m_mImage = null;
            Image img = null;
            this.getComponent().setContent(img);
            return;
        }
        if (this.m_mImage == null || newValue != this.m_mImage.get_ID()) {
            this.m_mImage = MImage.get((Properties)Env.getCtx(), (int)newValue);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.m_mImage.toString());
        }
        AImage img = null;
        byte[] data = this.m_mImage.getData();
        if (data != null && data.length > 0) {
            try {
                img = new AImage(null, data);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.getComponent().setContent(img);
    }

    @Override
    public String getDisplayTextForGridView(Object value) {
        if (value == null) {
            return "";
        }
        return "...";
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    public void onEvent(Event event) throws Exception {
        if ("onClick".equals(event.getName()) && this.readwrite) {
            final WImageDialog vid = new WImageDialog(this.m_mImage);
            vid.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    if (!vid.isCancel()) {
                        int AD_Image_ID = vid.getAD_Image_ID();
                        Object oldValue = WImageEditor.this.getValue();
                        Integer newValue = null;
                        if (AD_Image_ID != 0) {
                            newValue = AD_Image_ID;
                        }
                        WImageEditor.this.m_mImage = null;
                        WImageEditor.this.setValue(newValue);
                        ValueChangeEvent vce = new ValueChangeEvent(WImageEditor.this, WImageEditor.this.gridField.getColumnName(), oldValue, newValue);
                        WImageEditor.this.fireValueChange(vce);
                    }
                }
            });
        }
    }

    @Override
    public void fillHorizontal() {
    }
}

