/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.adempiere.webui.window.WTextEditorDialog;
import org.compiere.model.GridField;
import org.compiere.util.CLogger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;

public class WHtmlEditor
extends WEditor
implements ContextMenuListener {
    private String oldValue;
    private AbstractADWindowContent adwindowContent;
    private Html box = null;
    private boolean m_mandatory;
    private boolean readwrite;
    private static CLogger log = CLogger.getCLogger(WHtmlEditor.class);

    public WHtmlEditor(GridField gridField) {
        super((Component)new Div(), gridField);
        this.init();
    }

    public Div getComponent() {
        return (Div)this.component;
    }

    private void init() {
        if (log.isLoggable(Level.INFO)) {
            log.info("Initializing component");
        }
        if (this.gridField != null) {
            Div div = this.getComponent();
            if (this.gridField.getNumLines() > 1) {
                int height = 24 * this.gridField.getNumLines();
                div.setHeight(String.valueOf(height) + "px");
            }
            div.setWidth("100%");
            LayoutUtils.addSclass("html-field", (HtmlBasedComponent)div);
            div.addEventListener("onDoubleClick", (EventListener)this);
            this.box = new Html();
            this.box.setParent((Component)div);
            this.popupMenu = new WEditorPopupMenu(false, false, this.isShowPreference());
            this.addTextEditorMenu(this.popupMenu);
            this.addChangeLogMenu(this.popupMenu);
        }
    }

    @Override
    public String getDisplay() {
        return this.box.getContent();
    }

    @Override
    public Object getValue() {
        return this.box.getContent();
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        super.setMandatory(mandatory);
        this.m_mandatory = mandatory;
    }

    @Override
    public boolean isReadWrite() {
        return this.readwrite;
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.readwrite = readWrite;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            this.box.setContent(value.toString());
        } else {
            this.box.setContent("");
        }
        this.oldValue = this.box.getContent();
    }

    @Override
    public String getDisplayTextForGridView(Object value) {
        if (value == null) {
            return "";
        }
        return (String)value;
    }

    @Override
    public Component getDisplayComponent() {
        return new Html();
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
            if (this.isShowPreference()) {
                ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
            }
            return;
        }
        if ("EDITOR".equals(evt.getContextEvent())) {
            this.editorEvent();
        } else if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        }
    }

    private void editorEvent() {
        this.adwindowContent = this.findADWindowContent();
        final WTextEditorDialog dialog = new WTextEditorDialog(this.gridField.getVO().Header, this.getDisplay(), this.isReadWrite(), this.gridField.getFieldLength(), true);
        dialog.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (WHtmlEditor.this.adwindowContent != null) {
                    WHtmlEditor.this.adwindowContent.hideBusyMask();
                }
                if (!dialog.isCancelled()) {
                    WHtmlEditor.this.box.setContent(dialog.getText());
                    String newText = WHtmlEditor.this.box.getContent();
                    ValueChangeEvent changeEvent = new ValueChangeEvent(WHtmlEditor.this, WHtmlEditor.this.getColumnName(), WHtmlEditor.this.oldValue, newText);
                    WHtmlEditor.super.fireValueChange(changeEvent);
                    WHtmlEditor.this.oldValue = newText;
                }
            }
        });
        if (this.adwindowContent != null) {
            this.adwindowContent.getComponent().getParent().appendChild((Component)dialog);
            this.adwindowContent.showBusyMask(dialog);
            LayoutUtils.openOverlappedWindow(this.adwindowContent.getComponent().getParent(), dialog, "middle_center");
        } else {
            SessionManager.getAppDesktop().showWindow(dialog);
        }
        dialog.focus();
    }

    private AbstractADWindowContent findADWindowContent() {
        Component parent = this.getComponent().getParent();
        while (parent != null) {
            if (parent.getAttribute("org.adempiere.webui.adwindow") != null) {
                ADWindow adwindow = (ADWindow)parent.getAttribute("org.adempiere.webui.adwindow");
                return adwindow.getADWindowContent();
            }
            parent = parent.getParent();
        }
        return null;
    }

    public void onEvent(Event event) throws Exception {
        if ("onDoubleClick".equals(event.getName()) && this.readwrite) {
            this.editorEvent();
        }
    }
}

