/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.adempiere.webui.AdempiereWebUI;
import org.adempiere.webui.component.FilenameBox;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.model.GridField;
import org.compiere.util.CLogger;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.UploadEvent;

public class WFilenameEditor
extends WEditor {
    private static final String[] LISTENER_EVENTS = new String[]{"onClick", "onChange", "onOK"};
    private static final CLogger log = CLogger.getCLogger(WFilenameEditor.class);
    private String oldValue;

    public WFilenameEditor(GridField gridField) {
        super((Component)new FilenameBox(), gridField);
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass("z-icon-Open");
        } else {
            this.getComponent().setButtonImage(ThemeManager.getThemeResource("images/Open16.png"));
        }
        this.getComponent().addEventListener("onUpload", this);
        this.getComponent().getButton().setUpload(AdempiereWebUI.getUploadSetting());
        this.getComponent().getButton().setAttribute("org.zkoss.zul.image.preload", Boolean.TRUE);
        if (gridField != null) {
            this.getComponent().getTextbox().setPlaceholder(gridField.getPlaceholder());
        }
    }

    public FilenameBox getComponent() {
        return (FilenameBox)this.component;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.oldValue = null;
            this.getComponent().setText("");
        } else {
            this.oldValue = String.valueOf(value);
            this.getComponent().setText(this.oldValue);
        }
    }

    @Override
    public Object getValue() {
        return this.getComponent().getText();
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    public void onEvent(Event event) {
        String newValue = null;
        if (!"onChange".equals(event.getName()) && !"onOK".equals(event.getName())) {
            if (event instanceof UploadEvent) {
                UploadEvent ue = (UploadEvent)event;
                this.processUploadMedia(ue.getMedia());
                return;
            }
            return;
        }
        newValue = this.getComponent().getText();
        this.processNewValue(newValue);
    }

    protected void processNewValue(String newValue) {
        if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
            return;
        }
        if (this.oldValue == null && newValue == null) {
            return;
        }
        ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
        this.fireValueChange(changeEvent);
    }

    private void processUploadMedia(Media file) {
        if (file == null) {
            return;
        }
        FileOutputStream fos = null;
        String fileName = null;
        try {
            try {
                File tempFile = File.createTempFile("adempiere_", "_" + file.getName());
                fileName = tempFile.getAbsolutePath();
                fos = new FileOutputStream(tempFile);
                byte[] bytes = null;
                if (file.inMemory()) {
                    bytes = file.getByteData();
                } else {
                    InputStream is = file.getStreamData();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buf = new byte[1000];
                    int byteread = 0;
                    while ((byteread = is.read(buf)) != -1) {
                        baos.write(buf, 0, byteread);
                    }
                    bytes = baos.toByteArray();
                }
                fos.write(bytes);
                fos.flush();
                fos.close();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.getComponent().setText(fileName);
        this.processNewValue(this.getComponent().getText());
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void setTableEditor(boolean b) {
        super.setTableEditor(b);
        this.getComponent().setTableEditorMode(b);
    }
}

