/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.component.DatetimeBox;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public class WDatetimeEditor
extends WEditor
implements ContextMenuListener {
    private static final String[] LISTENER_EVENTS = new String[]{"onChange", "onOK"};
    private static final CLogger logger = CLogger.getCLogger(WDatetimeEditor.class);
    private Timestamp oldValue = new Timestamp(0L);

    public WDatetimeEditor(GridField gridField) {
        super((Component)new DatetimeBox(), gridField);
        this.init();
    }

    public WDatetimeEditor(String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super((Component)new DatetimeBox(), label, description, mandatory, readonly, updateable);
        this.setColumnName("Datetime");
        this.init();
    }

    public WDatetimeEditor() {
        this(Msg.getMsg((Properties)Env.getCtx(), (String)"DateTime"), Msg.getMsg((Properties)Env.getCtx(), (String)"DateTime"), false, false, true);
    }

    public WDatetimeEditor(String columnName, boolean mandatory, boolean readonly, boolean updateable, String title) {
        super((Component)new DatetimeBox(), columnName, title, null, mandatory, readonly, updateable);
        this.init();
    }

    private void init() {
        this.popupMenu = new WEditorPopupMenu(false, false, this.isShowPreference());
        this.popupMenu.addMenuListener(this);
        this.addChangeLogMenu(this.popupMenu);
        if (this.gridField != null) {
            this.getComponent().getDatebox().setPlaceholder(this.gridField.getPlaceholder());
        }
    }

    public void onEvent(Event event) {
        if ("onChange".equalsIgnoreCase(event.getName()) || "onOK".equalsIgnoreCase(event.getName())) {
            Date date = this.getComponent().getValue();
            Timestamp newValue = null;
            if (date != null) {
                newValue = new Timestamp(date.getTime());
            }
            if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
                return;
            }
            if (this.oldValue == null && newValue == null) {
                return;
            }
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
            super.fireValueChange(changeEvent);
            this.oldValue = newValue;
        }
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    @Override
    public Object getValue() {
        if (this.getComponent().getValue() == null) {
            return null;
        }
        return new Timestamp(this.getComponent().getValue().getTime());
    }

    @Override
    public void setValue(Object value) {
        if (value == null || value.toString().trim().length() == 0) {
            this.oldValue = null;
            this.getComponent().setValue(null);
        } else if (value instanceof Timestamp) {
            this.getComponent().setValue((Timestamp)value);
            this.oldValue = (Timestamp)value;
        } else {
            try {
                this.getComponent().setText(value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.oldValue = this.getComponent().getValue() != null ? new Timestamp(this.getComponent().getValue().getTime()) : null;
        }
    }

    public DatetimeBox getComponent() {
        return (DatetimeBox)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        } else if ("VALUE_PREFERENCE".equals(evt.getContextEvent()) && this.isShowPreference()) {
            ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
        }
    }

    @Override
    protected void setFieldStyle(String style) {
        this.getComponent().getDatebox().setStyle(style);
        this.getComponent().getTimebox().setStyle(style);
    }
}

