/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.sql.Timestamp;
import java.util.Date;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.component.Datebox;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.util.CLogger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public class WDateEditor
extends WEditor
implements ContextMenuListener {
    private static final String[] LISTENER_EVENTS = new String[]{"onChange", "onOK"};
    private static final CLogger logger = CLogger.getCLogger(WDateEditor.class);
    private Timestamp oldValue = new Timestamp(0L);

    public WDateEditor(GridField gridField) {
        super((Component)new Datebox(), gridField);
        this.init();
    }

    public WDateEditor(String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super((Component)new Datebox(), label, description, mandatory, readonly, updateable);
        this.setColumnName("Date");
        this.init();
    }

    public WDateEditor() {
        this("Date", "Date", false, false, true);
    }

    public WDateEditor(String columnName, boolean mandatory, boolean readonly, boolean updateable, String title) {
        super((Component)new Datebox(), columnName, title, null, mandatory, readonly, updateable);
    }

    private void init() {
        this.popupMenu = new WEditorPopupMenu(false, false, this.isShowPreference());
        this.popupMenu.addMenuListener(this);
        this.addChangeLogMenu(this.popupMenu);
        if (this.gridField != null) {
            this.getComponent().setPlaceholder(this.gridField.getPlaceholder());
        }
    }

    public void onEvent(Event event) {
        if ("onChange".equalsIgnoreCase(event.getName()) || "onOK".equalsIgnoreCase(event.getName())) {
            Date date = this.getComponent().getValue();
            Timestamp newValue = null;
            if (date != null) {
                newValue = new Timestamp(date.getTime());
            }
            if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
                return;
            }
            if (this.oldValue == null && newValue == null) {
                return;
            }
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
            super.fireValueChange(changeEvent);
            this.oldValue = newValue;
        }
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    @Override
    public Object getValue() {
        if (this.getComponent().getValue() == null) {
            return null;
        }
        return new Timestamp(this.getComponent().getValue().getTime());
    }

    @Override
    public void setValue(Object value) {
        if (value == null || value.toString().trim().length() == 0) {
            this.oldValue = null;
            this.getComponent().setValue(null);
        } else if (value instanceof Timestamp) {
            this.getComponent().setValue((Timestamp)value);
            this.oldValue = (Timestamp)value;
        } else {
            try {
                this.getComponent().setText(value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.oldValue = this.getComponent().getValue() != null ? new Timestamp(this.getComponent().getValue().getTime()) : null;
        }
    }

    public Datebox getComponent() {
        return (Datebox)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        } else if ("VALUE_PREFERENCE".equals(evt.getContextEvent()) && this.gridField != null) {
            if (this.isShowPreference()) {
                ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
            }
            return;
        }
    }
}

