/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.List;
import org.adempiere.base.Service;
import org.adempiere.webui.apps.graph.IChartRendererService;
import org.adempiere.webui.apps.graph.model.ChartModel;
import org.adempiere.webui.editor.WEditor;
import org.compiere.model.GridField;
import org.compiere.model.MChart;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.AfterSizeEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Panelchildren;

public class WChartEditor
extends WEditor {
    private static final String[] LISTENER_EVENTS = new String[]{"onClick"};
    private MChart chartModel = null;
    private int chartWidth;
    private int chartHeight;
    private Div chartDiv;
    private static final CLogger log = CLogger.getCLogger(WChartEditor.class);

    public WChartEditor(GridField gridField, int windowNo) {
        super((Component)new Panel(), gridField);
        this.chartModel = new MChart(Env.getCtx(), gridField.getAD_Chart_ID(), null);
        this.chartModel.setWindowNo(windowNo);
        this.init();
    }

    private void createChart() {
        if (this.chartHeight > 0 && this.chartWidth > 0) {
            this.chartDiv.getChildren().clear();
            ChartModel model = new ChartModel();
            model.chart = this.chartModel;
            List list = Service.locator().list(IChartRendererService.class).getServices();
            for (IChartRendererService renderer : list) {
                if (renderer.renderChart((Component)this.chartDiv, this.chartWidth, this.chartHeight, model)) break;
            }
        }
    }

    public Panel getComponent() {
        return (Panel)this.component;
    }

    private void init() {
        Panelchildren pc = new Panelchildren();
        this.getComponent().appendChild((Component)pc);
        pc.setSclass("chart-field");
        this.chartDiv = new Div();
        this.chartDiv.addEventListener("onAfterSize", (EventListener)this);
        pc.appendChild((Component)this.chartDiv);
    }

    @Override
    public String getDisplay() {
        return this.chartModel.get_Translation("Name");
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public void setMandatory(boolean mandatory) {
    }

    @Override
    public boolean isReadWrite() {
        return true;
    }

    @Override
    public void setReadWrite(boolean readWrite) {
    }

    @Override
    public void setValue(Object value) {
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    public void onEvent(Event event) throws Exception {
        if (event instanceof AfterSizeEvent) {
            AfterSizeEvent ase = (AfterSizeEvent)event;
            this.chartWidth = ase.getWidth();
            if (this.chartWidth == 0) {
                this.chartWidth = 400;
            }
            this.chartHeight = 0;
            if (this.chartDiv.getStyle() != null && this.chartDiv.getStyle().contains("height")) {
                this.chartHeight = ase.getHeight();
            }
            if (this.chartHeight == 0) {
                this.chartHeight = this.chartModel.getWinHeight();
                this.chartDiv.setHeight(String.valueOf(this.chartHeight) + "px");
            }
            this.chartDiv.getChildren().clear();
            ChartModel model = new ChartModel();
            model.chart = this.chartModel;
            List list = Service.locator().list(IChartRendererService.class).getServices();
            for (IChartRendererService renderer : list) {
                if (renderer.renderChart((Component)this.chartDiv, this.chartWidth, this.chartHeight, model)) break;
            }
        }
    }

    @Override
    public void dynamicDisplay() {
        super.dynamicDisplay();
        this.createChart();
    }

    @Override
    public boolean isSearchable() {
        return false;
    }

    @Override
    protected void setFieldStyle(String style) {
        this.chartDiv.setStyle(style);
    }
}

