/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.editor.IProcessButton;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.ActionEvent;
import org.adempiere.webui.event.ActionListener;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.model.GridField;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public class WButtonEditor
extends WEditor
implements IProcessButton {
    public static final String EDITOR_ATTRIBUTE = "editor";
    private static final String[] LISTENER_EVENTS = new String[]{"onClick"};
    private static final CLogger logger = CLogger.getCLogger(WButtonEditor.class);
    private String m_text;
    private boolean m_mandatory;
    private Object m_value;
    private HashMap<String, String> m_values = null;
    private MLookup m_lookup;
    private int AD_Process_ID;
    private GridField gridfield = null;
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private IADTabpanel adTabpanel;

    public WButtonEditor(GridField gridField) {
        this(gridField, -1);
    }

    public WButtonEditor(GridField gridField, int rowIndex) {
        super((Component)new Button(), gridField, rowIndex);
        this.m_text = gridField.getHeader();
        this.AD_Process_ID = gridField.getAD_Process_ID();
        this.gridfield = gridField;
        this.getComponent().setAttribute(EDITOR_ATTRIBUTE, this);
        this.init();
    }

    @Override
    public int getProcess_ID() {
        return this.AD_Process_ID;
    }

    @Override
    public GridField getGridField() {
        return this.gridfield;
    }

    private void init() {
        this.label.setValue(" ");
        this.getComponent().setLabel(this.gridField.getHeader());
        this.getComponent().setTooltiptext(this.gridField.getDescription());
        String columnName = super.getColumnName();
        if (columnName.equals("PaymentRule")) {
            this.readReference(195);
            if (ThemeManager.isUseFontIconForImage()) {
                this.getComponent().setIconSclass("z-icon-Payment");
            } else {
                this.getComponent().setImage(ThemeManager.getThemeResource("images/Payment16.png"));
            }
        } else if (columnName.equals("DocAction")) {
            this.readReference(135);
            if (ThemeManager.isUseFontIconForImage()) {
                this.getComponent().setIconSclass("z-icon-Process");
            } else {
                this.getComponent().setImage(ThemeManager.getThemeResource("images/Process16.png"));
            }
        } else if (columnName.equals("CreateFrom")) {
            if (ThemeManager.isUseFontIconForImage()) {
                this.getComponent().setIconSclass("z-icon-CreateFrom");
            } else {
                this.getComponent().setImage(ThemeManager.getThemeResource("images/Copy16.png"));
            }
        } else if (columnName.equals("Record_ID")) {
            if (ThemeManager.isUseFontIconForImage()) {
                this.getComponent().setIconSclass("z-icon-Zoom");
            } else {
                this.getComponent().setImage(ThemeManager.getThemeResource("images/Zoom16.png"));
            }
            this.getComponent().setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"ZoomDocument"));
        } else if (columnName.equals("Posted")) {
            this.readReference(234);
            if (ThemeManager.isUseFontIconForImage()) {
                this.getComponent().setIconSclass("z-icon-InfoAccount");
            } else {
                this.getComponent().setImage(ThemeManager.getThemeResource("images/InfoAccount16.png"));
            }
        }
        if (this.gridField.getColumnName().endsWith("_ID") && !this.gridField.getColumnName().equals("Record_ID")) {
            this.m_lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.gridField.getWindowNo(), (int)0, (int)this.gridField.getAD_Column_ID(), (int)30);
        } else if (this.gridField.getAD_Reference_Value_ID() != 0) {
            this.m_lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.gridField.getWindowNo(), (int)0, (int)this.gridField.getAD_Column_ID(), (int)17);
        }
    }

    @Override
    public String getDisplay() {
        if (this.m_value != null) {
            return this.m_value.toString();
        }
        return null;
    }

    @Override
    public Object getValue() {
        return this.m_values;
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    @Override
    public void setValue(Object value) {
        this.m_value = value;
        String text = this.m_text;
        if (value != null && !super.getColumnName().equals("Record_ID")) {
            NamePair pp;
            if (super.getColumnName().equals("DocAction") && !MSysConfig.getBooleanValue((String)"DOCACTIONBUTTON_SHOWACTIONNAME", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()))) {
                text = Msg.getElement((Properties)Env.getCtx(), (String)"DocAction");
            } else if (this.m_values != null) {
                text = this.m_values.get(value);
            } else if (this.m_lookup != null && (pp = this.m_lookup.get(value)) != null) {
                text = pp.getName();
            }
        }
        this.getComponent().setLabel(text != null ? text : "");
    }

    public Button getComponent() {
        return (Button)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    public HashMap<String, String> getValues() {
        return this.m_values;
    }

    private void readReference(int AD_Reference_ID) {
        block6: {
            this.m_values = new HashMap();
            String SQL = Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Ref_List") ? "SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=?" : "SELECT l.Value, t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language((Properties)Env.getCtx()) + "'" + " AND l.AD_Reference_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)SQL, null);
                    pstmt.setInt(1, AD_Reference_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String value = rs.getString(1);
                        String name = rs.getString(2);
                        this.m_values.put(value, name);
                    }
                }
                catch (SQLException e) {
                    logger.log(Level.SEVERE, SQL, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (!this.actionListeners.contains(actionListener)) {
            this.actionListeners.add(actionListener);
        }
    }

    public boolean removeActionListener(ActionListener actionListener) {
        return this.actionListeners.remove(actionListener);
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    public void onEvent(Event event) throws Exception {
        if ("onClick".equals(event.getName())) {
            ActionEvent actionEvent = new ActionEvent(this, this.getColumnName(), "onClick");
            ActionListener[] listeners = new ActionListener[]{};
            ActionListener[] actionListenerArray = listeners = this.actionListeners.toArray(listeners);
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener evtListener = actionListenerArray[n2];
                evtListener.actionPerformed(actionEvent);
                ++n2;
            }
        }
    }

    public void setADTabpanel(IADTabpanel adTabpanel) {
        this.adTabpanel = adTabpanel;
    }

    @Override
    public IADTabpanel getADTabpanel() {
        return this.adTabpanel;
    }

    @Override
    public boolean isSearchable() {
        return false;
    }
}

