/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.component.Combinationbox;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.WAccountDialog;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.model.MAccountLookup;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.util.Clients;

public class WAccountEditor
extends WEditor
implements ContextMenuListener {
    private static final String[] LISTENER_EVENTS = new String[]{"onClick", "onChange", "onOK"};
    private MAccountLookup m_mAccount;
    private Object m_value;
    private static CLogger log = CLogger.getCLogger(WAccountEditor.class);

    public WAccountEditor(GridField gridField) {
        super((Component)new Combinationbox(), gridField);
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass("z-icon-Account");
        } else {
            this.getComponent().setButtonImage(ThemeManager.getThemeResource("images/Account16.png"));
        }
        this.m_mAccount = new MAccountLookup(gridField.getVO().ctx, gridField.getWindowNo());
        this.popupMenu = new WEditorPopupMenu(false, false, true);
        this.popupMenu.addMenuListener(this);
        this.addChangeLogMenu(this.popupMenu);
        if (gridField != null) {
            this.getComponent().getTextbox().setPlaceholder(gridField.getPlaceholder());
        }
    }

    public Combinationbox getComponent() {
        return (Combinationbox)this.component;
    }

    @Override
    public void setValue(Object value) {
        this.m_value = value;
        this.getComponent().setText(this.m_mAccount.getDisplay(value));
        this.getComponent().setToolTipText(this.m_mAccount.getDescription());
    }

    @Override
    public Object getValue() {
        if (this.m_mAccount.C_ValidCombination_ID == 0) {
            return null;
        }
        return this.m_mAccount.C_ValidCombination_ID;
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    public void cmd_button() {
        int C_AcctSchema_ID = this.gridField.getGridTab() != null ? Env.getContextAsInt((Properties)Env.getCtx(), (int)this.gridField.getWindowNo(), (int)this.gridField.getGridTab().getTabNo(), (String)"C_AcctSchema_ID") : Env.getContextAsInt((Properties)Env.getCtx(), (int)this.gridField.getWindowNo(), (String)"C_AcctSchema_ID");
        if (C_AcctSchema_ID <= 0) {
            C_AcctSchema_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_AcctSchema_ID");
        }
        new WAccountDialog(this.gridField.getHeader(), this.m_mAccount, C_AcctSchema_ID, new Callback<Integer>(){

            public void onCallback(Integer result) {
                Integer newValue = result;
                boolean changed = true;
                if (newValue == null) {
                    if (WAccountEditor.this.m_value == null) {
                        changed = false;
                    }
                    if (WAccountEditor.this.m_mAccount.getDisplay(WAccountEditor.this.m_value).equals(WAccountEditor.this.getComponent().getText())) {
                        changed = false;
                    }
                }
                if (changed) {
                    Object oldValue = WAccountEditor.this.m_value;
                    WAccountEditor.this.setValue(newValue);
                    ValueChangeEvent changeEvent = new ValueChangeEvent(WAccountEditor.this, WAccountEditor.this.getColumnName(), oldValue, newValue);
                    WAccountEditor.this.fireValueChange(changeEvent);
                }
                String uid = WAccountEditor.this.getComponent().getTextbox().getUuid();
                String script = "setTimeout(function(){try{var e = zk.Widget.$('#" + uid + "').$n(); if (jq(':focus').size() == 0) e.focus();} catch(error){}}, 100);";
                Clients.response((AuResponse)new AuScript(script));
            }
        });
    }

    public void cmd_text() {
        int C_ValidCombination_ID;
        block12: {
            String text = this.getComponent().getText();
            log.info("Text=" + text);
            if (text == null || text.length() == 0 || text.equals("%")) {
                this.cmd_button();
                return;
            }
            if (!text.endsWith("%")) {
                text = String.valueOf(text) + "%";
            }
            String sql = "SELECT C_ValidCombination_ID FROM C_ValidCombination WHERE C_AcctSchema_ID=? AND (UPPER(Alias) LIKE ? OR UPPER(Combination) LIKE ?)";
            sql = MRole.getDefault().addAccessSQL(sql, "C_ValidCombination", false, false);
            int C_AcctSchema_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.gridField.getWindowNo(), (String)"C_AcctSchema_ID");
            C_ValidCombination_ID = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, C_AcctSchema_ID);
                    boolean useSimilarTo = "Y".equals(Env.getContext((Properties)Env.getCtx(), (String)"P|IsUseSimilarTo"));
                    if (useSimilarTo && text.contains("*")) {
                        text = text.replaceAll("\\*", "\\\\*");
                    }
                    pstmt.setString(2, text.toUpperCase());
                    pstmt.setString(3, text.toUpperCase());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        C_ValidCombination_ID = rs.getInt(1);
                        if (rs.next()) {
                            C_ValidCombination_ID = 0;
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (C_ValidCombination_ID > 0) {
            Integer newValue = C_ValidCombination_ID;
            Object oldValue = this.m_value;
            this.m_value = newValue;
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), oldValue, newValue);
            this.fireValueChange(changeEvent);
        } else {
            this.cmd_button();
        }
    }

    public void onEvent(Event event) {
        if ("onChange".equals(event.getName()) || "onOK".equals(event.getName())) {
            this.cmd_text();
        } else if ("onClick".equals(event.getName())) {
            this.cmd_button();
        }
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        }
    }

    @Override
    public boolean isNullOrEmpty() {
        Object value = this.getValue();
        if (value != null && (Integer)value == 0) {
            value = null;
        }
        return value == null;
    }

    @Override
    public void setTableEditor(boolean b) {
        super.setTableEditor(b);
        this.getComponent().setTableEditorMode(b);
    }
}

