/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.desktop;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.adempiere.util.Callback;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Session;

public class FavouriteController {
    private static final String DESKTOP_FAVOURITE_CONTROLLER = "desktop.FavouriteController";
    private Map<Integer, MTreeNode> nodeMap;
    private int m_AD_Tree_ID;
    private MTreeNode rootNode;
    private List<Callback<Integer>> deletedCallbacks;
    private List<Callback<MTreeNode>> insertedCallbacks;

    private FavouriteController() {
        this.init();
    }

    private void init() {
        this.nodeMap = new LinkedHashMap<Integer, MTreeNode>();
        this.deletedCallbacks = new ArrayList<Callback<Integer>>();
        this.insertedCallbacks = new ArrayList<Callback<MTreeNode>>();
        int AD_Role_ID = Env.getAD_Role_ID((Properties)Env.getCtx());
        int AD_Tree_ID = DB.getSQLValue(null, (String)"SELECT COALESCE(r.AD_Tree_Menu_ID, ci.AD_Tree_Menu_ID)FROM AD_ClientInfo ci INNER JOIN AD_Role r ON (ci.AD_Client_ID=r.AD_Client_ID) WHERE AD_Role_ID=?", (int)AD_Role_ID);
        if (AD_Tree_ID <= 0) {
            AD_Tree_ID = 10;
        }
        this.m_AD_Tree_ID = AD_Tree_ID;
        MTree vTree = new MTree(Env.getCtx(), AD_Tree_ID, false, true, false, null);
        this.rootNode = vTree.getRoot();
        Enumeration enTop = this.rootNode.children();
        while (enTop.hasMoreElements()) {
            MTreeNode ndTop = (MTreeNode)enTop.nextElement();
            Enumeration en = ndTop.preorderEnumeration();
            while (en.hasMoreElements()) {
                MTreeNode nd = (MTreeNode)en.nextElement();
                if (!nd.isOnBar()) continue;
                this.nodeMap.put(nd.getNode_ID(), nd);
            }
        }
    }

    public static synchronized FavouriteController getInstance(Session currSess) {
        FavouriteController controller = (FavouriteController)currSess.getAttribute(DESKTOP_FAVOURITE_CONTROLLER);
        if (controller == null) {
            controller = new FavouriteController();
            currSess.setAttribute(DESKTOP_FAVOURITE_CONTROLLER, (Object)controller);
        }
        return controller;
    }

    private boolean barDBupdate(boolean add, int Node_ID) {
        int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        int AD_Org_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Org_ID");
        int AD_User_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_User_ID");
        StringBuilder sql = new StringBuilder();
        if (add) {
            sql.append("INSERT INTO AD_TreeBar (AD_Tree_ID,AD_User_ID,Node_ID, AD_Client_ID,AD_Org_ID, IsActive,Created,CreatedBy,Updated,UpdatedBy)VALUES (").append(this.m_AD_Tree_ID).append(",").append(AD_User_ID).append(",").append(Node_ID).append(",").append(AD_Client_ID).append(",").append(AD_Org_ID).append(",").append("'Y',SysDate,").append(AD_User_ID).append(",SysDate,").append(AD_User_ID).append(")");
        } else {
            sql.append("DELETE AD_TreeBar WHERE AD_Tree_ID=").append(this.m_AD_Tree_ID).append(" AND AD_User_ID=").append(AD_User_ID).append(" AND Node_ID=").append(Node_ID);
        }
        int no = DB.executeUpdate((String)sql.toString(), (boolean)false, null);
        return no == 1;
    }

    public boolean addNode(int nodeId) {
        MTreeNode node = this.rootNode.findNode(nodeId);
        if (node != null) {
            return this.addNode(node);
        }
        return false;
    }

    public boolean addNode(MTreeNode node) {
        if (this.barDBupdate(true, node.getNode_ID())) {
            this.nodeMap.put(node.getNode_ID(), node);
            for (Callback<MTreeNode> callback : this.insertedCallbacks) {
                callback.onCallback((Object)node);
            }
            return true;
        }
        return false;
    }

    public boolean removeNode(int nodeId) {
        if (this.barDBupdate(false, nodeId)) {
            this.nodeMap.remove(nodeId);
            for (Callback<Integer> callback : this.deletedCallbacks) {
                callback.onCallback((Object)nodeId);
            }
            return true;
        }
        return false;
    }

    public boolean hasNode(int nodeId) {
        return this.nodeMap.keySet().contains(nodeId);
    }

    public List<MTreeNode> getFavourites() {
        ArrayList<MTreeNode> list = new ArrayList<MTreeNode>();
        for (int key : this.nodeMap.keySet()) {
            list.add(this.nodeMap.get(key));
        }
        return list;
    }

    public void addInsertedCallback(Callback<MTreeNode> callback) {
        this.insertedCallbacks.add(callback);
    }

    public void addDeletedCallback(Callback<Integer> callback) {
        this.deletedCallbacks.add(callback);
    }
}

