/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.desktop;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Service;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.graph.IChartRendererService;
import org.adempiere.webui.apps.graph.WGraph;
import org.adempiere.webui.apps.graph.WPerformanceDetail;
import org.adempiere.webui.apps.graph.model.ChartModel;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.dashboard.DashboardRunnable;
import org.adempiere.webui.desktop.IDesktop;
import org.adempiere.webui.factory.IDashboardGadgetFactory;
import org.adempiere.webui.report.HTMLExtension;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.ZkReportViewerProvider;
import org.compiere.model.I_AD_Menu;
import org.compiere.model.MChart;
import org.compiere.model.MDashboardContent;
import org.compiere.model.MDashboardContentAccess;
import org.compiere.model.MDashboardPreference;
import org.compiere.model.MGoal;
import org.compiere.model.MMenu;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MSysConfig;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.AfterSizeEvent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.MaximizeEvent;
import org.zkoss.zul.Anchorchildren;
import org.zkoss.zul.Anchorlayout;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Include;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Panelchildren;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Timer;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.Vlayout;

public class DashboardController
implements EventListener<Event> {
    private static final String PANEL_EMPTY_ATTR = "panel.empty";
    private static final CLogger logger = CLogger.getCLogger(DashboardController.class);
    private Component prevParent;
    private Component prevNext;
    private List<Panel> panelList = new ArrayList<Panel>();
    private List<Anchorchildren> columnList;
    private Anchorlayout dashboardLayout = new Anchorlayout();
    private Anchorchildren maximizedHolder;
    private DashboardRunnable dashboardRunnable;
    private Timer dashboardTimer;
    private boolean isShowInDashboard;
    private int noOfCols;
    private static final int DEFAULT_DASHBOARD_WIDTH = 95;

    public DashboardController() {
        this.dashboardLayout.setSclass("dashboard-layout");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.dashboardLayout, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.dashboardLayout, "1");
        this.maximizedHolder = new Anchorchildren();
        this.maximizedHolder.setAnchor("100% 100%");
        this.maximizedHolder.setStyle("overflow: hidden; border: none; margin: 0; padding: 0;");
    }

    public void render(Component parent, IDesktop desktopImpl, boolean isShowInDashboard) {
        this.render(parent, desktopImpl, isShowInDashboard, false);
    }

    protected void render(Component parent, IDesktop desktopImpl, boolean isShowInDashboard, boolean update) {
        this.isShowInDashboard = isShowInDashboard;
        if (!update) {
            parent.appendChild((Component)this.dashboardLayout);
        }
        if (!update && isShowInDashboard) {
            ((HtmlBasedComponent)parent).setStyle("overflow-x: auto;");
        }
        this.dashboardLayout.getChildren().clear();
        if (!this.dashboardLayout.getDesktop().isServerPushEnabled()) {
            this.dashboardLayout.getDesktop().enableServerPush(true);
        }
        if (!update) {
            this.dashboardRunnable = new DashboardRunnable(parent.getDesktop());
        }
        this.columnList = new ArrayList<Anchorchildren>();
        Vlayout dashboardColumnLayout = null;
        int currentColumnNo = 0;
        int noOfCols = 0;
        int width = 0;
        try {
            Anchorchildren dashboardColumn;
            int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
            int AD_Role_ID = Env.getAD_Role_ID((Properties)Env.getCtx());
            MDashboardPreference[] dps = MDashboardPreference.getForSession((int)AD_User_ID, (int)AD_Role_ID);
            MDashboardContent[] dcs = MDashboardContentAccess.get((Properties)Env.getCtx(), (int)AD_Role_ID, (int)AD_User_ID, null);
            if (dps.length == 0) {
                this.createDashboardPreference(AD_User_ID, AD_Role_ID);
                dps = MDashboardPreference.getForSession((int)AD_User_ID, (int)AD_Role_ID);
            } else if (this.updatePreferences(dps, dcs, Env.getCtx())) {
                dps = MDashboardPreference.getForSession((int)AD_User_ID, (int)AD_Role_ID);
            }
            noOfCols = MDashboardPreference.getForSessionColumnCount((boolean)isShowInDashboard, (int)AD_User_ID, (int)AD_Role_ID);
            if (ClientInfo.isMobile() && isShowInDashboard && ClientInfo.maxWidth(999)) {
                if (ClientInfo.maxWidth(699)) {
                    noOfCols = 1;
                } else if (noOfCols > 2) {
                    noOfCols = 2;
                }
            }
            this.noOfCols = noOfCols;
            int dashboardWidth = isShowInDashboard ? 95 : 100;
            width = noOfCols <= 0 ? dashboardWidth : dashboardWidth / noOfCols;
            int extraWidth = 100 - (noOfCols <= 0 ? dashboardWidth : width * noOfCols) - (100 - dashboardWidth - 1);
            MDashboardPreference[] mDashboardPreferenceArray = dps;
            int n = dps.length;
            int n2 = 0;
            while (n2 < n) {
                MDashboardPreference dp = mDashboardPreferenceArray[n2];
                if (dp.isActive() && dp.isShowInDashboard() == isShowInDashboard) {
                    MDashboardContent dc = new MDashboardContent(dp.getCtx(), dp.getPA_DashboardContent_ID(), dp.get_TrxName());
                    int columnNo = dp.getColumnNo();
                    int effColumn = columnNo;
                    if (effColumn + 1 > noOfCols) {
                        effColumn = noOfCols - 1;
                    }
                    if (dashboardColumnLayout == null || currentColumnNo != effColumn) {
                        dashboardColumnLayout = new Vlayout();
                        dashboardColumnLayout.setSclass("dashboard-column");
                        dashboardColumnLayout.setAttribute("ColumnNo", (Object)columnNo);
                        dashboardColumnLayout.setAttribute("IsShowInDashboard", (Object)isShowInDashboard);
                        dashboardColumnLayout.setAttribute("IsAdditionalColumn", (Object)false);
                        Anchorchildren dashboardColumn2 = new Anchorchildren();
                        dashboardColumn2.setAnchor(String.valueOf(width) + "%" + " 100%");
                        if (!ClientInfo.isMobile()) {
                            dashboardColumn2.setDroppable("true");
                            dashboardColumn2.addEventListener("onDrop", (EventListener)this);
                        }
                        dashboardColumn2.appendChild((Component)dashboardColumnLayout);
                        this.columnList.add(dashboardColumn2);
                        this.dashboardLayout.appendChild((Component)dashboardColumn2);
                        ZKUpdateUtil.setHflex((HtmlBasedComponent)dashboardColumnLayout, "1");
                        currentColumnNo = effColumn;
                    }
                    Panel panel = null;
                    if (update) {
                        panel = this.findPanel(dp.getPA_DashboardContent_ID(), dp.getPA_DashboardPreference_ID());
                    } else {
                        panel = new Panel();
                        Caption caption = new Caption(dc.get_Translation("Name"));
                        panel.appendChild((Component)caption);
                        panel.setAttribute("PA_DashboardContent_ID", (Object)dp.getPA_DashboardContent_ID());
                        panel.setAttribute("PA_DashboardPreference_ID", (Object)dp.getPA_DashboardPreference_ID());
                        this.panelList.add(panel);
                        panel.addEventListener("onMaximize", (EventListener)this);
                        panel.setSclass("dashboard-widget");
                        panel.setMaximizable(true);
                        String description = dc.get_Translation("Description");
                        if (description != null) {
                            panel.setTooltiptext(description);
                        }
                        panel.setCollapsible(dc.isCollapsible());
                        panel.setOpen(!dp.isCollapsedByDefault());
                        panel.addEventListener("onOpen", (EventListener)this);
                        if (!ClientInfo.isMobile()) {
                            panel.setDroppable("true");
                            panel.getCaption().setDraggable("true");
                            panel.addEventListener("onDrop", (EventListener)this);
                        }
                        panel.setBorder("normal");
                    }
                    if (panel != null && panel.getAttribute(PANEL_EMPTY_ATTR) == null) {
                        dashboardColumnLayout.appendChild((Component)panel);
                    }
                    if (!update) {
                        Panelchildren content = new Panelchildren();
                        panel.appendChild((Component)content);
                        boolean panelEmpty = true;
                        boolean bl = panelEmpty = !this.render((Component)content, dc, this.dashboardRunnable);
                        if (panelEmpty) {
                            panel.detach();
                            panel.setAttribute(PANEL_EMPTY_ATTR, (Object)Boolean.TRUE);
                        }
                    }
                }
                ++n2;
            }
            if (dps.length == 0) {
                dashboardColumnLayout = new Vlayout();
                dashboardColumnLayout.setAttribute("ColumnNo", (Object)"0");
                dashboardColumnLayout.setAttribute("IsShowInDashboard", (Object)isShowInDashboard);
                dashboardColumnLayout.setAttribute("IsAdditionalColumn", (Object)true);
                dashboardColumn = new Anchorchildren();
                dashboardColumn.setAnchor(String.valueOf(width - 5) + "%" + " 100%");
                if (!ClientInfo.isMobile()) {
                    dashboardColumn.setDroppable("true");
                    dashboardColumn.addEventListener("onDrop", (EventListener)this);
                }
                dashboardColumn.appendChild((Component)dashboardColumnLayout);
                this.columnList.add(dashboardColumn);
                this.dashboardLayout.appendChild((Component)dashboardColumn);
                ZKUpdateUtil.setWidth((HtmlBasedComponent)dashboardColumnLayout, "100%");
            } else if (isShowInDashboard) {
                dashboardColumnLayout = new Vlayout();
                ZKUpdateUtil.setWidth((HtmlBasedComponent)dashboardColumnLayout, "100%");
                dashboardColumnLayout.setAttribute("ColumnNo", (Object)(currentColumnNo + 1));
                dashboardColumnLayout.setAttribute("IsShowInDashboard", (Object)isShowInDashboard);
                dashboardColumnLayout.setAttribute("IsAdditionalColumn", (Object)true);
                dashboardColumn = new Anchorchildren();
                dashboardColumn.setAnchor(String.valueOf(extraWidth) + "% 100%");
                if (!ClientInfo.isMobile()) {
                    dashboardColumn.setDroppable("true");
                    dashboardColumn.addEventListener("onDrop", (EventListener)this);
                }
                dashboardColumn.appendChild((Component)dashboardColumnLayout);
                this.columnList.add(dashboardColumn);
                this.dashboardLayout.appendChild((Component)dashboardColumn);
                ZKUpdateUtil.setWidth((HtmlBasedComponent)dashboardColumnLayout, "100%");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create dashboard content", (Throwable)e);
        }
        if (!update && !this.dashboardRunnable.isEmpty()) {
            this.dashboardRunnable.refreshDashboard(false);
            int interval = MSysConfig.getIntValue((String)"ZK_DASHBOARD_REFRESH_INTERVAL", (int)60000);
            this.dashboardTimer = new Timer();
            this.dashboardTimer.setDelay(interval);
            this.dashboardTimer.setRepeats(true);
            this.dashboardTimer.addEventListener("onTimer", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    if (DashboardController.this.dashboardRunnable != null && !DashboardController.this.dashboardRunnable.isEmpty()) {
                        DashboardController.this.dashboardRunnable.run();
                    }
                }
            });
            this.dashboardTimer.setPage(parent.getPage());
        }
    }

    private Panel findPanel(int PA_DashboardContent_ID, int PA_DashboardPreference_ID) {
        for (Panel panel : this.panelList) {
            Object value1 = panel.getAttribute("PA_DashboardContent_ID");
            Object value2 = panel.getAttribute("PA_DashboardPreference_ID");
            if (value1 == null || !(value1 instanceof Number) || value2 == null || !(value2 instanceof Number)) continue;
            int id1 = ((Number)value1).intValue();
            int id2 = ((Number)value2).intValue();
            if (id1 != PA_DashboardContent_ID || id2 != PA_DashboardPreference_ID) continue;
            return panel;
        }
        return null;
    }

    public boolean render(Component content, MDashboardContent dc, DashboardRunnable dashboardRunnable) throws Exception {
        int AD_Chart_ID;
        String url;
        int PA_Goal_ID;
        int AD_Process_ID;
        int AD_Window_ID;
        String htmlContent;
        boolean empty = true;
        String string = htmlContent = dc.get_ID() > 0 ? dc.get_Translation("HTML") : null;
        if (htmlContent != null) {
            StringBuilder result;
            block31: {
                result = new StringBuilder("<html><head>");
                URL url2 = this.getClass().getClassLoader().getResource("org/compiere/css/PAPanel.css");
                BufferedReader bufferedReader = null;
                try {
                    try {
                        String cssLine;
                        InputStreamReader ins = new InputStreamReader(url2.openStream());
                        bufferedReader = new BufferedReader(ins);
                        result.append("<style type=\"text/css\">");
                        while ((cssLine = bufferedReader.readLine()) != null) {
                            result.append(String.valueOf(cssLine) + "\n");
                        }
                        result.append("</style>");
                    }
                    catch (Exception e1) {
                        logger.log(Level.SEVERE, e1.getLocalizedMessage(), (Throwable)e1);
                        if (bufferedReader == null) break block31;
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        bufferedReader = null;
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        bufferedReader = null;
                    }
                    throw throwable;
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bufferedReader = null;
                }
            }
            result.append("</head><body><div class=\"content\">\n");
            result.append(String.valueOf(this.stripHtml(htmlContent, false)) + "<br>\n");
            result.append("</div>\n</body>\n</html>");
            Html html = new Html();
            html.setContent(result.toString());
            content.appendChild((Component)html);
            empty = false;
        }
        if ((AD_Window_ID = dc.getAD_Window_ID()) > 0) {
            int AD_Menu_ID = dc.getAD_Menu_ID();
            Div div = new Div();
            ToolBarButton btn = new ToolBarButton(String.valueOf(AD_Menu_ID));
            I_AD_Menu menu = dc.getAD_Menu();
            btn.setLabel(menu.getName());
            btn.setAttribute("AD_Menu_ID", AD_Menu_ID);
            btn.addEventListener("onClick", this);
            div.appendChild((Component)btn);
            content.appendChild((Component)div);
            empty = false;
        }
        if ((AD_Process_ID = dc.getAD_Process_ID()) > 0) {
            String sql = "SELECT AD_MENU_ID FROM AD_MENU WHERE AD_Process_ID=?";
            int AD_Menu_ID = DB.getSQLValue(null, (String)sql, (int)AD_Process_ID);
            ToolBarButton btn = new ToolBarButton();
            MMenu menu = new MMenu(Env.getCtx(), AD_Menu_ID, null);
            btn.setAttribute("AD_Menu_ID", AD_Menu_ID);
            btn.addEventListener("onClick", this);
            empty = false;
            if (dc.isEmbedReportContent()) {
                String processParameters = dc.getProcessParameters();
                this.embedReport(content, AD_Process_ID, processParameters);
                Toolbar toolbar = new Toolbar();
                content.appendChild((Component)toolbar);
                btn.setLabel("Open run dialog");
                toolbar.appendChild((Component)btn);
                btn = new ToolBarButton();
                btn.setAttribute("AD_Process_ID", AD_Process_ID);
                btn.setAttribute("ProcessParameters", processParameters);
                btn.addEventListener("onClick", this);
                btn.setLabel("View report in new tab");
                toolbar.appendChild((Component)new Separator("vertical"));
                toolbar.appendChild((Component)btn);
            } else {
                btn.setLabel(menu.getName());
                content.appendChild((Component)btn);
            }
        }
        if ((PA_Goal_ID = dc.getPA_Goal_ID()) > 0) {
            Div div = new Div();
            Toolbarbutton link = new Toolbarbutton();
            link.setImage(ThemeManager.getThemeResource("images/Zoom16.png"));
            link.setAttribute("PA_Goal_ID", (Object)PA_Goal_ID);
            link.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    int PA_Goal_ID = (Integer)event.getTarget().getAttribute("PA_Goal_ID");
                    MGoal goal = new MGoal(Env.getCtx(), PA_Goal_ID, null);
                    new WPerformanceDetail(goal);
                }
            });
            div.appendChild((Component)link);
            content.appendChild((Component)div);
            String goalDisplay = dc.getGoalDisplay();
            MGoal goal = new MGoal(Env.getCtx(), PA_Goal_ID, null);
            WGraph graph = new WGraph(goal, 55, false, true, !"C".equals(goalDisplay), "C".equals(goalDisplay));
            content.appendChild((Component)graph);
            empty = false;
        }
        if ((url = dc.getZulFilePath()) != null) {
            try {
                Component component = null;
                List f = Service.locator().list(IDashboardGadgetFactory.class).getServices();
                for (IDashboardGadgetFactory factory : f) {
                    component = factory.getGadget(url.toString(), content);
                    if (component != null) break;
                }
                if (component != null) {
                    if (component instanceof Include) {
                        component = component.getFirstChild();
                    }
                    if (component instanceof DashboardPanel) {
                        DashboardPanel dashboardPanel = (DashboardPanel)component;
                        if (!dashboardPanel.getChildren().isEmpty()) {
                            content.appendChild((Component)dashboardPanel);
                            if (dashboardRunnable != null) {
                                dashboardRunnable.add(dashboardPanel);
                            }
                            empty = false;
                        }
                    } else {
                        content.appendChild(component);
                        empty = false;
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create components. zul=" + url, (Throwable)e);
                throw new AdempiereException((Throwable)e);
            }
        }
        if ((AD_Chart_ID = dc.getAD_Chart_ID()) > 0) {
            final Div chartPanel = new Div();
            chartPanel.setSclass("chart-gadget");
            final MChart chartModel = new MChart(Env.getCtx(), AD_Chart_ID, null);
            content.appendChild((Component)chartPanel);
            empty = false;
            chartPanel.addEventListener("onAfterSize", (EventListener)new EventListener<AfterSizeEvent>(){

                public void onEvent(AfterSizeEvent event) throws Exception {
                    int width = event.getWidth() * 90 / 100;
                    int height = event.getHeight();
                    if (height == 0) {
                        height = width * 85 / 100;
                        chartPanel.setHeight(String.valueOf(height) + "px");
                    }
                    chartPanel.getChildren().clear();
                    ChartModel model = new ChartModel();
                    model.chart = chartModel;
                    List list = Service.locator().list(IChartRendererService.class).getServices();
                    for (IChartRendererService renderer : list) {
                        if (renderer.renderChart((Component)chartPanel, width, height, model)) break;
                    }
                }
            });
        }
        return !empty;
    }

    public void onEvent(Event event) throws Exception {
        Panel panel;
        Object value;
        Component comp = event.getTarget();
        String eventName = event.getName();
        if (event instanceof MaximizeEvent) {
            MaximizeEvent me = (MaximizeEvent)event;
            Panel panel2 = (Panel)event.getTarget();
            if (me.isMaximized()) {
                this.prevParent = panel2.getParent();
                this.prevNext = panel2.getNextSibling();
                panel2.detach();
                for (Anchorchildren anchorChildren : this.columnList) {
                    anchorChildren.detach();
                }
                this.dashboardLayout.appendChild((Component)this.maximizedHolder);
                this.maximizedHolder.appendChild((Component)panel2);
                panel2.setSclass("dashboard-widget dashboard-widget-max");
            } else {
                this.maximizedHolder.detach();
                panel2.detach();
                this.prevParent.insertBefore((Component)panel2, this.prevNext);
                for (Anchorchildren anchorChildren : this.columnList) {
                    this.dashboardLayout.appendChild((Component)anchorChildren);
                }
                panel2.setSclass("dashboard-widget");
                ZKUpdateUtil.setWidth((HtmlBasedComponent)panel2, null);
                ZKUpdateUtil.setHeight((HtmlBasedComponent)panel2, null);
            }
        } else if (eventName.equals("onClick")) {
            if (comp instanceof ToolBarButton) {
                ToolBarButton btn = (ToolBarButton)comp;
                if (btn.getAttribute("AD_Menu_ID") != null) {
                    int menuId = (Integer)btn.getAttribute("AD_Menu_ID");
                    if (menuId > 0) {
                        SessionManager.getAppDesktop().onMenuSelected(menuId);
                    }
                } else if (btn.getAttribute("AD_Process_ID") != null) {
                    int processId = (Integer)btn.getAttribute("AD_Process_ID");
                    String parameters = (String)btn.getAttribute("ProcessParameters");
                    if (processId > 0) {
                        this.openReportInViewer(processId, parameters);
                    }
                }
            }
        } else if (eventName.equals("onDrop")) {
            DropEvent de = (DropEvent)event;
            Component dragged = de.getDragged();
            if (dragged instanceof Caption) {
                Caption caption = (Caption)dragged;
                Panel panel3 = null;
                if (caption.getParent() instanceof Panel) {
                    panel3 = (Panel)caption.getParent();
                }
                if (panel3 != null) {
                    Anchorchildren target;
                    if (comp instanceof Panel) {
                        Panel target2 = (Panel)comp;
                        if (target2.getParent() != null && target2.getParent() instanceof Vlayout) {
                            Vlayout dashboardColumnLayout = (Vlayout)target2.getParent();
                            dashboardColumnLayout.insertBefore((Component)panel3, (Component)target2);
                            this.saveDashboardPreference(dashboardColumnLayout);
                        }
                    } else if (comp instanceof Anchorchildren && (target = (Anchorchildren)comp).getFirstChild() != null && target.getFirstChild() instanceof Vlayout) {
                        Vlayout dashboardColumnLayout = (Vlayout)target.getFirstChild();
                        dashboardColumnLayout.appendChild((Component)panel3);
                        this.saveDashboardPreference(dashboardColumnLayout);
                    }
                }
            }
        } else if (eventName.equals("onOpen") && comp instanceof Panel && (value = (panel = (Panel)comp).getAttribute("PA_DashboardPreference_ID")) != null) {
            int PA_DashboardPreference_ID = Integer.parseInt(value.toString());
            MDashboardPreference preference = new MDashboardPreference(Env.getCtx(), PA_DashboardPreference_ID, null);
            preference.setIsCollapsedByDefault(!panel.isOpen());
            if (!preference.save()) {
                logger.log(Level.SEVERE, "Failed to save dashboard preference " + preference.toString());
            }
        }
    }

    private void createDashboardPreference(int AD_User_ID, int AD_Role_ID) {
        MDashboardContent[] dcs;
        MDashboardContent[] mDashboardContentArray = dcs = MDashboardContentAccess.get((Properties)Env.getCtx(), (int)AD_Role_ID, (int)AD_User_ID, null);
        int n = dcs.length;
        int n2 = 0;
        while (n2 < n) {
            MDashboardContent dc = mDashboardContentArray[n2];
            MDashboardPreference preference = new MDashboardPreference(Env.getCtx(), 0, null);
            preference.setAD_Org_ID(0);
            preference.setAD_Role_ID(AD_Role_ID);
            preference.set_ValueNoCheck("AD_User_ID", (Object)AD_User_ID);
            preference.setColumnNo(dc.getColumnNo());
            preference.setIsCollapsedByDefault(dc.isCollapsedByDefault());
            preference.setIsShowInDashboard(dc.isShowInDashboard());
            preference.setLine(dc.getLine());
            preference.setPA_DashboardContent_ID(dc.getPA_DashboardContent_ID());
            if (!preference.save()) {
                logger.log(Level.SEVERE, "Failed to create dashboard preference " + preference.toString());
            }
            ++n2;
        }
    }

    private boolean updatePreferences(MDashboardPreference[] dps, MDashboardContent[] dcs, Properties ctx) {
        boolean change = false;
        int i = 0;
        while (i < dcs.length) {
            boolean isNew = true;
            int j = 0;
            while (j < dps.length) {
                if (dps[j].getPA_DashboardContent_ID() == dcs[i].getPA_DashboardContent_ID()) {
                    isNew = false;
                }
                ++j;
            }
            if (isNew) {
                MDashboardPreference preference = new MDashboardPreference(ctx, 0, null);
                preference.setAD_Org_ID(0);
                preference.setAD_Role_ID(Env.getAD_Role_ID((Properties)ctx));
                preference.set_ValueNoCheck("AD_User_ID", (Object)Env.getAD_User_ID((Properties)ctx));
                preference.setColumnNo(dcs[i].getColumnNo());
                preference.setIsCollapsedByDefault(dcs[i].isCollapsedByDefault());
                preference.setIsShowInDashboard(dcs[i].isShowInDashboard());
                preference.setLine(dcs[i].getLine());
                preference.setPA_DashboardContent_ID(dcs[i].getPA_DashboardContent_ID());
                preference.saveEx();
                if (!change) {
                    change = true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < dps.length) {
            boolean found = false;
            int j = 0;
            while (j < dcs.length) {
                if (dcs[j].getPA_DashboardContent_ID() == dps[i].getPA_DashboardContent_ID()) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                dps[i].deleteEx(true);
                if (!change) {
                    change = true;
                }
            }
            ++i;
        }
        return change;
    }

    private void saveDashboardPreference(Vlayout layout) {
        Object value = layout.getAttribute("ColumnNo");
        if (value != null) {
            int columnNo = Integer.parseInt(value.toString());
            value = layout.getAttribute("IsShowInDashboard");
            if (value != null) {
                boolean isAdditionalColumn;
                boolean isShowInDashboard = Boolean.parseBoolean(value.toString());
                List children = layout.getChildren();
                int counter = 0;
                for (Component child : children) {
                    Panel panel;
                    if (!(child instanceof Panel) || (value = (panel = (Panel)child).getAttribute("PA_DashboardPreference_ID")) == null) continue;
                    int PA_DashboardPreference_ID = Integer.parseInt(value.toString());
                    MDashboardPreference preference = new MDashboardPreference(Env.getCtx(), PA_DashboardPreference_ID, null);
                    preference.setColumnNo(columnNo);
                    preference.setLine(new BigDecimal(++counter * 10));
                    preference.setIsShowInDashboard(isShowInDashboard);
                    if (preference.save()) continue;
                    logger.log(Level.SEVERE, "Failed to save dashboard preference " + preference.toString());
                }
                if (isShowInDashboard && (value = layout.getAttribute("IsAdditionalColumn")) != null && (isAdditionalColumn = Boolean.parseBoolean(value.toString()))) {
                    layout.setAttribute("IsAdditionalColumn", (Object)false);
                    int noOfCols = this.columnList.size();
                    int dashboardWidth = 95;
                    int width = noOfCols <= 0 ? dashboardWidth : dashboardWidth / noOfCols;
                    int extraWidth = 100 - (noOfCols <= 0 ? dashboardWidth : width * noOfCols) - (100 - dashboardWidth - 1);
                    for (Anchorchildren column : this.columnList) {
                        column.setAnchor(String.valueOf(width) + "%" + " 100%");
                    }
                    Vlayout dashboardColumnLayout = new Vlayout();
                    dashboardColumnLayout.setAttribute("ColumnNo", (Object)(columnNo + 1));
                    dashboardColumnLayout.setAttribute("IsShowInDashboard", (Object)isShowInDashboard);
                    dashboardColumnLayout.setAttribute("IsAdditionalColumn", (Object)true);
                    Anchorchildren dashboardColumn = new Anchorchildren();
                    dashboardColumn.setAnchor(String.valueOf(extraWidth) + "% 100%");
                    if (!ClientInfo.isMobile()) {
                        dashboardColumn.setDroppable("true");
                        dashboardColumn.addEventListener("onDrop", (EventListener)this);
                    }
                    dashboardColumn.appendChild((Component)dashboardColumnLayout);
                    this.columnList.add(dashboardColumn);
                    this.dashboardLayout.appendChild((Component)dashboardColumn);
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)dashboardColumnLayout, "100%");
                    this.dashboardLayout.invalidate();
                }
                if (!this.dashboardRunnable.isEmpty()) {
                    this.dashboardRunnable.refreshDashboard(false);
                }
            }
        }
    }

    public void onSetPage(Page page, Desktop desktop) {
        if (this.dashboardTimer != null) {
            DashboardRunnable tmp = this.dashboardRunnable;
            this.dashboardRunnable = new DashboardRunnable(tmp, desktop);
            this.dashboardTimer.setPage(page);
        }
    }

    public void onLogOut() {
        if (this.dashboardTimer != null) {
            this.dashboardTimer.detach();
            this.dashboardTimer = null;
        }
        if (this.dashboardRunnable != null) {
            this.dashboardRunnable = null;
        }
        this.dashboardLayout.detach();
        this.dashboardLayout = null;
    }

    public void addDashboardPanel(DashboardPanel dashboardPanel) {
        if (this.dashboardRunnable != null) {
            this.dashboardRunnable.add(dashboardPanel);
        }
    }

    private String stripHtml(String htmlString, boolean all) {
        htmlString = htmlString.replace("<html>", "").replace("</html>", "").replace("<body>", "").replace("</body>", "").replace("<head>", "").replace("</head>", "");
        if (all) {
            htmlString = htmlString.replace(">", "&gt;").replace("<", "&lt;");
        }
        return htmlString;
    }

    private ReportEngine runReport(int AD_Process_ID, String parameters) {
        MProcess process = MProcess.get((Properties)Env.getCtx(), (int)AD_Process_ID);
        if (!process.isReport() || process.getAD_ReportView_ID() == 0) {
            throw new IllegalArgumentException("Not a Report AD_Process_ID=" + process.getAD_Process_ID() + " - " + process.getName());
        }
        int AD_Table_ID = 0;
        int Record_ID = 0;
        MPInstance pInstance = new MPInstance(process, Record_ID);
        this.fillParameter(pInstance, parameters);
        ProcessInfo pi = new ProcessInfo(process.getName(), process.getAD_Process_ID(), AD_Table_ID, Record_ID);
        pi.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
        pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)Env.getCtx()));
        pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        if (!process.processIt(pi, null) && pi.getClassName() != null) {
            throw new IllegalStateException("Process failed: (" + pi.getClassName() + ") " + pi.getSummary());
        }
        ReportEngine re = ReportEngine.get((Properties)Env.getCtx(), (ProcessInfo)pi);
        if (re == null) {
            throw new IllegalStateException("Cannot create Report AD_Process_ID=" + process.getAD_Process_ID() + " - " + process.getName());
        }
        return re;
    }

    public void embedReport(Component parent, int AD_Process_ID, String parameters) throws Exception {
        ReportEngine re = this.runReport(AD_Process_ID, parameters);
        Iframe iframe = new Iframe();
        iframe.setSclass("dashboard-report-iframe");
        File file = File.createTempFile(re.getName(), ".html");
        re.createHTML(file, false, AEnv.getLanguage(Env.getCtx()), (IHTMLExtension)new HTMLExtension(Executions.getCurrent().getContextPath(), "rp", SessionManager.getAppDesktop().getComponent().getUuid()));
        AMedia media = new AMedia(re.getName(), "html", "text/html", file, false);
        iframe.setContent((Media)media);
        parent.appendChild((Component)iframe);
    }

    protected void openReportInViewer(int AD_Process_ID, String parameters) {
        ReportEngine re = this.runReport(AD_Process_ID, parameters);
        new ZkReportViewerProvider().openViewer(re);
    }

    private void fillParameter(MPInstance pInstance, String parameters) {
        if (parameters != null && parameters.trim().length() > 0) {
            MPInstancePara[] iParams;
            String value;
            String[] params;
            HashMap<String, String> paramMap = new HashMap<String, String>();
            String[] stringArray = params = parameters.split("[,]");
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String[] elements = s.split("[=]");
                String key = elements[0];
                value = elements[1];
                paramMap.put(key, value);
                ++n2;
            }
            MPInstancePara[] mPInstanceParaArray = iParams = pInstance.getParameters();
            int n3 = iParams.length;
            n = 0;
            while (n < n3) {
                String variable;
                MPInstancePara iPara = mPInstanceParaArray[n];
                value = variable = (String)paramMap.get(iPara.getParameterName());
                if (variable == null || variable != null && variable.length() == 0) {
                    value = null;
                } else if (variable.indexOf(64) != -1) {
                    value = Env.parseContext((Properties)Env.getCtx(), (int)0, (String)variable, (boolean)false, (boolean)false);
                }
                if (value != null) {
                    if (DisplayType.isNumeric((int)iPara.getDisplayType()) || DisplayType.isID((int)iPara.getDisplayType())) {
                        BigDecimal bd = null;
                        bd = value instanceof BigDecimal ? (BigDecimal)((Object)value) : (value instanceof Integer ? new BigDecimal((Integer)((Object)value)) : new BigDecimal(value.toString()));
                        iPara.setP_Number(bd);
                    } else if (DisplayType.isDate((int)iPara.getDisplayType())) {
                        Timestamp ts = null;
                        ts = value instanceof Timestamp ? (Timestamp)((Object)value) : Timestamp.valueOf(value.toString());
                        iPara.setP_Date(ts);
                    } else {
                        iPara.setP_String(value.toString());
                    }
                    iPara.saveEx();
                }
                ++n;
            }
        }
    }

    public void updateLayout(ClientInfo clientInfo) {
        if (this.isShowInDashboard && ClientInfo.isMobile()) {
            int n = 0;
            if (ClientInfo.maxWidth(999)) {
                n = ClientInfo.maxWidth(699) ? 1 : 2;
            }
            if (this.noOfCols > 0 && n > 0 && this.noOfCols != n) {
                this.render(null, null, true, true);
                this.dashboardLayout.invalidate();
            }
        }
    }
}

