/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import java.util.Properties;
import org.adempiere.webui.apps.graph.WPAPanel;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.util.ServerPushTemplate;
import org.compiere.model.MSysConfig;
import org.compiere.util.Env;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;

public class DPPerformance
extends DashboardPanel {
    private static final String ON_POST_RENDER_ATTR = "onPostRender.Event.Posted";
    private static final long serialVersionUID = -8878665031716441912L;

    public DPPerformance() {
        this.setSclass("performance-widget");
        WPAPanel paPanel = this.createPAPanel();
        if (paPanel != null) {
            this.appendChild((Component)paPanel);
        }
    }

    protected WPAPanel createPAPanel() {
        WPAPanel paPanel = WPAPanel.get();
        return paPanel;
    }

    @Override
    public void refresh(ServerPushTemplate template) {
        super.refresh(template);
        if (Executions.getCurrent() != null && this.getAttribute(ON_POST_RENDER_ATTR) == null) {
            this.setAttribute(ON_POST_RENDER_ATTR, Boolean.TRUE);
            Events.echoEvent((String)"onPostRender", (Component)this, null);
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null && Executions.getCurrent() != null && this.getAttribute(ON_POST_RENDER_ATTR) == null) {
            this.setAttribute(ON_POST_RENDER_ATTR, Boolean.TRUE);
            Events.echoEvent((String)"onPostRender", (Component)this, null);
        }
    }

    public void onPostRender() {
        this.removeAttribute(ON_POST_RENDER_ATTR);
        if (this.getFirstChild() != null) {
            int timeout = MSysConfig.getIntValue((String)"ZK_DASHBOARD_PERFORMANCE_TIMEOUT", (int)500, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            Component grid = this.getFirstChild().getFirstChild();
            String script = "setTimeout(function() { var grid = jq('#" + grid.getUuid() + "');";
            script = String.valueOf(script) + "grid.parent().height(grid.css('height'));}, " + timeout + ");";
            if (Executions.getCurrent() != null) {
                Clients.response((AuResponse)new AuScript(script));
            }
            this.getFirstChild().invalidate();
        }
    }
}

