/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.util.Callback;
import org.adempiere.webui.adwindow.ADTabpanel;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.desktop.FavouriteController;
import org.adempiere.webui.exception.ApplicationException;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.MMenu;
import org.compiere.model.MQuery;
import org.compiere.model.MTreeNode;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.A;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Image;
import org.zkoss.zul.Label;
import org.zkoss.zul.Layout;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Panelchildren;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.Vlayout;

public class DPFavourites
extends DashboardPanel
implements EventListener<Event> {
    private static final long serialVersionUID = 8398216266900311289L;
    private static final String NODE_ID_ATTR = "Node_ID";
    public static final String FAVOURITE_DROPPABLE = "favourite";
    public static final String DELETE_FAV_DROPPABLE = "deleteFav";
    private Layout bxFav;
    private Label lblMsg;
    private List<A> links = new ArrayList<A>();
    private boolean inCallingController;

    public DPFavourites() {
        Panel panel = new Panel();
        this.appendChild((Component)panel);
        Panelchildren favContent = new Panelchildren();
        panel.appendChild((Component)favContent);
        this.bxFav = new Vlayout();
        this.setSclass("favourites-box");
        favContent.appendChild((Component)this.bxFav);
        this.createFavouritesPanel();
        Toolbar favToolbar = new Toolbar();
        this.appendChild((Component)favToolbar);
        if (ThemeManager.isUseFontIconForImage()) {
            Label deleteLabel = new Label();
            favToolbar.appendChild((Component)deleteLabel);
            deleteLabel.setSclass("z-icon-Trash trash-font-icon");
            deleteLabel.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Delete")));
            deleteLabel.setDroppable(DELETE_FAV_DROPPABLE);
            deleteLabel.addEventListener("onDrop", (EventListener)this);
        } else {
            Image img = new Image(ThemeManager.getThemeResource("images/Delete24.png"));
            favToolbar.appendChild((Component)img);
            img.setStyle("text-align: right; width:24px; height:24px;");
            img.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Delete")));
            img.setDroppable(DELETE_FAV_DROPPABLE);
            img.addEventListener("onDrop", (EventListener)this);
        }
        favContent.setDroppable(FAVOURITE_DROPPABLE);
        favContent.addEventListener("onDrop", (EventListener)this);
    }

    private void createFavouritesPanel() {
        FavouriteController controller = FavouriteController.getInstance(Executions.getCurrent().getSession());
        List<MTreeNode> favorites = controller.getFavourites();
        for (MTreeNode nd : favorites) {
            this.addNode(nd);
        }
        this.lblMsg = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"DropMenuItemHere"));
        if (this.bxFav.getChildren().isEmpty()) {
            this.bxFav.appendChild((Component)this.lblMsg);
        }
        controller.addInsertedCallback((Callback<MTreeNode>)((Callback)t -> this.onInsertedCallback((MTreeNode)t)));
        controller.addDeletedCallback((Callback<Integer>)((Callback)t -> this.onDeletedCallback((Integer)t)));
    }

    private void addNode(MTreeNode nd) {
        this.addNode(nd.getNode_ID(), nd.toString().trim(), nd.getDescription(), this.getIconFile(nd), nd.isWindow() && !nd.isForm());
    }

    private void onDeletedCallback(Integer nodeId) {
        if (this.inCallingController) {
            return;
        }
        for (A link : this.links) {
            String id = (String)link.getAttribute(NODE_ID_ATTR);
            if (!id.equals(nodeId.toString())) continue;
            this.removeLinkFromUI(link);
            break;
        }
    }

    private void onInsertedCallback(MTreeNode node) {
        if (this.inCallingController) {
            return;
        }
        for (A link : this.links) {
            String id = (String)link.getAttribute(NODE_ID_ATTR);
            if (!id.equals(String.valueOf(node.getNode_ID()))) continue;
            return;
        }
        this.addNode(node);
    }

    protected void addNode(int nodeId, String label, String description, String imageSrc, boolean addNewBtn) {
        Hlayout hbox = new Hlayout();
        hbox.setSclass("favourites-item");
        hbox.setSpacing("0px");
        hbox.setValign("middle");
        this.bxFav.appendChild((Component)hbox);
        A btnFavItem = new A();
        btnFavItem.setAttribute(NODE_ID_ATTR, (Object)String.valueOf(nodeId));
        hbox.appendChild((Component)btnFavItem);
        btnFavItem.setLabel(label);
        btnFavItem.setTooltiptext(description);
        if (ThemeManager.isUseFontIconForImage()) {
            btnFavItem.setIconSclass(imageSrc);
        } else if (imageSrc.startsWith("/theme/")) {
            btnFavItem.setImage(imageSrc);
        } else {
            btnFavItem.setImage(ThemeManager.getThemeResource(imageSrc));
        }
        btnFavItem.setDraggable(DELETE_FAV_DROPPABLE);
        btnFavItem.addEventListener("onClick", (EventListener)this);
        btnFavItem.addEventListener("onDrop", (EventListener)this);
        btnFavItem.setSclass("menu-href");
        if (addNewBtn) {
            Toolbarbutton newBtn = new Toolbarbutton(null, ThemeManager.getThemeResource("images/New16.png"));
            if (ThemeManager.isUseFontIconForImage()) {
                newBtn.setImage(null);
                newBtn.setIconSclass("z-icon-New");
            }
            newBtn.setAttribute(NODE_ID_ATTR, (Object)String.valueOf(nodeId));
            hbox.appendChild((Component)newBtn);
            newBtn.addEventListener("onClick", (EventListener)this);
            newBtn.setSclass("fav-new-btn");
            newBtn.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"New")));
        }
        this.links.add(btnFavItem);
    }

    public void onEvent(Event event) {
        Component comp = event.getTarget();
        String eventName = event.getName();
        if (eventName.equals("onClick")) {
            this.doOnClick(comp);
        } else if (eventName.equals("onDrop")) {
            DropEvent de = (DropEvent)event;
            Component dragged = de.getDragged();
            if (comp instanceof Panelchildren) {
                if (dragged instanceof Treerow) {
                    Treerow treerow = (Treerow)dragged;
                    Treeitem treeitem = (Treeitem)treerow.getParent();
                    this.addItem(treeitem);
                }
            } else if ((comp instanceof Image || comp instanceof Label) && dragged instanceof A) {
                A btn = (A)dragged;
                this.removeLink(btn);
            }
        }
    }

    private void doOnClick(Component comp) {
        if (comp instanceof A) {
            A btn = (A)comp;
            int menuId = 0;
            try {
                menuId = Integer.valueOf((String)btn.getAttribute(NODE_ID_ATTR));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (menuId > 0) {
                SessionManager.getAppDesktop().onMenuSelected(menuId);
            }
        } else if (comp instanceof Toolbarbutton) {
            Toolbarbutton btn = (Toolbarbutton)comp;
            int menuId = 0;
            try {
                menuId = Integer.valueOf((String)btn.getAttribute(NODE_ID_ATTR));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (menuId > 0) {
                try {
                    MMenu menu = new MMenu(Env.getCtx(), menuId, null);
                    MQuery query = new MQuery("");
                    query.addRestriction("1=2");
                    query.setRecordCount(0);
                    SessionManager.getAppDesktop().openWindow(menu.getAD_Window_ID(), query, new Callback<ADWindow>(){

                        public void onCallback(ADWindow result) {
                            if (result == null) {
                                return;
                            }
                            result.getADWindowContent().onNew();
                            ADTabpanel adtabpanel = (ADTabpanel)result.getADWindowContent().getADTab().getSelectedTabpanel();
                            adtabpanel.focusToFirstEditor(false);
                        }
                    });
                }
                catch (Exception e) {
                    throw new ApplicationException(e.getMessage(), e);
                }
            }
        }
    }

    private void removeLink(A btn) {
        String value = (String)btn.getAttribute(NODE_ID_ATTR);
        if (value != null) {
            int Node_ID = Integer.valueOf(value.toString());
            FavouriteController controller = FavouriteController.getInstance(Executions.getCurrent().getSession());
            this.inCallingController = true;
            if (controller.removeNode(Node_ID)) {
                this.removeLinkFromUI(btn);
            }
            this.inCallingController = false;
        }
    }

    private void removeLinkFromUI(A btn) {
        if (btn.getParent() instanceof Hlayout) {
            this.bxFav.removeChild(btn.getParent());
        }
        if (this.bxFav.getChildren().isEmpty()) {
            this.bxFav.appendChild((Component)this.lblMsg);
        }
        this.bxFav.invalidate();
        this.links.remove(btn);
    }

    public void addItem(Treeitem treeitem) {
        Object value = treeitem.getValue();
        if (value != null) {
            int Node_ID = Integer.valueOf(value.toString());
            FavouriteController controller = FavouriteController.getInstance(Executions.getCurrent().getSession());
            this.inCallingController = true;
            if (controller.addNode(Node_ID)) {
                String menuType = (String)treeitem.getAttribute("menu.type");
                boolean isWindow = menuType != null && menuType.equals("window");
                String label = null;
                String image = null;
                if (treeitem.getLabel() != null && treeitem.getLabel().trim().length() > 0) {
                    label = treeitem.getLabel().trim();
                    image = treeitem.getImage();
                } else {
                    A link = (A)treeitem.getTreerow().getFirstChild().getFirstChild();
                    label = link.getLabel();
                    image = ThemeManager.isUseFontIconForImage() && link.getIconSclass() != null ? link.getIconSclass() : link.getImage();
                }
                this.addNode(Node_ID, label, treeitem.getTooltiptext(), image, isWindow);
            } else {
                FDialog.error(0, (Component)this, "BookmarkExist", null);
            }
            this.inCallingController = false;
        }
    }

    private String getIconFile(MTreeNode mt) {
        if (ThemeManager.isUseFontIconForImage()) {
            return this.getIconSclass(mt);
        }
        if (mt.isWindow()) {
            return "images/mWindow.png";
        }
        if (mt.isReport()) {
            return "images/mReport.png";
        }
        if (mt.isProcess() || mt.isTask()) {
            return "images/mProcess.png";
        }
        if (mt.isWorkFlow()) {
            return "images/mWorkFlow.png";
        }
        if (mt.isForm()) {
            return "images/mForm.png";
        }
        if (mt.isInfo()) {
            return "images/mInfo.png";
        }
        return "images/mWindow.png";
    }

    private String getIconSclass(MTreeNode mt) {
        if (mt.isWindow()) {
            return "z-icon-Window";
        }
        if (mt.isReport()) {
            return "z-icon-Report";
        }
        if (mt.isProcess() || mt.isTask()) {
            return "z-icon-Task";
        }
        if (mt.isWorkFlow()) {
            return "z-icon-WorkFlow";
        }
        if (mt.isForm()) {
            return "z-icon-Form";
        }
        if (mt.isInfo()) {
            return "z-icon-Info";
        }
        return "z-icon-Window";
    }
}

