/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DPActivitiesModel {
    private static final CLogger logger = CLogger.getCLogger(DPActivitiesModel.class);

    public static boolean isShowUnprocessed() {
        return Env.getAD_Client_ID((Properties)Env.getCtx()) > 0;
    }

    public static int getNoticeCount() {
        String sql = "SELECT COUNT(1) FROM AD_Note WHERE AD_Client_ID=? AND AD_User_ID IN (0,?) AND Processed='N' AND AD_BroadcastMessage_ID IS NULL";
        int retValue = DB.getSQLValue(null, (String)sql, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_User_ID((Properties)Env.getCtx()));
        return retValue;
    }

    public static int getRequestCount() {
        String sql = MRole.getDefault().addAccessSQL("SELECT COUNT(1) FROM R_Request WHERE (SalesRep_ID=? OR AD_Role_ID=?) AND Processed='N' AND (DateNextAction IS NULL OR TRUNC(DateNextAction) <= TRUNC(SysDate)) AND (R_Status_ID IS NULL OR R_Status_ID IN (SELECT R_Status_ID FROM R_Status WHERE IsClosed='N'))", "R_Request", false, true);
        int retValue = DB.getSQLValue(null, (String)sql, (int)Env.getAD_User_ID((Properties)Env.getCtx()), (int)Env.getAD_Role_ID((Properties)Env.getCtx()));
        return retValue;
    }

    public static int getWorkflowCount() {
        int count;
        block6: {
            count = 0;
            String sql = "SELECT count(*) FROM AD_WF_Activity a WHERE a.Processed='N' AND a.WFState='OS' AND ( a.AD_User_ID=? OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='H' AND COALESCE(r.AD_User_ID,0)=0 AND COALESCE(r.AD_Role_ID,0)=0 AND (a.AD_User_ID=? OR a.AD_User_ID IS NULL)) OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='H' AND r.AD_User_ID=?) OR EXISTS (SELECT * FROM AD_WF_Responsible r INNER JOIN AD_User_Roles ur ON (r.AD_Role_ID=ur.AD_Role_ID) WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='R' AND ur.AD_User_ID=?)) AND a.AD_Client_ID=?";
            int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
            int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
            sql = MRole.getDefault().addAccessSQL(sql, "a", true, false);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, AD_User_ID);
                    pstmt.setInt(2, AD_User_ID);
                    pstmt.setInt(3, AD_User_ID);
                    pstmt.setInt(4, AD_User_ID);
                    pstmt.setInt(5, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return count;
    }

    public static int getUnprocessedCount() {
        if (!DPActivitiesModel.isShowUnprocessed()) {
            return 0;
        }
        String sql = "SELECT COUNT(1) FROM RV_Unprocessed WHERE AD_Client_ID=? AND CreatedBy=?";
        int retValue = DB.getSQLValue(null, (String)sql, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_User_ID((Properties)Env.getCtx()));
        return retValue;
    }
}

