/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import java.util.HashMap;
import java.util.Properties;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.dashboard.DPActivitiesModel;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ServerPushTemplate;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zul.Box;
import org.zkoss.zul.Vbox;

public class DPActivities
extends DashboardPanel
implements EventListener<Event> {
    private static final long serialVersionUID = 3787249181565314148L;
    private static final CLogger logger = CLogger.getCLogger(DPActivities.class);
    private Button btnNotice;
    private Button btnRequest;
    private Button btnWorkflow;
    private Button btnUnprocessed;
    private String labelN;
    private String labelR;
    private String labelW;
    private String labelU;
    private int noOfNotice;
    private int noOfRequest;
    private int noOfWorkflow;
    private int noOfUnprocessed;

    public DPActivities() {
        this.setSclass("activities-box");
        this.appendChild((Component)this.createActivitiesPanel());
    }

    private Box createActivitiesPanel() {
        Vbox vbox = new Vbox();
        this.btnNotice = new Button();
        vbox.appendChild((Component)this.btnNotice);
        this.labelN = Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"AD_Note_ID"));
        this.btnNotice.setLabel(String.valueOf(this.labelN) + " : 0");
        this.btnNotice.setTooltiptext(this.labelN);
        this.btnNotice.setImage(ThemeManager.getThemeResource("images/GetMail16.png"));
        int AD_Menu_ID = DB.getSQLValue(null, (String)"SELECT AD_Menu_ID FROM AD_Menu WHERE Name = 'Notice' AND IsSummary = 'N'");
        this.btnNotice.setName(String.valueOf(AD_Menu_ID));
        this.btnNotice.addEventListener("onClick", this);
        this.btnRequest = new Button();
        vbox.appendChild((Component)this.btnRequest);
        this.labelR = Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"R_Request_ID"));
        this.btnRequest.setLabel(String.valueOf(this.labelR) + " : 0");
        this.btnRequest.setTooltiptext(this.labelR);
        this.btnRequest.setImage(ThemeManager.getThemeResource("images/Request16.png"));
        AD_Menu_ID = DB.getSQLValue(null, (String)"SELECT AD_Menu_ID FROM AD_Menu WHERE Name = 'Request' AND IsSummary = 'N'");
        this.btnRequest.setName(String.valueOf(AD_Menu_ID));
        this.btnRequest.addEventListener("onClick", this);
        this.btnWorkflow = new Button();
        vbox.appendChild((Component)this.btnWorkflow);
        this.labelW = Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"WorkflowActivities"));
        this.btnWorkflow.setLabel(String.valueOf(this.labelW) + " : 0");
        this.btnWorkflow.setTooltiptext(this.labelW);
        this.btnWorkflow.setImage(ThemeManager.getThemeResource("images/Assignment16.png"));
        AD_Menu_ID = DB.getSQLValue(null, (String)"SELECT AD_Menu_ID FROM AD_Menu WHERE Name = 'Workflow Activities' AND IsSummary = 'N'");
        this.btnWorkflow.setName(String.valueOf(AD_Menu_ID));
        this.btnWorkflow.addEventListener("onClick", this);
        if (DPActivitiesModel.isShowUnprocessed()) {
            this.btnUnprocessed = new Button();
            vbox.appendChild((Component)this.btnUnprocessed);
            this.labelU = Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"UnprocessedDocs"));
            this.btnUnprocessed.setLabel(String.valueOf(this.labelU) + " : 0");
            this.btnUnprocessed.setTooltiptext(this.labelU);
            this.btnUnprocessed.setImage(ThemeManager.getThemeResource("images/Open16.png"));
            AD_Menu_ID = DB.getSQLValue(null, (String)"SELECT AD_Menu_ID FROM AD_Menu WHERE Name = 'My Unprocessed Documents' AND IsSummary = 'N'");
            this.btnUnprocessed.setName(String.valueOf(AD_Menu_ID));
            this.btnUnprocessed.addEventListener("onClick", this);
        }
        return vbox;
    }

    @Override
    public void refresh(ServerPushTemplate template) {
        int notice = DPActivitiesModel.getNoticeCount();
        int request = DPActivitiesModel.getRequestCount();
        int workflow = DPActivitiesModel.getWorkflowCount();
        int unprocessed = DPActivitiesModel.getUnprocessedCount();
        if (this.noOfNotice != notice || this.noOfRequest != request || this.noOfWorkflow != workflow || this.noOfUnprocessed != unprocessed) {
            this.noOfNotice = notice;
            this.noOfRequest = request;
            this.noOfWorkflow = workflow;
            this.noOfUnprocessed = unprocessed;
            template.executeAsync(this);
        }
    }

    @Override
    public void updateUI() {
        this.btnNotice.setLabel(String.valueOf(this.labelN) + " : " + this.noOfNotice);
        this.btnRequest.setLabel(String.valueOf(this.labelR) + " : " + this.noOfRequest);
        this.btnWorkflow.setLabel(String.valueOf(this.labelW) + " : " + this.noOfWorkflow);
        if (DPActivitiesModel.isShowUnprocessed()) {
            this.btnUnprocessed.setLabel(String.valueOf(this.labelU) + " : " + this.noOfUnprocessed);
        }
        EventQueue queue = EventQueues.lookup((String)"ActivitiesEventQueue", (boolean)true);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("notice", this.noOfNotice);
        map.put("request", this.noOfRequest);
        map.put("workflow", this.noOfWorkflow);
        map.put("unprocessed", this.noOfUnprocessed);
        Event event = new Event("onActivitiesChanged", null, map);
        queue.publish(event);
    }

    @Override
    public boolean isPooling() {
        return true;
    }

    public void onEvent(Event event) {
        Component comp = event.getTarget();
        String eventName = event.getName();
        if (eventName.equals("onClick") && comp instanceof Button) {
            Button btn = (Button)comp;
            int menuId = 0;
            try {
                menuId = Integer.valueOf(btn.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (menuId > 0) {
                SessionManager.getAppDesktop().onMenuSelected(menuId);
            }
        }
    }
}

