/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component.test;

import java.util.Vector;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.WListItemRenderer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class WListItemRendererTest {
    WListItemRenderer m_renderer;
    Vector<Object> m_dataValid = new Vector();
    Vector<Object> m_dataInvalid = new Vector();
    Vector<String> m_columnNames = new Vector();

    @Before
    public void setUp() throws Exception {
        Vector<Object> dataRowValid = new Vector<Object>();
        Vector<Object> dataRowInvalid = new Vector<Object>();
        this.m_columnNames.add("Name");
        this.m_columnNames.add("Age");
        this.m_renderer = new WListItemRenderer(this.m_columnNames);
        dataRowValid.add("River Phoenix");
        dataRowValid.add(23);
        this.m_dataValid.add(dataRowValid);
        dataRowInvalid.add("Elvis Presley");
        dataRowInvalid.add(42);
        dataRowInvalid.add("Graceland");
        this.m_dataInvalid.add(dataRowInvalid);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testWListItemRenderer() {
        WListItemRenderer renderer = new WListItemRenderer();
        Assert.assertEquals((long)0L, (long)renderer.getNoColumns());
    }

    @Test
    public final void testWListItemRendererVectorOfQextendsString() {
        Assert.assertEquals((long)2L, (long)this.m_renderer.getNoColumns());
    }

    @Ignore(value="Not running because instantiating a ZX listbox causes a NullPointerException as it attempts to post events")
    @Test
    public final void testRender() throws Exception {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public final void testUpdateColumn() {
        ListHead head = new ListHead();
        this.m_renderer.updateColumn(1, "Address");
        Assert.assertEquals((long)2L, (long)this.m_renderer.getNoColumns());
        this.m_renderer.renderListHead(head);
        ListHeader header = (ListHeader)((Object)head.getChildren().get(1));
        Assert.assertEquals((Object)"Address", (Object)header.getLabel());
    }

    @Test
    public final void testAddColumn() {
        this.m_renderer.addColumn("Address");
        Assert.assertEquals((long)3L, (long)this.m_renderer.getNoColumns());
    }

    @Test
    public final void testRenderListHead() {
        ListHead head = new ListHead();
        this.m_renderer.renderListHead(head);
        Assert.assertEquals((long)2L, (long)head.getChildren().size());
        Object header = head.getChildren().get(1);
        Assert.assertTrue((boolean)(header instanceof ListHeader));
        Assert.assertEquals((Object)"Age", (Object)((ListHeader)((Object)header)).getLabel());
    }

    @Ignore(value="Not running because the ZX listbox cannot be instantiated in JUnit")
    @Test
    public final void testGetRowPosition() {
        Assert.fail((String)"Not yet implemented");
    }

    @Ignore(value="Not running because the ZX listbox cannot be instantiated in JUnit")
    @Test
    public final void testGetColumnPosition() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public final void testClearColumns() {
        ListHead head = new ListHead();
        this.m_renderer.clearColumns();
        Assert.assertEquals((long)0L, (long)this.m_renderer.getNoColumns());
        this.m_renderer.renderListHead(head);
        Assert.assertEquals((long)0L, (long)head.getChildren().size());
    }

    @Ignore(value="Not running because the ZX listbox cannot be instantiated in JUnit")
    @Test
    public final void testClearSelection() {
        Assert.fail((String)"Not yet implemented");
    }

    @Ignore(value="Not running because the ZX listbox cannot be instantiated in JUnit")
    @Test
    public final void testAddTableValueChangeListener() {
        Assert.fail((String)"Not yet implemented");
    }
}

