/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component.test;

import java.util.Vector;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ListModelTableTest
implements WTableModelListener {
    private static final Integer ms_number0 = 0;
    private static final Integer ms_number1 = 1;
    private static final Integer ms_number2 = 2;
    private static final Integer ms_number3 = 3;
    private static final Integer ms_number4 = 4;
    private static final Integer ms_number5 = 5;
    private static final Integer ms_number6 = 6;
    private ListModelTable m_table;
    private boolean m_isListenerCalled = false;

    @Before
    public void setUp() throws Exception {
        Vector<Integer> row0 = new Vector<Integer>();
        Vector<Integer> row1 = new Vector<Integer>();
        Vector<Vector<Integer>> data = new Vector<Vector<Integer>>();
        row0.add(ms_number0);
        row0.add(ms_number1);
        row1.add(ms_number2);
        row1.add(ms_number3);
        data.add(row0);
        data.add(row1);
        this.m_table = new ListModelTable(data);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testListModelTable() {
        ListModelTable table2 = new ListModelTable();
        boolean isException = false;
        Assert.assertEquals((long)0L, (long)table2.getNoColumns());
        Assert.assertEquals((long)0L, (long)table2.getSize());
        try {
            Object data = table2.getDataAt(0, 0);
            Assert.assertNull((Object)data);
        }
        catch (IllegalArgumentException exception) {
            isException = true;
        }
        Assert.assertTrue((boolean)isException);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testListModelTableCollection() {
        int invalidRow = 2;
        int noColumns = 2;
        Assert.assertEquals((long)2L, (long)this.m_table.getNoColumns());
        Assert.assertEquals((long)2L, (long)this.m_table.getSize());
        Assert.assertEquals((Object)0, (Object)this.m_table.getDataAt(0, 0));
        Object data = this.m_table.getDataAt(2, 0);
    }

    @Test
    public final void testAddColumn() {
        int noColumns = 3;
        this.m_table.addColumn();
        Assert.assertEquals((long)3L, (long)this.m_table.getNoColumns());
        Assert.assertNull((Object)this.m_table.getDataAt(0, 2));
    }

    @Test
    public final void testSetNoColumns() {
        int noColumns = 3;
        this.m_table.setNoColumns(3);
        Assert.assertEquals((long)3L, (long)this.m_table.getNoColumns());
        Assert.assertNull((Object)this.m_table.getDataAt(0, 2));
    }

    @Test
    public final void testGetDataAt() {
        Assert.assertEquals((Object)ms_number0, (Object)this.m_table.getDataAt(0, 0));
        Assert.assertEquals((Object)ms_number3, (Object)this.m_table.getDataAt(1, 1));
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testSetDataAt() {
        int invalidRow = 2;
        this.m_table.setDataAt(ms_number4, 0, 0);
        this.m_table.setDataAt(ms_number5, 1, 1);
        Assert.assertEquals((Object)ms_number4, (Object)this.m_table.getDataAt(0, 0));
        Assert.assertEquals((Object)ms_number5, (Object)this.m_table.getDataAt(1, 1));
        this.m_table.setDataAt(ms_number6, 2, 0);
    }

    @Test
    public final void testSetNoRows() {
        int noRows = 3;
        this.m_table.setNoRows(this.m_table.getSize() + 1);
        Assert.assertEquals((long)3L, (long)this.m_table.getSize());
        Assert.assertEquals((Object)ms_number3, (Object)this.m_table.getDataAt(1, 1));
        Assert.assertNull((Object)this.m_table.getDataAt(2, 1));
    }

    @Test
    public final void testAddTableModelListener() {
        this.m_table.addTableModelListener(this);
        this.m_table.setDataAt(ms_number4, 0, 0);
        Assert.assertTrue((boolean)this.m_isListenerCalled);
    }

    @Override
    public void tableChanged(WTableModelEvent event) {
        Assert.assertEquals((Object)ms_number4, (Object)this.m_table.getDataAt(0, 0));
        this.m_isListenerCalled = true;
    }
}

