/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.List;
import org.adempiere.webui.component.ListCell;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.WListItemRenderer;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.info.InfoWindow;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.GridField;
import org.compiere.model.MInfoColumn;
import org.compiere.util.KeyNamePair;
import org.zkoss.zul.Listcell;

public class WInfoWindowListItemRenderer
extends WListItemRenderer {
    private MInfoColumn[] gridDisplayedInfoColumns = null;
    private ColumnInfo[] gridDisplayedColumnInfos = null;
    private InfoWindow infoWindow = null;

    public WInfoWindowListItemRenderer(InfoWindow infoWindow) {
        this.infoWindow = infoWindow;
    }

    public WInfoWindowListItemRenderer(InfoWindow infoWindow, List<? extends String> columnNames) {
        super(columnNames);
        this.infoWindow = infoWindow;
    }

    public void setGridDisplaydInfoColumns(MInfoColumn[] infoColumns, ColumnInfo[] columnInfos) {
        this.gridDisplayedInfoColumns = infoColumns;
        this.gridDisplayedColumnInfos = columnInfos;
    }

    @Override
    protected Listcell getCellComponent(WListbox table2, Object field, final int rowIndex, final int columnIndex) {
        if (this.gridDisplayedInfoColumns == null || this.gridDisplayedColumnInfos == null) {
            return super.getCellComponent(table2, field, rowIndex, columnIndex);
        }
        Listcell listcell = null;
        ListModelTable model = table2.getModel();
        Object obj = model.get(rowIndex);
        MInfoColumn infoColumn = this.gridDisplayedInfoColumns[columnIndex];
        if (model.isSelected(obj) && infoColumn != null && !infoColumn.isReadOnly() && columnIndex > 0) {
            ListCell listCell = new ListCell();
            final GridField gridField = this.gridDisplayedColumnInfos[columnIndex].getGridField();
            final WEditor editor = WebEditorFactory.getEditor(gridField, false);
            Object value = table2.getValueAt(rowIndex, columnIndex);
            if (value instanceof IDColumn) {
                IDColumn idc = (IDColumn)value;
                value = idc.getRecord_ID();
            } else if (value instanceof KeyNamePair) {
                KeyNamePair knp = (KeyNamePair)value;
                value = knp.getKey();
            }
            editor.setValue(value);
            editor.addValueChangeListener(new ValueChangeListener(){

                @Override
                public void valueChange(ValueChangeEvent evt) {
                    WInfoWindowListItemRenderer.this.infoWindow.onCellEditCallback(evt, rowIndex, columnIndex, editor, gridField);
                }
            });
            listCell.appendChild(editor.getComponent());
            listcell = listCell;
        }
        if (listcell == null) {
            listcell = super.getCellComponent(table2, field, rowIndex, columnIndex);
        }
        return listcell;
    }
}

