/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import org.compiere.model.Obscure;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;

public class Textbox
extends org.zkoss.zul.Textbox
implements EventListener<Event> {
    private static final long serialVersionUID = -3919623360765045602L;
    private Obscure m_obscure = null;
    private boolean m_infocus;

    public Textbox() {
        this.addFocusListener(this);
    }

    public Textbox(String value) throws WrongValueException {
        super(value);
        this.addFocusListener(this);
    }

    public void setEnabled(boolean enabled) {
        this.setDisabled(!enabled);
    }

    public void setObscureType(String obscureType) {
        this.m_obscure = obscureType != null && obscureType.length() > 0 ? new Obscure("", obscureType) : null;
        this.setValue(this.getValue());
    }

    public void addFocusListener(EventListener<Event> listener) {
        this.addEventListener("onFocus", listener);
        this.addEventListener("onBlur", listener);
    }

    public String getValue() throws WrongValueException {
        String value = super.getValue();
        if (this.m_obscure != null && value != null && value.length() > 0 && !this.isReadonly() && value.equals(this.m_obscure.getObscuredValue(this.getMaxlength()))) {
            value = this.m_obscure.getClearValue();
        }
        return value;
    }

    public void setValue(String value) throws WrongValueException {
        if (this.m_obscure != null && ("password".equals(this.getType()) || !this.m_infocus)) {
            super.setValue(this.m_obscure.getObscuredValue(value, this.getMaxlength()));
        } else {
            super.setValue(value);
        }
    }

    public void onEvent(Event event) throws Exception {
        if ("onFocus".equals(event.getName())) {
            this.m_infocus = true;
            if (this.m_obscure != null) {
                this.setValue(this.getValue());
            }
        } else if ("onBlur".equals(event.getName())) {
            this.m_infocus = false;
            if (this.m_obscure != null) {
                this.setValue(this.getValue());
            }
        }
    }

    public void setType(String type) throws WrongValueException {
        if ("password".equals(type)) {
            this.setObscureType("AA");
        }
        super.setType(type);
        this.setClientAttribute("autocomplete", "new-password");
    }
}

