/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.HashSet;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.util.ManageImageCache;
import org.compiere.model.MImage;
import org.compiere.model.MInfoWindow;
import org.zkoss.image.Image;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zul.Include;
import org.zkoss.zul.impl.LabelImageElement;

public class Tab
extends org.zkoss.zul.Tab {
    private static final long serialVersionUID = -7504310693884092219L;
    private boolean isDisableDraggDrop = false;

    public Tab(String str) {
        this.setLabel(str);
    }

    public Tab() {
    }

    public void setDecorateInfo(DecorateInfo decorateInfo) {
        if (decorateInfo != null) {
            decorateInfo.decorate((LabelImageElement)this);
        }
    }

    public void onClose() {
        Tabpanel tp = (Tabpanel)this.getLinkedPanel();
        if (tp != null) {
            tp.onClose();
        }
    }

    public boolean isDisableDraggDrop() {
        return this.isDisableDraggDrop;
    }

    public void setDisableDraggDrop(boolean isDisableDraggDrop) {
        this.isDisableDraggDrop = isDisableDraggDrop;
    }

    public void close() {
        org.zkoss.zul.Tabbox tabbox;
        org.zkoss.zul.Tab tab;
        if (this.isSelected() && (tab = this.selectNextTabWR()) != null) {
            HashSet<org.zkoss.zul.Tab> selItems = new HashSet<org.zkoss.zul.Tab>(2);
            selItems.add(tab);
            Events.postEvent((Event)new SelectEvent("onSelect", (Component)tab, selItems));
        }
        if ((tabbox = this.getTabbox()) != null && tabbox.getModel() != null) {
            return;
        }
        org.zkoss.zul.Tabpanel panel = this.getLinkedPanel();
        if (this.getTabbox() instanceof Tabbox) {
            ((Tabbox)this.getTabbox()).removeTabFromActiveSeq(this);
        }
        this.detach();
        if (panel != null) {
            Component include = panel.getFirstChild();
            if (include instanceof Include) {
                include.detach();
            }
            panel.detach();
        }
    }

    protected org.zkoss.zul.Tab selectNextTabWR() {
        org.zkoss.zul.Tab nextActiveTab;
        Tabbox idTabbox = null;
        if (this.getTabbox() instanceof Tabbox) {
            idTabbox = (Tabbox)this.getTabbox();
        }
        if (idTabbox != null && idTabbox.isActiveBySeq() && (nextActiveTab = idTabbox.getNextActiveBySeq(this)) != null) {
            nextActiveTab.setSelected(true);
            return nextActiveTab;
        }
        org.zkoss.zul.Tab tab = (org.zkoss.zul.Tab)this.getPreviousSibling();
        while (tab != null) {
            if (!tab.isDisabled()) {
                tab.setSelected(true);
                return tab;
            }
            tab = (org.zkoss.zul.Tab)tab.getPreviousSibling();
        }
        tab = (org.zkoss.zul.Tab)this.getNextSibling();
        while (tab != null) {
            if (!tab.isDisabled()) {
                tab.setSelected(true);
                return tab;
            }
            tab = (org.zkoss.zul.Tab)tab.getNextSibling();
        }
        return null;
    }

    public static class DecorateInfo {
        private String imageKey;
        private String imageIntenalUrl;

        public void decorate(LabelImageElement comp) {
            Image ico;
            if (this.imageIntenalUrl != null) {
                comp.setImage(this.imageIntenalUrl);
            } else if (this.imageKey != null && (ico = ManageImageCache.instance().getImage(this.imageKey)) != null) {
                comp.setImageContent(ico);
            }
        }

        public DecorateInfo(MImage imageData) {
            this.imageIntenalUrl = ManageImageCache.getImageInternalUrl(imageData);
            if (this.imageIntenalUrl == null) {
                this.imageKey = ManageImageCache.instance().loadImage(imageData);
            }
        }

        public DecorateInfo(String imagePath) {
            this.imageIntenalUrl = ManageImageCache.getImageInternalUrl(imagePath);
            if (this.imageIntenalUrl == null) {
                this.imageKey = imagePath;
            }
        }

        public static DecorateInfo get(ADWindow adWindow) {
            return adWindow == null ? null : new DecorateInfo(adWindow.getMImage());
        }

        public static DecorateInfo get(MInfoWindow mInfo) {
            return mInfo == null ? null : new DecorateInfo(mInfo.getImageURL());
        }
    }
}

